/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.logging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    static String defaultProperties = StrUtils.strjoinNL("handlers=java.util.logging.ConsoleHandler", "java.util.logging.ConsoleHandler.level=INFO");

    private Log() {
    }

    public static void info(String caller, String msg) {
        Log.log(caller).info(msg);
    }

    public static void info(Object caller, String msg) {
        Log.log(caller.getClass()).info(msg);
    }

    public static void info(Class<?> cls, String msg) {
        Log.log(cls).info(msg);
    }

    public static void info(Object caller, String msg, Throwable th) {
        Log.log(caller.getClass()).info(msg, th);
    }

    public static void info(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).info(msg, th);
    }

    public static void warn(String caller, String msg) {
        Log.log(caller).warn(msg);
    }

    public static void warn(Object caller, String msg) {
        Log.warn(caller.getClass(), msg);
    }

    public static void warn(Class<?> cls, String msg) {
        Log.log(cls).warn(msg);
    }

    public static void warn(Object caller, String msg, Throwable th) {
        Log.warn(caller.getClass(), msg, th);
    }

    public static void warn(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).warn(msg, th);
    }

    public static void fatal(Object caller, String msg) {
        Log.fatal(caller.getClass(), msg);
    }

    public static void fatal(Class<?> cls, String msg) {
        Log.log(cls).error(msg);
    }

    public static void fatal(Object caller, String msg, Throwable th) {
        Log.fatal(caller.getClass(), msg, th);
    }

    public static void fatal(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).error(msg, th);
    }

    public static void fatal(String caller, String msg) {
        Log.log(caller).error(msg);
    }

    public static Logger log(Class<?> cls) {
        return LoggerFactory.getLogger(cls);
    }

    public static Logger log(String loggerName) {
        return LoggerFactory.getLogger((String)loggerName);
    }

    public static void enable(String logger) {
        Log.enable(logger, "all");
    }

    public static void enable(String logger, String level) {
        org.apache.log4j.Level level1 = org.apache.log4j.Level.ALL;
        Level level2 = Level.ALL;
        if (level.equalsIgnoreCase("info")) {
            level1 = org.apache.log4j.Level.INFO;
            level2 = Level.INFO;
        }
        if (level.equalsIgnoreCase("debug")) {
            level1 = org.apache.log4j.Level.DEBUG;
            level2 = Level.FINE;
        }
        if (level.equalsIgnoreCase("warn")) {
            level1 = org.apache.log4j.Level.WARN;
            level2 = Level.WARNING;
        }
        Log.logLevel(logger, level1, level2);
    }

    public static void logLevel(String logger, org.apache.log4j.Level level1, Level level2) {
        if (level1 != null) {
            org.apache.log4j.LogManager.getLogger((String)logger).setLevel(level1);
        }
        if (level2 != null) {
            java.util.logging.Logger.getLogger(logger).setLevel(level2);
        }
    }

    public static void enable(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.ALL);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.ALL);
    }

    public static void disable(String logger) {
        org.apache.log4j.LogManager.getLogger((String)logger).setLevel(org.apache.log4j.Level.OFF);
        java.util.logging.Logger.getLogger(logger).setLevel(Level.OFF);
    }

    public static void disable(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.OFF);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.OFF);
    }

    public static void setWarn(String logger) {
        org.apache.log4j.LogManager.getLogger((String)logger).setLevel(org.apache.log4j.Level.WARN);
        java.util.logging.Logger.getLogger(logger).setLevel(Level.WARNING);
    }

    public static void setWarn(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.WARN);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.WARNING);
    }

    public static void setInfo(String logger) {
        org.apache.log4j.LogManager.getLogger((String)logger).setLevel(org.apache.log4j.Level.INFO);
        java.util.logging.Logger.getLogger(logger).setLevel(Level.INFO);
    }

    public static void setInfo(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.INFO);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.INFO);
    }

    public static boolean setLog4j() {
        String fn;
        File f;
        if (System.getProperty("log4j.configuration") == null && (f = new File(fn = "log4j.properties")).exists()) {
            System.setProperty("log4j.configuration", "file:" + fn);
        }
        return System.getProperty("log4j.configuration") != null;
    }

    public static void setLog4j(String filename) {
        if (filename.toLowerCase().endsWith(".xml")) {
            DOMConfigurator.configure((String)filename);
        } else {
            PropertyConfigurator.configure((String)filename);
        }
    }

    public static void setJavaLogging() {
        Log.setJavaLogging("logging.properties");
    }

    public static void setJavaLogging(String file) {
        try {
            FileInputStream details = new FileInputStream(file);
            LogManager.getLogManager().readConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    static void setJavaLoggingDft() {
        try {
            ByteArrayInputStream details = new ByteArrayInputStream(defaultProperties.getBytes("UTF-8"));
            LogManager.getLogManager().readConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    private static void setLoggingForCommandLine() {
    }
}

