% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialize.R
\name{execute}
\alias{execute}
\alias{commencify}
\title{Execute a operator tree, either bringing back the result or landing it as a table.}
\usage{
execute(source, optree, ..., table_name = NULL, limit = NULL,
  source_limit = NULL, overwrite = TRUE, temporary = FALSE,
  precheck = FALSE)

commencify(source, optree, ..., table_name = NULL, limit = NULL,
  source_limit = NULL, overwrite = TRUE, temporary = FALSE,
  precheck = FALSE)
}
\arguments{
\item{source}{data.frame or DBI connection.}

\item{optree}{relop operation tree.}

\item{...}{force later arguments to bind by name.}

\item{table_name}{character, name of table to create.}

\item{limit}{numeric, if set limit to this many rows during data bring back (not used when landing a table).}

\item{source_limit}{numeric if not NULL limit sources to this many rows.}

\item{overwrite}{logical if TRUE drop an previous table.}

\item{temporary}{logical if TRUE try to create a temporary table.}

\item{precheck}{logical if TRUE precheck existance of table and columns.}
}
\value{
data.frame or table handle.
}
\description{
Run the data query.  If table_name is not set results
(up to limit rows) are brought back to R. If
table_name is set full results are materailized as a remote
table.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- dbi_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))
  optree <- extend_se(d, c("v" := "AUC + R2", "x" := "pmax(AUC,v)"))

  print(optree)

  cat(format(optree))

  v <- execute(my_db, optree)
  print(v)

  v2 <- execute(data.frame(AUC = 1, R2 = 2), optree)
  print(v2)

  # land result in database
  res_hdl <- execute(my_db, optree, table_name = "res")
  print(res_hdl)
  print(DBI::dbGetQuery(my_db, to_sql(res_hdl, my_db)))
  print(DBI::dbReadTable(my_db, res_hdl$table_name))
  DBI::dbRemoveTable(my_db, res_hdl$table_name)

  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{materialize}}, \code{\link{dbi_table}}, \code{\link{to_sql}}, \code{\link{dbi_copy_to}}, \code{\link{table_source}}
}
