% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumericGap.R
\docType{class}
\name{NumericGap-class}
\alias{NumericGap-class}
\alias{NumericGap}
\title{Class "NumericGap"}
\description{
Class \code{NumericGap} is responsible for creating instances of input fields with
numeric type of answers in question \link{Entry} type assessment tasks according
to the QTI 2.1 standard.
}
\section{Slots}{

\describe{
\item{\code{response_identifier}}{A character value representing an identifier for
the answer. By default, it is generated as 'id_gap_dddd', where dddd
represents random digits.}

\item{\code{points}}{A numeric value, optional, representing the number of points for
this gap. Default is \code{1}.}

\item{\code{placeholder}}{A character value, optional, responsible for placing
helpful text in the text input field in the content delivery engine.}

\item{\code{expected_length}}{A numeric value, optional, responsible for setting the
size of the text input field in the content delivery engine.}

\item{\code{solution}}{A numeric value containing the correct answer for this numeric
entry.}

\item{\code{tolerance}}{A numeric value, optional, specifying the value for the upper
and lower boundaries of the tolerance rate for candidate answers. Default
is 0.}

\item{\code{tolerance_type}}{A character value, optional, specifying the tolerance
mode. Possible values:
\itemize{
\item "exact"
\item "absolute" - Default.
\item "relative"
}}

\item{\code{include_lower_bound}}{A boolean value, optional, specifying whether the
lower bound is included in the tolerance rate. Default is \code{TRUE}.}

\item{\code{include_upper_bound}}{A boolean value, optional, specifying whether the
upper bound is included in the tolerance rate. Default is \code{TRUE}.}
}}

\examples{
ng <- new("NumericGap",
          response_identifier = "id_gap_1234",
          points = 1,
          placeholder = "use this format xx.xxx",
          solution = 5,
          tolerance = 1,
          tolerance_type = "relative",
          include_lower_bound = TRUE,
          include_upper_bound = TRUE)
}
\seealso{
\link{Entry}, \link{TextGap}, \link{TextGapOpal} and \link{InlineChoice}.
}
