% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_table_exports.R
\name{layout_to_rowrecs_data_table}
\alias{layout_to_rowrecs_data_table}
\title{Map data records from block records that have one row per measurement value to row records.}
\usage{
layout_to_rowrecs_data_table(data, ..., columnToTakeKeysFrom,
  columnToTakeValuesFrom, rowKeyColumns, sep = "_")
}
\arguments{
\item{data}{data.frame to work with (must be local, for remote please try \code{moveValuesToColumns*}).}

\item{...}{force later arguments to bind by name.}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{rowKeyColumns}{character array names columns that should be table keys.}

\item{sep}{character if not null build more detailed column names.}
}
\value{
new data.frame with values moved to columns.
}
\description{
Map data records from block records (where each record may be more than one row) to
row records (where each record is a single row).  Values specified in rowKeyColumns
determine which sets of rows build up records and are copied into the result.
}
\examples{

(d2 <- wrapr::build_frame(
  "id"  , "id2", "measure", "value" |
    1   , "a"  , "AUC"    , 0.7     |
    2   , "b"  , "AUC"    , 0.8     |
    1   , "a"  , "R2"     , 0.4     |
    2   , "b"  , "R2"     , 0.5     ))

(layout_to_rowrecs_data_table(d2,
                             columnToTakeKeysFrom = "measure",
                             columnToTakeValuesFrom = "value",
                             rowKeyColumns = c("id", "id2")))

}
\keyword{internal}
