% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gqCvPen.R
\name{rq.gq.pen.cv}
\alias{rq.gq.pen.cv}
\title{Title Cross validation for consistent variable selection across multiple quantiles.}
\usage{
rq.gq.pen.cv(
  x = NULL,
  y = NULL,
  tau = NULL,
  lambda = NULL,
  nfolds = 10,
  cvFunc = c("rq", "se"),
  tauWeights = NULL,
  foldid = NULL,
  printProgress = FALSE,
  ...
)
}
\arguments{
\item{x}{covariate matrix. Not needed if \code{model_obj} is supplied.}

\item{y}{univariate response. Not needed if \code{model_obj} is supplied.}

\item{tau}{a sequence of tau to be modeled, must be at least of length 3.}

\item{lambda}{Values of \eqn{\lambda}. Default will automatically select the \eqn{\lambda} values.}

\item{nfolds}{number of folds}

\item{cvFunc}{loss function to be evaluated for cross-validation. Supported loss functions include quantile ("rq") and squared loss("se"). Default is the quantile loss.}

\item{tauWeights}{weights for different quantiles in calculating the cv error. Default is equal weight.}

\item{foldid}{indices of pre-split testing obervations}

\item{printProgress}{If set to TRUE prints which partition is being worked on.}

\item{...}{other arguments for \code{rq.gq.pen.cv} sent to \code{rq.gq.pen}}
}
\value{
An rq.pen.seq.cv object. 
\describe{
\item{cverr:}{ Matrix of cvSummary function, default is average, cross-validation error for each model, tau and a combination, and lambda.}
\item{cvse:}{ Matrix of the standard error of cverr foreach model, tau and a combination, and lambda.}
\item{fit:}{ The rq.pen.seq object fit to the full data.}
\item{btr:}{ Let blank, unlike rq.pen.seq.cv() or rq.group.pen.cv(), because optmizes the quantiles individually does not make sense with this penalty.}
\item{gtr:}{ A data.table for the combination of a and lambda that minimize the cross validation error across all tau.}
\item{gcve:}{ Group, across all quantiles, cross-validation error results for each value of a and lambda.}
\item{call:}{ Original call to the function.}
}
}
\description{
Title Cross validation for consistent variable selection across multiple quantiles.
}
\details{
Let \eqn{y_{b,i}} and \eqn{x_{b,i}} index the observations in 
fold b. Let \eqn{\hat{\beta}_{\tau,a,\lambda}^{-b}} be the estimator for a given quantile and tuning parameters that did not use the bth fold. Let \eqn{n_b} be the number of observations in fold
b. Then the cross validation error for fold b is 
\deqn{\mbox{CV}(b,\tau) = \sum_{q=1}^Q \frac{1}{n_b} \sum_{i=1}^{n_b} \rho_\tau(y_{b,i}-x_{b,i}^\top\hat{\beta}_{\tau_q,a,\lambda}^{-b}).}
Note that \eqn{\rho_\tau()} can be replaced squared error loss. Provides results about how the average of the cross-validation error changes with \eqn{\lambda}. Uses a
Huber approximation in the fitting of model, as presented in Sherwood and Li (2022).
}
\examples{
\dontrun{ 
n<- 200
p<- 10
X<- matrix(rnorm(n*p),n,p)
y<- -2+X[,1]+0.5*X[,2]-X[,3]-0.5*X[,7]+X[,8]-0.2*X[,9]+rt(n,2)
taus <- seq(0.1, 0.9, 0.2)
cvfit<- rq.gq.pen.cv(x=X, y=y, tau=taus)
cvCoefs <- coefficients(cvfit)
}
}
\references{
\insertRef{heteroIdQR}{rqPen}

\insertRef{huberGroup}{rqPen}
}
\author{
Shaobo Li \email{shaobo.li@ku.edu} and Ben Sherwood, \email{ben.sherwood@ku.edu}
}
