% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{ants_registration}
\alias{ants_registration}
\title{Register two images using 'ANTs'}
\usage{
ants_registration(
  fixed,
  moving,
  type_of_transform = "SyN",
  initial_transform = NULL,
  outprefix = tempfile(),
  mask = NULL,
  grad_step = 0.2,
  flow_sigma = 3,
  total_sigma = 0,
  aff_metric = c("mattes", "GC", "meansquares"),
  aff_sampling = 32,
  aff_random_sampling_rate = 0.2,
  syn_metric = c("mattes", "CC", "meansquares", "demons"),
  syn_sampling = 32,
  reg_iterations = c(40, 20, 0),
  aff_iterations = c(2100, 1200, 1200, 10),
  aff_shrink_factors = c(6, 4, 2, 1),
  aff_smoothing_sigmas = c(3, 2, 1, 0),
  write_composite_transform = FALSE,
  verbose = FALSE,
  smoothing_in_mm = FALSE,
  ...
)
}
\arguments{
\item{fixed}{fixed image to which we register the moving image, can be
character path to 'NIfTI' image, or \code{'ANTsImage'} instance,
\code{'oro.nifti'} object, \code{'niftiImage'} from
package \code{'RNifti'}, or \code{'threeBrain.nii'} from package
\code{'threeBrain'}; see also \code{\link{as_ANTsImage}}}

\item{moving}{moving image to be mapped to fixed space; see also \code{\link{as_ANTsImage}}}

\item{type_of_transform}{a linear or non-linear registration type;
print \code{ants$registration} to see details}

\item{initial_transform}{optional list of strings; transforms to apply prior
to registration}

\item{outprefix}{output file to save results}

\item{mask}{image mask; see also \code{\link{as_ANTsImage}}}

\item{grad_step, flow_sigma, total_sigma}{optimization parameters}

\item{aff_metric}{the metric for the 'affine' transformation, choices are
\code{'GC'}, \code{'mattes'}, \code{'meansquares'}}

\item{aff_sampling, aff_random_sampling_rate, aff_iterations, aff_shrink_factors, aff_smoothing_sigmas}{controls 'affine' transform}

\item{syn_metric}{the metric for the \code{'SyN'} transformation, choices
are \code{'GC'}, \code{'mattes'}, \code{'meansquares'}, \code{'demons'}}

\item{syn_sampling, reg_iterations}{controls the \code{'SyN'} transform}

\item{write_composite_transform}{whether the composite transform (and its
inverse, if it exists) should be written to an 'HDF5' composite file;
default is false}

\item{verbose}{verbose the progress}

\item{smoothing_in_mm}{logical, currently only impacts low dimensional
registration}

\item{...}{others passed to \code{ants$registration}}
}
\value{
A 'Python' dictionary of aligned images and transform files.
}
\description{
Register two images using 'ANTs'
}
\details{
Function family \code{ants_registration*} align images (specified by
\code{moving}) to \code{fixed}. Here are descriptions of the variations:
\describe{
\item{\code{ants_registration}}{Simple wrapper function for 'Python'
implementation \code{ants.registration}, providing various of registration
options}
\item{\code{ants_registration_halpern1}}{Rigid-body registration designed
for 'Casey-Halpern' lab, mainly used for aligning 'MRI' to 'CT' (or the other
way around)}
}
}
\examples{

if(interactive() && ants_available()) {

  ants <- load_ants()

  # check the python documentation here for detailed explanation
  print(ants$registration)

  # example to register
  fi <- ants$image_read(ants$get_ants_data('r16'))
  mo <- ants$image_read(ants$get_ants_data('r64'))

  # resample to speed up this example
  fi <- ants$resample_image(fi, list(60L,60L), TRUE, 0L)
  mo <- ants$resample_image(mo, list(60L,60L), TRUE, 0L)

  # SDR transform
  transform <- ants_registration(
    fixed=fi, moving=mo, type_of_transform = 'SyN' )

  ants$plot(fi, overlay = transform$warpedmovout, overlay_alpha = 0.3)


}


}
