% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{incidence_age_distribution}
\alias{incidence_age_distribution}
\title{Plot the age distribution of incident cases.}
\usage{
incidence_age_distribution(agedata, df = 10)
}
\arguments{
\item{agedata}{Vector of ages at diagnosis for each patient in the registry.}

\item{df}{Degrees of freedom for the smooth.}
}
\value{
Plot of the raw data and smoothed age distribution function.
}
\description{
This function plots the age distribution of incident cases from the registry.
}
\examples{
data(prevsim)

incidence_age_distribution(prevsim$age)

incidence_age_distribution(prevsim$age, df=5)

}
\seealso{
Other incidence functions: \code{\link{incidence}},
  \code{\link{mean_incidence_rate}},
  \code{\link{plot.incidence}},
  \code{\link{raw_incidence}},
  \code{\link{test_incidence_fit}}
}

