% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgWriteRast.R
\name{pgWriteRast}
\alias{pgWriteRast}
\title{Write raster to PostGIS database table.}
\usage{
pgWriteRast(conn, name, raster, bit.depth = NULL, constraints = TRUE,
  overwrite = FALSE)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{A character string specifying a PostgreSQL schema (if
necessary) and table name to hold the
raster (e.g., \code{name = c("schema","table")})}

\item{raster}{An R \code{RasterLayer}, \code{RasterBrick}, or \code{RasterStack}}

\item{bit.depth}{The bit depth of the raster. Will be set to 32-bit
(unsigned int, signed int, or float, depending on the data)
if left null, but can be specified (as character) as one of the
PostGIS pixel types (see \url{http://postgis.net/docs/RT_ST_BandPixelType.html})}

\item{constraints}{Whether to create constraints from raster data. Recommened
to leave \code{TRUE} unless applying constraints manually (see
\url{http://postgis.net/docs/RT_AddRasterConstraints.html}).
Note that constraint notices may print to the console,
 depending on the PostgreSQL server settings.}

\item{overwrite}{Whether to overwrite the existing table (\code{name}).}
}
\value{
TRUE for successful import.
}
\description{
Sends R \code{Raster*} to a new PostGIS database table.
}
\details{
RasterLayer names will be stored in an array in the column
"band_names", which will be restored in R when imported with the function
\code{\link[rpostgis]{pgGetRast}}.
}
\examples{
\dontrun{
pgWriteRast(conn, c("schema", "tablename"), raster_name)

# basic test
r<-raster(nrows=180, ncols=360, xmn=-180, xmx=180, ymn=-90, ymx=90, vals=1)
pgWriteRast(conn, c("schema", "test"), raster = r, bit.depth = "2BUI", overwrite = TRUE)
}
}
\author{
David Bucklin \email{dbucklin@ufl.edu}
}
\seealso{
Function follows process from 
\url{http://postgis.net/docs/using_raster_dataman.html#RT_Creating_Rasters}.
}

