% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_phylopic.R
\name{geom_phylopic}
\alias{geom_phylopic}
\title{Geom for adding PhyloPic silhouettes to a plot}
\usage{
geom_phylopic(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  remove_background = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{FALSE}, the default, never includes, \code{NA} includes if any aesthetics are
mapped, and \code{TRUE} always includes. It can also be a named logical vector
to finely select the aesthetics to display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{remove_background}{\code{logical}. Should any white background be
removed from the silhouette(s)? See \code{\link[=recolor_phylopic]{recolor_phylopic()}} for details.}
}
\description{
This geom acts like \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}, except that the specified
silhouettes are used as points. Silhouettes can be specified by their \code{name},
\code{uuid}, or image objects (\code{img}).
}
\details{
One (and only one) of the \code{img}, \code{name}, or \code{uuid} aesthetics must
be specified. The \code{img} aesthetic can be
\link[grImport2:Picture-class]{Picture} objects or png array objects, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}. Use the \code{x} and \code{y} aesthetics to place the
silhouettes at specified positions on the plot. The \code{size} aesthetic
specifies the height of the silhouettes in the units of the y axis. The
aspect ratio of the silhouettes will always be maintained.

The \code{alpha} and \code{color} aesthetics can be used to change the transparency
and color of the silhouettes, respectively. If "original" is specified for
the \code{color} aesthetic, the original color of the silhouette will be used
(usually the same as "black").

The \code{horizontal} and \code{vertical} aesthetics can be used to flip the
silhouettes. The \code{angle} aesthetic can be used to rotate the silhouettes.
When specifying a horizontal and/or vertical flip \strong{and} a rotation, the
flip(s) will always occur first. If you would like to customize this
behavior, you can flip and/or rotate the image within your own workflow
using \code{\link[=flip_phylopic]{flip_phylopic()}} and \code{\link[=rotate_phylopic]{rotate_phylopic()}}.

Note that png array objects can only be rotated by multiples of 90 degrees.
}
\section{Aesthetics}{
 geom_phylopic understands the following aesthetics:
\itemize{
\item \strong{x} (required)
\item \strong{y} (required)
\item \strong{img/uuid/name} (one, and only one, required)
\item size
\item color
\item alpha
\item horizontal
\item vertical
\item angle
}

Learn more about setting these aesthetics in \code{\link[=add_phylopic]{add_phylopic()}}.
}

\examples{
library(ggplot2)
df <- data.frame(x = c(2, 4), y = c(10, 20), name = c("cat", "walrus"))
ggplot(df) +
  geom_phylopic(aes(x = x, y = y, name = name),
                color = "purple", size = 10) +
  facet_wrap(~name) +
  coord_cartesian(xlim = c(1,6), ylim = c(5, 30))
}
