#include <R.h>
#include <Rinternals.h>
#include <Rmath.h>

	//xm[-1] = 0.
	static double xm[128] = {0.311549761973982, 0.394827135621115, 0.454225565247115, 0.502209241859997, 0.543279740871549, 0.579639896025026, 0.612552127214819, 0.642815237161278, 0.670970579305089, 0.697403944850754, 0.722401200871135, 0.746180743751145, 0.768913668435616, 0.790736853292442, 0.811761715798749, 0.832080352855707, 0.85176989211337, 0.87089565449386, 0.889513520197329, 0.907671781591563, 0.925412432802673, 0.942772348072405, 0.95978405398168, 0.976476461604026, 0.992875407922606, 1.00900409876991, 1.02488347431943, 1.04053253973739, 1.05596860237475, 1.07120748698939, 1.08626372510733, 1.10115071366622, 1.11588084553229, 1.13046563059766, 1.14491577567402, 1.15924128292085, 1.17345154326301, 1.18755537479833, 1.20156109960958, 1.21547657500477, 1.22930927348648, 1.24306629203939, 1.25675440232755, 1.27038008220751, 1.28394955478748, 1.29746879103507, 1.31094358250755, 1.32437948841702, 1.33778194326978, 1.35115620213429, 1.36450741209487, 1.37784060169138, 1.3911606876719, 1.40447252881982, 1.41778090478044, 1.43109054153254, 1.444406117937, 1.45773229184144, 1.47107370711541, 1.48443501070996, 1.49782082931855, 1.51123583725576, 1.52468473417355, 1.53817225265772, 1.55170318745141, 1.565282415609, 1.57891488483304, 1.59260562291999, 1.60635978157428, 1.62018263767621, 1.6340795944237, 1.6480562295109, 1.66211826352478, 1.67627161034335, 1.6905224319664, 1.70487706041441, 1.71934210302604, 1.73392446728624, 1.74863132208725, 1.76347020232, 1.77844896050985, 1.79357590774556, 1.80885971496704, 1.82430959178391, 1.83993522069022, 1.85574690883494, 1.87175554310581, 1.88797274335227, 1.90441084250346, 1.92108309375638, 1.93800361981206, 1.95518759557725, 1.9726513864826, 1.99041261606889, 2.00849033620877, 2.02690524291654, 2.04567982801241, 2.06483863636675, 2.08440852500061, 2.10441901082294, 2.12490259222463, 2.14589526982194, 2.16743700210504, 2.18957237760501, 2.21235135280671, 2.23583026210879, 2.2600728094293, 2.28515168339683, 2.31115012586523, 2.33816434384347, 2.36630623704429, 2.39570727723101, 2.42652314118909, 2.45894051360545, 2.49318584901338, 2.52953773326819, 2.56834457921303, 2.61005072218009, 2.65523524129729, 2.70467453688575, 2.75944430895637, 2.82110000292331, 2.89201859905778, 2.97611657059033, 3.08059152839483, 3.22120337255591, 3.44646649892577, 6.18285175699892};
	//ym[-1] = 1.
	static double ym[128] = {0.95262721, 0.92501601, 0.901982255, 0.881520465, 0.862796485, 0.84536127, 0.828937885, 0.813340275, 0.798435765, 0.78412555, 0.770333495, 0.756999375, 0.7440745, 0.73151878, 0.71929872, 0.707385955, 0.695756195, 0.684388445, 0.673264405, 0.66236797, 0.65168492, 0.64120257, 0.630909585, 0.62079576, 0.61085187, 0.601069545, 0.591441165, 0.581959755, 0.57261892, 0.56341278, 0.55433591, 0.54538329, 0.536550265, 0.527832505, 0.519225985, 0.51072695, 0.50233188, 0.494037485, 0.485840675, 0.477738555, 0.46972839, 0.46180761, 0.45397379, 0.44622464, 0.43855799, 0.430971795, 0.4234641, 0.416033075, 0.40867696, 0.4013941, 0.39418291, 0.387041885, 0.3799696, 0.372964685, 0.36602584, 0.359151825, 0.35234146, 0.345593615, 0.33890721, 0.33228121, 0.32571464, 0.319206555, 0.312756055, 0.306362285, 0.300024425, 0.293741685, 0.287513315, 0.281338605, 0.27521687, 0.269147455, 0.26312974, 0.257163125, 0.25124705, 0.24538098, 0.23956439, 0.233796805, 0.228077765, 0.222406825, 0.21678358, 0.211207635, 0.205678635, 0.200196225, 0.1947601, 0.189369955, 0.184025525, 0.17872655, 0.17347281, 0.168264095, 0.163100235, 0.15798106, 0.152906445, 0.147876285, 0.14289049, 0.137949005, 0.133051805, 0.128198885, 0.123390275, 0.118626035, 0.11390626, 0.109231075, 0.10460065, 0.100015185, 0.09547493, 0.09098018, 0.086531285, 0.08212864, 0.07777272, 0.07346405, 0.0692032499999999, 0.0649910149999999, 0.06082815, 0.05671556, 0.052654305, 0.0486455849999999, 0.04469079, 0.04079154, 0.03694973, 0.03316758, 0.02944777, 0.0257935149999999, 0.022208805, 0.018698675, 0.015269685, 0.011930765, 0.00869487000000002, 0.00558274000000003, 0.00263448999999993, 5e-09};

static unsigned int I1=1234, I2=5678;

void set_seed_rpgm(unsigned int i1, unsigned int i2)
{
    I1 = i1; I2 = i2;
}

unsigned int mt_rand(void)
{
    I1= 36969*(I1 & 0177777) + (I1>>16);
    I2= 18000*(I2 & 0177777) + (I2>>16);
    return ((I1 << 16)^(I2 & 0177777)); 
}

void rnorm_vect(int N, double * vector, SEXP * mu, SEXP * sd)
{
	unsigned int u0, A;
	double u;

	unsigned char j=0;
	
	double* mu_vect = REAL(*mu);
	double* sd_vect = REAL(*sd);
		
	int n_mu = length(*mu);
	int n_sd = length(*sd);

	for(int i=0 ; i != N ; ++i)
	{
		if(!j)
		{
			u0 = mt_rand();
			j=3;
		}
		else
		{
			--j;
		}
		A =  u0 & 127;
		u0 >>= 7;

		vector[i] = 0.;
		while(!vector[i])
		{
			u = unif_rand()*xm[A];
			if(A != 0 && (u <= xm[A-1])) //prcalculer xm[A] / xm[A-1] pour comparer U0. Et mme prcalculer Max_MT*(xm[A] / xm[A-1]) en integer pour comparaison avec mt_rand()
			{
				vector[i] = u0 & 1 ? mu_vect[i % n_mu] + sd_vect[i % n_sd]*u : mu_vect[i % n_mu] -sd_vect[i % n_sd]*u; //rbernou() ? u : -u
				u0 >>=1;
			}
			else
			{
				if(runif(ym[A], (A ? ym[A-1] : 1.)) <= exp(-.5*u*u))
				{
					vector[i] = u0 & 1 ? mu_vect[i % n_mu] + sd_vect[i % n_sd]*u : mu_vect[i % n_mu] -sd_vect[i % n_sd]*u; 
					u0 >>=1;
				}
			}
		}
	}
}

//Le simulateur ci-dessus ne s'applique qu'au choix de la tranche et au signe.
void rnorm_rpgm01(int N, double * vector)
{
	unsigned int u0, A;
	double u;

	unsigned char j=0;
	
	for(int i=0 ; i != N ; ++i)
	{
		if(!j)
		{
			u0 = mt_rand();
			j=3;
		}
		else
		{
			--j;
		}
		A =  u0 & 127;
		u0 >>= 7;

		vector[i] = 0.;
		while(!vector[i])
		{
			u = unif_rand()*xm[A];
			if(A != 0 && (u <= xm[A-1])) //prcalculer xm[A] / xm[A-1] pour comparer U0. Et mme prcalculer Max_MT*(xm[A] / xm[A-1]) en integer pour comparaison avec mt_rand()
			{
				vector[i] = u0 & 1 ? u : -u; //rbernou() ? u : -u
				u0 >>=1;
			}
			else
			{
				if(runif(ym[A], (A ? ym[A-1] : 1.)) <= exp(-.5*u*u))
				{
					vector[i] = u0 & 1 ? u : -u; 
					u0 >>=1;
				}
			}
		}
	}
}

void rnorm_rpgm(int N, double * vector, double mu_, double sd_)
{
	unsigned int u0, A;
	double u;

	unsigned char j=0;

	for(int i=0 ; i != N ; ++i)
	{
		if(!j)
		{
			u0 = mt_rand();
			j=3;
		}
		else
		{
			--j;
		}
		A =  u0 & 127;
		u0 >>= 7;

		vector[i] = 0.;
		while(!vector[i])
		{
			u = unif_rand()*xm[A];
			if(A != 0 && (u <= xm[A-1])) //prcalculer xm[A] / xm[A-1] pour comparer U0. Et mme prcalculer Max_MT*(xm[A] / xm[A-1]) en integer pour comparaison avec mt_rand()
			{
				vector[i] = u0 & 1 ? mu_ + sd_*u : mu_ -sd_*u; //rbernou() ? u : -u
				u0 >>=1;
			}
			else
			{
				if(runif(ym[A], (A ? ym[A-1] : 1.)) <= exp(-.5*u*u))
				{
					vector[i] = u0 & 1 ? mu_ + sd_*u : mu_ -sd_*u; 
					u0 >>=1;
				}
			}
		}
	}
}

// [[register]]
SEXP rn(SEXP n, SEXP mu, SEXP sd)
{
	int N;
	
	double mu_;
	double sd_;

	
	if(TYPEOF(n) == INTSXP)
		N=*INTEGER(n);
	else if(TYPEOF(n) == REALSXP)
		N = (int) *REAL(n);
	else
		N = 0;

	SEXP vector_sexp;
	double* vector;
	PROTECT(vector_sexp = allocVector(REALSXP, N));
	vector = REAL(vector_sexp);
	


	if(length(mu) == 1 && length(sd) == 1)
	{
		if(TYPEOF(mu) == REALSXP)
		{
			mu_ = *REAL(mu);
		}
		else if(TYPEOF(mu) == INTSXP)
		{
			mu_ = (double) *INTEGER(mu);
		}
		else
		{
			mu_ = 0.;
		}
		
		if(TYPEOF(sd) == REALSXP)
		{
			sd_ = *REAL(sd);
		}
		else if(TYPEOF(sd) == INTSXP)
		{
			sd_ = (double) *INTEGER(sd);
		}
		else
		{
			sd_ = 1.;
		}
		
		if(mu_ == 0. && sd_ == 1.)
			rnorm_rpgm01(N, vector);
		else
			rnorm_rpgm(N, vector, mu_, sd_);
	}
	else
	{
		rnorm_vect(N, vector, &mu, &sd);
	}

	UNPROTECT(1);

	return vector_sexp;
}
