% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classes.R
\name{rpf.rescale}
\alias{rpf.rescale}
\alias{rpf.rescale,rpf.base,numeric,numeric,matrix-method}
\alias{rpf_rescale_wrapper}
\title{Rescale item parameters}
\usage{
rpf.rescale(m, param, mean, cov)
}
\arguments{
\item{m}{item model}

\item{param}{item parameters}

\item{mean}{vector of means}

\item{cov}{covariance matrix}
}
\description{
Adjust item parameters for changes in mean and covariance of the
latent distribution.
}
\examples{
spec <- rpf.grm()
p1 <- rpf.rparam(spec)
testPoint <- rnorm(1)
move <- rnorm(1)
cov <- as.matrix(rlnorm(1))
Icov <- solve(cov)
padj <- rpf.rescale(spec, p1, move, cov)
pr1 <- rpf.prob(spec, padj, (testPoint-move) \%*\% Icov)
pr2 <- rpf.prob(spec, p1, testPoint)
abs(pr1 - pr2) < 1e9
}

