% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_simulation_results.R
\name{SimulationResultsBaseCountData}
\alias{SimulationResultsBaseCountData}
\title{Class for Simulation Results Count Data}
\description{
A class for simulation results count data.
}
\details{
Use \code{\link[=getSimulationCounts]{getSimulationCounts()}}
to create an object of this type.
}
\section{Fields}{

\describe{
\item{\code{maxNumberOfIterations}}{The number of simulation iterations. Is a numeric vector of length 1 containing a whole number.}

\item{\code{seed}}{The seed used for random number generation. Is a numeric vector of length 1.}

\item{\code{allocationRatioPlanned}}{The planned allocation ratio (\code{n1 / n2}) for the groups. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control. Is a positive numeric vector of length 1.}

\item{\code{conditionalPower}}{The conditional power at each stage of the trial. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{iterations}}{The number of iterations used for simulations. Is a numeric vector of length 1 containing a whole number.}

\item{\code{futilityPerStage}}{The per-stage probabilities of stopping the trial for futility. Is a numeric matrix.}

\item{\code{thetaH0}}{The difference or assumed effect under H0. Is a numeric vector of length 1.}

\item{\code{accrualTime}}{The assumed accrual time intervals for the study. Is a numeric vector.}

\item{\code{accrualIntensity}}{The absolute accrual intensities. Is a numeric vector of length \code{kMax}.}

\item{\code{groups}}{The group numbers. Is a numeric vector.}

\item{\code{directionUpper}}{Specifies the direction of the alternative, only applicable for one-sided testing. Default is \code{TRUE} which means that larger values of the test statistics yield smaller p-values. Is a logical vector of length 1.}

\item{\code{earlyStop}}{The probability to stopping the trial either for efficacy or futility. Is a numeric vector.}

\item{\code{sampleSizes}}{The sample sizes for each group and stage. Is a numeric vector of length number of stages times number of groups containing whole numbers.}

\item{\code{overallReject}}{The overall rejection probability. Is a numeric vector.}

\item{\code{rejectPerStage}}{The probability to reject a hypothesis per stage of the trial. Is a numeric matrix.}
}}

\keyword{internal}
