% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_stage_results.R
\name{plot.StageResults}
\alias{plot.StageResults}
\title{Stage Results Plotting}
\usage{
\method{plot}{StageResults}(x, y, ..., type = 1L, nPlanned,
  stage = x$getNumberOfStages(), allocationRatioPlanned = NA_real_,
  main = NA_character_, xlab = NA_character_, ylab = NA_character_,
  legendTitle = NA_character_, palette = "Set1",
  legendPosition = NA_integer_, showSource = FALSE)
}
\arguments{
\item{x}{The stage results at given stage, obtained from \code{getStageResults} or \code{getAnalysisResults}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{...}{Optional \code{ggplot2} arguments. Furthermore the following arguments can be defined:
\itemize{
\item \code{thetaRange}: A range of assumed effect sizes if testing means or a survival design was specified. 
            Additionally, if testing means was selected, an assumed standard deviation can be specified (default is 1).
\item \code{piRange}: A range of assumed rates pi1 to calculate the conditional power. 
          Additionally, if a two-sample comparison was selected, pi2 can be specified (default is the value from 
       \code{getAnalysisResults}). 
\item \code{directionUpper}: The direction of one-sided testing. 
       Default is \code{directionUpper = TRUE} which means that larger values of the 
       test statistics yield smaller p-values.
\item \code{thetaH0}: The null hypothesis value, default is 0 for the normal and the binary case, 
       it is 1 for the survival case.      
       For testing a rate in one sample, a value thetaH0 in (0,1) has to be specified for 
       defining the null hypothesis H0: pi = thetaH0.
}}

\item{type}{The plot type (default = 1). Note that at the moment only one type 
(the conditional power plot) is available.}

\item{nPlanned}{The sample size planned for the subsequent stages. 
It should be a vector with length equal to the remaining stages and is the 
overall sample size in the two treatment groups if two groups are considered.}

\item{stage}{The stage number (optional). Default: total number of existing stages in the data input
used to create the stage results.}

\item{allocationRatioPlanned}{The allocation ratio for two treatment groups planned for 
the subsequent stages, the default value is 1.}

\item{main}{The main title.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{legendTitle}{The legend title.}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{legendPosition}{The position of the legend. 
By default (\code{NA_integer_}) the algorithm tries to find a suitable position. 
Choose one of the following values to specify the position manually:
\itemize{
  \item \code{0}: legend position outside plot
  \item \code{1}: legend position left top
  \item \code{2}: legend position left center
  \item \code{3}: legend position left bottom
  \item \code{4}: legend position right top
  \item \code{5}: legend position right center
  \item \code{6}: legend position right bottom
}}

\item{showSource}{If \code{TRUE}, the parameter names of the object will 
be printed which were used to create the plot; that may be, e.g., 
useful to check the values or to create own plots with \code{\link[graphics]{plot}}.}
}
\description{
Plots the conditional power together with the likelihood function.
}
\details{
Generic function to plot all kinds of stage results.
The conditional power is calculated only if effect size and sample size is specified.
}
\examples{

design <- getDesignGroupSequential(kMax = 4, alpha = 0.025, 
    informationRates = c(0.2, 0.5, 0.8, 1), 
    typeOfDesign = "WT", deltaWT = 0.25)

dataExample <- getDataset(
    n = c(20, 30, 30),
    means = c(50, 51, 55),
    stDevs = c(130, 140, 120)
)

stageResults <- getStageResults(design, dataExample, thetaH0 = 20)

if (require(ggplot2)) plot(stageResults, nPlanned = c(30), thetaRange = c(0, 100))

}
