% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd-examples.R
\name{escape_examples}
\alias{escape_examples}
\title{Escape examples}
\usage{
escape_examples(x)
}
\description{
This documentation topic is used primarily for testing and to record
our understanding of the \verb{\\example\{\}} escaping rules.
}
\examples{
# The only thing that must be escaped in examples is Rd comments:
100 \%\% 30
# even if they are in strings
"50\%"

# Otherwise, backslashes and braces can be left as is
"\""
"{"
# It looks like you could use Rd tags in comments, but these are
# not actually parsed
1 # \link{mean}

# The only place that a backslash can occur in R code is as part of
# an infix operator or in a non-syntactic name. If you do either of those
# things, you'll need to escape it yourself.
`\%\\\\\%` <- function(x, y) x + y
10 \%\\\% 20

# You must escape braces if they are unbalanced, which typically
# only occurs in \dontshow{}:
\dontshow{if (FALSE) \{ }
print("Hello")
\dontshow{ \} }

# Otherwise, you _can_ escape them, but there's little point.
# The following two lines are equivalent
f <- function() { NULL }
f <- function() \{ NULL \}
}
\keyword{internal}
