% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studies.R
\name{get_study_tree}
\alias{get_study_tree}
\title{Study Tree}
\usage{
get_study_tree(
  study_id = NULL,
  tree_id = NULL,
  object_format = c("phylo"),
  tip_label = c("original_label", "ott_id", "ott_taxon_name"),
  file_format,
  file,
  deduplicate = TRUE,
  ...
)
}
\arguments{
\item{study_id}{the identifier of a study (character)}

\item{tree_id}{the identifier of a tree within the study}

\item{object_format}{the class of the object to be returned
(default and currently only possible value \code{phylo} from
the \code{\link[ape]{ape}} package).}

\item{tip_label}{the format of the tip
labels. \dQuote{\code{original_label}} (default) returns the
original labels as provided in the study,
\dQuote{\code{ott_id}} labels are replaced by their ott IDs,
\dQuote{\code{ott_taxon_name}} labels are replaced by their
Open Tree Taxonomy taxon name.}

\item{file_format}{the format of the file to be generated
(\code{newick} default, \code{nexus}, or \code{json}).}

\item{file}{the file name where the output of the function will be
saved.}

\item{deduplicate}{logical (default \code{TRUE}). If the tree
returned by the study contains duplicated taxon names, should they
be made unique? It is normally illegal for NEXUS/Newick tree
strings to contain duplicated tip names. This is a workaround to
circumvent this requirement. If \code{TRUE}, duplicated tip labels
will be appended \code{_1}, \code{_2}, etc.}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}
}
\value{
if \code{file_format} is missing, an object of class
    \code{phylo}, otherwise a logical indicating whether the file
    was successfully created.
}
\description{
Returns a specific tree from within a study
}
\examples{
\dontrun{
 tree <- get_study_tree(study_id="pg_1144", tree_id="tree2324")

 ## comparison of the first few tip labels depending on the options used
 head(get_study_tree(study_id="pg_1144", tree_id="tree2324", tip_label="original_label")$tip.label)
 head(get_study_tree(study_id="pg_1144", tree_id="tree2324", tip_label="ott_id")$tip.label)
 head(get_study_tree(study_id="pg_1144", tree_id="tree2324", tip_label="ott_taxon_name")$tip.label)
}
}
