% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitives.R
\name{head}
\alias{head}
\alias{head.SO3}
\alias{head.Q4}
\title{Return the First or Last Part of an Object}
\usage{
\method{head}{SO3}(x, n = 6L, ...)

\method{head}{Q4}(x, n = 6L, ...)
}
\arguments{
\item{x}{an object}

\item{n}{a single integer.  If positive or zero, size for the resulting
    object: number of elements for a vector (including lists), rows for
    a matrix or data frame or lines for a function.  If negative, all but
    the \code{n} last/first number of elements of \code{x}.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
An object (usually) like \code{x} but generally smaller.  For
  \code{\link{ftable}} objects \code{x}, a transformed \code{format(x)}.
}
\description{
Returns the first or last parts of a vector, matrix, table, data frame
  or function.  Since \code{head()} and \code{tail()} are generic
  functions, they may also have been extended to other classes.
}
\details{
For matrices, 2-dim tables and data frames, \code{head()} (\code{tail()}) returns
  the first (last) \code{n} rows when \code{n >= 0} or all but the
  last (first) \code{n} rows when \code{n < 0}.  \code{head.matrix()} and
  \code{tail.matrix()} are exported.  For functions, the
  lines of the deparsed function are returned as character strings.

  If a matrix has no row names, then \code{tail()} will add row names of
  the form \code{"[n,]"} to the result, so that it looks similar to the
  last lines of \code{x} when printed.  Setting
  \code{addrownums = FALSE} suppresses this behaviour.
}
\examples{
head(letters)
head(letters, n = -6L)

head(freeny.x, n = 10L)
head(freeny.y)

tail(letters)
tail(letters, n = -6L)

tail(freeny.x)
tail(freeny.y)

tail(library)

head(stats::ftable(Titanic))
}
\author{
Patrick Burns, improved and corrected by R-Core. Negative argument
  added by Vincent Goulet.
}
