\name{Arithmetic}
\alias{"+.Q4"}
\alias{"+.SO3"}
\alias{"-.Q4"}
\alias{"-.SO3"}
\alias{+.Q4}
\alias{+.SO3}
\alias{-.Q4}
\alias{-.SO3}
\alias{Arithmetic}
\title{Arithmetic operators on SO(3)}
\usage{
  \method{+}{SO3} (x, y)

  \method{-}{SO3} (x, y = NULL)

  \method{+}{Q4} (x, y)

  \method{-}{Q4} (x, y = NULL)
}
\arguments{
  \item{x}{first argument}

  \item{y}{second argument (optional for subtraction)}
}
\value{
  \item{+}{the result of rotating the identity frame
  through x then y} \item{-}{the difference of the
  rotations, or the inverse rotation of only one argument
  is provided}
}
\description{
  These binary operators perform arithmetic on rotations in
  quaternion or rotation matrix form (or objects which can
  be coerced into them).
}
\details{
  The rotation group SO(3) is a multiplicative group so
  ``adding" rotations \eqn{R_1}{R1} and \eqn{R_2}{R2}
  results in \eqn{R_1+R_2=R_2R_1}{R1+R2=R2R1}.  Similarly,
  the difference between rotations \eqn{R_1}{R1} and
  \eqn{R_2}{R2} is \eqn{R_1-R_2=R_2^\top R_1}{R1-R2=R2'R1}.
  With this definition it is clear that
  \eqn{R_1+R_2-R_2=R_2^\top
  R_2R_1=R_1}{R1+R2-R2=R2'R2R1=R1}. If only one rotation is
  provided to subtraction then the inverse (transpose) it
  returned, e.g. \eqn{-R_2=R_2^\top}{-R2=R2'}.
}
\examples{
U <- c(1, 0, 0)          #Rotate about the x-axis
R1 <- as.SO3(U, pi/8)    #Rotate pi/8 radians about the x-axis
R2 <- R1 + R1            #Rotate pi/8 radians about the x-axis twice
mis.axis(R2)             #x-axis: (1,0,0)
mis.angle(R2)            #pi/8 + pi/8 = pi/4

R3 <- R1 - R1            #Rotate pi/8 radians about x-axis then back again
R3                       #Identity matrix

R4 <- -R1                #Rotate in the opposite direction through pi/8
R5 <- as.SO3(U, -pi/8)   #Equivalent to R4

M1 <- matrix(R1, 3, 3)   #If element-wise addition is requred,
M2 <- matrix(R2, 3, 3)   #translate them to matrices then treat as usual
M3 <- M1 + M2

M1 \%*\% M1                #Equivalent to R2
t(M1) \%*\% M1             #Equivalent to R3
t(M1)                    #Equivalent to R4 and R5

#The same can be done with quaternions: the identity rotation is (1, 0, 0, 0)
#and the inverse rotation of Q=(a, b, c, d) is -Q=(a, -b, -c, -d)

Q1 <- as.Q4(R1)
Q2 <- Q1 + Q1
mis.axis(Q2)
mis.angle(Q2)

Q1 - Q1                  #id.Q4 = (1, 0, 0, 0)
}

