% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R, R/frequencies.R
\name{freq}
\alias{freq}
\alias{Frequency}
\alias{frequencies}
\alias{print.freq}
\alias{pander.freq}
\alias{print.frequencies}
\alias{pander.frequencies}
\title{Frequency tables}
\usage{
freq(vector, digits = 1, nsmall = 1, transposed = FALSE, round = 1,
  plot = FALSE, plotTheme = ggplot2::theme_bw())

\method{print}{freq}(x, digits = x$input$digits,
  nsmall = x$input$nsmall, transposed = x$input$transposed, ...)

\method{pander}{freq}(x, ...)

frequencies(..., digits = 1, nsmall = 1, transposed = FALSE,
  round = 1, plot = FALSE, plotTheme = ggplot2::theme_bw())

\method{print}{frequencies}(x, ...)

\method{pander}{frequencies}(x, prefix = "###", ...)
}
\arguments{
\item{vector}{A vector of values to compute frequencies for.}

\item{digits}{Minimum number of significant digits to show in result.}

\item{nsmall}{Minimum number of digits after the decimal point to show in
the result.}

\item{transposed}{Whether to transpose the results when printing them (this
can be useful for blind users).}

\item{round}{Number of digits to round the results to (can be used in
conjunction with digits to determine format of results).}

\item{plot}{If true, a histogram is shown of the variable.}

\item{plotTheme}{The ggplot2 theme to use.}

\item{x}{The `freq` or `frequencies` object to print.}

\item{\dots}{For `frequencies`, the variables of which to provide
frequencies; for the `print` methods, additional arguments are passed on
to the `print` function.}

\item{prefix}{The prefix to use when printing `frequencies`, to easily prepend
Markdown headers.}
}
\value{
An object with several elements, the most notable of which is: \item{dat}{A
dataframe with the frequencies}

For \code{frequencies}, these objects are in a list of their own.
}
\description{
Function to show frequencies in a manner similar to what SPSS' "FREQUENCIES"
command does. Note that \code{frequency} is an alias for \code{freq}.
}
\examples{


### Create factor vector
ourFactor <- factor(mtcars$gear, levels=c(3,4,5),
                    labels=c("three", "four", "five"));
### Add some missing values
factorWithMissings <- ourFactor;
factorWithMissings[10] <- factorWithMissings[20] <- NA;

### Show frequencies
freq(ourFactor);
freq(factorWithMissings);

### ... Or for all of them at one
frequencies(ourFactor, factorWithMissings);


}
\keyword{univar}
