% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_search.R
\name{orcid_search}
\alias{orcid_search}
\title{Orcid search - more user friendly than \code{\link[=orcid]{orcid()}}}
\usage{
orcid_search(
  given_name = NULL,
  family_name = NULL,
  past_inst = NULL,
  current_inst = NULL,
  affiliation_org = NULL,
  ringgold_org_id = NULL,
  grid_org_id = NULL,
  credit_name = NULL,
  other_name = NULL,
  email = NULL,
  digital_object_ids = NULL,
  work_title = NULL,
  grant_number = NULL,
  keywords = NULL,
  text = NULL,
  rows = 10,
  start = NULL,
  ...
)
}
\arguments{
\item{given_name}{(character) given name}

\item{family_name}{(character) family name}

\item{past_inst}{(character) past institution}

\item{current_inst}{(character) current institution}

\item{affiliation_org}{(character) affiliation organization name}

\item{ringgold_org_id}{(character) ringgold organization id}

\item{grid_org_id}{(character) grid organization id}

\item{credit_name}{(character) credit name}

\item{other_name}{(character) other name}

\item{email}{(character) email}

\item{digital_object_ids}{(character) digital object ids}

\item{work_title}{(character) work title}

\item{grant_number}{(character) grant number}

\item{keywords}{(character) keywords to search. character vector, one
or more keywords}

\item{text}{(character) text to search}

\item{rows}{(integer) number of records to return}

\item{start}{(integer) record number to start at}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
a \code{data.frame} with three columns:
\itemize{
\item first: given name
\item last: family name
\item orcid: ORCID identifier
}

If no results are found, an empty (0 rows) data.frame
is returned
}
\description{
Orcid search - more user friendly than \code{\link[=orcid]{orcid()}}
}
\details{
The goal of this function is to make a human friendly
way to search ORCID.

Thus, internally we map the parameters given to this function
to the actual parameters that ORCID wants that are not
so human friendly.

We don't include all possible fields you could search against
here - for that use \code{\link[=orcid]{orcid()}}
}
\note{
\code{current_prim_inst} and \code{patent_number} parameters have been
removed as ORCID has removed them
}
\section{How parameters are combined}{

We combine multiple parameters with \code{AND}, such that
e.g., \code{given_name="Jane"} and \code{family_name="Doe"} gets passed
to ORCID as \verb{given-names:Jane AND family-name:Doe}
}

\examples{
\dontrun{
orcid_search(given_name = "carl", family_name = "boettiger")
orcid_search(given_name = "carl")
orcid_search(given_name = "carl", rows = 2)
orcid_search(keywords = c("birds", "turtles"))
orcid_search(affiliation_org = '("Boston University" OR BU)')
orcid_search(ringgold_org_id = '1438')
orcid_search(grid_org_id = 'grid.5509.9')
orcid_search(current_inst = '')
orcid_search(email = '*@orcid.org')
orcid_search(given_name = "carl", verbose = TRUE)
}
}
\references{
\url{https://members.orcid.org/api/tutorial/search-orcid-registry}
}
\seealso{
\code{\link[=orcid]{orcid()}}
}
