% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolog.R
\name{once}
\alias{once}
\title{Invoke a query once}
\usage{
once(
  query = call("member", expression(X), list(quote(a), "b", 3L, 4, TRUE,
    expression(Y))),
  options = NULL
)
}
\arguments{
\item{query}{an R call. The R call consists of symbols, integers and real numbers,
character strings, boolean values, expressions, lists, and other calls.
Vectors of booleans, integers, floating point numbers, and strings with
length \emph{N} > 1 are translated to prolog compounds !/N, \%/N, #/N and $$/N,
respectively. The names can be modified with the options below.}

\item{options}{This is a list of options controlling translation from and to prolog.
\itemize{
\item \emph{boolvec} (see option rolog.boolvec, default is !) is the name of the
prolog compound for vectors of booleans.
\item \emph{intvec}, \emph{realvec}, \emph{charvec} define the compound names for vectors of
integers, doubles and strings, respectively (defaults are \%, # and $$).
\item If \emph{scalar} is \code{TRUE} (default), vectors of length 1 are translated to
scalar prolog elements. If \emph{scalar} is \code{FALSE}, vectors of length 1 are
also translated to compounds.
}}
}
\value{
If the query fails, \code{FALSE} is returned. If the query succeeds, a
(possibly empty) list is returned that includes the bindings required to
satisfy the query.
}
\description{
Invoke a query once
}
\examples{
# This query returns FALSE
once(call("member", 1, list(quote(a), quote(b), quote(c))))

# This query returns an empty list meaning yes, it works
once(call("member", 3, list(1, 2, 3)))

# This query returns a list stating that it works if X = 1
once(call("member", 1, list(quote(a), expression(X))))

# The same query using simplified syntax
q = quote(member(1, ""[a, .X]))
once(as.rolog(q))

# This query returns a list stating that X = 1 and Z = expression(Y)
once(call("=", list(expression(X), expression(Y)), list(1, expression(Z))))

# This works for X = [1 | _]; i.e. something like [|](1, expression(_6330))
once(call("member", 1, expression(X)))

# This returns S = '1.0' (scalar)
once(call("format", call("string", expression(S)), "~w", list(1)), options=list(scalar=TRUE))
  
# This returns S = '#(1.0)' (vector), because the 1 is translated to #(1.0). 
# To prevent "~w" from being translated to $$("~w"), it is given as an atom.
once(call("format", call("string", expression(S)), as.symbol("~w"), list(1)), 
  options=list(scalar=FALSE))

}
\seealso{
\code{\link[=findall]{findall()}}
for querying all solutions

\code{\link[=query]{query()}}, \code{\link[=submit]{submit()}}, and \code{\link[=clear]{clear()}} for fine-grained control over
non-deterministic queries

\code{\link[=rolog_options]{rolog_options()}}
for options controlling R to prolog translation
}
