% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChunks.R
\name{getChunks}
\alias{getChunks}
\alias{getNames}
\alias{getDates}
\alias{getDocs}
\alias{getVocab}
\alias{getLDA.RollingLDA}
\alias{getID.RollingLDA}
\alias{getParam.RollingLDA}
\title{Getter for RollingLDA}
\usage{
getChunks(x)

getNames(x)

getDates(x, names, inverse)

getDocs(x, names, inverse)

getVocab(x)

\method{getLDA}{RollingLDA}(x, job, reduce, all)

\method{getID}{RollingLDA}(x)

\method{getParam}{RollingLDA}(x)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link{RollingLDA}} object.}

\item{names}{[\code{character}]\cr
Names of the requested items (dates or docs). Default are all names.}

\item{inverse}{[\code{logical(1)}]\cr
Should all items except those with the given names be returned? Default is \code{FALSE}.}

\item{job}{not implemented for \code{\link{RollingLDA}} object.
See \code{\link[ldaPrototype:getSCLOP]{getLDA}}}

\item{reduce}{not implemented for \code{\link{RollingLDA}} object.
See \code{\link[ldaPrototype:getSCLOP]{getLDA}}}

\item{all}{not implemented for \code{\link{RollingLDA}} object.
See \code{\link[ldaPrototype:getSCLOP]{getLDA}}}
}
\value{
The requested element of a \code{\link{RollingLDA}} object.
}
\description{
Returns the corresponding element of a \code{\link{RollingLDA}} object.
}
\seealso{
Other RollingLDA functions: 
\code{\link{RollingLDA}()},
\code{\link{as.RollingLDA}()},
\code{\link{updateRollingLDA}()}
}
\concept{RollingLDA functions}
