% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolayer.R
\name{as_GeoPackage}
\alias{as_GeoPackage}
\alias{as_GeoPackage.geolayer}
\title{Save as \code{GeoPackage}}
\usage{
as_GeoPackage(gl, dir, name, keep_all_variables_na)

\method{as_GeoPackage}{geolayer}(gl, dir = NULL, name = NULL, keep_all_variables_na = FALSE)
}
\arguments{
\item{gl}{A \code{geolayer} object.}

\item{dir}{A string.}

\item{name}{A string, file name.}

\item{keep_all_variables_na}{A boolean, keep rows with all variables NA.}
}
\value{
A string, file name.
}
\description{
Save the geolayer (geographic information layer) and the variables layer in a
file in \code{GeoPackage} format to be able to work with other tools.
}
\details{
If the file name is not indicated, it defaults to the name of the geovariable.

By default, rows that are NA for all variables are eliminated.

The \code{GeoPackage} format only allows defining a maximum of 1998 columns. If the
number of variables and columns in the geographic layer exceeds this number,
it cannot be saved in this format.
}
\examples{

gl <- mrs_db_geo |>
  as_geolayer()

f <- gl |>
  as_GeoPackage(dir = tempdir())

}
\seealso{
Other query functions: 
\code{\link{as_geolayer}()},
\code{\link{filter_dimension}()},
\code{\link{get_layer}()},
\code{\link{get_variable_description}()},
\code{\link{get_variables}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{set_layer}()},
\code{\link{set_variables}()},
\code{\link{star_query}()}
}
\concept{query functions}
