% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_sources.R
\name{merge_sources}
\alias{merge_sources}
\title{Merge source files by different coders}
\usage{
merge_sources(
  input,
  output,
  outputPrefix = "",
  outputSuffix = "_merged",
  primarySourcesRegex = ".*",
  primarySourcesIgnoreRegex = outputSuffix,
  primarySourcesPath = input,
  recursive = TRUE,
  primarySourcesRecursive = recursive,
  filenameRegex = ".*",
  postponeDeductiveTreeBuilding = TRUE,
  ignoreOddDelimiters = FALSE,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent),
  inheritSilence = FALSE
)
}
\arguments{
\item{input}{The directory containing the input sources.}

\item{output}{The path to the directory where to store the merged sources.
This path will be created with a warning if it does not exist. An exception
is if "\code{same}" is specified - in that case, every file will be written to the
same directory it was read from.}

\item{outputPrefix, outputSuffix}{A pre- and/or suffix to add to the filename
when writing the merged sources (especially useful when writing them to the
same directory).}

\item{primarySourcesRegex}{A regular expression that specifies how to
recognize the primary sources (i.e. the files used as the basis, to which
the codes from other sources are added).}

\item{primarySourcesIgnoreRegex}{A regular expression that specifies which
files to ignore as primary files.}

\item{primarySourcesPath}{The path containing the primary sources.}

\item{recursive, primarySourcesRecursive}{Whether to read files from
sub-directories (\code{TRUE}) or not.}

\item{filenameRegex}{Only files matching this regular expression are read.}

\item{postponeDeductiveTreeBuilding}{Whether to imediately try to build the deductive
tree(s) based on the information in this file (\code{FALSE}) or whether to skip that. Skipping
this is useful if the full tree information is distributed over multiple files (in which case
you should probably call \code{parse_sources} instead of \code{parse_source}).}

\item{ignoreOddDelimiters}{If an odd number of YAML delimiters is encountered, whether this
should result in an error (\code{FALSE}) or just be silently ignored (\code{TRUE}).}

\item{preventOverwriting}{Whether to prevent overwriting existing files or not.}

\item{encoding}{The encoding of the file to read (in \code{file}).}

\item{silent}{Whether to provide (\code{FALSE}) or suppress (\code{TRUE}) more detailed progress updates.}

\item{inheritSilence}{If not silent, whether to let functions called
by \code{merge_sources} inherit that setting.}
}
\value{
Invisibly, a list of the parsed, primary, and merged sources.
}
\description{
This function takes sets of sources and merges them using the utterance
identifiers (UIDs) to match them.
}
