% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_to_html.R, R/export_to_markdown.R
\name{export_to_html}
\alias{export_to_html}
\alias{export_to_markdown}
\title{Export parsed sources to HTML or Markdown}
\usage{
export_to_html(
  input,
  output = NULL,
  template = "default",
  fragment = FALSE,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)

export_to_markdown(
  input,
  heading = "Sources",
  headingLevel = 2,
  template = "default",
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{input}{An object of class \code{rock_parsedSource} (as resulting from a call
to \code{parse_source}) or of class \code{rock_parsedSources} (as resulting from a call
to \code{parse_sources}.}

\item{output}{For \code{export_to_html}, either NULL to not write any files,
or, if \code{input} is a single \code{rock_parsedSource}, the filename to write to,
and if \code{input} is a \code{rock_parsedSources} object, the path to write to.
This path will be created with a warning if it does not exist.}

\item{template}{The template to load; either the name of one
of the ROCK templates (currently, only 'default' is available), or
the path and filename of a CSS file.}

\item{fragment}{Whether to include the CSS and HTML tags (\code{FALSE}) or just
return the fragment(s) with the source(s) (\code{TRUE}).}

\item{preventOverwriting}{For \code{export_to_html}, whether to prevent overwriting
of output files.}

\item{encoding}{For \code{export_to_html}, the encoding to use when writing
the exported source(s).}

\item{silent}{Whether to suppress messages.}

\item{heading, headingLevel}{For}
}
\value{
A character vector or a list of character vectors.
}
\description{
These function can be used to convert one or more parsed sources to HTML,
or to convert all sources to tabbed sections in Markdown.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Parse all example sources in that directory
parsedExamples <- rock::parse_sources(examplePath);

### Export results to a temporary directory
tmpDir <- tempdir(check = TRUE);
prettySources <-
  export_to_html(input = parsedExamples,
                 output = tmpDir);

### Show first one
print(prettySources[[1]]);

}
