# count_indices() works as intended

    [[1]]
     [1]  9 10  7  8  6  7  3  8 10  7
    
    [[2]]
     [1] 10  2  8  8  7  6  7  6  2  5
    
    [[3]]
     [1]  9  2 10  5 10  1  7 10  2  9
    
    [[4]]
     [1]  4  2  8  3  6  2  1 10 10  1
    
    [[5]]
     [1]  9  9  8  5 10  9  1  7  8  2
    

---

    [[1]]
     [1]  9  7  8  6  3  2 10  5  4  1
    
    [[2]]
     [1]  8  7  6  9  3  2  1  4 10  5
    
    [[3]]
     [1]  2  5 10  1  8  6  9  7  4  3
    
    [[4]]
     [1]  2  8  3  6  9 10  4  7  1  5
    
    [[5]]
     [1] 10  1  9  8  5  2  7  4  6  3
    

---

    $count_all
         o1 o2 o3 o4 o5 o6 o7 o8 o9 o10
    [1,]  0  0  1  0  0  1  3  2  1   2
    [2,]  0  2  0  0  1  2  2  2  0   1
    [3,]  1  2  0  0  1  0  1  0  2   3
    [4,]  2  2  1  1  0  1  0  1  0   2
    [5,]  1  1  0  0  1  0  1  2  3   1
    
    $count_clean
         o1 o2 o3 o4 o5 o6 o7 o8 o9 o10
    [1,]  0  0  1  0  0  1  3  2  1   2
    [2,]  0  2  0  0  1  2  2  2  0   1
    [3,]  1  2  0  0  1  0  1  0  2   3
    [4,]  2  2  1  1  0  1  0  1  0   2
    [5,]  1  1  0  0  1  0  1  2  3   1
    

---

    $count_all
         o1 o2 o3 o4 o5
    [1,]  0  0  1  0  0
    [2,]  0  2  0  0  1
    [3,]  1  2  0  0  1
    [4,]  2  2  1  1  0
    [5,]  1  1  0  0  1
    
    $count_clean
         o1 o3 o5
    [1,]  0  1  0
    [2,]  0  0  1
    [3,]  1  0  1
    [4,]  2  1  0
    [5,]  1  0  1
    

---

    $count_all
         o1 o2 o3 o4 o5 o6 o7 o8 o9 o10
    [1,]  1  1  1  1  1  1  1  1  1   1
    [2,]  1  1  1  1  1  1  1  1  1   1
    [3,]  1  1  1  1  1  1  1  1  1   1
    [4,]  1  1  1  1  1  1  1  1  1   1
    [5,]  1  1  1  1  1  1  1  1  1   1
    
    $count_clean
         o1 o2 o3 o4 o5 o6 o7 o8 o9 o10
    [1,]  1  1  1  1  1  1  1  1  1   1
    [2,]  1  1  1  1  1  1  1  1  1   1
    [3,]  1  1  1  1  1  1  1  1  1   1
    [4,]  1  1  1  1  1  1  1  1  1   1
    [5,]  1  1  1  1  1  1  1  1  1   1
    

# nonparametric_resampling() works correctly

                         mpg cyl  disp  hp drat    wt  qsec vs am gear carb
    Pontiac Firebird    19.2   8 400.0 175 3.08 3.845 17.05  0  0    3    2
    Hornet 4 Drive      21.4   6 258.0 110 3.08 3.215 19.44  1  0    3    1
    Duster 360          14.3   8 360.0 245 3.21 3.570 15.84  0  0    3    4
    Mazda RX4           21.0   6 160.0 110 3.90 2.620 16.46  0  1    4    4
    Mazda RX4 Wag       21.0   6 160.0 110 3.90 2.875 17.02  0  1    4    4
    Ford Pantera L      15.8   8 351.0 264 4.22 3.170 14.50  0  1    5    4
    AMC Javelin         15.2   8 304.0 150 3.15 3.435 17.30  0  0    3    2
    Merc 280C           17.8   6 167.6 123 3.92 3.440 18.90  1  0    4    4
    Merc 450SLC         15.2   8 275.8 180 3.07 3.780 18.00  0  0    3    3
    Fiat 128            32.4   4  78.7  66 4.08 2.200 19.47  1  1    4    1
    Porsche 914-2       26.0   4 120.3  91 4.43 2.140 16.70  0  1    5    2
    Honda Civic         30.4   4  75.7  52 4.93 1.615 18.52  1  1    4    2
    Mazda RX4.1         21.0   6 160.0 110 3.90 2.620 16.46  0  1    4    4
    Toyota Corona       21.5   4 120.1  97 3.70 2.465 20.01  1  0    3    1
    Toyota Corona.1     21.5   4 120.1  97 3.70 2.465 20.01  1  0    3    1
    Merc 280            19.2   6 167.6 123 3.92 3.440 18.30  1  0    4    4
    Dodge Challenger    15.5   8 318.0 150 2.76 3.520 16.87  0  0    3    2
    Merc 450SLC.1       15.2   8 275.8 180 3.07 3.780 18.00  0  0    3    3
    Merc 280.1          19.2   6 167.6 123 3.92 3.440 18.30  1  0    4    4
    Duster 360.1        14.3   8 360.0 245 3.21 3.570 15.84  0  0    3    4
    Merc 230            22.8   4 140.8  95 3.92 3.150 22.90  1  0    4    2
    Cadillac Fleetwood  10.4   8 472.0 205 2.93 5.250 17.98  0  0    3    4
    Toyota Corona.2     21.5   4 120.1  97 3.70 2.465 20.01  1  0    3    1
    Hornet Sportabout   18.7   8 360.0 175 3.15 3.440 17.02  0  0    3    2
    Merc 230.1          22.8   4 140.8  95 3.92 3.150 22.90  1  0    4    2
    Pontiac Firebird.1  19.2   8 400.0 175 3.08 3.845 17.05  0  0    3    2
    Merc 450SLC.2       15.2   8 275.8 180 3.07 3.780 18.00  0  0    3    3
    Hornet Sportabout.1 18.7   8 360.0 175 3.15 3.440 17.02  0  0    3    2
    Hornet Sportabout.2 18.7   8 360.0 175 3.15 3.440 17.02  0  0    3    2
    Mazda RX4 Wag.1     21.0   6 160.0 110 3.90 2.875 17.02  0  1    4    4
    Merc 280.2          19.2   6 167.6 123 3.92 3.440 18.30  1  0    4    4
    Ferrari Dino        19.7   6 145.0 175 3.62 2.770 15.50  0  1    5    6

# case_resampling() works correctly

    $boot
       X.Intercept. x1           x2          x3          x4        x5  m gauge  r
    1   -0.16423128 NA  0.098389523  0.75544122  0.81082980 0.4197672 m0 0.043  0
    2   -0.17641899 NA  0.071183572  0.71576933  0.86079250 0.4302637 m1 0.039  0
    3   -0.17957381 NA  0.075094037  0.71608011  0.86421766 0.4395321 m2 0.036  0
    4   -0.16902999 NA  0.117491453  0.75348517  0.80018782 0.4508008 m3 0.033  0
    5   -0.42449811 NA -0.288914127  0.29582354  1.60544532 0.3284866 m0 0.041  1
    6   -0.66766994 NA -0.582144442  0.02607292  2.17446498 0.2294951 m1 0.031  1
    7   -0.72704392 NA -0.681359078 -0.07304629  2.34563898 0.2000520 m2 0.029  1
    8   -0.69406169 NA -0.665562475 -0.05843255  2.29979836 0.2117820 m3 0.029  1
    9   -0.19486576 NA  0.115011277  0.69755470  0.81243705 0.4497745 m0 0.042  2
    10  -0.06698538 NA  0.266355756  0.88557640  0.45617898 0.4923297 m1 0.035  2
    11  -0.14042871 NA  0.187046924  0.79198063  0.62747742 0.4559267 m2 0.035  2
    12  -0.10847011 NA  0.237704661  0.84431447  0.53478485 0.4775256 m3 0.035  2
    13  -0.04339017 NA  0.106041162  0.70069444  0.76295660 0.4351493 m0 0.037  3
    14  -0.11353069 NA -0.085681191  0.46397661  1.10889605 0.3882579 m1 0.036  3
    15  -0.06203791 NA -0.019267127  0.54518420  0.97824521 0.4017733 m2 0.034  3
    16  -0.12728190 NA -0.106086047  0.44072348  1.14556612 0.3839510 m3 0.032  3
    17   0.83553644 NA  2.087913904  2.64978492 -2.52009639 0.7965948 m0 0.046  4
    18  -0.09545578 NA -0.003440662  0.66417445  0.92231535 0.3189445 m1 0.021  4
    19   0.73068933 NA  1.874113656  2.46842779 -2.22355558 0.7081355 m2 0.023  4
    20  -0.23985643 NA -0.266659252  0.41783944  1.37443396 0.2684028 m3 0.016  4
    21  -0.19320960 NA  0.252624039  0.90274986  0.61218833 0.4134014 m0 0.048  5
    22  -0.21998948 NA  0.316498804  0.94400651  0.49267987 0.4425193 m1 0.037  5
    23  -0.16533341 NA  0.391511637  1.00907429  0.33273838 0.4559481 m2 0.035  5
    24  -0.15760810 NA  0.487681517  1.08074554  0.19383771 0.4916161 m3 0.036  5
    25   0.09273114 NA  0.486968415  1.24663148  0.07171286 0.4669341 m0 0.051  6
    26  -0.13916971 NA  0.027456398  0.80218240  0.84554412 0.3447881 m1 0.048  6
    27   0.02784970 NA  0.533393337  1.23705375  0.08812366 0.5008808 m2 0.046  6
    28  -0.18798041 NA -0.073809969  0.70403857  1.00387969 0.3231212 m3 0.039  6
    29  -0.28949315 NA  0.047675421  0.63783829  1.10392763 0.3763080 m0 0.035  7
    30  -0.43187099 NA -0.158525453  0.44955118  1.46620586 0.3417812 m1 0.026  7
    31  -0.38231527 NA -0.088523817  0.51214983  1.36528755 0.3679794 m2 0.028  7
    32  -0.45885042 NA -0.229509423  0.35852981  1.61709164 0.3330355 m3 0.025  7
    33   0.10618913 NA  0.946256282  1.47672358 -0.42240291 0.6128926 m0 0.039  8
    34  -0.08949921 NA  0.555232279  1.07396465  0.23298910 0.5448959 m1 0.014  8
    35   0.20144970 NA  1.199762684  1.69305590 -0.82245966 0.6647764 m2 0.018  8
    36   0.10020972 NA  0.915375000  1.41331995 -0.37964457 0.6174150 m3 0.013  8
    37  -0.23013345 NA  0.295730521  0.80235224  0.66011659 0.4757657 m0 0.040  9
    38  -0.27836399 NA  0.277611125  0.77103108  0.67704502 0.4613643 m1 0.031  9
    39  -0.31452959 NA  0.212991731  0.70951150  0.75326911 0.4560612 m2 0.031  9
    40  -0.31452959 NA  0.212991731  0.70951150  0.75326911 0.4560612 m3 0.031  9
    41  -0.16948269 NA -0.403674531  0.20520774  1.61141101 0.3931555 m0 0.051 10
    42  -0.29170790 NA -0.600097755  0.06787593  1.90265441 0.3432818 m1 0.046 10
    43  -0.30357462 NA -0.643417647  0.04017581  1.93244187 0.3260526 m2 0.044 10
    44  -0.30617004 NA -0.665684997  0.02899548  1.95581464 0.3146685 m3 0.039 10
    
    $resamples
    $resamples[[1]]
       [1]  491  649  330  368  460  439  584  438  423  511  723  344  271  143
      [15]  938  455  330  930  536  525  351  392  622  775  998  231  667  342
      [29]  338  797  285  981  889  604   50  877  666  101  890   33  647  666
      [43]  946  670  324   93  114  600  307  694  955  754  288  267  335  417
      [57]  938  604  347   42  334   13  417  361  729  712  656  373   26  857
      [71]  209   48  663  527  958  878  536  482  317  132  739  270  929   35
      [85]  266   74  570  679  912  271  543  906  101  435  437  959  613  621
      [99]  943   39  947  630   89  530  899  982  554  394  254  192  955  761
     [113]  847  461  602  746  334  860  930  377  763  192    4   63  532  575
     [127]  861  867  855  224  753  176   94  660  182  825  227  508   27  905
     [141]   80  432  649  477  207  369  886  298  631  457   72  350  537  384
     [155]  612  931  571  302   51  371  460  790  602  865  895  909  774   40
     [169]  774  716  309  160  927  580  280  117  562  685  151  145  299  793
     [183]  129   68  478  349  654  636  472  109  102  757  788  935  990  834
     [197]  285  305  412  284  561  908  763  935  872  668  670  942  742  475
     [211]  117  963  283   60  718  940  426  990  731  330  576  699   72  454
     [225]  645  873  991  178  463  944  348  657  311  526   69   70  173   95
     [239]  149  470  195  412  430  339  972 1000  543    8  294  957  220  286
     [253]  930  213  285  233  109   22  158  509  479  872  900  671  209  429
     [267]  721  152  583   27  430  874  703  134  679    4  737  308  461  602
     [281]  181  488  565  302   96  853  987  962  618  614  735  215   32  230
     [295]  367  270  524  703  671   64  356  400  444  365  294  665  278  651
     [309]  547  703  379  605  668  610  577  328  663  880  743  577  510  385
     [323]  147  729  966  166  206   62  559   71  682  494  861   98  177   36
     [337]  726  627  679  811  796  119  185  866  564  536  798  687  245  575
     [351]  217  897  349  612  559  585  372  786  573  760  988  137  878  266
     [365]  783  572  333  389   90  636  349  152  188  752  901  490  793  743
     [379]  886  672  462  525  555  598  129   60  851  647  676  980  670  494
     [393]  706  176  847  894  304   55  756   46  756  660  976  107  164  891
     [407]  655  816  490  617   89  264  256  625  626  565  384  680  323  384
     [421]  192  838  391  697  710  684  556  817  274  223  543  801  762  766
     [435]  896  572  724  993  275  539  569  721  181  362  493  256  724   58
     [449]  613  569  126  998  996   25  582  457  721  234  471  390  414  532
     [463]  376  738  837  149  899  503  305  842  773  381  542  467  398  238
     [477]  577  933  853  572  470   90  900   22  370  396   56  181   12  972
     [491]  289  418    6  212  772  616  625  788  693  418  903   20  813   56
     [505]  653   89  228  530  777  483  979  273  194  805  768  940  650  651
     [519]  425  928  552  573  436   48  292  486  952  811  455  601  707  351
     [533]  199  105   43  178  143  656  533  530  914  711  148   71  507  890
     [547]  783  766  322   17  221  672  645  879  147  999  399  466   58  968
     [561]  202  515  889  693  514  637  750  726  731  739  921  683  291  583
     [575]   10  791  335  604  622  632  902   74  530  645  106  587   59  524
     [589]  858  764  885  249  952  926  580  307  700  198  527  103  591  797
     [603]  839  986  139  115  683  839  527  361  627  477  852  278  915  853
     [617]  497  545  266   73  622   19  321  756  813  646  655  696  286  186
     [631]  400   63  392  716  810  972  416  450   91  136  845  954  849  584
     [645]  657  139   67  837  901  205  159  465  704  690  663  690   35  391
     [659]  241  679  568  462  671  740  239  483  159   69  347  188  196  701
     [673]    9  968  909   11  182  644  996  204  291  596  652  919  664  736
     [687]   18    7  548  494   69  483  429  640  589   12  429  624  320  666
     [701]  351  337  229  592  911  600  413  249  380   39  803  176   19  339
     [715]  735  667  654  529   22  292  341  576    4  731  520  298  877  289
     [729]  979   31  889  593  380  159  191  286  158  459  916  179  341  775
     [743]  405  449  314   54  122   58  238  677  123  657  501  726  146  379
     [757]  469  851   56  284  857  127  319  308  630  739  953  810    5  598
     [771]  581  234  194  703  889  994  935  590  363  975  532  570   74  178
     [785]  582  997  615  417  632   81  507   95  669  747  628  831  653  362
     [799]   97  221  623  868   40  725  633  557  574  522  681  789  508  629
     [813]   40    4   89  842  456  624  909  819  353   95  973  875  701   73
     [827]   40  943  716  589  553  773  721  312  218  985  399  608  635  897
     [841]  317  292  849  871  893  808  701  510  455    7   32  353  818  499
     [855]   60  984   97  394  845   92  843  416    1  101  365  333  637  974
     [869]  712  937   12  973  482  737   81  660  110  738   99  909  520  284
     [883]  290  183  497   88  576  387  410  344   60  780  493  233  805  420
     [897]   75  175  242    5  789  935   60  457  352  826  269  416  523  205
     [911]  339  303  798  262  641  435  843  621  186  962  876  228  751   23
     [925]  991  431  986   57  786  930  227  111  126  192  434  718  570  707
     [939]  280  404  971  573   10  100   19  151  709  588  163  213  580  721
     [953]  415   88  313  402  966  782  658  592  757  713   34  680  302  473
     [967]  796  903  898  239  144   48  651  874   29  635  832  336  182  710
     [981]  463  910  642  411  226  970  800  329  228  117  670  124  903  770
     [995]  950  902  779  764  118  149
    
    $resamples[[2]]
       [1] 180 354 675 733 156 616 122 843 748 311 818 680 408 847 656 232 355 730
      [19] 896 166 880 871 835  67 300 518 752  40 103  16 915 538 691 683 746 677
      [37] 858 755  19 491 826 805 692  60 758 573 344 449 613 853 709 855 254 199
      [55] 313 900  66 602  90 248 863 994 384 633 328 726 457 815 298 443 454 450
      [73] 835 868 401 844 162 753 523 615 269 661 923  31 733 100 532 819 684 572
      [91] 472 279 758 914 760 604 368 395  58 655 733 340 487 759 668 584 394  82
     [109] 581  46 349 173 937 442 527 800 517 673 686 124 556 760 200 251 701 408
     [127] 439 760 277  64 683 497 894 413 373 533 589 671  68 745 360 955 526 888
     [145] 164 728 987 780 503 897 668  79 326 317 315 684 506 537 657 994  40 317
     [163] 763 241 313 881 848 307 641 752 406 544 981 693 765 549 618  74 610 420
     [181] 989 127 810 276 232 797 844 483 879 410 675 320 626 973 815 778 598 414
     [199] 215 951  13 520   3 379 685 764 558 411 282 969  17 493 221 385  15 790
     [217] 516 266 975  64 761 391 410 880 486 122 726 524 165 468 792 113 351 673
     [235] 228 574 182 390 101 843 274 711 638 236 954 404 533 693 770 977 398 841
     [253] 649 880 242 505 459 113 917  35 443 245 386 756 578 823 683 262 627 665
     [271] 510 648 235 993 380 273 931 808 570  26 479 290 797 263 568  51 305 520
     [289] 744 705 978 270 238 400 917 228 119 171 985  36 378 807 720 114 940 998
     [307] 379  12 804 360 921  26 454 612 536 370 719 307 335 139 707 142 329 801
     [325] 887 160 511 702 873 198 688 903 338 838 560 877 840 895 105 647 753  58
     [343] 209 840 385 451 146 429 686 521 905 230 865  28 900 252 437 889 411 547
     [361] 765 143 375   2 780 273 430 360 589 516 276 495 599  71 265  77 580 151
     [379] 413 998 812 299  59 493 588 325 426 797 889 120 773 432  89 614 520 998
     [397] 177 269 989 246 737 850 453 587 379 812 903 227 283 229 160 523 893  66
     [415] 277 302 691 269 589 387 220 857 464 544  34  50  48 930 488  90 173 361
     [433] 187  85 462 438 837 453  15 908  54  85 161  44 938 339 436 157 419 157
     [451] 228 674 863 840 945 781 747 358 990 712 723 174 448 978 956 585 335 767
     [469] 804 459 239 137 663 302 445 125 308 986 758 854 862 379 396 165  31 300
     [487] 323 775 933 330 503 255 115 136 490 884 262 555 115 479 895 855 831 185
     [505] 772 208 155 297 460  36 560 298 977 666   5 760 967 663 524 443 922  81
     [523]  42 634   2 918 238 747 301 152 749 538 822 166 532 549 614  41 475 846
     [541] 310 157 749 787 971  12 538 590 656  97 529 419 383 242 129 241 766 813
     [559] 601 946 819 675  80  18 631 352 236  80 798 785  77 672 746 142 835  46
     [577]  12 871  70 668 985  56 383 328  58 985 233 796 228 735 340 325 562 426
     [595] 305 141 185 451 421 197  83 636 923 903 813 848 175 998 613 563 540 458
     [613] 908 223 559 650 448 655 478 456 634 533 697 217 564 755 230  58 403 981
     [631] 592 452 172 900 642 426 212 392 920 818 974 403 766 287  25 846 142 476
     [649] 786  56 218   9 397   8 581 419 613 696 472 502 619 629 353   3 153 322
     [667] 392 259 960 392 509 626 202 633 325 704 166 607 302 524 783 732 233 239
     [685] 971 647 110 540 264 582 959 192 452 124 962 774 884 178 407 573 186 894
     [703] 876 480 380 450 230 760 276 960 563  76 309 775 503 471   9 842 117 211
     [721]  21  68 406 575 679 449 288 321 987 306 428 888 736 990 638 800 609 189
     [739] 589 661 232 834 605 447 362 874 578 705 969 594 650 988 337 268 687 151
     [757] 138 526 150 155 140 853 682 226  98 621 203 586 214 542 695 471 836 959
     [775] 777 657 965  77 950 252  95 860 194 214 397 475 404  89 726 709 115 181
     [793] 507   7 962 244 993 509  66 852 879 629 956 609 369 968 780 409 958 399
     [811] 395 575 254 633 808 177  94 889 351 257 742 649 700 365 375 128  33  66
     [829] 723 354 429 790 833 932 178 498 865 919  48 602 659  69  13 656 290 952
     [847] 676 443 501 386 424 944  74 862 677 858 200 188 342 636 568 726 558 259
     [865] 408 345 263 126 307 384 830  45 542 665 505 165  64 710 706 347   3 656
     [883] 696 383  10 307 319  69 290 654 863 504 146  78 321 229 638 773 832  28
     [901] 900 798 411 291 775 183  24 448 404 694 979 601 905 110  59 247 223 248
     [919] 611 343 597  97 186 945 982 542 686 856 966 937 276 660 936 351 338 462
     [937] 166 328 358 746 603 883 613 200 846 651 744 925 360 184 655 780 401 669
     [955] 907 472 151 638 707 274 134 787 616 466 212 116  86  41 998 363 638 268
     [973] 134 486 454 786  29 259 651 652 773 896 779 480 969 910  49 361 565 168
     [991] 782 748 542 675 219 556 831 760 794 227
    
    $resamples[[3]]
       [1]  694  707  134  766  839  891  866  881   99  536  685  230  578  991
      [15]  323  788  861  460  285  819  435  578  543  703  606  925  636  784
      [29]  339  731   36  401  270  704  545   36  344  139  888  979  283  359
      [43]  787  678  493  691  519  184  366    5  797  160  983  327   80  248
      [57]  289  882  493  290  662  205  982  329  330   80  202  163  565  716
      [71]  122  975    6    6  363  757  752  782  149  160  519  591   67   85
      [85]    8  407  292  338  173  501  924  997  554  712  317   23  963  111
      [99]  590  941  146  971  473  993  457  153  835  666  394  794  892  632
     [113]  694  615  905    3   41  922  124  513  573  916  365   71  915  106
     [127]  311   31  590  789  532  343  498  639   92  819  112  978   95    8
     [141]  475  414  864  254  540   25  828  267  566  181  855  271  965  768
     [155]   45  391  717   73  297  679  985  386  727  182  119   12  957  762
     [169]   57  331  281  232  788  613   98  555  131   24  117   58  641  714
     [183]  930  221  679  174  839  466  775  122  949  989  905  799  309  947
     [197]  671  942   40  303  770  163  883  918  944  991  338  581  459  799
     [211]   61  373  286  391  770  845  585  168  699   68  928  841  335  395
     [225]  541  657  475  692  576  158  456  758  181  697  991  378  650  576
     [239]  973  614    1  958  477  112  881  341  490  362  509  859  617  228
     [253]  179  316   56  131  327  967  431  687  962  387  156  909  197  822
     [267]  231  387  840  962  832  133    9  196  270  750  356  313  962  861
     [281]   30  699   29  123  219  286  679  690  712  735  162  766  470  189
     [295]  317  290  435  625  798  749  675  257  810   54  671  351  958  600
     [309]  993  712  194  750  856  631  231  283  822  322  631  886  642  878
     [323]  482  329  989  791   80  923  870  789  950  131  519  807  525  161
     [337]   18  739  111  493  145  191  117  680  495  391  809  580  541  430
     [351]  215  897  758  892  697  424  323  181  571  143  227  481  283  925
     [365]  837  969  718  682  975  636  226  758  310  122  577  887   25  561
     [379]  848  655  100  292  792  415  819  517  167  840  243  571  306  107
     [393]  766  997  946  532  675  556  996  779  608   30  511   72  455  605
     [407]  707  114  149  289  461  905  490  781   97  621  318  129  104   27
     [421]  275  997  290  579  671  887  185  686  407  741  486  560  143  101
     [435]  345  509  238  673  349  817  878  620  751    2  555  919  986  866
     [449]   35   57  240  469  808  747  679  893  861  590  850  905  181  250
     [463]  441  655  675  754  932  375  622  837  850  697  446  363  184  186
     [477]  419  874  148  779  386  790  989  899  599  795  464    5  267  588
     [491]  891  904  398  716  360  331  736  206   50  976  658  974  500  818
     [505]  115   99  200   92  119  921   89  113  666  185  734  952  901  854
     [519]  668  758  258  770  373  221  811  622  725   33  107   17  213  284
     [533]  518  451  678  757  581  997  553  701   22  878  421  885  927  806
     [547]  167   95  293  696  795  878  384  236   85  509  729  558  759  598
     [561]  261  360   89  583  839  418  669   52  303  562  286  207  315   39
     [575]  533    5  688  397  352  512  213  775  489   24  677  495  565  545
     [589]  411  655  954   98  101  436  617  204  127   50  357  223  832  175
     [603]  746  223  972  988  165  491  715  671  793  697  434  801  139  119
     [617]   89  883  889  936  813  678  927  837  271  161  988  390  792  977
     [631]  949  134  314  680  461  286  942  624  126  571  636  354  849  425
     [645]  239  859  262  753  359  127  987  194  494  268  445  908  565  951
     [659]  573   86  213  737   92  447  888  449  661  834  238  720  790  507
     [673]  730  443  829   37  977  270  338  214  149  298   59  121  708   68
     [687]  998  424  565   24  649  964  318  525  659  201  943  366  261  528
     [701]  581  966   16  171  222  578  316  501  995   11  374  993  804  161
     [715]  592  409  462  863  450  345  953  688  598  872  727  367  296   97
     [729]  390  344  969  963  812  314  877  424  228  720  672  446  317  109
     [743]  374  654  561   82  202  309   35  447   26  561  217  472  442  329
     [757]   93  471  531  159   32  436  587  806  664   73  591  525  931  849
     [771]  855  303  703  968  651   75  213  590 1000  516  323  246  404  468
     [785]  410  431  886  274   85   38  809  751   20  515  386  482  691  772
     [799]  508  331  275  158  885  731   73  192  582   54  248   78  677  180
     [813]  799  885  295  842  695  318  177  907  367  101  362  379   25  348
     [827]  267  438   72   17  318   61  443  814  285  719  477  385   31  612
     [841]  532  311  477  320  429  733   68  202  735  865  851  427  960  127
     [855]  164  491   51  446  283  734  732  800  965  139  747  166  519  659
     [869]  915  456   43  549  590  794   27  437  842  799   64  370  583  922
     [883]  385  640  116  251  542  535  407  413   20  392  200  962  456  511
     [897]  334  746  202  183  803  241  249  927  956  269   10  256  923  858
     [911]  969  511  151  133  959  763  258  556   59  277  473  400  336  443
     [925]  860  642  776   29  998  843  771  627   60  427  209  446  574  288
     [939]  893  196  398  337  304  794  288   41  103   18  196  311  616  219
     [953]  355  940  456  930  582  453  431  221  906  829  761  168  251  701
     [967]  133  696  181  448  468  889  685   84  944  290  791  517  647  576
     [981]  437   10  680  856  353  361  456  960  782  874  425  185  429  716
     [995]  748  190  661  350  497  595
    
    $resamples[[4]]
       [1]   12   97  794  743  193  642  964  390  220   36   24  689  178  344
      [15]  934  993  407  350  808  662  112  973  183  969  354   45  574  154
      [29]  713  251  115  957  897  263  416  227  662   20  501  733  360  731
      [43]  574  161  614  802  990  732  722  383   19  646  217  762  320  908
      [57]  569   99  552   47  300  629  212  786   26   98  952  697  177  987
      [71]  513  492  118  419  662  445   11  253  452  733  690  528  202  532
      [85]  273  102  859  224  234  283  558  118  565  429  659  451  543  739
      [99]   71  170  486  551  192  288   13  328  867  594  812  824  344  195
     [113]  344  543  498  993  227  583   59  944  752  479  151  627  257  343
     [127]  548  723  317  880  889  243   47  514  200  694   29  850  610  860
     [141]  866  430  254  648  320  107  883  935  384  777  597    8  218  569
     [155]   25  234  763  349  410  867  715  315  275  630  496  937  691  203
     [169]  487  773  154  794  199  229  218  433  854  572    7  776  529  321
     [183]  517  643  725  161  416  276  659  721  471  487  425  131  243   11
     [197]  795   90  207  225  442  708  643  708  492  827  633  329  805  806
     [211]  381  544  541  558  944  295  621  177   42  702  428  903 1000  995
     [225]  707  587   13  556  400  636  899  744  649  589  529  228  393  616
     [239]  356  293  739  795    3  465  885  605  197  894  152  785  498  271
     [253]  339  378  494  754  412  821  418  690  166  331  731  819   14  464
     [267]  520  438  900   36  305   47  857  955  206  346  372  599  763  494
     [281]  100  871  565  881  499   96  240  902  200  849  938  841  918  296
     [295]  887  460  886  388  371  782  806  601  242  457  735  806  656  364
     [309]  518  253  265  623  700  814  777  442  747  718  752   37  916  580
     [323]  537  250  463  467  714  116  127  396  110  867  107  666  642  205
     [337]  695   44  306  987  788  985  206  875  318  995  853  240  312    8
     [351]  418   18  108  214  700  317   38  958  156  602  603  622  996  992
     [365]  201  267  409  371   78  825   30  907  500  330  901  984  370  490
     [379]  852  821  748  971   81  337  301  707  795   57  992  768  301  945
     [393]    1  259  487  262  634  571  356   71  547  257  250  922  414   41
     [407]  896  811  991   89  410  372  154  872  792   37  893  456   81  974
     [421]  617  227  451  436  591   28  379  548  318  729  694  261  638  359
     [435]  620  894  955  728  683  914  547  345  744  319  770  510  486  440
     [449]  331  103  670  797  331  732  186  818  192  779  966  139  126  872
     [463]  814  452   15  830  916  122  820  781  715  606  105  961  527  716
     [477]  242  870  681  743  223   36   56  695  944  821  602  478  521  345
     [491]  938  159  167  718  632  690  886  472  990  551   60  485  970  987
     [505]  115  365  365  315  711  450  405    1  416  724  830  594  477  674
     [519]  235  702  552  246  164  751  236  144   95  259  512  794   54  965
     [533]  430  622  905  462  654  446  232  255  525  878  326   82  327  636
     [547]   66   78  409  938  178  550  603  977  141  514  634  785  471  369
     [561]  288  599  465  446  716  650  258  141  646   97  900  466  240  313
     [575]  799  156   56  276  663  808  369  439  111  886  472  981  563  163
     [589]  377  260  798  179  484  482  530  912  631  235  354  239  256  346
     [603]  115  834  811  256  672  766  919  121  767  477   93  208  586  653
     [617]  322  373  582  815  710   75 1000  339  618  173  340   83  597  104
     [631]  393  572  149  428  406  283  467  530  163  739  345  727  281  623
     [645]  968  329  820  747  860  813  868  595  208  241  180  287  332  130
     [659]   89  994  842  696  311  968  661  667  969  523  211  920  726  497
     [673]  454  587  696  858  371  730  688  607  510  510  268  340  455  522
     [687]  940  461  666  385  109  437  369  450  681  741  135  528  222  274
     [701]  954  304  630  361  194  467   67  899   77  245  417  991  240  142
     [715]  969  543  615  931  160   63  488  969  161  387  958  147  417  988
     [729]   16  269  752  393  319  127  838  258  517  993    3  794  919  746
     [743]  368  800  172  549  678  929  162  406  138  343  407  448  207  774
     [757]  394  185  231  734  617  556  741  787  223  846  520   73  613  455
     [771]  781  369  772  994  531  160  479  618   88   35  244  630  789  951
     [785]  564  902  184  639  401   48  830   61  661  335  947  988  213  574
     [799]  247  178  148  140  225  480  397  779  762  468  368  690  868  896
     [813]  350  855  629  388   48  413   42  500  269  288  587  999  450  777
     [827]  730  991  448  784  831  408  380  559   54  305  904   21  250  852
     [841]  465  667  441  323  236  729  238  555  135  851   64  518  773  316
     [855]  155  296  559  222  493  988  338  802  429  210  990  231  451   85
     [869]  932  359  650  338  589  117  779   70  940  669  900  845  411  838
     [883]  576  525  433  309  232  167  498  322  774  880  360  799  685  600
     [897]  271  563   90  484  380  507  659  536  218  508  256  445  937  925
     [911]  276  269  778  667  414  117   95  135  261  300  326  166  395  677
     [925]  403  947  221  759  529   70  624   43   23  721  126  146  136  158
     [939]  810  274  985   75  709  470  221  866  635  132  540  527  188  493
     [953]  775  727  647  284  629  353  400  730   53  100  814  237  448   27
     [967]  608   80  852   33  968  728  222  565  347  272  920  111  700  660
     [981]  111  192  562    6  294  324  734  354  495  537  364  733  889  375
     [995]  949  297  807  199   11  401
    
    $resamples[[5]]
       [1]  565  837  416  271  105  280  176  217   97  933  111  804  834  416
      [15]  196  623  598  919  862  739  933  405  179  509  723  667  104  523
      [29]  896  299  392  983  856  532   68  549  286  694  338   97  817  256
      [43]  750  146  211  108  669  385  981   23  852  665  919  877  248  509
      [57]  480   62   91  717  333  750  704  734  766  922  621  158  284  715
      [71]  563  771  407  738  177  886   75  456  946  570  646  996  788  355
      [85]  521  886  238  712  104  452  569  321  945  781  511  283  809  689
      [99]  805  600  362  540  438  481  710  182  923  443  493  605  584  766
     [113]  429  938  246  254  976   58  122  380   29  550  294  792  978  670
     [127]  422  859  741   48  290   60  189  395  350  639  351  664  958  675
     [141]  803  693  324  204  316  854  810  362  155  700  454  895  957  700
     [155]  346  770  744  295  466  871  590   58  172  401   25  525  410  737
     [169]  720  985  595  536  881  706  604  846  258  824  710  428  643  851
     [183]   69  579  111  562  837  216  437  572 1000  177   76  353  656  950
     [197]  539  472  274    9  854   41  424   17   14  147  580  955  684   21
     [211]  733  108  188  113  816  201  625  591  360  322   25  311  752  335
     [225]  921  817  848  933  201  511  242  148  516   60  328  991  855  614
     [239]  580  523  396  885  416  620  114  619  853  652  252  799  927  148
     [253]  354  666  544  455  604   28  470  669  711  138  623  945  362   56
     [267]  259  376   34  758  586  499  134  289  528  601  447  528  685  653
     [281]  573   63  306  293  178  740  380  400  818  576  945  214  784  370
     [295]  979  129  463  462  179  691  470  855  458  167  596  639  654   64
     [309]  233  127  910  209  721  610  753  335  231  792  154  427  391  583
     [323]  968  888  182  650  834  781    9  908  249   17  698  640  191  937
     [337]  625  767  411  962  601  147  163  136  352  657  866  829    5  161
     [351]  649  354  751  623  182  779   31  226  470  979  749   78  583   59
     [365]  973   27  330  510  916  715  973  743  839  491  386  450  812  141
     [379]   63  242  379  120  833  931  482  757  843  899  708  330  274  490
     [393]  459  939  667  533  976  819  911  248   20  265  210  359  941  976
     [407]  493  596  290  229  849  473  448  223  484  498  553  627  314  335
     [421]  158  215  986  433  169  509  483  329  983  225  243  415  565   41
     [435]  146  590  354   35  528   18  256  533  906  139  783  850  479  486
     [449]  469  296  266  684  202  608  386   90   32   15   47   94  543  303
     [463]  327  406   66  228  327  146  169  327  933  201   95  957  460  427
     [477]  522  526  934  300  680  577  525  964  664  934  256   75  746  982
     [491]  485  654  662  499  577  468  336  267   45  865  344  678  525  622
     [505]  221   63  581  884  407  618  425  653  174  224  912  411  798  488
     [519]  835  913  334  374  168   22  747  633  173  723  121  173  663  320
     [533]  541  336  834  510  913  166  701  994  347  521  388  461  625  702
     [547]   46  278  626  334   75  295  465  119  654  549  878  653  702  508
     [561]  855  934  262  670  255  808  171  470  446  624  982  419  738  924
     [575]  185  907  506  772  546  165   38   38  171   38  200  350  972  657
     [589]  239  638   65  570  666  868   77  424  496  645   16  387   27  947
     [603]  940  689   25  549   43  432  350  553  313  160  922  708  737  508
     [617]  834  894  303  748 1000  803  898  740  483  927   13  701  479  611
     [631]  864  121  347  251  915  552  537  996  342  255  336  808  625  619
     [645]  615  167   70  359  764  680  193  753  325  983  888  251  901  416
     [659]   50   44  464  181  470  859  183  487  708  791  734  273  680  301
     [673]  117  158  120  552  476  718  617  889  643   60  355  244  781  479
     [687]   45  169  599  459   60  732  525  491  977   77  173   16  487   33
     [701]  631  605   79  644  761  634  784  653  120   80  940  547  817  232
     [715]  647  686  495  139  376  635  713   68  884  155  463  290  769  814
     [729]  961  178  478  726  678  675  981  415  120  893  427  540  483  116
     [743]  534   36  479  516  304  991   92  472  820  468  918  226  325  197
     [757]  622  950  177  991  199  405  872  161  905  719  904  165   11  615
     [771]  418  555  600  635  304  589  272   65  596  708  369  302  365  440
     [785]  880  724  391  758  997  217  232   11  299  590  243  131  399  752
     [799]  981   50   77  596  373  803  226  399  195  438  444  725  255   45
     [813]  492  346  236  781  652  720  123  824  536  260  526   82  607  656
     [827]  268  602  478  526  592  330  941  232  794  335  851  418  446  745
     [841]  269  714  557  355  288  646  175  958  715  465  407  790  848  129
     [855]  468  300  286  208  254  236  372  332  769  615  912   78  473  969
     [869]  898  866  750  297  355  352  863  514   72  327  147   67  306  805
     [883]  820  483  508  606  413   20  415  638  929  625  107  151  307  856
     [897]  430  921  891   16   87  166  581  306   57  603  845   95  968  237
     [911]  363  622  470  367  465  378  601  312  560  111  252  615  357  164
     [925]  728  921  262  604  649  383  781  469  570  569  924  376  361  139
     [939]  703  928  958  260  516  395  333   59  160  494   89  596  719  539
     [953]  109  589  903  452   81  569   15  802  759  646  788  343  806  806
     [967]  391  364  167  133  771  786  469  877  624   30  475  559  908  209
     [981]  174  202  159  107  475   56  203   27  787  212  175  530  863  816
     [995]  895  630  720  940  817  798
    
    $resamples[[6]]
       [1]    6  687   69  743   73  130  106  691  284  255  738  350  259  173
      [15]  958  485  564  218  974  505  575  503  115  653  749  203  648  230
      [29]  854  246  588  455  919  203  541  393  134  502  272  936  947  667
      [43]  858    7  228  901  822  647  235  801  161  695  853  753  724  301
      [57]   98  738  720  647  968  966  712  434  455  283  736  608  903  329
      [71]  331  656   28  969  955  277  872  323  318  478  545   13  692  298
      [85]  734  309  565  638  461  358  897  381  995   49   20  229  116  773
      [99]  792  163  889  816  601  916  633  992  969  135  253   88  294  304
     [113]  926  658   96  681  577  764   80   86  865  749   90  288  343   76
     [127]  269  592  512  441  964  124  635  670  821  185  722  338  455   33
     [141]  224  806  257  286  496  192  947  187  152  125  174  801  242  570
     [155]   87  832  351  693  409  609  435  146  166  698  285  381  841  314
     [169]  938   61  981  804   39  255   78  789  488  796  983  440  655  295
     [183]  893  806  649  413  722  507  172  148  410  753  171  707  389  442
     [197]  570   14  325  361  810   95  130  117  221  976  906  268   44   10
     [211]  227  782  316  856  372  512  392  797  298  385  471  566   34  612
     [225]  751  374  283  583  811  987  682  558   18  418   99   76  373  111
     [239]  910  170  657  851  996  276  152  214  245  352  983   69  339  933
     [253]  187   54  871  763  966  138  677   41  349  265  275  121  967  180
     [267]  616  211  787  628  325  226  680  322  201  991   30  225  868  395
     [281]  984  889  537  824  211    1  148  646  571  137  269  233  773  277
     [295]  300  778  792  454  974  495  219   18  934  589  298  507  838  588
     [309]  947  949  764  320  826  589  229   98  918   74  355  193   55  952
     [323]   47  360  864   10   54  679  716  336  619  131  837  370   89  902
     [337]  207  499  446  763   84  871  927  117  897  482  307  575  269  843
     [351]  265    6  955  799  121   22  298  224  842  395   85   37  990  403
     [365]  501  194  355  246  521  730  959  634   93  411  914  328  106  739
     [379]  276  910  977  604  710  327  517  840  170  945  567  695  962  822
     [393]  468  147  541  589  325  869  947  171   44  740  411  796   51  275
     [407]  543  581  482   77  282  865  339  862  799  813  225  418  728  764
     [421]  235  764  957  917  769  567  576  725  783  638    8  490  430  525
     [435]  848  515  261  504   14   11  195  841  250  830  395   72  644  223
     [449]  944  605  386  170  265  771  386  598  538  925  452  251  551   25
     [463]  943  873  217  671  189  728  651   69  128  680   95  695  779  475
     [477]  336   84  985  165  495  624  101   16  327   38  475  532  280   41
     [491]  101  778  190  552  350   62  759  652  537  278  828  823  604   21
     [505]  742  174  328  378  919  272  449  967  762  745   29  393  866  513
     [519]  567  710  281  846  929  184  473  269  620  618  666  401  292  449
     [533]  500  756  690  232   90    4  900  133  587  993  617  476   57  109
     [547]  173  746  986   30    6  493  984  757  241  613  486  555  658   66
     [561]  300  860  930   97  883  962  969  693  551  883  969  516   40  282
     [575]  270  615  829   99  202  458  382  689  747  457   53  637  413   42
     [589]  980  211  340  645  369  615  702  166  349  146   45  967   57  606
     [603]  449 1000  379  543  631  473  197  374  978   58   91  173  326  978
     [617]  662   90  972  487  181  834  560  702  442  418  500  578  421  567
     [631]  783  947  317  214  862  423  391  627  802  746  319  303  927  482
     [645]  996  940  452  677  134   15  616  819  172  857  803  819  479  112
     [659]  695   79  187  864  714  459   22  958  575  183  454  400  488  368
     [673]  937  415   33  266  393  523  324   26   85  960  844  603  821  782
     [687]  157  741  915  443  344  150  231  954  958  116  195  619  921  248
     [701]  152  420   51  812  700  603  850  406  414  389  731   85  587  213
     [715]  903  467 1000  203  132  696  827  661  719  498  211  869  599  510
     [729]  295  511  287  766  517  805  206   13  604  429  544  733  722  259
     [743]  965  712  147  788  480  778  564  749  919  931  507  221  750  150
     [757]  256   94  873  328   89  116  260  298   72  981  417  835  506  372
     [771]  206  796  110  547  960  760  202  508  993  240   53  813  866  523
     [785]   91  840  420  276  657  736  560   62  298   84  687  772  255  320
     [799]   42  567  752  879  961  910  433  729  651  765  714  381  430   16
     [813]   89  946  885  608  728  664  887  806  270  698  846  508  405  827
     [827]  216  100  268  362  372  737  855  759  695  322  237  558  134  171
     [841]  628  574  563  918   17  282  972  289  324  475  163  224  629  615
     [855]  945  327  796  866  153  729  759  364  619  969  209  367  694  455
     [869]  577  680  684  894  168  368  254   45  198  473  295  544  117  941
     [883]  753  351  637  474   93  313   81  260  982  723  720  863  578  792
     [897]   34   55  495  225  215  247  203  333  631  656  678  112  889   25
     [911]  276  254  485  587  902   41  378  804  242  487  699   73  428  143
     [925]   11  801  572  751  529  148  148  216  653  572  736  396  537  877
     [939]    4  559  226  464  456  239  942  360  448  620   64  682  390  458
     [953]  432  494  531  907  216  258  427  192  431   82  629  403  547  200
     [967]  632  166  713  564    5  599  547  310  805  641  345  961  581  354
     [981]  227  603  286  396  947  181  921  753  429   31  604  978  862    3
     [995]  649  416  761  100  177  496
    
    $resamples[[7]]
       [1]  316  312  827  344  165  748  642   86  128  228  292  596  273  399
      [15]  899  363  940  770  857  251  332  227  722  665  429  388  545  378
      [29]  950  556  973  802  232  111  309  919  826  338  430  434  726  578
      [43]  192  983  845  254  851   80  362  865  618   58  617  310  438   61
      [57]  388  777  470  857  815  861  416  872  724  683  670  918  402  856
      [71]  504  768  658  559  918  812  641  310  455  194  821  442  297  305
      [85]  437   65  949  465  611  433  139  914  323   65  234  640  952  478
      [99]   83  376  312  863  757  317  608  552  542  290  925  928  242  187
     [113]  311  196  166  716  435  777  362  921  755  441  465  675  424  832
     [127]  362  948  390  332  772  398  624  198  877  374  810  560  128  705
     [141]  589  886  422  159  523  949  434  266  534  413  491  232   49  841
     [155]  248  779  816  136  616  435  888  284  153  275  985  698  428  847
     [169]   12  405  238  948  388   62  336  627  395  642  740  435   72  830
     [183]   56   42  830  578   76  713  101  196  856  730  851  759  718  474
     [197]  513  669   94  392  626  903  706  918  525  394  448  374  502  338
     [211]  587  562  286  505  957  274  561  137  802  924  774  924  757   35
     [225]  920  503  720  287  572  233  429  750  597  939  794  273  934  982
     [239]   97  169  446  342  823  803  429  423  222   15  230  515  351  359
     [253]  592  704  804  302  967  257  574  589   16  564   21  275  873  938
     [267]  748  302  944  983   53  729  326   32  994  573  739  856  578  189
     [281]   45  779  193  119  544  547  203  750  927  567  321   48  118  403
     [295]  314  167  635  325  682  164   91  240  323  880  127  131  156  367
     [309]  722  953  149  117  354  780  312  860  222  910  352   86   64  583
     [323]  551  329  353  422  598  759   64  796   99  491  973  952  854  762
     [337]  384  549  732  827  972  777  619   60  491  882   51  279  745  604
     [351]  303   88  780  253  203  537  192  771  651   54  367  192   10  566
     [365]  457  122  914  587  468  674  975  898  118  124  330  251  628  235
     [379]  596  505  653  983  578  620  338  927  975  569  737  270  239  174
     [393]   70  553  517  315  247  810  305  565  647  722  935  519  617  986
     [407]  453  315  971  651  861  393  638  781  699  743  959  316  445  344
     [421]  653  115  661  674  665  903  638  159  196  305  708  393  810  686
     [435]  795  933  489  136  891  204  224  862  207  584  373  692  102  439
     [449]  809  901  718  267  661  471  235  790  101  203  224   95  790  656
     [463]   96  662  699  905  813  204  811  468  181  430  437  742  379  342
     [477]  312  316  445  514  828  275  951  312  366  825  969  875  970  132
     [491]  200  620   46  637  666  148  125  628  382  452  271  651  869    5
     [505]  709  650  665  804  727   60  722  680  548  922  607  468  221  386
     [519]   79  647  106   12  384  456  242   81  561  610  401  314  229  975
     [533]  131  278  766  935  895  393  349  560  732  566  879  187  322  791
     [547]  300  601  171  947  224  421  421  898  334   97  239  641  113  604
     [561]  823  829  726  713  847  539  393    6  676  647  710   64  265  830
     [575]  156  631  484  236  729  520  853  197   15  652  972   79  776  371
     [589]  345  285  922  536  346   11  576  325  607  710  301   34  962  783
     [603]  587  379  887  909  756  385  899  284  661  772   35  470  513   69
     [617]  462  132  272  246    5   93   12  247  198  672  579  612  377  246
     [631]  677  991  508  504   19  121  151  430   16  689  191  933  649  310
     [645]  771  236  881  471  659  969  378  701  132   55  350  862  274  131
     [659]  673  398  996  393  691  481  472  655  527  560  879  440  800  560
     [673]  114  834  970  348  695  818  633  950  451  976  579  638  223  887
     [687]  638  701  601  461  780  195  477  662  289  940  338   63  600  446
     [701]  647  689  431  317  709  919    5  170  211  751  491  948  726  375
     [715]  712  164  754  635   67  620   60  214  879  311  696  570  532   95
     [729]  121  370  578  978  460  953  393  136  850   79   78   95  393  353
     [743]  490  180  972  852  746  958  575  776  557  353  394  881  861  428
     [757]   96  297  564  992  554  971  610  573  459  710  545  969  945  885
     [771]  677  510  990  835  972  392  842  650  436   52  890  841  230  227
     [785]  786  568  245  397  680  605  303  572  311  939  772  651  842  161
     [799]  693  710  973  325  251  962  294  191  382  993  748  191  869   41
     [813]  982  255  943  501  304  308  283  569  828  690  800  704  577  910
     [827]  816  108  813  176  335  207   52  114    8  616   92  129  444  637
     [841]   41  836  208  621  424  494  539  693  605  775  291  517  250   14
     [855]   22  185  303  708  486  944  752  684  776  268  822   23  624  796
     [869]  411  578   32  771  780  361  375  592  334  733  724  182  606  941
     [883]  879  281  672  773  562  421  400  298  195  793  194  893  229  136
     [897]  824  287  393  516  390  594  484  298  969  694  483  922    1  868
     [911]  950  345  353  776   35   39  519  834   32  163  839   55  336  946
     [925]  787  721  488  992  972  427  731  250  354  443    3   13  868  480
     [939]  731  501  803  748  262  772  507  851  527  791   85  838  979   54
     [953]  447  518  387  978  719  621  813  879  981  286  571  782  314  663
     [967]  200 1000  241  304   73  573  351  354  476  120  472  530  383  575
     [981]  918  177  779  230  605  389  645  242  573  515  237  252  599  123
     [995]  281  973  966  773  998  650
    
    $resamples[[8]]
       [1] 209 672 776 906 843 502 332 477 169 457 194 425 918 764 494 484 544 739
      [19]  38 970 863 320 429 298 697 285 233 748 467 527 792 836 833 329  18 453
      [37] 738 784 793 177 598 230 787 525 290  83 731 989 133 599 627 207 290 257
      [55] 870 534 900 185 240 116 809 736 684 392  27 247 337 421 921 946 973 353
      [73] 430 684 715 784 633 345 943 443 682   7 958 669 577 115 722 306 728 750
      [91] 839 756 349 924 827 404 191 935 641 858 741 455 547 163 718 813 269 111
     [109] 508 770 616 986 584 670 670   6  90 157 281   4  87 478 847 520 224 481
     [127] 525 891 315 555  11 797 683 536 359 597 156 550 986 215  18 918 692 520
     [145] 520 655 209 397 766 282 131 754 428 921 718 210 322 656 346 919 760 276
     [163] 595  43 115 922 476  53 266 325  37 623 639 537 233 932 682 140 715  93
     [181] 202 919 858 341 801 509 305 131 243 499 737 208 445 122 423 667 381 630
     [199] 875 219 169 954 340  68  17 330 384 236  76 451  88 422 250 964 190 625
     [217]  33 352 975 331 974 837 177 862 836 301 446 626  31 844  61 583 924   5
     [235] 570 998 986 475  15 212 358  51 934 754 952 728 793 564 367 224 490 384
     [253] 826 575 768 404 530 710 863 113 914 890 179 186 496 673 841 169 519 620
     [271]  43 318 771 198  52 268 501 492 841 286  98 165 483 698 725  76  76 201
     [289] 704 185 321 922 759 673 476 623 547 626 521 935 971 190 176 417 342  73
     [307] 982 968 856 624 286 465 921 662 917  59 308 697 479 768 205 148 107 853
     [325] 129 551 760 976 362 678 236   3 889 911 284   8 555  25 794 451 445 473
     [343] 194 586 387  49 168 928 103 553 493  49 890 355 144 996 186 351 426 572
     [361] 320 318 899 994 752 373 525 887 205 268 269 933 504 425 907 357  16 104
     [379]  64 250 658 677 977 164 404 218  16 596 795 195   2 574 369 264 286 670
     [397] 329 890 794 104 929 492 684 528 247 787 300 633 213 601 145 337 799 212
     [415] 927 950 877 281  52 619 582 504 502 395 783 688 541 231 198 247 894 764
     [433] 601 532 120 830 551 626 351 507 737 905 567 698 978 762 253 330 786 644
     [451] 724 942 469 989 757 586 975 991   1  58 650 443 669 869 889 616 671 764
     [469] 334 132 578 778 982  68 119 596 673 177 862 765 894 249 251  90 582 251
     [487]  32 739 950 603  87 626 910 214 523 298 292 952 137 878 233   2 733 654
     [505] 145 805 169 266 319 837 812 928 969 861  97 401 537 724 867 803 349 940
     [523]  12 373 569 148 371 354 452 879 720 952 474 413 388 954 636 421  68 571
     [541] 185  73 379 893 487 879 367 168 862 517 288 958 607 822  86 194 644 768
     [559] 336 549 271 334 815 202 385 866 184 209 382 874 183 549 711 181 530 577
     [577] 320 294 987 477  34 790 590 306 261 232  21 349 608  73 575 669 689 820
     [595] 261 622 233   5 995  28 436 371 442  56 302 886 743 380 592 988 821 350
     [613] 501 198 969 319 503 494 733 606 614 304 132   8 957 245 646 481 121 378
     [631] 249 955 741 131 185 228 950 472 694 854 806 690 812 619 138 877 150 482
     [649] 529  46 808 394 806  96 380 916 295 820 167 600 527  85 433 341 323 875
     [667] 765 991 991 770 225  76 567 571 115 883 975 449 428  57  23 857 409 712
     [685] 111  97 990  49 821 609 894 712 853 859 510 288 838 728 397 509 864 600
     [703] 703 564 954 708 900 571 342 130 464  33 545 138 444 604 679 925 689 627
     [721] 779 115 211 611 133 247 955 513 125 218 847  64 484 913 822 923 726 702
     [739] 902   4 683 983 878 460 120  12 716 432 128 684 903  24 423 768  32 261
     [757] 619 110 980 888 842 517 251 826 745 478 346 900 424   7 993 322 606 122
     [775] 147 616 933 133 858 682 366 951 438 749 445 982 995 652 593 333  39 816
     [793] 913 537 786 661 103 248  25 849  96 789 677 280 950 335 454 235 504 830
     [811]  83 168 211 708 763 695 795 764 939 232 515 560 888 840 200  30 800 727
     [829] 724 754 806 921 453 221 676 486 633 112 384 893 119 757 831 272 511 165
     [847] 919 603 612 925 493 673 984 940 530 519 795 360 860  28 508 329 167 127
     [865] 251 400 287 102 687 936 680 276  97 714 753  72 696 652 392 334 698 147
     [883] 783 821 936 879 892 164  58 657 823 808 978 530 329 544 306 258 136 719
     [901] 961 709 195 222 202 163 279 301 488 739 895 425 880 846 308 852 873 723
     [919] 639 921 439 321 531 157 947 546 333 394 660 625 220 376 901 791 978 800
     [937]  55 420 186 919 845 235 724 719 373 386 251 587  24 670 205  89 264 415
     [955] 240 164 652 181 996 805 169  29 225 759 734 545 682 385 862 273 199 420
     [973] 733  97 385 192 682  94 308 843 823 848 393 108 943 881 375  28 989  60
     [991] 217 941 668 952 297 970   2 146 571  58
    
    $resamples[[9]]
       [1] 118 108  72 667 359 137 900 240 508 751 731 152 266 603 537 550 174 373
      [19] 880 608 267 274 135 924   5 198 451 863 352 346 395 878 873 109 871  92
      [37] 851 205 300 411 145  73 960  89 436  77 118 931 707 132 892  45 948 276
      [55] 361 897 164 138 920 526 279 577 777 331 223 916 306 204 400 719  70 727
      [73] 729 416 520 701 165  21 846 415 625  87  60 227 788 204  45 376 705 685
      [91] 614 829 162 470 496 914 871 153 555 751 496 876 714 539 162 609  22 280
     [109] 456 688 431 874 958 473  60 391 808 750 639  17 909 325 380 584 556 707
     [127] 796 624 314 936 501 202 157 257 728 211 288 729 547 523  42 408 571  42
     [145] 242 895  21 264 625  61 720 432 300 430 505 886 791  95 610 227 835 988
     [163] 989 105 574 563 734 719  89 381 233 963 829 812 197 833 234 298 117 163
     [181] 469 168 670 932  17 723 601 708  51 341 806 356 187 486 351 652 485 858
     [199] 383 313 566 873 199 708 993 529 549 790 957 353 707 914 877 371 403 941
     [217] 303 603 397 447 329 393 764 704 373  28 255 521 181 145 209 900 635 232
     [235]  11 444 610  83  13 845 990 403 333   9 206 465 713 430 749 539 330 109
     [253] 355 247  64 228 833 434 372 113 704 543 338 981 353 402 605 567  41 898
     [271]   5  70 820 967 784 286 606 699 440 690 594 778 599 478  32 259 166 997
     [289] 428 118 466  71 700 660 725 972 134 415 473 273 714 409 192 910 581 612
     [307] 330 463 168 694 649 395 892 212 153 296 422 865 913 328  89 787  41 745
     [325] 946 260 352 668  90 992  25 976 809 893 617 533 257 999 700 781 620 205
     [343] 314 252 730 367  63  59 118 311 114 258 521 995 110 512 795 348 567 856
     [361] 564 332 247 256 704 788 655 896 304 518 721 891 572 794  18 574 705  41
     [379]  89  45 215 245 161 330 368 255 858 774 797 340 618 244  87 862  66 771
     [397]  84 821  30 942  58 568 256 725 965 732  64 158 666 323  45 609 158 419
     [415] 277 943 680 128 505 813 687 916 643 698 503   2 964  59  15 858 228 175
     [433] 195 657 335 636 446 585 487 565 622 595 787 631 872  82 911 581 462 655
     [451] 965 694 303 520 908 814  32 520 642  94 565 628 861 958 690 272 105 717
     [469] 121 436 262 677 124 102 705 547  60 328 732 594 679 277  22 394 160 943
     [487] 806 844 790 168 816 741 532 955 860 920 968 716 733  13 867 383  42 561
     [505] 374 694 871 688 598  63 244 758 458 614 190 318 261 823   3  81 295  25
     [523] 661 689 926 593 666 727 399 462 640 117 687 250 589 327 905  85 935 685
     [541] 585  47 649 853 664 155 120 365 168 474 231 159 210 267 261 686 973 443
     [559] 629 119 877 845 840  52 636 506 700 952 128 766 839 618 279 116 698 881
     [577] 566 247 108 570 849 172 845  40 311 297 125 899 660 489 272 738  66 117
     [595] 430 842 119 116 133 116 837 232 169 335 982 129 554 221 146 800 864 424
     [613] 341 209 943  16 853 815 199 177 201 640 528 808 245 710 139 156 326 397
     [631] 553 607 101 704  80 441 986  51 351 507  60  10 289 405 445  28 926 445
     [649] 585 178 469 118 356 932 507 463 879 956 179 152 358 843 140 352 198 424
     [667] 715 604 940 612  64 494 331 369 601 659 393   9 301 535 912 554 538 401
     [685] 215 845 327 691 247 354 211  13  23  88 797 791 300 560 367 565 813  78
     [703] 323 621 779 372 580 303  23 169 393 202 173 147  86 489 747 399 273  95
     [721] 826 259 623 488 244 528 925 581 534 235 683 658 683 779 879 717 612 458
     [739] 144 256  14 377 494 342 380 431 564 431 145 744 882 962 235 890 225 603
     [757] 318 957  67 740 353 248 688 453 502 493 457  45 332 288 416 132 397 838
     [775] 416  14  39 578 471 913 701 398  99 322 122  95  97 100  76 599 265 869
     [793] 276 301 397 676 984 492  94 157 689 462 501 916 252 163 487 701 534 979
     [811] 998 698 113  30 759 413 461  57 135 462 115 574 900 591  55 116 939 365
     [829] 672 317 931 499 371 896 428 936 673 145 915 485  11 944 165 247 116 778
     [847] 216 885 834 901 569 850 128 386 520 158 275 664 269 221 178  15 432 543
     [865] 612  87 981 381 537 509 606 905 824 716  92 338  93 670 894 868 296 722
     [883] 341 298 273 770 803 520 655 159 683 811 646 743 717 905 709 490 385 139
     [901] 161 398 348 465 424 946 931 943 974 837 639 107 455 565 131 545 381 311
     [919] 506 247 776 377 356 786 922 472 244 222 426 742 455 910 360 723  16 244
     [937]  28 770 733 266  93   1 772 276 488 340  84 673 345 437 710 790 493 427
     [955] 817 561 138 794 809  79 979  33 232 723 971  82 498 703 375 803 852 512
     [973] 799 337 434 548 448 426 157 554 931 174 222 359 734 318 690 372 567 254
     [991] 210 843 422  52 711 931   5 695 299 700
    
    $resamples[[10]]
       [1]  838  838  536  806  502  749  597  264   48  628  663  658  647  466
      [15]  412  231  752  119  564  398  380  435  832  470   41  342  120  527
      [29]  307  508  106  155   17  189  583  552  864  147  529   86  396  967
      [43]  976  368  934  209  933  277  856  297  705  257   71  973  772  279
      [57]  147  304  800  936  140  698  373  478  759  707  986  668  925  271
      [71]  488  977  692  544  554  309  670  448  223  176  129  795  426  494
      [85]  581  173  251  164  762  417  538  536   89  523  488  809  327  687
      [99]  277  305  627  222  701  123   52  499  288  426  348  808  463  312
     [113]  195  756  668  594  170  100   50  416  120  994  900  611  411  590
     [127]  609  981   11  905  118  135  904  165  296  413  662  537  114  392
     [141]  911  337  207  489  372  576  681  193  956  640  935  166  937  348
     [155]  498  240  577  299  891  960  994  742  158  697  542  957  656  118
     [169]  194  678  319  150  106  828  656  877  399  504  378  111  478   73
     [183]  248  147   33  590   20  303  246  949   39  396   14   69  345  152
     [197]  590  988  857  705  164  614  577  778  204  430  937  722  890  626
     [211]  937  700  842  634  511  323  675  311  824  968  418  753  929  581
     [225]  587  912  466  170  870  857  319  699 1000  685  325  751  137  769
     [239]  127  398  297   36  339  550  409  817  148  635  262  368  567  500
     [253]  713  308  521  423  766  129  737  682   14   15  217   23  446  756
     [267]   28  254  993  111  857  477  833  974  165   72  297  957  255  167
     [281]  180    7  483  237  861  962  489  125  951  561  561  676  131  172
     [295]  793  840  933  902  659  269  893  524  906  997  900  784   60  758
     [309]  613  615  868  907  811  406   38  668  474  614  316  572  536  405
     [323]  150  125  897  809  351  456  403  325  258    1  375    3   92  874
     [337]  838  384  510   19  368  687  803  284  834  589  701  851  697  135
     [351]  717  234  661  410  184   34  471  152   53  339  768  151  552  233
     [365]  990  266  935  330  836  479   46   46  127  573  885  114  317  822
     [379]  523  563  414  631  648  561  684  323  213  104  600  388  647    5
     [393]  966  798  778  700  156  241  493  279  614  234  852  588  645  262
     [407]  350  630  675  106  276  374   13  909  966  854  369  692  305  413
     [421]  673  208  121  875  346  580  999  687   88  947  386  112  612  656
     [435]  284  938  987  844  920  195  707  389  835  115  641  454  346  169
     [449]  892  265  838  112  272  826   42  947  384  169  167  622  636  717
     [463]  354  494  298   83   91  477  819   95  886  436  878  995  826  349
     [477]  160  879  134  564   64  719  443  696  931  889  563  523  805  681
     [491]   61  474  583  164  884  638  319  106  772  696  715  159  198  215
     [505]  130  660  865  305  997   21  138  509  475  989  791  691  694  318
     [519]  246  437  384  332  388  787  486   35  669  909  999  964  762  689
     [533]  888  562  791  948  350   63  569  716   87   33  288  637  148  466
     [547]   16  574   67  982   63  900  544  891  864  834  541  772  552  750
     [561]  438  493  660  877  604  788  291   80  331  573  166  549  711  513
     [575]  153  772  628  306  979  449  406  773  364  436  770   40  800  566
     [589]  751  720  466  593  345  228  135  508  838  530  787  907  485  136
     [603]   56  172  427  282  944   92  717  225  999  664  894  916  487  474
     [617]  555  887  937   42   98  241  454  333  919  428   75  583  961  443
     [631]   12  820  276  411  352  172  195  425  365  444  562  179  625  661
     [645]  174  793  673   81  338  322  637  444  859   37  585  504  536  139
     [659]  898  143  431  118  215  759   17  648  277  852  218  489  777  881
     [673]  276  861  766  585  403  396  853  281  607  879  888  218  883  398
     [687]  517  604  573  919  548  757   43  659  620  774  768  169  211  459
     [701]  192  674  525  721  858  750  171  177   40  398  476  291  512  893
     [715]   74  146  230  164  457  771  851  326  463  732  183  359   69  944
     [729]  818  822  880  733  218  883  711  514  867  465  945  934  659  894
     [743]   51  322  376  563  215   18  577    4  765  464  794  694  185  113
     [757]  378  849  105    3  653  875  662  516  505  840  732  881  749  374
     [771]  952  508  327  111  185  126  482  325  596  584   25  186   60  958
     [785]  472  695  427  676  717  535  163  100  567   62  269  402  164  187
     [799]  599  808  453  190  245  102  149  645  372  862  579  288   91  876
     [813]  336    6  527  466  708  277  995  967  749  749  694  623  713   69
     [827]  728  127  109  467  759  609  398  625  870  107  665  720  973  498
     [841]  318  215  795  831  362  538  815  131  635  406  419  592   27   69
     [855]  219  370  125  141  357  965  564  174  356  622  976  773  389  628
     [869]  197  295  480  498  501  640  323   83  240  262  795   21  467   20
     [883]  521  275   26  568  196  155  823  999  190  956  670  703  124  785
     [897]   77  844  716  583  300  240  893  734  277  832  272  106  644  145
     [911]  697  744  651  822  838  173  367  318  788  457  952  297  903  287
     [925]  217   18  417  237  768  107  512  353  961  305  691  500  994  355
     [939]  911  742  180  922  756  468  863   67  919   41  785  208  632  209
     [953]  957  615  929  464  862  892   68  962  421  531  136  360  707  815
     [967]  546  866  196  637  466  439  175  908  785  264  464  610  824  805
     [981]  547  901  565  518  388  571  461  874   95  674   80   91  389  823
     [995]   52   60   49  698  146  209
    
    
    $original
    Outlier-Robust 2SLS Model 
    Initial estimator:  robustified 
    Reference distribution:  normal 
    Two-stage Least-Squares Model: y ~ x1 + x2 + x3 + x4 + x5 | x1 + x2 + x3 + z4 + z5 + z6 
    Iterations:  3 
    Final selection:  Outliers found:  33     Outliers proportion:  0.033 
    
    attr(,"class")
    [1] "r2sls_boot"

---

    $boot
       X.Intercept. x1          x2         x3          x4        x5  m gauge  r
    1   -0.17641899 NA  0.07118357  0.7157693  0.86079250 0.4302637 m1 0.039  0
    2    0.97759855 NA  2.32133017  3.1271790 -2.97347733 0.9631871 m1 0.043  1
    3   -0.56141548 NA -0.21292862  0.4086724  1.55239333 0.3078774 m1 0.041  2
    4   -0.60976577 NA -0.92066151 -0.2787045  2.56857646 0.1548943 m1 0.032  3
    5   -0.01527094 NA  0.25833384  0.9227829  0.52683929 0.5050201 m1 0.028  4
    6   -0.20892227 NA  0.06581414  0.6423868  0.89476010 0.4821101 m1 0.031  5
    7    0.25702667 NA  0.71095342  1.2286178 -0.05931845 0.6395222 m1 0.035  6
    8    0.37039512 NA  0.84999575  1.6750445 -0.64165780 0.5936257 m1 0.048  7
    9    0.10521536 NA  0.52189801  1.0783701  0.20514304 0.5649944 m1 0.034  8
    10  -0.34537864 NA -0.58729762  0.1971830  1.75343082 0.2349887 m1 0.032  9
    11  -0.27811170 NA  0.08924669  0.7652453  0.90509200 0.3916556 m1 0.031 10
    
    $resamples
    $resamples[[1]]
       [1] 550 689 755 426 369 481 879 556 602 366 309 470 936  10 319 155 441 751
      [19] 134 986 866 701 342 121  86 380 703 874 707 977 797 450 301 142 457 767
      [37] 472 563 126 694 122 615 319  39 812  97 955 868 974 545  91 302 550 223
      [55] 945 197 157 954 772  51 782 469 316 524 770  47 736 127 911 254 781 577
      [73] 155 241 333 946 898 129 368 101 524 868 551 824 184 940 127  17 620 935
      [91] 309 512 153 670 625 809 443 548 189 786 909 836 738 925 589 815 915 286
     [109] 453 769  35 450 854 946 595 166 249 671 290 150 803 854 225 986 200 199
     [127] 175 582 450 743 628  66 876 434 210  75 398 394 106 337 152 198 142 854
     [145] 997 278 749 377 140 795 321 352 567 551 489 509 759 390 158 680 684 820
     [163] 623 912  29 951 477 972 938 245 354 720 301 926 140 402 175 921  24 233
     [181] 561 757  87 158   4 596 172 704  78  76 541 735 540 767 851 938 136 851
     [199] 366 506  34 279 685 258 364 880 718 905 914 354 401 227  66  54 719 816
     [217] 717 978 915 710 906 551 843 650 878 708 841 443 470 187 995 940 252 240
     [235] 338 653  76  42 223   7 396 809 434 377 649 209 457 928 141 723 422 217
     [253] 363 381 907   2 216 260 807 585 156 438 125 252  22 218 385 940 746 872
     [271]  48 776 862 687 623 151 630 203 238 382 735 519 910 290 193 849 349 104
     [289]  57 479 500 136 850 262 212  92 325 188 666 883 807 661 869 199 204 925
     [307] 471 883 985  84 931 210 447 444  13 795 592 679 165 513 538 562 679 451
     [325] 389 265 562  93 671 962 742 673 363 772 375  85 634 332 888 851 995 941
     [343]  81 151 650 736 717 628 831  11 863 219 331 403  74 948  85   5 715 826
     [361] 365 271 745 562  90  47 432 590 960 649  20  93 199 185 580 686 435 533
     [379] 392 432 439 792 237 895 810 868 105  59 535 938 278 321 120 410 472 416
     [397] 399 360  66 599 400 724 381 318 451 256 965 136 656 243 451 404  85 714
     [415] 453 612 578 293 790 356  96 862 874 923 889 590 858 883  14 408 472 991
     [433] 711 452 778 892 941  16  44 889 655 196  53 257 909 183 582 960 778  25
     [451] 166 331 943  41 849 891 374 196  95 983 810 246 519 147 855 344 236 268
     [469] 453 596 852 448 349 420 802 686 699   6 499 147 919  31  16 518 247 824
     [487] 914 765 201   7 187 124 245 235 517 421 885 706 979  17 845 754  86 806
     [505] 756  15 929  22 277  93  70 920 149  55 448 476 419 814 996 823 433 839
     [523] 968 562 996 463 173   6 350  39 299 942 755 474 178 157 290 173 328 496
     [541] 305 315 566 889  63 302 243  38 546 342 111 352 811 204 805 415 934 408
     [559] 715 112 999  39 551 217 670 992  49 137 673 274 361 102 410  51 562 804
     [577] 212  73 338 789 233  80 474 610 717 165 498 879 130 424 722 601  65 861
     [595] 799 159 208 371 348  69 163 136  72 166 268 341 430 842 850 359 758  12
     [613] 613 165 362 156 645   1 464 926 379 624 292 931 372 536  97 820 899 881
     [631] 154 207 447  69 282 367 872 367 728 960 746 219 954 722 274  14 845 300
     [649]  35 250 631 990 693 855 782 276 613 412 199 228 941 836 892 660 833 167
     [667]  57 430 146 634 193 730 758 379 828 213 786 451 257 934 458 533 260 201
     [685] 951 159 796 413 999 814 223 408 644 799  74 954 611 778 534  49 230 554
     [703] 606 360 522 542 646 208 639 785 973 833 200 116 938 786 842 933 128 283
     [721] 168 205 243 996  98 353 402 441 871 625  24 899 390 450   2 406 295 985
     [739] 753 254 362 514  38 587 398 819 133 868 860 795 563 343  51 664 294 918
     [757] 263 988  61 458 935 707 567 982 860 231  34 851 724  74 810 648 467 326
     [775] 627  55 469 833 196 386 558 751 127 260 534 681 166 737 579 528 187 192
     [793] 646 357 192 918 905 360 954 844 840 452  19 296 692 518 340 183 401 826
     [811]  48 776 768 508 483 784 537 994  45 409 439 247 262 615  32 940 140 953
     [829] 817 218 198 741  61 917  81 346 677 642  92 372 372 663 456 564 252 623
     [847] 961 574 700 682 377 199 828 668 444 941  68 964  47 470 500 243 397 220
     [865] 755 998 318  41 972 190 374 436 412 432 628  39 168 493 672 202 354 595
     [883] 928 823 748 165 835 278 131 369 821 845  21 163 312 847 352 283 821 506
     [901] 986 544 513 115 521 444 631 809  15 187 913 203 797 106 150 145 474 694
     [919] 496 935 602  80 826 971 298 517 265 763 220 603 878 449 854 825 214 740
     [937] 997 763 115 825 306 514 274 193 835 620 468 892 235 246 133 549 641 255
     [955] 468 628 455 882 377  32 293 446 192 292 328 682 897 834 428 731 453 680
     [973] 110 294 505 583 352 676 191 543 901 330 143 758 496 355 582 806 779 699
     [991] 285 933 413  80 779 698 480 815  88 985
    
    $resamples[[2]]
       [1]  419   49  455  168  121  671  359   53  457  978  540  751  380   76
      [15]   40  266  120  298  386  295  291  694  967  249  572  122  619  424
      [29]  209  559  804  898  921  730  500  690  538 1000  635  627  581  929
      [43]   43   64  183  584  457  303  590  237  620  745  393  220  925   47
      [57]  217  153  910  884  740  532  899  378  343  292  647  605  583  553
      [71]  602  835  728   70  880  523  116  874  591  333  694  206  768  220
      [85]   72  497  532  355  701  820   33  849  253  100  123  142  910  119
      [99]  191  285  798  283  611  590  570  253  938  133  590  381   46  640
     [113]  698  402  126  396   99  308  498  174  732  749  165  611  242  942
     [127]   80  322  422  549  524  299  991  112  321  483  680  820  557  125
     [141]  667   62  508  867  964  983  107  530    7  242  767  104  695  342
     [155]    7  139  535  992  752  163  226  549   85  717   56   22  378  906
     [169]  641  557  140  292   55  844  455  233  628  945   32  175  127   73
     [183]  960  134  622  715  939  550  536  299  482   17  312  531  314  267
     [197]   66  579  137  808  558  890   10  152  761  966   28  618   69  561
     [211]  994   38  437   14  216  134  352  294  764  889  193  915  496  161
     [225]  211  415  239  942  255   37  570  512  745  803  599  456  418    5
     [239]  387  801  549  580  979  837  215  822  466  368  345  580  584  410
     [253]  841  782  591  264  469  802  711  654  381  192  290  776  863  248
     [267]  980  849  317  642  648  110  822  461  556  627   64  408  792  331
     [281]  244  891   21  399  586  349  243  944  738  900  812  832  820  202
     [295]  180  351  555  165  830  895  749  196  356  952  741  639  861  379
     [309]  146  133  858  296  658  503  653   49  455  333  643  405  612  505
     [323]  406   61  163  103  102  852  536  470  262  294  580  934  633  988
     [337]  490  552 1000  138  956  825  248  355  227  356   37  156  512   71
     [351]  356  759  584  508  757  766   20  602  983  508  949  946  687  634
     [365]  279  824  328  291  720  256  778   77  615  304  682    7  315  897
     [379]  386  316  550  692    9  514   88  756  417  807  291  593  791  256
     [393]  482  312  154 1000  585  430  856   23  524  992  248  308  558  211
     [407]  676  989  222  811  587  314  499  775  311  418  721  913   52  398
     [421]   75  160  140  527  709  357  885  536  711  875  877  695  302  553
     [435]  115  560  224  762  233  864  762  795  597  670  953  572  250   57
     [449]  554  327  662  124  175  584  862    6  571  159  131  108   21  370
     [463]  687  893  643  172  733  706  744  357  839  743  698  683  283  789
     [477]  614  586   64  279  263  410  294  880  428  134  436  906   34  436
     [491]   76   71    8  466  990  258  235  891  418  215  193  162  785  997
     [505]   39  920  782  545  392  118  892  298   52  618  525   33  107  177
     [519]  981  526  525  922  995  638  510  682  199   38  885  877  857  920
     [533]  952   47  715  685  124  216  906  599  611  919   67  195   83  458
     [547]  899  879  810  733  917  500  603  253   27  685  845  911  463  760
     [561]  898  293   52  860  202  361  441  685  505  204  679  343  914  751
     [575]  106  260  489  849  272  678  746  155  425  285  341  502  326  308
     [589]  330  930  181  623  379  300  520  301  388  367  186  715  804  335
     [603]  943  720  796  895   50  255   50  604  472   17  501  542  819  708
     [617]  892  174  989  848  281  137  239  395   99  360  992    2  495  196
     [631]  675  703   92   35   61  778  627  249   30  313  135  329   93  404
     [645]  235  542  486  114  852  180  803  424  136  258  305  425   65  314
     [659]  849  606  688  563  231  582  786  455   25  549  421  519  646  439
     [673]  336   97  342  688   40  726  344   19  278  628   90  127  493  834
     [687]  187  914  393  774  775  821  654  297  309  376  382  503  304  727
     [701]  108  559  197  583  813  862  334  403  605  818   15  522  914  943
     [715]  461  298  955  668    6  273  971  621  979   58  950  157  639  948
     [729]  737  876  755  583  772  203  803   64  193  888  739  640  868   11
     [743]  313  193  481  661  618  182    9  459   69  271  749  754  291  508
     [757]  467  942  627  577  782  791   20  611  819  361  957  348  801  442
     [771]  696  204  140  785  860   70   63  452  590  876  302  672  419  407
     [785]  360  802  475  571  375  560  154  772  501  627  567  348   64  926
     [799]  454  456  814  990  166  168  390  662   37   65  341  511  476  550
     [813]  103  792  712  117  225  660  525  399  610    5  856  337  610  725
     [827]  916  300   26  624  791  178  634  577  649    1  858  251  963  739
     [841]  937   57  567  841  389   71  630  891  645  896  307  924  322  946
     [855]  511  303  504  419  467  123  476   62  409  988  620  928   85  683
     [869]  501  761  651  762  155  966   16  575  121  794  410  895  614  259
     [883]  288  645  579  136  535  757  710  791  652  602  577   37  390  123
     [897]  362  588  309  134  605  539  268  204  332  131  620  216   79  997
     [911]  522  471  225  462  554  730  638  118  705  950   24  311  742  921
     [925]  275  220  716  988  951  526  141  100  574  297  600  148  605  616
     [939]  868  182  617  935  626  807  189  185   69  101  635  438   96  180
     [953]  175  768  768   68   79  522   21   60  441  801  778  631  406  964
     [967]  182  269  105  916  388  653  482  589  619  533  356  536  823  543
     [981]  877  202  734  363  789  360  590   95  836  265  686  600  540  873
     [995]  291  732  303  147  110  803
    
    $resamples[[3]]
       [1]  603  998  279  234  679  435  392   50  507  959  971  325  972  501
      [15]  896  310  808  944  999  238  108  140  102  640  601  774  952   95
      [29]  553  203  377  429  777  816  985  765  830  526   27  374  368  344
      [43]  953  767  748   52  428  652  824  540   88  229  752   88  916  172
      [57]  324  734  379  874  961  639  872  535  330  945  310  337  740  489
      [71]  453    6  171  679  392  255  419  499  850  947  953  166  618  463
      [85]  371  807  372  222  149   40  853  173  671  190  836  929  178  893
      [99]  453  530  869  644  697  473  895    2  181  287  379  980  327   78
     [113]   39   69  246  381  496  693   32  686  871  343  945  338  486  190
     [127]  313  400  599  713  756  855  617   59  529  566  442  508  158  901
     [141]  489  552  500  986  306  314  738  989  877   57  800  184   55  896
     [155]  594  101  178   72  134    2   10  591  611  449  569  908  212  723
     [169]  299  458  428  340  217 1000  779  311  609  241  546  715   39  732
     [183]  726  777  982  733  318   10   47  832  616  245  596  866  226   86
     [197]  520  405  103  700   13  356  893  639  592  471  658  690  984  564
     [211]  897  537  560  673  706  559  512  464   59  432   17  863  966  635
     [225]  163  426  535  775  575  285  565  497  480  733  276  306  587  256
     [239]  591   18   17  379  267  347  776  798  152  689  169  711  938  251
     [253]  444  796  359  306   71  766  650  719  279  195  713  376  447  337
     [267]  329  116  496  676  285   92  856  329  174  965  724  642  124  791
     [281]  645  688  977  428  546  360  713  742  702  910  893   18  266  132
     [295]  250  133  904  199  466   81  779  848  610  501  190  234  555  322
     [309]  720  622  791  184  751  770  759  629  596  749   11  458  478  127
     [323]  108  628  839   76  708  282  948  902  687  649  995  635  452  569
     [337]  896  879  624  182  145  972  659  841  971  124  132   58  249  562
     [351]   85 1000  199  962  551  298  960  172  978  523  100  844  708  591
     [365]  141  424  831  524  352  826   71  499  333  100  681  712   34  269
     [379]  116  883  354  673   32  673  544  659  346    1  901  733  922  888
     [393]  111  991  231  243  116   45  459  273  404   62  534  757  917   73
     [407]  828  277  485  758  552  475  946  789  774  778    1  292  597  815
     [421]   24  709  936  331  774  356   63  709  835  852   76  720  311  965
     [435]  896  919  345  585   18  586  616  295  121  304  912  826  203  892
     [449]  638  691  990  243   96  972  610  487  398  652  732  144  236  977
     [463]  507  730  783   97  279  312  643  500   35  309  732  978  328  568
     [477]  260  182  649  586  649   71  447  596  857  693  118  277  306   59
     [491]   53  633  918  144  936  850  304  478   48  824  478   51  115   87
     [505]  794  484  669  907   29  335  465  256  479  448  642  845  664  226
     [519]  164  356   41  736  343  581  590  632  995   27  115  779  390  273
     [533]   89  676  444  563  886  924  865  672  832  215  122  129  523  663
     [547]  569  716  925    2  928  432  988  715  398  705  847  975  321  789
     [561]  881   14  343   71  865  683  229  784  432  935  451  358  640  116
     [575]  252  798  503  430  937  635   39  619  195   22  238  583  701  667
     [589]  740  181  401  665  246  731  230  142  692  546  463  145   73  230
     [603]  260  729  748  775  756  833  641  122  580  157  654  587   41  751
     [617]  675  761  292  809  477  112  822  140  905  715  564  754  199  383
     [631]  916  330  725  782  915  485  434  195  540  853  156  410  320  586
     [645]  883  659  764  937  297  853  361  223  699   95  391  586   43  901
     [659]   45  680  521  929  349  518  294  613  800   43  293  159  718  252
     [673]   13   55  350  934  672  369  111  451  842  407  732  738   80  757
     [687]  332  489  835  980  588  305  564  662  962  250  642   51  730  130
     [701]  844   41   19  639  681  366  352  940  268  109  825  910  406    9
     [715]  333   64  999   12  648  276  299  515  881  492  701  356  654  431
     [729]  820  406  837  884  817  191  583  792  943  595  713  272  561  981
     [743]  162  681  452  561  528  862  352  876   24   66  987    6  101  921
     [757]  219  102  735  998  115  479  138  852  800  717  438  149  286  173
     [771]  311  853  137  893  708  534  161  775  786  608  281  174  523  687
     [785]  101   87  236  857  106  490  668  221  758  992  723  399  494  888
     [799]  400  459  162  812  314  293  608   12  714  590  652  450  324  333
     [813]  942  535  451  406  475  491  236  901  338  287  326  658   29  452
     [827]  505  138  274  861  172  541  914  914  861  474  293  168   67  262
     [841]  837  654  954  772  619  463   78   55  786  812  430  136  171  599
     [855]  404  808  579  970  441  396  804  615  908  353  741  510  490  908
     [869]  715  131   20  657  339   19  144  596  260  562  216  941  206  851
     [883]  731  542    1  634  938  708  357   11  443  391  535   52   72  426
     [897]  576  771  290  352  698  821  415  946  534  413  914  461    8  208
     [911]   20  386   22  594  783  551  928  840  409  476  832  984  281   11
     [925]  957  851  601   98  100  261  336  680  249  410  823  311  995  406
     [939]  392  751  829  178  419  933  108  620   83  499  135  511  438  431
     [953]  420  677   33  222  510  762  127  831  796   24   67  280  348  292
     [967]  156  531  198  396   23  186   81  201  975   20  759  432  772  307
     [981]  556  375  921  847  868  443  335  832  267  215  908  992  631  594
     [995]  496  806  237  385  462  376
    
    $resamples[[4]]
       [1]  728  496   99  133   53  657  463  355  958  607  430  692  524  975
      [15]  887  273  470  776  822  216  391  528   17  607  680  540  643  216
      [29]  709  669  894  978  736  562  798  551  916  800  557  666  822  986
      [43]   83  749   20  992  834   99  583  532   80   11  481  446  235  595
      [57]  307  274  226  415  227  270  837  760  148  691  523  326  251  487
      [71]  831  325  902  863  833  949  727  435  100  150  581  578  104  375
      [85]  153  185  922  512  892  344  991  476  330  741  864  499  520  763
      [99]  672  608  646  575  558  425  476  949  517  841   53  958  943  224
     [113]  143   11    8  230  693  904  587   46  247  672  873  843  348   98
     [127]  694  236  175  630  955  691  222  634   93  902  901  445  854  564
     [141]  396  416  446  351  447  375  290  904  286   79   47   89  621  651
     [155]  355  545  121   52  589  462  941  572  581  929  946  788  692  655
     [169]  950  517  805  125  306  394  296  164  412  683  150  407  301  425
     [183]  313  765  176  140  481  988   98  885   23  155  575  965  446  327
     [197]  153  126  185   40  929  991  129  468  856  620  843  355  611  806
     [211]  439  553  269  720  905  364  135  436   56  560  831  880  337  299
     [225]  174   19  122    2  392  862  523  831  739  618  918  332  798  812
     [239]  878   60  310  301  513  861  572  152  788  456   27  634  548  225
     [253]  312  406  340  450  334  673  897  438  372  910  599   98  583  430
     [267]  400  705  484   52  127  818  898  467  550  736  225  556   51  429
     [281]  718  912  327  360  140  290  557  425  500  939  314  142  916  401
     [295]  644  154  784  770  854  346  925  990  612  943  558  569  876  781
     [309]  640  209  331  708  730  175  635  651  204  370  471  662  979   96
     [323]  642  787  846  550  733  832   44  314  125  927  892  537  473  566
     [337]  181  847  483  537  688  217  584  615   89  303  444  288  130  653
     [351]  988  250  644  327  771  149   95  139  206  518  643  714  278  394
     [365]  177  827  318  948  628  873  673  198  406  400  935  966  393  349
     [379]  588  503  774  968  665  141  879  544  537  760  977  111  503  869
     [393]  240  387  106  859  382  120  542  579  763  914  379  191  901  886
     [407]  962  953  153   29  548   51  897  905  717  482  406  675   12  866
     [421]  969  558  190  370  458  600  105   79  395  424   74  385  429  900
     [435]  506  605  946  883  368  992   37   96    6  951  298  903  786  209
     [449]  969   89  228  323  700  365  353   37  893  531   28  478  196  699
     [463]  202  815  280  331   95  848  961   38   91  923  730  841  100  581
     [477]  699  735  111  208  898  679  716  817  477  257   58   99  699  835
     [491]  178  386  982  668  350  551  415  806  487  674  243  451  542  739
     [505]  639  656  334  112  761  914  615  676  473  719  162  963  123  325
     [519]  173  375  466  482  569  685  965  593  749  828  175  511  338  875
     [533]   22  412  142  657  472  106  491   99  954  529  239    2  183  689
     [547]   54  822  688  289   98  628  673  984  218  364  103  332  571  113
     [561]  859  697  728  314  237  481  568  442  921   69  646  476  217  623
     [575]  784  109  575  297  192  388  539  585  878  823  788  994  810  992
     [589]  361   79  118   95  411  149  446  925  885  859  296  747  136  872
     [603]  973  631  986  132  802   73  609  198  173  457  743  227  178  803
     [617]  685  325  374  301  864  823   29  367  118  583  679  230  360  171
     [631]  958  377  972  213    1  312  137  947  637  173  850  825  967  359
     [645]  669   98  392  872  676  708  925  802  457  354  964  122  324  419
     [659]  950  327  954  662   18  958  926  555  990  828  839  787  804   36
     [673]  508  110  984  817  760  399  800  292  141  928  233  395  836  791
     [687]  951  749  398  702  936  661  147  542  805  925  351  623  482  428
     [701]  367  211  426  597  676  643   89  443  507  931  853  530   29  772
     [715]  731  215  167  669  105  527  951   56  945  450   39  850  322  556
     [729]  840  144  254  410  530  978  216  643  361  236   95  300  225  397
     [743]  383  518  420    5  277  880  333   70  418  597  536  571  546  255
     [757]  480  388  131    1  845  870  240  763   60   19  867  698  576  308
     [771]  701  860   10  652  669  140  897  896  149  919  280  324  636  216
     [785]  651  526  505  536  687  755  465  652  209  853  863  561   81  700
     [799]  464  413  918  543  181   40  228  348  496  403  390   31  657  879
     [813]  110  350  928  536  925  970  753  514  738  305  486  107  614  666
     [827]    2  548  137  755  263  251  139  641  900  255   97   24  660  105
     [841]  925   88  594  518  601  821  508  277  687   20  780  202  258  714
     [855]  280  916  588  609  178  828  905  994  450  255   12  108  513  239
     [869]  454  965  531  123    1  936  232  668  599  264  461  539  229  212
     [883]   79  212  447  192  852  614  404  861  790  458  962  958  537  924
     [897]  310  875    4  564  229  123  689  596  943  522  440  174   23   26
     [911]  606  293   92   25  315  223  383  760  485   79  749  521  788  199
     [925]  742  912  826  733  603  514  166  902  746  105  641   48  371  312
     [939]   74  768  762    5  393  186  429  689 1000  912  737  354   35  231
     [953]  410  415  904   28   49  681  820  162  633   60  493  136  177   18
     [967]  915  541  257  241  487  935  878  717  601  122  403  646  114  848
     [981]  541   18  536  352  660  261  859  912  215  163  354  200  669  706
     [995]  569  533  944  165  673  993
    
    $resamples[[5]]
       [1] 543 526  53 462  94 147 272 849 719 775 140 464 851 328 976 133 294 408
      [19] 413 725 316 185 899 423 340 759 510  88 600 223 300  10 194 495 910 809
      [37] 325 550 123 522 933 509 398 433 428 257 902 468 892 906 863 194 365 683
      [55] 492 768 162 233 318 832 295 993 580 420 755 782 134 457 303 841 881 765
      [73] 835 100 326  68 108 737 567 131 396 746 149 172 606 329  95 521 256 848
      [91] 185 463 506 240 737 229 289 485  73 214 842 213 345 177 973 712 685 668
     [109] 113 166 860 487  78 260 666 820 648 710 813 176 962  32 122 870 942  12
     [127] 482 479 911 745 288 819 455 548 688 102 321 260 285 188 832 533  16 365
     [145] 505 254 588 322 950  22 321 437 840 417 747  86 646 999 174  51 816 512
     [163] 837 232 392 155 602 172 527 353 744 364  58 520 792 773 956 983 406  12
     [181] 379  96 827 752 294 876 660 501 982 380 179 913 746 974 457 950 895 912
     [199] 381 587  84 629  23 403 383 726 307 458 733 901 457 989 121   8 738 551
     [217] 181 318 674 176 507 773 623 900 483 353 769  24 451 596 775 168 929 531
     [235] 894  75 186 178 600 109 463 909 266 978 518 508 442 894 845 558 203 503
     [253] 672 716 168 425 884  34 769 357 856 777 949  54  19 218 439 662 325 224
     [271] 970 532 790 101 314 154  43 809  64 356  72 799 780  59 902 846 235 317
     [289] 914 567  90 123 871 961 825  80 343 999 753 823 720 247 133 158 977 250
     [307] 146 779 321 826 431 499 604 833 887 582  94 892  23 524 462 760 171 640
     [325] 540 982 959 188 937 624 522  94 646 373   5  50 254 654 217 921 964 382
     [343] 570 562 201 924 709 131 450 535 457  90 813 549 866 204  49 229 830  79
     [361] 843 389 552 785 217  80 782 203 853 350 765 468 579 981  16 509 637 471
     [379] 139 891 308 765  20 398 478 369 372 195 270 988  90  22 275 250 523 289
     [397] 691 496 975 659 564 130 854 623 373 931 186 427 331 557 526 688 534 488
     [415]  34 987 487 806 283 455 841  36 754 231 414 522 212 906 621 542 691 530
     [433] 460 670 904 910 208 951 962 734 411 137 132 689  42 455 476 152 204 226
     [451] 961 664 683 485 507 685 733 840 276 487 506 503 754 391 422  37 560  39
     [469] 123 674 277 380 920  33 466 131 175 633 758 857 228 252 959 255 467 304
     [487] 598 660 146 751 973 616 288 186 570 757 298 257 664 691 517 354 747 104
     [505] 228 363 282 698  19 663 813 590 987 929 162 978 347 766 800 230 293 609
     [523]  67  66 649 658 572 266  99 790  64 267 167 633 539 794 477 231 113 677
     [541] 268 927 979 745 567 112 177 122 723 478 326 295 735 453  65 248 799 772
     [559] 604 312 127 633 271 275 781 276 903 589 960  19 916 703 260 389 180 716
     [577] 894  36 452 826 554 662 145 917 452 399 728 766 380 374 222 383 705 310
     [595] 473 195 159 234 107 249 358 440 681 418 532 116 503 298 637 518 931 281
     [613] 162 906 852 860 711  86 400 414 109   8 718 573 948 495  48 217 205 492
     [631] 449 119 148  88 778  36 332 670 713 205 132 831 670   2 335 601 229 943
     [649] 512 683 865 512 110 124 938 404 317 807 453 633 342 836 703  41 808 303
     [667] 661 321 105 143 860 612  18 912  48 699 101 409 169 946  23 154 570 618
     [685] 106  49  26 318  65 305 384 796 516 539 703 373 407 509 405 998 208 454
     [703] 660 620 685 879 421 221 503 562 245 129 679 623 273 160 256 562 705 824
     [721] 481  85 337  40 848 846 318 518 468 669 297 939 565 565 505  91 201 741
     [739] 555 635 773 831 644 518 295 850 786 948 412 979 965 676 224 472 891 247
     [757] 977 123 287 563 246 294 428 485 161 706 390 514 208 322 931 421 857 911
     [775]  17 614 300 826 987 970 158  57 460 558 337 754 610 301 896 595 912 643
     [793] 366 570 985 514 306 357 244 493 737 675 859  79  21 640 597 952  23 194
     [811] 183 246 190 506 528 915 897 591  16 291 162 796 713 225 719 384 254 384
     [829] 548 183 481 326 306 470 897 958 552 560  62 184 381  83 616 899 966  15
     [847] 615 845 506 653 115 914 765 469 378 766 729 610 669 237 374 559 505 440
     [865]  10 430 136 907 250 334 519 215 312 220 315 342 314 480 530  63 506 219
     [883] 875 485 136 420 736 781 626 173 316 931 411 649 856 960 916 243 866 160
     [901] 847 689 600 353 922  11 202 912 429 571 190 795 397 400 992 448 165 417
     [919] 105 221 712 924 737  72 569 672 895 380 702 524 320 355 472 708 906 463
     [937] 720 272 493  57   9 699 972 868   7 515 631 172 881 361 944 677 479 527
     [955] 313 776 273 394  24 447 320 493 377 992 826 962 439 129 679  39 702 689
     [973] 587 767 372 698 383 846 861 541 971 523 334 863 107 782 299 475 996 148
     [991] 989 538 286 432 298  87 300 156 307 180
    
    $resamples[[6]]
       [1]  394   37  762  114  181  709  414  396  608  839  638  812   34  531
      [15]  336  778  206  131  385  930  165  256  488  426 1000   32  655   26
      [29]  224  339  917  813  207  888  818  681  154  457   85    1  131  770
      [43]  531  651   35  439  633  914    5  914  802  412  642   96  986  119
      [57]  423  775  192  819  172  885  459  994  816  157  559  731  580  337
      [71]  779  848  110  401  523  600  870  884  822   27  319  974  763  270
      [85]  769  155  725  632  303  501  450  937  834  337  525  933  446  580
      [99]  699  245  297  220  551  467   72  426  686  352  767  809  217  747
     [113]  715   25  829  585  210  578  228  994  128   48  502  298  543  307
     [127]  250   55  743  801  640  660  896   70  836  313  844  795  400  840
     [141]  789  178  607  208  509  588  528  623  209  606  723  672  321  707
     [155]  372  526  723  319  844  176   78  214   65  665  321  602  602  715
     [169]  944  966  356  255  252  815  928  385  157  892  306  763  529    4
     [183]  905  769   17  392  167  156  395  472  829   89  181  226  886  875
     [197]  419   65  341  917  947  950  831  949  371  200  121  362  315  840
     [211]  209  831  232  403  123  562  276  389  272  383  426  475  193   44
     [225]  856   82  160  931  598   56  133  554   24  834  344  302  808   53
     [239]  724  396   78  629  560  814   33  749  640  382  463   75  449   18
     [253]  401   96  357   87  488  234  763   57  544  978   90  197  547  248
     [267]  138  345   46  569  576  872  423  863  643  879  674  822  992  696
     [281]  252  251  991  237  485  609  743  727   21  115  236  368  664  941
     [295]  123  514  864  110  383  660  439   79  361  885  550  575  536  523
     [309]  415  966  818 1000  276  884   28  928  270  871  891  352    5  498
     [323]  538  621  795  232  423   76  316  689  759  307  362  422  776  880
     [337]  385  923  518  171  693  332   69  296  375  140  594  673  937  950
     [351]  417  951  926  360  966  579  564  562  231  685  634  309  672  526
     [365]  638   27  896  443  156  703  870  615  654  254  380  497   70  160
     [379]  117  877  186  564  921   45  757  588  473  576   39  894  810  787
     [393]  526  814   35  214  542   44  653  593   71    2  500  114  797  829
     [407]   62  220  309  435  971  292   69  164  484  308  891  732   33  219
     [421]  697  317  465  352  912  202  273  371  367  105  544  879  182  533
     [435]  720  308  630  743  378  418  808  418  492  785  204   32  348   84
     [449]  398  209   27  937  397  665  377  620  986   82  572  796  853  761
     [463]  400  681  744   34  462  630  578  843  483  146   27  155  470  545
     [477]  966   79  614  829  861  188  816  466  835   96  595  184  113  770
     [491]  866  897  679  209  450  680  990  363  887  158  328  807  762  226
     [505]  980  240  619  147  276  790  862  738  178  239  974   23   62  614
     [519]  243  270  676  253  578  937  191  788  227  187   76  537  445  441
     [533]  116  459  937  899  452  656  851  830  112  448  543  990   61  859
     [547]  475  273   39  212  366  332   20  564  630  121  987   91  219  681
     [561]  666  850  395  649  725  895  192  399  511  154  123  510  840  525
     [575]  750  254  704  188  139  579   18   62  158  879  714  474  667  962
     [589]  325  430  627  961  129  289   62  215  106  171  577   60  550  548
     [603]  692  907  399  796  651  506  512  191  635  440  483  698  966  527
     [617]  539  127  846  664  358  205  147  798  337  283  855  404  792  768
     [631]  369   72  292   76   79  507  264  676  801  395   52  425  971  347
     [645]  637  888  128  859  134  207  221  999  993    8   71  912  398  245
     [659]  961  742  869  955  104  324  899  675  388  630  800  887  147  667
     [673]  340  216  444  518  708  265  852  234  608  681  490  571  783   27
     [687]  318  634  813  560  402  586  170  716  795  333  542  488  900  753
     [701]  660  775  805   86  732  866   44  841  931   30  455  960  404  707
     [715]  854  623  306  899  548  877  277  652  815  890  786  940  813  358
     [729]   16    2  271  197  819  735  183  145  355  872  646  411  391  271
     [743]  750  178  389  567  244  970  603  488  922  808   38  619  791  214
     [757]  145  450  444  176  224  708  586  689  122  713  624  908  679  876
     [771]  750  398  263   16  980  890  698  733   72  106  379  506  115  352
     [785]  599  238  815  194  962  525  508  409  228  993   79  253  444  833
     [799]  897  471  950  514  618  803  380  695  658  942  541  595  683   93
     [813]   61  710  822  811   19  511   33  219  110   19  641  538  987  671
     [827]  893  262  858  841  175  113  758  498   92  469  256  180  407  936
     [841]  506  865  732  292  380  703  644  427  489   28  897  722  695  194
     [855]  577  914   83  689  438  493  158  327  866  815  642  218  665  486
     [869]  753  663  764  585  708  593  993   57  797  775  216  237  936  795
     [883]  809  352    6  625  504  894  773  734  132  608  888  601  249  906
     [897]   75  554  996   10  473   73  621  648  616  947  265  155  575  371
     [911]   11  651  142  977   32  197  379  442  251  364   71   51  111  664
     [925]  581  762   68  435  289   53  224  297  914  787  630  874  207  452
     [939]  100  773  680  732  561  726  525  470  111  142  378  424  832  251
     [953]  241  481  957  496  480  322  540  691  308   75  273  617  292  228
     [967]  991  459  519  148   18  427  287  558  421  224  671  422  204   54
     [981]  791  628  367  880  818  370  521  620  268  889  921  561  456  822
     [995]   58  898  145  756  813  996
    
    $resamples[[7]]
       [1]  914  212  682   17  497  848  116  458  748  945  547  915  303  280
      [15]  196  795  480  504  131  618  329  311  306  278  742  750  216   88
      [29]  385  316  272   84  176  748  726  175  538  880  171  706  328  547
      [43]   68  469  344   86  892  289  363  222  755  294  945  949  853  148
      [57]  325  953  932  534  426  239  612  790   90  128   41  484  790  424
      [71]  719  709  504  809  543  440  788  263  871  763  163  448   29  133
      [85]  521  632  352  764  747    2  578  404  136  458  900  736  588  765
      [99]  819  209  795  922   64  274   47   69  656  887  768  114  620   75
     [113]  594  744  495  120  220  685  484  339  668  556  105  940  823  932
     [127]  768  398  373  404  313   76  391  260  650  514  782  347  832  315
     [141]  446  282  939  489  375  121  702  998  119  212  527  318  129  344
     [155]  542  241  157  784  611  373  864  677  480  853  119  994  195  217
     [169]  130  773  680  703  755  546  152  385  662  851  391  484  299  704
     [183]  628  343  944  789  639  841  376   63  638  573  808   93   25  843
     [197]  831  139  574  754   19  410   85  839  788  438  403  347  261  812
     [211]  463  738  162  448   48  468  319  192   29   26  951  781  816  253
     [225]  914  897  475  241  657   11  388  541  491  558  661  212  620   59
     [239]   68   50  610  562  512   14  122  249  439  615  781  159  315  203
     [253]  430  406  674  229   31  361  537  741  434  675  446  686  875  131
     [267]  595  693   42  871  898  714  675  745  689  998  572  470  237  704
     [281]  857  342  752  801  587  307  955  101  477  940  321  781  392  682
     [295]  749  798  628  686  279  487  715  829  376  486  495  142  418    8
     [309]  125  195  188  200  697   92  363  561  541  702  178  249  975  810
     [323]  710  167  808  348  343  472  702  820  890  920  395  579  965   82
     [337]  979  529  137   68   23   33  739  256  724  493  756  709   81  135
     [351]  189  865  993  612  854   38  473  555   88  600   45  444  541  941
     [365]   12  311  486  307  568  934  309  768 1000  176   27  358  248  935
     [379]  212  712  605  269  825  431  352  841  486  972  330  285   72  161
     [393]  587  225  155  208  503  176  300  924  164  455   81  307  320  943
     [407]  927  839  284  619  745  717  418  928  674 1000  726  659  441  554
     [421]  729  942   22    1  818  457  430  518  293  990   85  995  816  629
     [435]  659  289  489  516  312  694  702  226  339  396  650   11  807  807
     [449]  429  928  717  329  308  439  828  751  726   24  875  763  569  991
     [463]  995  392  404  960  423  989  676  530  646  714  745  242  666  533
     [477]  331  555  446  864  581  958  120  632  752  913  341  134  174  761
     [491]  335  988  773  806  453  279  772  372  920  890  853  910  566    8
     [505]  265  980  141  415  521  150   17   30  896   31  381  551  102  224
     [519]  740  354  668  587  252  355   60  379  458  361  796  213   18  390
     [533]  459  601  807  232  890  526  269  675  554   74  987  800  217  664
     [547]  722  337  837  892   19   97  280  697  799  851  413  114  243  363
     [561]  724  865  672  156  873  916  713  302  238  769  759  957  484  739
     [575]  194  807  606  176  193  452  709  265  476   40  119  498  151  168
     [589]  737   12  486  968  349  912  606  201  285  737  243  848  272  114
     [603]  351  310  172   41  880  541  609  920  402   79  554   85  448  179
     [617]  871  163  882  633  757  175  184   41  973  192   80  746  980  558
     [631]  771  203  436  236  621  256  992  689  378  652  158  386  387  265
     [645]  698  662  598  683  560   20  302  785  732  355  105   66  886  387
     [659]  314  702  845  240  236  833  255  292  375  122  153  659  140  949
     [673]  212  637  862  744  215  119  902  860    4  802  185  760  628  277
     [687]   77  748  846  445  986  459  924  108   34  154  590  746  378  775
     [701]  613  905  679  345  870  274  632  214  859  412  301  990   36  199
     [715]  164  411  148  300   88  225   91  110  927  162  492  443  949  399
     [729]  551  471  754  253  416  775  977  865  573  340  512  662  689  424
     [743]  879  306  472  690   23  345  170  646  575  560  202  757  522  725
     [757]   77   34  328  526  689  820  333  159  797  651  611  750  348    5
     [771]   45   20  617  610  125  324   14  358  765  359  117  766  399  770
     [785]  569  561  969  117  727  664  391  643  170  351  773  449   66  441
     [799]  695  393  583  371   57  325  985  476  977  467  341  114  231  274
     [813]  502  755  894   75  160  854   10  925  951  120  204  107  442   80
     [827]  779  840  643  659  576  435  339  112  550  810  371  701  585  733
     [841]  604  773  341  555  995  280  922  556  904  872  598  443  560  219
     [855]  910  408  283  503  578  818  372  676  161  201  872  908  545  260
     [869]   25  563  179   80  644  701  356  529  595  932  842  784  366   47
     [883]  359  622  218  392  425  985  731  869  932  276  565   11  378  695
     [897]   47  519  894  887  922  513  439  282  802  376  524  404  227  971
     [911]  788  828  697  149  335  692  255  845  750  120  717  295  996  181
     [925]  860  604   54  204  776  762  735  647  482  533   26  231  389   78
     [939]  191  311  662  175  158  499  227  659  412  717  897  688  278  226
     [953]  470  178  817  589  939   43   60  783   78  769  689  911  323   58
     [967]  776  270  127  323   76  930  266  178  614  518   63  269  734  761
     [981]  170  658  822   51  104  689  625  314  397  961  725  669  499  898
     [995]  464  513  721    5  753  236
    
    $resamples[[8]]
       [1] 598 530 363 601   8 825 339 332 275 676 867 979 266  74 496 496 195 498
      [19] 513 832 470  65 203 625 348 425 870 693 568 591  86 553 120 890 216  40
      [37]  55 299 843 703 169 643 345 518  87 638 628 847 334 802 476 363 907 572
      [55] 522 518 976 632 959 237 265 442 670 737 751 677 899 793  31 552 992 495
      [73] 930 864 866 369 212 992 480 275 372 702 175 834 827 582 224 398 724 309
      [91] 167 490 526 260  78 711 781 370 373 449 794 472 418 601 290 456  60 466
     [109] 987 627 531 341 140 226  72 427 439 882 116 440 522 500 647 701 783 535
     [127] 448 406 169 436 763 584 878 220 879  37 900 975 589 212 531 548 396 382
     [145] 275 739 485  14 507 717 250 601 422 588 805 642 291  42 787 916 180 349
     [163] 753 877 205 161 530 749 289 505 593 496 545  97  15 323 109 895 701 356
     [181] 760 791 299 860 706  66 199 729 297 768 287 301 514 608 302 792 911  15
     [199] 658 784 125  85 734 448  35 109 648 921 226 944 973 973 431 765 638 340
     [217] 637 564 256 525 728 183 103  40 619 544  57 386 212 320 992  71 899 927
     [235] 224 343 540 820 417 344  95 940 801 986 611 383 507 494 198 500  58 788
     [253] 677  45 697 774 591 792 259 264 884 822  63 354 344 371 296 239 105 972
     [271] 607 538 222 285 642 699 893 464 307 436 954 784 728 333 711 197 692 113
     [289] 864 516 459 158 676 924 359 677 245 418 409 835 849 719 403 658 865 709
     [307] 881 539 547 143 843 135  85 704 114 699 547 244 942 521 773 543 678 935
     [325] 223   3 168 784 434 122 181 981 108 840 209 462 682 232 210 191 183 659
     [343] 923 695 733 930 875 362  95 429 652 269 313 871 758  52 264 912 659 458
     [361] 656  20 992 327 216 775 728 504 804 415 441 657 160 595  99 411 692 861
     [379] 676 375 611 627 825 187 434 541 141 789 499 997 315 494 543  28 122 403
     [397] 854 643 784 146 676 502 809 386 271 807 545 120 779 957 866  18 993  71
     [415] 142 400 555 557 389 687 470 196 194 788 255  31 435 448 687 217  92 895
     [433] 944 403 149 464 928 299 374 313 375 917 397  68 619   6 328 202  86  24
     [451] 391 681 261 262  81 238 151 401  43 764 640 139  41 483 944 511 907 418
     [469] 854 881 646 564 710 261 750 961 765 633 354 634 273 479 796 609 183 747
     [487] 279 460 275 666  31 838 742 881 650 922 264 303  35   8 108 654 224 391
     [505] 425 111 832 997 972 811 674 145 420 326 478 814 406 191 198 461   6 882
     [523] 235 542 256 688 216 773 413 966 978 651 975 908 333 559 537 528 904 864
     [541] 222 853 259 232 716 209 611 211 476  64 279 141 413 799 389 941 659 411
     [559] 997 969 654 455  26 653 289 271 960 436  17 615 928  60 858 909 408  91
     [577] 779 156 387 533 476 556 573 728 885 162 120 537 524 178 968 347 591 776
     [595] 845 123 713 742 328 881 471 898 818 873 200 588 692 232 367 797 731 334
     [613] 434 891 321 286 704 818   1 695 412 677 384  10 414 640 748 309 338 166
     [631] 985 379 828 236  95  33 984 605 397  32 602 462 737 617 691 442 982 273
     [649] 686 283 165 475 113 416 343 835 519 784 913 379 451 352  63 642 883  86
     [667] 600 207 152 942 660 130 795  77 611 501 990 259 757 752 851  32 954 176
     [685] 175 494 708 563 646 383 971 949 143 311 538 273 347  28 247 510 696 209
     [703]  76 318 718  33 965 820 637 332 175 281  58 324 759 557 268 683 889 594
     [721]  69  70 401 740 305 777 708 513 432 577 573 188 112 807 637 732 481 354
     [739] 355 446 271 943 865 334 670 389 642 882 509 531  63 731 471 499  75  81
     [757] 809 727 767 878 711 608 683 841  54  77  69 187 727 918  56 488  12 675
     [775] 394 495 297 572 796  62 278 224 309 954  46 258 480 431 540 682 507 696
     [793] 296 434 305 572 475 736 790 413 620 621 392 265 915 279 769 613 476 856
     [811] 227 699 602 129 783 277 189 291 501 900 166 852 293 197 203 150  29 516
     [829] 602  80 116 620 612 921 450 988 421  91 105 981 840 559  75 992 383 890
     [847] 302 849 663 780 372 159 409 334 809 816 488 265 872 119 956 730 691 957
     [865] 214 875 586  83 120 330 632 419 539 795 315 470 637 572 716 692 246 135
     [883] 861 659 644  49 406 448 734 123 159 836 652 993 255 415 837 209 820 525
     [901] 535 396 503 682 879 567 121 577 832 605 717 951 100 711 794 665 193 607
     [919] 746 860 772 677 335 258 915 670  69  66 561 867 510 112  41 776 458 717
     [937] 496 478 964  36 775 600 669 929 368 707 258 418 881 270  23 488 815 992
     [955] 269 759 299 448 671  36 924 630  85 797 101 938 477 671 995 764 776  31
     [973] 270 403 105 573 955 930 919 348  96 114 193 785 727  52 981 875 971 179
     [991] 147 871 853 844 261 730  72 559  94 179
    
    $resamples[[9]]
       [1] 309 648 656  43 763 262 825 839 980 290 782 246 667  85 109 827 785 254
      [19] 415  84 443 166 554 265 818 297 457 597  19 440 862 847 392 279 429 309
      [37] 556 112 748 658 948 271 978 398  44 892 543 744 580 570 841 164 684 692
      [55] 673 897 387 696 872 150 740 223 710 124 598  71 776 401 877  84 547 731
      [73] 457 656 244 543 750 641  36  86 140  37 262 152 573 350 163 623  91  20
      [91] 961  61 128 243 563  96 818 736 756 552 973 992 167 689 306 875 442   9
     [109] 452 295 624 516 748  29 422 693 733 992 528 981 351 554 894 116 704 428
     [127] 644   4 442 665 484 461 415 122 423 102 620 444 393 371 702 446 973 770
     [145] 314 616 136 272 145 811 590 240 193  92 207  59 247 311 790 993 416 551
     [163] 962 316 384 199 327 608 107 662 837 519 322 213 969 461 223 683 845 734
     [181]  29 684 304 768 522 117 228  80 585 405 799 136 930 290 329 854 510  21
     [199] 370 247 657 745 613 549 135 731  17 939 575 717 285 818 751 958 479 456
     [217] 440 276 618 930 185 115 707 496 247 732 514 184 741  91  74 583 797 454
     [235] 388 834 186 130  30  36 477 575 465 482 851 781 349 468 952  16 388 362
     [253] 200 724 163 953 864 289 159 914 101 943 682 413 876 554 209 220  96 933
     [271] 452 994 103 496 130 806 931 970 315 929 297 551 316 701 819 887 287 380
     [289] 802 146 469 212 904 512 270 652 509  82 202 900 258 107 100 665 783  96
     [307] 921 353 594 892 903 776 387 599 855 981 489 689 123  36 438 759 985  69
     [325] 789 267 543 595 325 192 412 717 154 604 595 540 775 335 830 701 998 428
     [343] 783 253 381 624 185 691 975 679 885 396 675 767 309 755 825 527 746 903
     [361]  49 850 223 772 747 654 475 695 916 237 912 898 623 797 142 200 215 564
     [379] 188 488 424  38 353 459 148 792  29 723 518 793 101 919 268 453 269 327
     [397] 166 280 648  60  22 967 783 955  34 629 912 579 328 490 205 933 493 649
     [415] 873 595 961 802 305 930 835 984 951  23 815 368 445 153 508 485  92 674
     [433] 136 514 170 330 813 944 911 558 242 912 741 186 167 915 794 979 913 929
     [451] 150  74 876 307 352 925  88 307 358 612 749  53  95 926 980 975 739 233
     [469]  22 743 217 958 399 929 966 591 276 839 251 111 139 722 517 912 284 680
     [487] 585 466 971 525 839 109 847 850 836  42 744 199 217 352 168  32 974 775
     [505]  11 893 187  23  73 676 987 931 721 899 394 393  55 996 995 205 607 209
     [523] 745 470 540 919 435 985 305 782  46 233 211 119  75 359 707 536 328 513
     [541] 959 922 951 462   1 474 741 630 683 935 634 556  97 251 242  40 624 584
     [559] 223 262 805 914 358 478 666 993 329 385 461 632 366 225 408 605 840 244
     [577] 556 724 949 401 122 533 788 898  26 761  78 325 904 162 369 469 271 549
     [595] 407 223 226 749 980 811 126 998 474 408 495 708 824 444 435 853 386 312
     [613]  96  29 771 234 893 248 605 885 355 942 988 700 400 697 416 827 243 363
     [631] 831  30 471 736 517 154  12 575 842 103 181 472 911 660 237  52 188 932
     [649] 539 282 577  41 162 958 526 872 897 253 306 894 406 148 581 679 623 516
     [667] 228 975  29 974  84  95 773 897 212 237  35 926 260 914 560 721 751 107
     [685] 206 313 994 105 104 970 375 647 174 234 299 382 756  62 556 583 380 731
     [703] 127 836 813 388  72 992 314 220 466 413  33 900 535 794 424 672 934 209
     [721]  88 783 922 485 211 851 625 843 336 958 139 725  20 695 737 565 633 704
     [739] 354  98 768 915 369 240 276 459  32 908 497 258  76 500 992 376 331 883
     [757] 617 994 537 306 112 552 631 180 572 529 891 227 388 397 980  54 718 657
     [775] 358 229 344 409 156 680 233 888 950 794 639 635 478 398 243 615   4 524
     [793] 320 575 144 565 513 116 804 665 545 692 840 110 275 571 562 713 740 656
     [811] 849 883 796 484 452 201 838 155 268 809 327 371 108 474 782 999 365 985
     [829] 982  64 430 726 180 556 632 495 638 515  53  54 847 504 449 901 545 182
     [847] 751 927 258 589 863 947 927 356 677 145 687 948 189 448 512  62 410 674
     [865] 203 742 454 595 633 645 173 201 687 720 845 624 199 731 912 661 984 871
     [883] 375 200  49 865 702 276 941 740 829 310 133 273  39 845 191 113 135 674
     [901]  41 925 275 796 927 783  11 584 549 982 318 226 224 336 240 679 517  47
     [919] 207 995 112 832 586 892 856 526 157 607 161 221 553 283 300 930 123 354
     [937] 467 685 240 737 111 596 119 734 347 334 817 757 323  13  54 627 283 170
     [955] 968 674  40 283 674 131 573 720 368 325 778 782 689 742 793 185 362 956
     [973] 539 531 135 322  18 820  95 762 885 298 261 228 386 570 457 563 619 579
     [991] 705 425 264 256 162 120 606 633 770 563
    
    $resamples[[10]]
       [1]  180  590  903  733  222  841  186  701  351  770  986  788  350  583
      [15]  494  495  786   35  474  804  411  756  657  532  161  971  684  628
      [29]  252  517   55  205  881  854   62  931   17   79  225  480  572  100
      [43]  617  541   58  109  606  288  419  911  911  861  815  798  358  838
      [57]  919  968  860  895  965   79  288  290  798  662  939  725  177  733
      [71]  753  633  687   47  479  861  645  481  123  108  673  893  688  933
      [85]  975  414  306  264  269  576  642  122  532  639  767  868  560  435
      [99]  380  218   86  674  261  958  959  612  396  867  250  129  596   91
     [113]  834  845  335  984  783  912  986  268    6  428  616  271  562  372
     [127]  120  800  509  345  918  879  345  550  858  778  230  366  323  444
     [141]  614  188  862  878  826  154  507  696   69   21  761    5  548  884
     [155]  675  144   82  883  335  882  556  585  950  120  910  997  158  958
     [169]  308  842  833  113  188  645  685  394  806  582   87  265  761  359
     [183]  756  170  473  892  161  117  769  390  659  890  632  819  408  102
     [197]  240  193  346  281  518  640   36  399  332  941  796   26   88  896
     [211]  963  856  678  588  881  270  187  477  487  272  665  148   91  211
     [225]  933  836  237   89  445  848  586  965  253  187  385  841  246  572
     [239]  365  139  831  950  363   34  165  915  995  140  925  863  233  123
     [253]  849  667  621   35  642  892  940  625  103  418  423  736  599  987
     [267]  356  977  958  372  947  977  193  505  502  569  837  868  162  124
     [281]  958  162   70   80  285  614  796  135  351  412  151   42   62  735
     [295]  563  230  647  183  753  478  992  121  836  550  138  697  468  189
     [309]  490  525  763  995  807  339  931  280  242  653  494  970  171   58
     [323]  118  869  976  605  291  204  989  182  127  720  500  894  236  336
     [337]   24  447  879  685  949  981  822   60   18  241  492  820  126   48
     [351]  327  286  798   43  233  394  601  900  688  580  187  765  392  217
     [365]  557  377  671  685  323  534  481  611  151  743  488  886  890  965
     [379]  280  123  726  724  387  976  767  191  554  390  358  989   10  674
     [393]   18  453  522  678  946  898  328  328  873  824  555  241  593  198
     [407]  648  209  456  562  853  360  370  256   40  551  133  611  335  213
     [421]  531  770  515  217  107  668  722  297  171  817  569  507  877   75
     [435]  162  763  691   76  613  761  804  824  239    1  430  550  693  783
     [449]  995  554   54  939  429  196  147  391  161  716  105   75  314  820
     [463]  953  211   94  815  607  933  840   69  938  963  255  488  243  519
     [477]  729   41  820  867  759  376  344  307   71  124  465   72  885  741
     [491]  871   65  979  319  851  927  645  215  443  839  861  203  502  678
     [505]  118  211   20  421  810  745  455  784  662  910  889  789  496  250
     [519]  828  329  151  870  666  888  618   39  996  217  287  561  688  259
     [533]  350  823  827  214  698   67  474  757   78  854   23  577   46  489
     [547]  340  892  543  225   16  113  753  660  541  218  611  143  269  627
     [561]  130  127  186  888  464  169  653  405  251  115  310   85  749  165
     [575]   48   85  337  719  587  855  816  739  332  818  310  895   92  723
     [589]  644  525  673  179  472  981  571  414  469  824  924  567  148  352
     [603]  307  527   85  483  196  506  704  926  218  946  324  534  387  249
     [617]  737  398  953  498  198  698  388  136  570  541   50  917  843  568
     [631]   17  357  298  107  961  867  421  384  198  532  504  924  836  477
     [645]  836  533  770  330  143  917  379  494  858  276  436  806  893  944
     [659]  497  530   91 1000  759  487  636  787  466  695  960  975   56  132
     [673]  765  399  669  791   54  102  186  842  761  287  428  278  505  445
     [687]  680   66  867   49  963  448  675  821  108  527  320  460  645  107
     [701]  116  667  144  473  915  881  249  262  591  195  601  305  614  175
     [715]  734  554  715  960  179  952  450  538  672  531  307  616    7  561
     [729]   64  526  207  161  627   95  527  142  672  948   76  973  120   89
     [743]  358  508  436  121  429  789  439  557   34  347  964  881   99  386
     [757]  169  657  873  638  518  277  338   85  419  752  583  646   42  827
     [771] 1000   87  907   10  845  822  689  158  670  318  796  598  248  108
     [785]  455  507  615  694  988   49  793  466  762  419  371  187  801  843
     [799]  523  137  718  280  655  777  545  767   54   78    2  207  910  313
     [813]  550  461    8   84   67  192  560   64  979  883  138   54   53  276
     [827]  123  579  328   78  854  353  792  340  608  917  549  666  495  184
     [841]  899  824  993  344  358  825  809  990  746  528  592  367  777  827
     [855]  186  594  122  675  344  352  424  763  469  683  739  715  916  698
     [869]  400  805  117  998  918   30   16  363  452  615  539  980  637   93
     [883]  907  788  563  546  610  494  444  642  238  756  806  263  261  515
     [897]  515  585  777  957  564  595  232  137  913  471  805  215  344  483
     [911]  947  497  409  618  154  998  177  897  287  968  653  103  980  653
     [925]  810   84  637  500  849  463  735  703  674  251  520  507  708  343
     [939]  307  553  122  543  429  911  984  228  481  989  713  744  176  624
     [953]  266  390  534  623  973  622  855  738  368  407  691  366  586  864
     [967]  642   66  317  615  921  855  479  388  562  627  624  755  364  996
     [981]  585  507  307  645  392  723  491  314  298  913  260  831  734  615
     [995]  219  657  577  388  710  892
    
    
    $original
    Outlier-Robust 2SLS Model 
    Initial estimator:  robustified 
    Reference distribution:  normal 
    Two-stage Least-Squares Model: y ~ x1 + x2 + x3 + x4 + x5 | x1 + x2 + x3 + z4 + z5 + z6 
    Iterations:  3 
    Final selection:  Outliers found:  33     Outliers proportion:  0.033 
    
    attr(,"class")
    [1] "r2sls_boot"

---

    $boot
       X.Intercept.  m gauge  r
    1    -0.1764190 m1 0.039  0
    2     1.9842441 m1 0.054  1
    3     0.1083137 m1 0.029  2
    4    -0.5942437 m1 0.043  3
    5    -0.3566934 m1 0.034  4
    6     0.2845327 m1 0.046  5
    7     0.3315480 m1 0.036  6
    8    -0.8020391 m1 0.043  7
    9    -0.5130966 m1 0.048  8
    10   -0.1535738 m1 0.050  9
    11   -0.2484292 m1 0.039 10
    
    $resamples
    $resamples[[1]]
       [1]  214  436  813  390  814  553  548  512  487  885  834  652  557  250
      [15]  260  680   71  953  291  783  194  624  442  716  914  933  647  689
      [29]   25  827  844  943  201  718  385  596  599  419  983  239   85  602
      [43]  739  780  447  112  744  617  274  648  530  155  256    2  115  202
      [57]  566  755   40  221  141  283  459  465   67  774  523   63  810  938
      [71]  502  120  555  727  985  187  539  239   68  517  513   72  410  213
      [85]  369  331  139  215  701  622  416  447  662   20  136   47  284  907
      [99]  289  689   89  391  421   68  424  435  588  829   16  267   34  729
     [113]  504  434  441  462  153  277  647  429   60  234  691  557  563  236
     [127]  355  608  221  659  762  102  524  275  160  946  646  946  407  916
     [141]  582  778  425  748  791  796  426  865  497  976   54  223  356   82
     [155]  278  858  798  416   85  292  558  664  997  625  539  682  882  934
     [169]  198  368  633  953  421  431  616   64  883  703  350  618  385  854
     [183]  564   84  763  135  826  524  549  115  362  837  582  637  244  747
     [197]  968  129  388  543  308  565  724  677  128  855  466  411  842  343
     [211]  547  161  492   53  342  133  579  298  555  330  881   74  690  958
     [225]  877  616  365  798  162  455  205  347  818  595   22  266  236  475
     [239]   26  240  230  429  365  134  633  712  186  207  409  251  216  444
     [253]  828  452  274  675  178  944  901  838  622  341  819  816  610  730
     [267]  840  461  484  272   13  654  182  647  175  415  119  994  578  401
     [281]   34  954  607  495  961  198   61  145  723   78  394  191  210  176
     [295]  753   85  113  240  480  895  989  491  447  909  638  683  823  356
     [309]  165  541  959  264  792  735  605  162  811  622  119  413  261  315
     [323]  260   39  970  324  485  360  875  377   24  153  796  562  908   99
     [337]  421  390  404  605  119  774  583  598  408  627  957   63  480  663
     [351]  744  900  628  959   27  533    8  717  638    4  203  893  987  617
     [365]   74  290  907  581  500  668  496  283  889  888  292  666  878  634
     [379]  948   54  583  338  934  581  998  695  107  989  388  220  940  338
     [393]  380  145  378  518  932  582    1  704  600  683  557  568  446  960
     [407]  112  766  262  292   64  290  823  957  640  489  149  861  257  596
     [421]  370  368  338  808  800   66  324  247  216   85  562  997  894  857
     [435]  874  810  127  658  860  615  744  404  297  656  297  201  468  746
     [449]  885  141   12  340  801  618   23  718  129  572  996  909  834  357
     [463]  131   73  188  992  951  941  265  240   44  164  752  869  596  190
     [477]  679  960  417  429  771  152  371  503  149  911  758  152  516  937
     [491]  971   36  515   31  506  931  541  813  425  521  761   97   26  521
     [505]  601  464  352  255  562  615  785  782  383   35  465  212  950  468
     [519]  549  591  618  262  838  604  352  501  386  192  879  325  380  499
     [533]  851  159  810  794  845  524  775  761  541  797  389  898  934  111
     [547]  158  327  919  893  125  808  880  717  311  963   69  653  743  921
     [561]  869  108  781  569  512  521  385  613  248  768  819  489  954  546
     [575]  834  867  974  729   63  677  923  563  938  698  498  988  687  998
     [589]   22  603  913  227  622  944   59  523  612  602   80  162  657  344
     [603]  886  244  998  716   37  889   86  240  517  160  668  926  694  549
     [617]  577  450   70  264  402  811   35  794  308  243  273   87  115  530
     [631]  146  438  430  276   15   11  413  434   30  464  131  169  126  491
     [645]  453  246  843  993  299  400   85  251  699   14  846  974  680  943
     [659]  618  929   81  274  216  173  197  954  238   46  267  922  156  616
     [673]  560  373  551  508  933  752  662  405   11  909  490   45  855  747
     [687]  213  309  580  109   23  556  318  999  740  574  900  763  346  662
     [701]  693  214  995  855  571   60   57  230   45  581  159  948  575  593
     [715]  753  894  663  292  617  440  475  299  924  554  124  275  342  228
     [729]  681  170  950  105  911  117  686  125   94  761  618  601  973  246
     [743]  363  833  221  973  808  230  546  763  894  465  608  684  728  167
     [757]  412  822  577  758  957    5  292  788   70  584   74    5   29  802
     [771]  406  861  918  952  853  945  603  340  134  920  769  882  530  973
     [785]  820  550  226   67  254  295  851  729  750  537  905  447  463  541
     [799]  767  291  259  246  404  805  104  844  328  842  440   34  320  987
     [813]  516  880  416  875  598  250  431  791  739  797  574   67   86  217
     [827]  231  972  712  140    2  497  748  106  418  586  112  325   87  449
     [841]  534  752  103  720  397  581  931  773  859  658  571  388  679  623
     [855]  686  477  174   52  324  613  113  449  549  460  323   91  441  678
     [869]  640  592  886  944  721  192  392  373  859  251  281  599  630  527
     [883]  325   73  803   41   79   46  892  583   80  242  138  490   14  319
     [897]  295  851  151  310  122  219  498  195  828   41  389  603 1000  702
     [911]  265  474  472   63   87  792  220  309  516  814  926  202  679  350
     [925]  159  725   59  413  662  114  668  253  933  864  209  799  882  697
     [939]  314  676  782  758  941  597  709  335  370  817  411  340  822  819
     [953]  487  617  708   60  336  297  843  809  559  159 1000  107  854  815
     [967]  667  655  475  580  155  174  320   80  379  789  131  919  329  940
     [981]  294  401  579  915  988  988  473  751  189  285  257  628  893  866
     [995]  950   76  625  604  356  205
    
    $resamples[[2]]
       [1]  991  588  233  510  784  979  404  414  724  751  572   44  238  874
      [15]  748  636  745  214   23   63  955   15  564  524  637  775  146  946
      [29]  148   23  659  523  570  614  483  200  480   18  543  866  878  791
      [43]  215  327  617  120  851  902  852  154  974  799   47  374  558  545
      [57]  672  648  211  778  785   53   37  569  609  729  614  906  474  171
      [71]  687  116  911  994  775  742  982  305  789  185  685  313  107  803
      [85]  291  623  966  585   38  756  756  533  627  817   24  980  525  779
      [99]  780  635  654  596  396  464  241  506  784  797  584  126  963  882
     [113]  951  957  133  698  190  968  748  719  939  618   59    8  578  595
     [127]  611  737  267  875  479  804   70  702  822  922   75  679   68  925
     [141]  526  217  101  463  608  354  497    2  377  451  935  295  199  325
     [155]  962   20  241  223  751  880   99  552  863  294  308  811  225  541
     [169]    8  499  833  887  251  852  533  531  649  795  610  591  569  438
     [183]  278  396  182  447   39  565  315  177  197  288  283  732  613  830
     [197]    2  539  202  817  457  734  817  274  871  179  266  136  108  145
     [211]  568  831   93  133  973  259  241  895  428   63  889  881  421  922
     [225]   42  958  285  819    4  198  571  644  570  602  672  245  974  417
     [239]  880  991   61  266  723  123   73  926  813  219  792  189  500  449
     [253]  137  566  282  892  808  209  305  407  727  215  882  684  895  124
     [267]  423  769  911  256  651  389  626  776  310   54  549  936  594  569
     [281]  987   24  582  871  808  228  257  211  526   51  499  920  306  315
     [295]  580  844  651  350  109  786  111  127  686  635  476  691   92  980
     [309]   84  163   48  566  823  455  374  666  542  709  278  258  713  784
     [323]  815  905  514  921  363  920  263   45   31  196  172  932   89   98
     [337]  558  149  430  511  301  727  911  668  271  910  812  384    3  246
     [351]  323  125  701  216  495  584  212  542  969  683  705  167  705  399
     [365]  762  608  195  356  972   12   27  648  330  167  615  518  521  994
     [379]  309  721  257  871  863  243   39  161   95   44  930  662  261  615
     [393]  443  812  606  465  573  892  804  209  106  618  445  656  617  164
     [407]  292  762  345  719   82  602  215  910  631  576  374  946  512  198
     [421]   23   58  919  312  257  319  120  609   90  300  796  281  546  202
     [435]  498  116  601   71  599  172  417  875  915  693  463  103  592  237
     [449]  882  500  819  401  549  999  102   35  245  905    9  946  116  485
     [463]  265  905  377  519   74  819  818  657  991  550  908  142  431  514
     [477]   87  353  906  714  763  869  232  434  851  218  983  490  648  915
     [491]   28  891  778   50   37  508  604  783  263  235  773   26  470  459
     [505]  236  129  206  355  559  811  894  860  852  281  581  275  875  400
     [519]  693  365  392  444  721  973  233  145   16  616  927  971  165  894
     [533]  695  904  946  688  585  345   63  913  321  811  374  390  755   23
     [547]   23  172  401  130  467    1  317  720  510  187  867  768  868   13
     [561]  720   74  277  849  177  209  910  914  234  639  518  185  819  679
     [575]  394  103   77  252  379  295  858  929  166  271  482  430  510  415
     [589]  325  147  651  709  209  369  915  172  871   84  278  257  700  900
     [603]   92   65  337  185  228  676  442  893  288  175  911   70  500  516
     [617]  845  843   62  771  559  394  225  583  166  598  974  724  513  895
     [631]  615  601  198  185  278  391  377   36  989  758  484  412  906  871
     [645]  166  659  279  231   13  629  160  695  337  157  916  877  817  202
     [659]  261  614  724  937  158  263  949   42   39  375   23  102  991   97
     [673]  787  275  296  153  596  718  695  993  173  250  964  199  995  694
     [687]  725  962  411   28  690  146  373  959  218  354  529   38   28  566
     [701]  840   36  949  255   19   74  695  382  460  914   68  961  633  141
     [715]  743  479  573  423  308  917   53  767  235  443  975  209  269  194
     [729]  774  547  610  884  621  484  685  985  944   36  684  580  972  637
     [743]  761  328  672  242  151  254  748  630  384  766  830  347  402  845
     [757]  264  557  614  422  724  435  696  523  979  144  239  658  848  816
     [771]  660   71  377  779  702  198   78   76  675  866  223  785  840  744
     [785]  831  384  912  329  682  826  812  960  383  193  666  600  505  887
     [799]   52  737  137  194  738  334 1000  570  738  700  848  522  494  337
     [813]  402  506 1000  832  666  214  252  368  861  511   87  488  275  540
     [827]   50  365  429  226  296  528  633  467   61  919  544  519  747  900
     [841]  152  760    3  113  628  803  982  849  509  628  782  411  810  623
     [855]  433   49  858  564  827    3  879  867  499  371  831  993  544  494
     [869]  245  662  462  160  744  920  942  543  296  694  741  277  689  192
     [883]  304  973  174  952  715  736  476   38  695  762  227  800  274  448
     [897]   31  438  332  813  119  881  824   46  713  179  351  970  331  862
     [911]  237  733  915  454  466  454  718  906  704  176  284  315  425  793
     [925]  551  621   36  841  885  428  650  498  456  395  942  156  515  730
     [939]  753  306  110  618  270  914  951  807  920  286  830  821  643  962
     [953]   70  294  565  717  111   58  155  147   62  292  203  233  785   46
     [967]  946  537  170  714  921  375  715  567  103  845    6  314  960  490
     [981]  145  912  651  960  170  791  792  270   65  308   50  795  748  424
     [995]  915  928  352  346  878   19
    
    $resamples[[3]]
       [1]  443  680  537  748  901  809  489  795    5  216  631  717  777  255
      [15]  915  558  192  538  532  435  575   72  613  723  874  876  726  365
      [29]  848   13  665  704   50  271  625  198  230  387  518  870   76  595
      [43]  391   21  834   50  754    3    9  690  179  563  820  682  607  642
      [57]  674  591  406  208  643 1000  121  175  773  722  357  316  318  404
      [71]  912  735  767  895  437  922  342  737  483  785  460  376  374  743
      [85]  459  203  185  299   80  449  796    3  687  236  949  741  353  349
      [99]  563  469  257  506   35  508  724  678  453  873  475  403  379  461
     [113]  946  421  465   40  232  441  530  427  636  674  445  312  946  862
     [127]  117  362  696  694  966  904  666  888  746  464  855  871  119  424
     [141]  409  236    3  329  969  538  195  218  101  905  757  847  883  128
     [155]  748  772  922  134  636  708  519   42   84  181  889  903   25  201
     [169] 1000  930  638  775  993  485  248  157  308  791   15  284  641  341
     [183]  150  960  581  235  409  613  206  265  864  771  241  588  244  148
     [197]  321  731  185  599  559  556  577  885  296  470  321  424  502  216
     [211]  849  125  946  891  808  681  195  327  762  541  150  291  805  126
     [225]  256  809  240  651  398  649  654  239  515  577  714   28  356  947
     [239]  723  413  772  562   41  454  338  453    3  268  384  412  161  609
     [253]  687  384  371  245  718  423  876   78  911  846  253  664  704  845
     [267]  477  953   67  143  979  296  317   73   23  177  568  262  595  438
     [281]  739  216   38  761  740  785  486   65  739   75  888  212  833  224
     [295]   89  819   59  763    5  310  577  669   23  742  453  325  534  874
     [309]  931  839  776   14  997  869  639  758  192  698  824   50  955  272
     [323]   49  119  991  407  278  956  702  220  580  755  766  108  599  103
     [337]  585  926  521  500  200  829  294  294  964  365  184  883  564  183
     [351]  166  264  431  324  130  863  637  190   70  354  149   68  930  144
     [365]  488  898  948  876  576  146  665  101  993   59  514  104  102  204
     [379]  773  318  308  144   54  977  742  154   22  175  966  284  704  898
     [393]  448  520  963  648  980  454  933  532  204  820  808  566   17  368
     [407]  881  112  108  841  117  870  951  892  545  961  220  311  315  100
     [421]  182  573  261  668  635  172  409  434  469  281  694  613  706  696
     [435]  461  531  260  408  768  110  868  467  284  182   58   68  433  184
     [449]  638  732  115  344  975  716  977  711  792  331  393  687  970  390
     [463]  285  303  404  395  700  634   68  928  679  735    8  164  967  853
     [477]  779   33  118   55  612  119  428  232  359  407  984  869  994  935
     [491]  240  294  158  252  739  695   80  521  542  140  545  556  606  302
     [505]  217  183  935  592  685  830  998  479    1  415  322   82  497  707
     [519]  978  268  394  754  848  485  125  914  679  712  396  356  705  450
     [533]  653  487  780  887   89  772  797  465  675  226  350  342  231  862
     [547]  403  780  297  682  953  537  173  189  200  934  449  428  401    5
     [561]  732  821  617  396  746  831  442  601  442  929  890  520   56  961
     [575]  678  510  799   39   84  549  405  235   21  980  822  343  992  963
     [589]  452  554  746  223  752  442  749  764  406  880  819  155  540   10
     [603]  500  857  442   33  769  892  931  799  717  177  895  896  256  576
     [617]  538  295  252  583  282  311  680  767   20  853  684  212  387  960
     [631]  663  772   78  237  668  265 1000  208  101  111  841  317  681  208
     [645]  859  295  532  784  944  760  793  824  701  539  748  593  302  914
     [659]  950  724  246  896  818  247  292  166  405  201  401   37  881   86
     [673]  220  746  923  622   38   29  539  836  227  882  502  502  325   68
     [687]  847  760   24  305  656  543  159  342  940  364  355    4   91  689
     [701]  202  567  365  103  454  573  560  179  603  435   36  514  351  157
     [715]  648  394  993  873  163  315  155  601  396  642  298  647  138  409
     [729]  627  452  247  211  881  700  672   60  424  150  851  492  293  483
     [743]  732  655  621  506  361  305  475  987  982  671  738  391  638  980
     [757]  484  283  401  184  945   61    3  308  577  354  852   61  499  972
     [771]  324   61  400  237  992  428  309  299  581  285  373  776  315  793
     [785]  724  349  353  457  347  164  920  358  111  340  109  357  824  440
     [799]  391  373  856  741  586  983  145  535  493   44  788  518  788   95
     [813]  769  140  226  332  868  616  426  265  275  178  328  799  174  559
     [827]  629  484  402  406  395  815  986  306  227  400  571  299  737  111
     [841]   87   64  794   82  187  871  663  291  502  162  560  958  279   25
     [855]  262  147  148   10  890  860  602  337  462  839  790  903  835  458
     [869]  912  577  322  330   87   61  778  763  229  822  464  331   88  137
     [883]  216  241  494  740  472  789  531  812  676  726  740  583   92  628
     [897]  981  261   88  368  179  114  688  532  942  972  770  838   28  831
     [911]  523  949  831  341  903  407   66  559  355  415  836  800  732  848
     [925]  149  407  319  232  891  735  616  995  640  382  914  832  882   67
     [939]  889  453  138  136  262  358  716  707   57  529  761  353   30   33
     [953]  332   98  498  829  941  561  487  901  140  225  180  202   19  183
     [967]  366  718  130  803  543   21  344  637  507  764  102  438  330  202
     [981]   24  783   56  440  667  948  408  314  806  168  763  469  640  130
     [995]  181  763  904  840  827  116
    
    $resamples[[4]]
       [1] 632 133 822 760 356 492 666 887 639 773 745 586 451 527 569 100 616 291
      [19] 360 667 298 927 113 380 993 703 907 736 834 416  98 163 211 445 955  35
      [37] 161 183 337 580 839 334 763 571 199 856 439 220 407 690 208  41 277 354
      [55]  30 791 509 314  95 746 299 947 573 545 285 760 214 918  49 463 817 548
      [73] 140 565 613 450 955 109 978 980 558 541 640 115 320 454 407 968 335  80
      [91]  17 199 855 606 432 647 840 522 365 398 526 267 820 365 453 258 268 572
     [109] 712 281 799   7 538 654 754 174 422  45 499 220 919 374 835 658 906 309
     [127] 367 979  36 133 702 798  49 306 948 159 435 715 282 506  61 815  57 793
     [145] 581  64 649 702 511 764 965 766 631 579  46 700 336 866 375 153 792 584
     [163] 463 513 597 144 532 211 131 312 485 569 584 172 647 801 939 966 785  46
     [181] 455 340 896 271 795 360 723 722 712  66 339 797 923  66 259 363 929 676
     [199] 270 600 990 756 604  95 133 650 315 657 935 803 643 321 325 583 284  64
     [217]  62   4 397 819   4 997 707 344 761 117 756 696 481 129 145 855 921 119
     [235] 153 305 162 184 479 910 779 164 951 687 499  19 243 144 567 208 936 396
     [253] 582 951 809 958 921 194 364  67  23 327 589 555 725 682 437 443 653 854
     [271] 989 280 616 966 472 343 991   6  34 794 702 469 283  81 548 579 831 588
     [289] 368 210 666 327 372 179 220 981 624 666 763 768 660 256 388 685 572 430
     [307] 238 194 446 227 757 138 510 879 463 122 685 809 199 512 807 521 855 296
     [325] 624  29 136 877 390 258 794 501 995 543 374 290 970 595 502 315  70 722
     [343] 496  19 561 515 168 912 759 299 743 226 300 807 308 312 110 128  42 650
     [361] 352 692  78 136 154 787  51 137 492 585 859 497 966 194  73 985 835 117
     [379] 782 920 470 284 298 290 922 948 943 219 519 337 838 982 456 875 227 368
     [397] 448 185 865 402 682 502 595 128 543 285 347  62 305   8 184 617 807 160
     [415] 943 968 787 445 540 695 935 361 146 598 776 658 366 388 788 579 860 508
     [433] 105 820 217 116 436  17 970 958 320 462 498 256 918 877 403 344 908 493
     [451] 644 913 460 412 215 335 879 343 212   1 837 844 569 896 649 548 170 476
     [469]  80 141 129 874 525 902 843 751 784 856 338 117 727 355 184 129 108  77
     [487] 445 961 794 445 508 881 217 529 516 948  33 789 764 141 380 494 363 252
     [505] 761 834 653 738 284 747 905 987 744 930  31  73 155 567 177 344  25 412
     [523] 560   4 832 756 894 777 400 498 305 788 835 468 524 487 477 761 301  99
     [541] 773 468 359 788 936 942 890 686 278  36 839 324 274 334 464 830 394 212
     [559] 129 204 730 203 521 279 956 301 318  65 902 320 520 241 154 747 796 470
     [577] 566 541 367 510 683  75 296 866 416 447 666 132 967 957 701 642 179 780
     [595] 330 448 813 799 671 981 757 115 156 479 682 875 696 947 301 409 226 203
     [613] 133 244 815 313   2 678 752 510 560 476 479 501 541 964 621 998 656 151
     [631] 504 583 560 593 653 750  17 677 836 753 632 536 575 318 917 388  87 712
     [649]  77 531 574 289 225 604 544 696 506 403 580 917 679 170 632 646 410 121
     [667] 417 542 944 790  85 663 186 605 181 193 952 703 955 994 101 445 143 925
     [685] 677 981 768 193 327 940 205 524 302  98 767 258 812 662  61 940 389  30
     [703] 678 949 860 452 848 299  28 127 423 730 864 403 479 132 980 743 610 850
     [721] 982 381  43 371 998 288 687 836 194 468 558 163 453 767 650 401 393 762
     [739] 134 439 122 898 109 544 928 244 972 527 217 371 946  35 918 790 727 968
     [757] 447 189 609 530 118 611 356 198 346 766 775 109 991 403 268 823 533 375
     [775] 770 407 705 418 257 629 340 805 159 801 888 935 940 873 218 998 149 446
     [793] 183 770 148  27  62 535 863 643 885 954 654  15 266 859 767 113  44 967
     [811] 476 870  71 711 826 994 504 135  54 398 342  19 291 891 858  66 539 521
     [829] 537 992 710 264 445 732 673 287 299 183 554 503 985 233 814 330 537 364
     [847] 105 460 170 186  63 910 327 175 756 724 369 862 246 711 868 619 750 183
     [865]  40 895 775 242 488 558 687 282 854 355 245 799 989 679 981 724 431 555
     [883] 118 743   1 987 761 534 361 491 958  55 477 717 882 173 946 182 496 848
     [901] 989  59 597 607 517 260 952  91 229 861 193 111 163 876 627 853 869  52
     [919] 890 334 160 410 529 843 688 314 820  61 329 475 603 108 884 279 526 862
     [937] 863 676 989 184 274 433 251  18 112 653 535 776 577 335 570 931   4  33
     [955] 683 169 207 723 784 575 286 774 155 412 411 388 976 943 134 504 891 242
     [973] 989  41 247 766 229 491  71 417 898 499 954  62 916 178 708 779 335 889
     [991] 728 327 756  64  30 516 419 241 849 109
    
    $resamples[[5]]
       [1]  482  232  593  943  105  708  636  488  349  833  528  353  215  322
      [15]  479  422  331  400  998  578  711  482   79   15  650  494   44  330
      [29]  690  658   10  936  108  829  228  267  850  634  923  891  644   42
      [43]  642  803  828  379  104  198  194  742  414  362  801  283  196  122
      [57]  580  714  166  761  828   20  486  424  755  424  757  836   83  778
      [71]  853   26  116  118  328  218  122  854  904  370  929  861  230  799
      [85]    6   51  249  807  407  947   43  875  431  872  996  126  393  969
      [99]  607  111  813  775  314  706  887  110  634   91  726  598  360  149
     [113]  451  755   73  261  590  918   82  741   77  353  727  510  277  698
     [127]  717  593  835  306  337  134  755  299  621  356  971  428  738  334
     [141]  281  138  492   89  406  542  969  789  570  108  198  393  757  823
     [155]  945  205  641  851  247  364   16  704  186  188  684  477  139  555
     [169]  786  629  948  639  384  826  853  363  134  716  822  548  190   62
     [183]   19    6  697  753  985  468  176  858  619  259  324  240  738   18
     [197]  982  653  700  183  910  972  958  753  776   65  235  401  436  951
     [211]  799  668  425  369   42   63  285  154  154  696  507  204  473  895
     [225]  414  964  366  749  183  438  426  637  882  980  159  460  973  327
     [239]  117  807  442  672  387  808  487  786  777  603  400  851  103  660
     [253]  630  309  544  463  668  930  655  208  896  763  377  172  873  209
     [267]  941  641  865   74  722  216  363  488  988  300  450  431  696  149
     [281]  785   99  759  122  115  419  565  326  977   90  129    6  658  753
     [295]  623  387  933  803   52  934   45  338  408  367  640  607  222  737
     [309]  272  474  954  834  833  429  607   43   14  335  215  747  435  318
     [323]   98   87  330  423  785  756    2  895  193  652  805  504  260  759
     [337]   72  843  762  286  513  993  192   35  632  269  501  494  879  322
     [351]  844   42  933  672  598  964  786  201  199  129  933  120  740  578
     [365]  211  809  603  453  367  716  317  169  776  464  321   73  825  178
     [379]  500  939  675  497  387  226  193  438  173  710  271  339  860  152
     [393]  329  370  940  263  395  615  888  554   80  426  961  900  867  594
     [407]  197  576  610  443  437   50  179  723  310  811  870  981  779  299
     [421]  691  199  622  521  816  600  756  174  310   85  485  617  929   71
     [435]  219  745  648  975  306  305  812  421   70  448  815  814   32  621
     [449]  940  273  303  946  665  199  201  551  109  468   83  975   52  722
     [463]  585  748  764  504  754  255  603  161  776  370  165  670  657  743
     [477]  971  266  530  364  340  445  750  901  358  832   26  495  464  485
     [491]   44    8   29  173  512  723  881  362  937  604   58  481  358  874
     [505]   70  848  894  149  714  755  522  954  420  920  416  176    7  442
     [519]  816  938  618  312   54  262  856  466  952  179  573  667  759  530
     [533]  461  671  405  471  295  463  803  248  373  500  289  304  151  672
     [547]  402  601  881  109  813  267  407  512  391  232  477  578   71  283
     [561]  672  800   62  254  338  382  589  697  753   36  366  663  336  164
     [575]  717  280  856  436  151  731  312  207  673  507  397  827  265  162
     [589]  741  743  187  772  651  771  187  632  816  622  448  869  814   83
     [603]  495  322  750   55  946  313  313  178  870   15  571  517  417  488
     [617]   46  277  541  578  929  369  343   62  595  425  813  256  741    9
     [631]  306  136  903  946  289  739  323  171  754  643  909  557  303  293
     [645]  918  832   69  837  376  611  423  908  344  141  407   11  181  235
     [659]  511   31  762  621  931  342  562   65  916  723    6  320  807   87
     [673]  308  256  738   81  781  326  958  436  443  457  643  283  368   66
     [687]  344  882  433  915  811  532  396  123  424   24  168  910   53  458
     [701]   11  480  429  341  909  808  912  190  116  623   52  137  634  597
     [715]  577  572  160  131  714  512  686  528   28  602   31   65  419  636
     [729]    8  523  637  867  932  508   77   10  234  688  551   94  395  386
     [743]  960  885  340  634  247  821  269  580  386  401  795  245   27  616
     [757]  917  407  103  342  202  871  407 1000   38  520   44  932  552  474
     [771]  826  745  379  131   70  601  278  220  895  232  612  891  799  470
     [785]  460  165  253  178  145   99  857  824   81  255  798  967  450  368
     [799]  552  779  995  499  642  321  619  178  660  472   46  803  418  441
     [813]  420  813   17   60  603  294   20  329  455  383  142  306  735  896
     [827]  301  734  434  410  142  216  197  817  853  727  573   15  763  104
     [841]  797  241  183  451  955  651   64  250  427  656  286  754  325  746
     [855]  430   95  958  829  565  270  941  132  116  428  512  413  204   92
     [869]  366  850  335   94  995  660  196  925  906  509  188  727  422  694
     [883]  467  717  576  415  361  616  726  474  667  737  370  952  603  462
     [897]  146  676  157  790  476  551  883    2  883   83  792  840  942    1
     [911]  826  747  648  912  909  512  171  405  310   23  887  123  323  922
     [925]   36  580  261  537  897  549  700  952   41   15  662  589  240  324
     [939]  743  900  802  459  860  935  429  920  269  769  849  305  620  289
     [953]  167  459  855  790  781   71  431  358  915  181  746  705  543  476
     [967]  850  895  950  419  418  347  867  687  378  797  157  222   17  954
     [981]  912  962  476  196  709  527  525  460  696  872  635  765  368  649
     [995]  126  183  162  768  532   18
    
    $resamples[[6]]
       [1]  302   95  292  833  871  736   80   98  501  467  329  588  604  625
      [15]  819  126  340  335   56  430  492  422  446    7  569  724  242  877
      [29]  904   82  195  705  854  243  307  683   98  630  889  503  858  881
      [43]  190   93  952  972  677  541  977  995  816  206  255  996  305  168
      [57]  834  163  352  188  324   96  249  745  537   54  482  843  881  847
      [71]  697  578  822  487  760  162  980  539  191  111  342  473  219  952
      [85]  347  683  734   31  256  760  683  812  705  793  103  627  716  190
      [99]  854  559    2  456  707  185  948  288  728  197  885  714  594  481
     [113]  479  282  305   87  508  794  622   98  433  786  500  489  655  324
     [127]  247  631  172  251  146    4    3  504  234  449  356  218  912  877
     [141]  989  710  425   89  106  602  897  615  116  366  151  540  387  375
     [155]  891  165  261   63  929  566  129  322   82   17  124   51  948  718
     [169]  911  991  449  138   10  571  612  564  587  616  692  627  820  758
     [183]  256  180  681  994  575  202  419  444  619  192  455  277  654  647
     [197]  415  569  677  320   78  539  257  289  971  401   13  172  301  157
     [211]   88  474  671  975  206  606  527  152   77  837  691   80  621  617
     [225]  501   96  428  733  575  308  994  120  141   57  774  639  480  792
     [239]  949  976  374  230   87  211  442  990  926  188  334  703  175  912
     [253]  706  542  599  136  381  342  354  388   77  949  753   82  595  118
     [267]  500  438  129  600  392  183  547  797  405  382  257  632  132  786
     [281]  664  799  846  690  550  764  681  511  910  434  781  863  277  315
     [295]  902  551  368  265  731  160  735  692  143  804  693  677  144   49
     [309]  586  490  865  450  513  922   25   62  967  279   18  752  733   51
     [323]  402  770  547  386  532  880  285  911  257  115  510  528  286  931
     [337]   59  462  237  890  159  218  925  738  497  852  981   91  348  419
     [351]  608  156  962  392  536  320  303  472  352  808  447   12  803  617
     [365]  119  669  743  766  284  116  893  481  122  999  883   82  925  847
     [379]  808  452  517  707  726  371  300  592  874  347   66  409  815  669
     [393]  875  534  968  149  460  710  205   15  159  866  337  919  746  968
     [407]  723   65  763  488  590  561  735  131  286  406  261  891  130  609
     [421]  174  706  246  616  367  549  831  374  314  441  985  960  753  454
     [435]  623   53  530  851  701  910  563  697  815  562   49  180  671  137
     [449]  739  899  266  130    2  289  287  609  596  670  338  489  775  857
     [463]  448  590  687  640  659  378  427  584   83  674  224   20  404  304
     [477]  531  819  654  675  525  702  956  275  782  442   53   21  609  747
     [491]  182  495  244  398  357  114  850  456  991  812  798  192  257  442
     [505]  416  296  481  955  703  670  126  485  587  134  878  162  814  677
     [519]  400  583    6  823  450  702  338  578  740  978  878  157  782  778
     [533]  922  492  890  621  771  834  652  832  168  808  771   22  568  328
     [547]  803  915  849  659  768  661  891  234  623  882  762  643  743  719
     [561]  686  878  985  106  244  372  493  546   26  959  474  418  227  846
     [575]  532  532  168  531  731  319  771  780  112  904  376  775  737   75
     [589]  235  304  404  252  651  284  203   90  600  477  144  388   62  209
     [603]  948  318  769  313  948  360  725  633  400  141  970  472  508  764
     [617]  701  797  627  662  836  488  435  235  195  404  327  704  424  732
     [631]  478  159  818  922  792  659  306  576  750  141  165  963  997  926
     [645]  508  326  641  428  464  995  768 1000  731  146  665  322  605  202
     [659]  240   55   27  702  579  396  748   51  316  483  872   56  103   75
     [673]  407  697  960  109  875  257  403  186  233  607  143  759  947   25
     [687]   24  723  222  489  929  748  399  446  856  836  461  739  321  730
     [701]  101   94  348  131  442  212  157  531   51  636  680  925  750  544
     [715]   38  733  495  756  386  541  734  497  740  728  308  388  993  235
     [729]  915  687  811  424  663  906  457  203  373  290  237  966 1000  352
     [743]  971   22  923  416  130  573  277  852  553  414  210  200  129  861
     [757]  354  639  576  163  965  738  418  790  729  381  983  647  916   28
     [771]  889  596  192  609  199  353  616  803  550  466  316  603  450  574
     [785]  536  530  840  297  393  812  984  342  564   30   28  939  854  432
     [799]  803  853  956  331   33  332  560  430  827  331  680  640  185  771
     [813]  676  646  515  272  456  645  523   73  293  278  479  866   97  759
     [827]  619  459   79  531  914  562  768  651  301  274  277  356  839   70
     [841]  567  233  348  737  975  224  769  661  729  996  492  466  282  110
     [855]  294  767  883  483   49  324  796  964  439  295  144  294  516  327
     [869]  890   68  695  454  533  289   76  469  132  275  613  867  211  416
     [883]  919  193  201  942  798  566  361  862  798   31  649  328  365  979
     [897]  252  278  173  562  694  922  844  992  419  763  584  201  439  530
     [911]  918  560    7  379  767  757  503  731  518  866  163  285  426  797
     [925]  397  513  733   27  556  634  675  191  184  164  930  698  298  848
     [939]  182  615  897  949  316  392  120  166  291  339  693  593  177  408
     [953]   41  536  640  378  547  138  391  436  748  763  646  228  197  230
     [967]  153  471  638  499  588  337  347  572  267  257  916  522  733  794
     [981]  464  947  444  459  553  781  732  269  645  181  226  362  346  875
     [995]   81  869  733  161  477  806
    
    $resamples[[7]]
       [1] 766 302 416 237 663  88 493  49  59 876 400 744 577 551 487 187 234  35
      [19] 666 206 225 849 777 821 139 113 615 113 845 292 753 235 706 912 666 329
      [37] 274 212 475 984 608 521 210 794 973 303 162  21 444 438 720 607 625  33
      [55] 885 124 845 721 601 158 252 748 767 177 281 558 613 859 900  19 249 225
      [73]  23  50 364  51 504 799 506 778 381 323 362 444  37 875 237 325 165 113
      [91] 700 422  85 484 854 266 880 548  76 106 408 314 410 434 492 971 642 259
     [109] 236 978 630 473  73 239 428 905   5 211 682  72 108 833 808  92 511  63
     [127]  63 159  96 994  34 410 663 635 412 264 862 393  81 265 277 631 745  13
     [145] 181 776 391 622 677 406 711 642 108 603  41 327 323 434 560 702  70 171
     [163] 402  15 933   3 517 485 928 190 728 946 594 156 485 421   6 612 400  19
     [181] 235 578 439 756 785 729  70 132 790 845 956 216 142  21  37 861  84 312
     [199] 795  73 662 254  36 930 884 895  54 984 463 954 453 456 955 375 234 927
     [217] 613 266 243 187 956 590 404 751 290 780 695 588 549  24 891 561 649 283
     [235] 707 168 628 192 377 618 611 777 510 276 100 525 456 357 567 421 907 692
     [253] 632  86 537  95 252 683 148 850 568 290 704 319  42 687  51 165 504  24
     [271] 108 441 401 957 457 422 269 814 959 619 752 802 715 826 393 726 441  26
     [289]  46 597 631 448 446 389 293 190 567 712 977 561 378 642 603 454 239 202
     [307] 639  28 844 789  59 645 530 438 792 764 789  39 891 271 881 178 967  85
     [325] 590 871 334 848  60 188 581 163 835 535  97 482 355 815 583  22 333 835
     [343] 301 454 472 703 717 512 819 727 912 645 147  73   7 222 319 909 241 449
     [361] 190 569 779 988 387 626 301 402 814 641 897 639 296 539 859 379 172 170
     [379] 753 837 701 564 629 903 914 382 957 244 434 651 269 214 485 717 613 191
     [397] 656 824 847 515 683  48 171  56 312  72 187  90 733   9 983 181 736  45
     [415] 688 237 586 562 536 480 942 410 337 542 946 326 603 370 346 956 621 650
     [433] 807 296  91 407 996 839  33 427  24  30 144 626 221 394  75 736 649 853
     [451] 261  75 852 107 101 236 628  66 918 923 476  41 225 737 300 515  10 952
     [469] 646 279 213 146 841  42 668 922 108 465 910 725 272 157 178 225 195 434
     [487] 862 748 719 194 198 119 934 639 684 861 939 633 907 214 617 820 320 238
     [505] 894 674 695 782 553 748 450 652  41 395 324 471 901 765 698 595 178 573
     [523] 162 243 580 642 456 563 511 620 538 793 323  31 539 928 942 326 488  41
     [541] 298 112 978 677 282 229 747 893 244   3 352 664 820 820 795  76 848 165
     [559] 131 279 215 201 356 980 152 888 917 791 749 579 606 330 164 843 201 121
     [577] 628 760  50 784 664 215 718 804 521 687 297 145 708 720 496 890 302 314
     [595] 467 606 516 573 550 886 922 475 476 664 234 882 775 313 885  25 271 801
     [613] 200 896  27 537 184 582 305 546 491 490  61 973 721 170 761 533 622 905
     [631] 865 165 662 388 637 205 831 429 491 145 911  75 760  68 999 694 185 285
     [649] 346 924 348 947 128 109 623 146 249  65 450 875 320 759 262 475 151 637
     [667] 344 833 374 626 998 159 416 171 158   1 937 133 983   9 909 180 871 147
     [685] 668 925 802 706 926 337 101 150 593 361 627 814 495 984 820 492  96 655
     [703] 696 778 822 908 607 781 654 678 873 148 606 877 510 159 633  83 547 730
     [721] 146 845 399 770  72 223 618 890 287 144 353 335  59 747  81 747 465 377
     [739] 695 456  51 161 810 782 452 869 581 636 947 544 145 388 187 655  44 789
     [757] 769 508 273 507  73 651 337 653  91 633   1 792 365 750 770 220 857 393
     [775] 134 378 582 169 823 167 682 393 345 359 836 923 120 124 828 381 541 411
     [793]  60 340 238 908 882 629 445 679 919 100 790 470  16 625 943 291 576 395
     [811] 880 126 688 724 152 863 527 812 617 726 366 770 494 166 355 804 454 785
     [829] 927 308 256  64 448 212 466 411 521 594 769 305 767 735 541 648 132 974
     [847] 870 656 899 557 419 435  71 820 286  16 956 331 223 697 101 984 485 543
     [865] 592 939 370 518 426 724 512 267  74 282 990 680 384 304 133  79 183 774
     [883] 957 912  36 130 517 671 430 777 951 492 269 147 632 377 941  77 764 986
     [901] 557 380 927 788 503 543 144 739 987 784 204  55  99 978 327 547 837  64
     [919] 419  74 689 759 571 368 463 413 357 940 211 972 389 536 597 712 200 310
     [937] 745 258 798 404 452   4 595 770 976 245 947 393 733 889  46 846 988 948
     [955] 512 877  69 475 617 449 161 627 662 832 938 443 200 752 961 538 829  56
     [973]  53 200 614 959 199 678 127 444 753  87 112 406 363 869 672 583 757 444
     [991]  28  74 932 580  30 592 744 497 950 705
    
    $resamples[[8]]
       [1]  294  712  322  128  404  750  736  408   48  638  399  693  716  193
      [15]  717  650  406  698  673  881  901  558  302  892   77  418  379  792
      [29]  535  959  149  700  383  324  675  154   49  122  858  947  979  506
      [43]  243  301  185  937  480  795  225  322  240  390  415  956  872  381
      [57]  424  396  743  287  509  624  285  627  473  957  919  913  993  957
      [71]  243  232  551  552   62  215  441  439  603  298  372   28  271  818
      [85]  641  652  407  901  721  629   73  383   76  574  434  736  738  383
      [99]  318   99  463  824  541   37   50  510  942  158  146  440  525  243
     [113]  161   56  250  965  962  902  289  219  621   74  637  456  107  635
     [127]   17  546  808  664  200  905  950  116  208   43  185  603  908  785
     [141]  113  439  971  483  860  803  943  942  163  673  594   70  451  594
     [155]  381  904   30  335  468  291  243  433  266   57  850  171  538  365
     [169]  427  794  817  884  473   72  578  729  416  543   58  133   80  328
     [183]  757   50  312  973  575  860  194  350  139  623  817  666  528  757
     [197]  487  563  154  408  523  395  127   79  750  842  808  879  254  956
     [211]  389  711  936   37   44  944  130  155  580  661  194   10  827  390
     [225]  438  121  248  813  704  685  832  770  205  370  312  240  816  422
     [239]  373  973  166  459  942  680  631   15  919  281  841  506   50  219
     [253]  468  263  180  899  623  467  811  151  624  835  268  495  249  296
     [267]  675  769  206  110  716  663  508  360    5  372  362  672  414  722
     [281]  133   35  173  439  627  121  467  720  259  978  886  171  474  583
     [295]  307  418  510  230  317  391  676  702  933  511  774  499  926  105
     [309]  600  654  740  465   35   77  353   38  997  907  124  179  222  101
     [323]  956  917  935  749  185  609  223  944  298  714    3  902  553  779
     [337]  646  756   64  546  641  962  891  669  891  441  141   32  120  747
     [351]  842  309  422  912   70  182   87  527  780  346  917  174  521  847
     [365]  844  777  718  130  359  944  778  733  451  173  566  607  976  649
     [379]  539  741  898  737  514   57  100  161 1000  484  252  460  436  634
     [393]  870  542  372  275  444  602   97  414  919   97  833  373  329   88
     [407]  942  433   41  344  411  717  969  974  451  427  125  333  646  202
     [421]  802  719  506  488  237   33  244  664  665  790  781  175  478  787
     [435]   15  320  818  190  876  753  423  444  680  100  138  346  229  501
     [449]  250  258  352  297  920  764  328  412  676  331  332  407  882    4
     [463]  680  422  637  807   13  431  641  496  692    8    9  228  764  460
     [477]   83  261  547  152  205  924  689   91  307  779  104  882  317  465
     [491]  800  278  384  460  430  350  404   76  543  727  817  244  915  710
     [505]  860  882  804  913  403  227  764  334  388  983  796  581  977    9
     [519]  585  630  127   18  974  413  639  162  260  172  899  982  657  490
     [533]  207  682  520  583  382  787  211  355  565  676   25  917  145  440
     [547]  365  682  686  748  196  983  387  395  613  343  258  651  606  739
     [561]   75  562  933  943  739  627  737  395  108  540  933   52  699  976
     [575]  888 1000  703  639  203  102  833  543  805   19  257  437  345  141
     [589]  933  251  512  241  992  873  641  529  446  138  731  342  747  674
     [603]  703  721  961  900  749  307  293  773  111   55  748  831  990  882
     [617]  579  437  922  169  567  592  145  132  797  541    4  495  415  864
     [631]  340  932  726  190  324  570  559  508  862  206  166  915   62  162
     [645]  504  234  230  712  774  447   37  313  541  618  338  827  891  912
     [659]  740  451  957  193  429  737  154  155  341  783  754  926  969   50
     [673]  694  216  726  358  931  452  318  127  989  176  863  512  978   61
     [687]  939  313  996  389  383  177   89  939  198   69  364  702   18  898
     [701]  941  919  765  107  396  356  292  364  848  891  497  445  356  646
     [715]  903  898  439  345  896  670  815  749  208   59  824  492   51  167
     [729]  348  848  797  210  512  415  927  599  185  139  124  338  253 1000
     [743]  565  449  487  340  752  120  855  808   74  161   65  419  251  265
     [757]  335  441  148  379  378  579  822  735  663   88  349  255   92  391
     [771]   18  606  852  934  153  479  360  890  542  522  580  172  594  758
     [785]  479  907  888   35   16   27  585  657  197   21  184  481   34  503
     [799]  253  863  820  952   68  871  905  652  433  608  386  901  783   71
     [813]  284  189  857  313  296  907  908  873  854  912  165  141  253  274
     [827]  778  190  780  309  843  123  541   58  943  493  237  979  980  776
     [841]  737   36  927   79  948  827  679  792  688  500  562  228  959  472
     [855]  487  948  199  979  923  548  867  335  465  104   43  656  917  964
     [869]  982  873  121  847  882  780  682   94  635  883  578  882  895  889
     [883]   22  423  591   37  180  781  266  111  816  221  286  362  870  556
     [897]  534  251  485  225  312   11   24  771  909  193  492   96  447  968
     [911]  743  979   16  875  131   19  117  902  994  983  738   65  381  882
     [925]  213  696  464  335  605  583  674  960  279  421  726  919  431  899
     [939]  924  549  719  932  934  119  274  403  678  537  202  203  297  669
     [953]  774   13  840  169  940  974  226  536  901  168  204  444  600  850
     [967]  458  947  419  237  554  584  140  306  246  701  148  967  552  809
     [981]   58  126   48  267  835  898  670  369  672  702  754  183  278    8
     [995]  189  359   96   36  370  717
    
    $resamples[[9]]
       [1] 429 834 156 972 426 639 909 712 683 622 687 468 249 401  44 240 375  42
      [19] 801 438 570 734 522 838  86 678 496 949 427 329 114 373 758 715 532 359
      [37] 100 196 708 775 491  56 130 854 878 790  90  85 701 738 643 861 876 423
      [55] 170 200 942 668 634 359 298 739 611 863 749 310 457 669   2 673 901 624
      [73] 374 393 945 145 779 173 571  90 419 755 139 179 220 913 727 198 529 534
      [91] 358 889 478 223 900 450 902 509 869 353  30 187 298 324 532 153 647 736
     [109] 946 392 437 780 370 931 389 427 483 235 468  70 517 130 845 712  61 418
     [127] 966 973 116 457 770 653 235 635 670 166 664 446 246 333 205 834 507 563
     [145] 308 622 319 300 236 689 545 389 143  97 349 625 116 510   3 195 768  23
     [163] 173 296 550 718 238 954 885 612 881 820 993 826 272  36 710 210 317 806
     [181] 400 389  59 280  69 323 442 906 154 576 450 990 261 901 968 269 668  63
     [199] 262 732 642 619 616 837 205 468 611 893  13 691 323 252 342 928 103 524
     [217] 773 582 421 624 452 410 822 464 557 399 254 958 724 585 730 174 870 691
     [235] 644 982 224 362 684 325  11 593 426 793  93 843 221 133 850 759 484 837
     [253] 723 331 329 631  30 160 152 640 500 131 859 976 467 823 138 342 211 283
     [271] 663 278 432 465 489 224 963 692 796 654 206 565 401 335 234 611 143 671
     [289] 798 629   9 185 215 695 962 812 960 520 792 346 286 317 255  99 338 676
     [307]   8 981 778 997 406 968 554 122 817 602 717 153 742 993 881 361  49 695
     [325] 173 514 468 219 747 702 982 442 899 502 698 138 578 687 788 224 727 166
     [343] 603 340 375  45 244 806 557 627 812  93 967  46 794 410 896 807 652 197
     [361] 419  54 512 126  30 266  56 309 272 187 448 956 441 323 429 436 165 147
     [379] 529 554 829 181 653 495 613  12 387   5  57 297  43 817  90 587 631 417
     [397] 673 484 531  19 479  78 266 266 667 140 487 386 151 755 865 315  67 710
     [415] 488 692 986 220 584 484 928 652 797 100 159   8 945 549 731 779 835 432
     [433] 955  34 512  50 174 237 696 593 663 925 833 281  32 639 852 433 811 631
     [451] 442 716 714 628 542 459 614 282 144 909 412 912 354 786  23 279 302 237
     [469] 143   2 992 200  59 784  22 198 510 771 262 395 522 571 207 150 142  15
     [487]  84  88 929  38 548 211 381 444 409  12 117 562  70 880 606 115  54 248
     [505] 973 177 843 634 749 386 930 888 264 233 772 363 675 749 688 124 498 867
     [523] 136 665 169 667 656 839 449 130 472 811 281 703   9 725 508 512 305 367
     [541] 672 784  17 666  84 116 568 888 844  81 213 842 501 778 485 281 761 972
     [559] 472 194 242 864 699 745 788 761 754 207 553 157 609 552 835 486 499 145
     [577] 356 557 893  38 930  86 479 714 207 139 588 439 148 754 795 372 473 446
     [595]  47 201 115 216 503 422 730 147 794 883 392 555 755 523 239 232 347 233
     [613]  90 813 505 944 402 375 852 659 706 915 581 233 950 119 981 143 453 743
     [631] 279 921 874 601 743 380  86 664 579 808 561 369 917 702 975 953 468 521
     [649] 867 353  59 741 878 832  49 370 133 196 708  69 338 414 756 783 540 699
     [667] 553 797 583 910 820   1 329 478 265 593 937 702 223  25 930 748 298 987
     [685] 674 820 204 442 207 842 922 879  21 849 130 180 522 177  21  88 262 476
     [703] 256 781 127 396 770 353 543 725 620 999  50 942 512 666 144 451 387 931
     [721] 735 538 164 458 984 153 382 282 842 169 332 279 170 983 418 493 342 859
     [739] 576 672 263  94 398 654 811 796 968 662 737 474 109 800 394 179 703 537
     [757] 852 392 665 172  52 773 854 320 188 466 128 885 512 678  43 274 354 720
     [775] 291 512 190 130 790 918 921 883 144 532 472 302 624 734 962 454  70 380
     [793] 336 865 127  45 820 222 337 105 886 763 643 506 981 517 977 955 547 705
     [811] 671 362 258 249 334 844 491 686  65 455 589 518 184 785  45 960  73 785
     [829] 162 985 157 410 519 882  16 348 489 717 629 867 982 901 221 463 635 206
     [847] 841  34 698 485 338 504 603 725 978 696 285 935 606 589 926 411 389 257
     [865] 292 231 603 276 677 171 568 977  90 667 316 477 205 904 621 850 913 718
     [883] 845 191 147 371 648  23 561 903 338 331  78 389 336 309 915 164 442 179
     [901] 832 478 858 146 690 660  64 574 790 380 517 738  95 385 423 163 176 404
     [919] 605 552 573 283 105 386 818 973 361 840 311 536 909 269 564 482 496 622
     [937] 456 675 791 429 728 638 899 801 964 647 420  65 433  47  15 513 355 535
     [955] 402 923 909 455 102 275 348 329 691 755 839  88 638  73 704 200 620 485
     [973] 666 166 940 726 839 982 307 196 279 218 744 703 166 798 709 870 971 585
     [991] 363 887 799 211 109 268 148 995 240 285
    
    $resamples[[10]]
       [1] 275 296  32 173 786 489  77 867 864 910 479 280 177 208  38 560 992  59
      [19] 474 750 957 511 418 243 649  54 607 258 904 436 606 375 996 522 986 302
      [37] 320 654  41 934 677 446 307 497 170 966 572 404 612 547 718 609 457 844
      [55] 151  42 733 178 188 952 522 878 121 193 233  32 842 550 965  19 175 943
      [73] 243 613 397 813 877 957 506 994 673 720 392 374 205 255 821  26 587 614
      [91] 674 324 266 630 556  99 498 124  63 261 301 863 360 842 180 710 266 108
     [109] 802  27 351 555 902 796 548 252 504 424 619 748 775 757 354 101 670 124
     [127] 329  27 812 173 407 735  47  73 408 400 642 847 785  84 815 171 279 658
     [145] 473 913  46 827 317 228 588 869 270  15 751 192 537   9 736 785 261 702
     [163] 703 752 341 190 834 295 776  61  65 711 869 407 842 819 793 905 467 165
     [181]   9 568 821 465 171 132 899 942 769 672 822 231 239 245 134 312 771 494
     [199] 553 811 970 560 929 908  79 543 919 433 591 111 561 560 929 236 611 311
     [217] 846 662 377 314  42 609 785 808 930  75 489 794 566 496  49 253 604 558
     [235] 870 166 955 162 939  17 836 618 208 256 725 626 500 377 611 613 328   9
     [253] 408  95  27 101 688 801 171 742  38 145 651 248  87  89 945 721 539 495
     [271] 276 426 932 716 469 787 337 934 896 400 654 549 794 350 526 816 912 321
     [289] 749 515 119 781 184 707  53 722 675 996 774 531 686 993 638 745 598 391
     [307] 129   6 170  74 731 577 143 521 400 611 988 230  15 464  24 863 141  32
     [325] 874 930 511 629 745 964 922 253 829   5 841 647 698 826 511 491 297 167
     [343] 724 312 761 562 930 523 843 650 649 133 338 691 993 306 531 141 503 421
     [361] 942 327 772 844 608 904  89 391 829 179 274 344 300 100 787 998 647  94
     [379] 374 811 882 459 726 923   5 430 255 153 524 857 779 689 526 602 302 502
     [397] 681 517 876 669 349 608 589 660 946 480 296 657 466 822  44 924 300 738
     [415] 772 391 290 955 628 543 300 727 191 745 412 806 581 291 707 388 759 228
     [433] 988  81 306 189 456 473 971 841 921 343 925  71 183 549 776 209 665 653
     [451] 188 313 646 778 323 172 884 823 132 465 798 381 180 882 991 114 281  73
     [469] 964 678  64 677 411  44 505 379 607 449 302 670 580 894  32 326 434 476
     [487] 469 134 933 724 413 854 460 734 391 745 131 138 313 581 549 361 612 501
     [505] 768  58 561 414 573 800 723 439 166 247 474  95 265 253  42 263 337 826
     [523] 183 208 207 661 276  86 795 148 673  47 849 960 877 947 662 677  38 629
     [541] 825 489 828 469 616 264 667 225 710 711 836 356 142 264 105 369 798 235
     [559] 469 498 194 672   3 482 316 950 655 534 623 357 246 794 237 996 916 156
     [577] 425 783 973 384 936 503 219 959  41 682  12 248 132 806 884 965 553 168
     [595] 627  52 147 408 304 268   4 257 978 702 763 867 378 614  61  45 167 151
     [613] 606 887 503 623 338 572 560 375 604 211 948 668 723 307 856 450 197  10
     [631] 100 128 721 926 724 158 374 869 513 689 489 791 869  33 405 775 412 683
     [649] 103 114 393 420 293 922 373  93 698 398  94  53 446  28 631 593 959 833
     [667] 519 545  95 635 280 431 545  55 171 630 945 377 731 463 591 794 582 494
     [685] 154  31 693 673 281 882 698 531 886 766 408 340 378  35 180 890 736 817
     [703] 267 860 456  64 440 540 103 350 851 292 738 700 882 402 781 492 433 102
     [721] 119 592 578 216 146 373 440  27 961 179 594 129 406  82 293   9 739 566
     [739] 814 342 107 806 526 440 225 531 980 482 322 200 700 463 692 723 770 220
     [757] 877 109 257 829 700 154 272 728   3 899 578 552 803 945 426 830 554 314
     [775] 424 495 200 958 810 437 859 470 825  50 395 537  35   7 365 953 685 850
     [793] 529 856 755 133 323 499 870 982 622   1 102  20 897 241 987 885 605 780
     [811] 656 621 243 300 440 773 551 897 359 317  23 607 718 264 875 938 888 643
     [829] 468 711 553 777 958 521 911 206 203 874 677 521 412 717 865 890  60 455
     [847] 305 868 732 984 537 712 386 421 776 632 581 930 183  75 772 178 797 673
     [865] 908 525 336 675 992 279 854 141 337 716 294 891 715 929 852 648 282 106
     [883]  31 895  75 571 371 380 217 681 421 259 892 875 474  57  28 754 362 745
     [901] 355 286 832 347 396 406 355 640 888 980  98 177 282 659 172 467 722 416
     [919] 198 831 706 194  93 458 637 445 778 721 271 511 653  33 463 396 629 357
     [937] 789 675 553 188 796 314 733 886 378 332 995 238 939 620 443 115 182 242
     [955] 250 381 185 942 125 679 489  55 651 618 287 545 206 371 787 515 931 144
     [973] 321 405 256 431 980 641 951 143 791 383  27 428 411 577 470 147 984 966
     [991] 225 652 582 748  74 421 207 175  44  47
    
    
    $original
    Outlier-Robust 2SLS Model 
    Initial estimator:  robustified 
    Reference distribution:  normal 
    Two-stage Least-Squares Model: y ~ x1 + x2 + x3 + x4 + x5 | x1 + x2 + x3 + z4 + z5 + z6 
    Iterations:  3 
    Final selection:  Outliers found:  33     Outliers proportion:  0.033 
    
    attr(,"class")
    [1] "r2sls_boot"

---

    $boot
                x2  m gauge  r
    1   0.07118357 m1 0.039  0
    2   0.48556351 m1 0.037  1
    3   0.56131343 m1 0.024  2
    4   0.09711559 m1 0.033  3
    5  -0.58052895 m1 0.041  4
    6  -0.28895920 m1 0.039  5
    7   0.43209672 m1 0.035  6
    8  -0.91601029 m1 0.036  7
    9  -0.52138461 m1 0.033  8
    10 -0.10271269 m1 0.036  9
    11 -0.91113818 m1 0.040 10
    
    $resamples
    $resamples[[1]]
       [1]  934  261  274  371  679  365  310  822   40  924  915  825   13  915
      [15]  411  755  670  693  335  983  409  208   14  846  849  151  642  215
      [29]  287  600  345  147  564    3  708  189    1  385  677  203  710  223
      [43]  456  936  191  451  272  760   81  429  149  828  371  186  614  773
      [57]  382  721  640  377  255  130  544  188  504  897  916  271  787  101
      [71]  319  655  717  525  713  374  909  132   94  203  939  629  558  224
      [85]  429  932  269   38  109  913   79  377  438   24  893  468  242  830
      [99]  282  103  547  575  618  509  396   11  381  311  898  309  129  111
     [113]  897  706  278  106  432  238  608  355  199  951  510  685  274  382
     [127]  181  594   89  574  147  545  890  571  475  725  761   77  295  464
     [141]   88  992  194  538  157  434  792  542  219  213  965  562  408  782
     [155]  847  191  176  361  731  194  527  741  806  172  375  707  770   76
     [169]  611  482  983  136  293  351  583   81  467  862  303   72  795  671
     [183]  403  725  108  998  512  555  707  302   52  361   90  747  795  733
     [197]  938  329  441  951   50  421  441  226  814  820  559  922  371   86
     [211]  256   61  179  654  288  509  706  139  727  868  320  928  849  629
     [225]  608  528  542  864  313  957  655  846  474   26  841  782  544  800
     [239]  198  877  384  950  255  788  115  564   40  607  508   17  929  800
     [253]  286  107  784  382  837  948  438  119  113   21  603  911  387  139
     [267]  648  309  607  919  106  505  837  993  109  345   58  635  886  833
     [281]  407  855  454  515  322  124  752   74  474  930  749  116  282  702
     [295]  768  812  717  970  643  233  622  819  439  292  953  104  871  157
     [309]  971  205  402  123  196  323  848  261  884  269  107  490  475  773
     [323]  165  342  240  214   67   52  643  348  616  425  774  490  602  480
     [337]  214  690  663  688  672  104  834  670  268  296  956  490  661  176
     [351]  971  160  468  113  840  423  672  426  650   36  673  500  563  214
     [365]  484  953  508  741  797  672  486  585   75  619  351  925  739   47
     [379]  379  377  455  189  437  841  700  896  789   62  954  176  533  867
     [393]  668  980  511  364  124  473    3  616  847   37  719  219  429  335
     [407]  877  951  107  875  347  680  205   68  416  545  553  801   80  744
     [421]  506  814  128  990  859  679  320  615  237  473  103  562  137  279
     [435]   36   68  268  840  246   42  668  660  763  876  481  329  812  735
     [449]  228  648  966  884  789  631  764  363  522  623   31  640  393  689
     [463]  869  242  202  966  103  999  521  226  834  315  654  424  700  565
     [477]   83  571  863  508  584  398  445  180  644  990  540  145  890  996
     [491]  654  336   16  940  738  797  186  962  364  566  114  978  356  883
     [505]  136  394  919  346  399  135  282   66  233  121  307  601  231  820
     [519]  622  213  184  142  840  124  846  953  521  753  419  706  960   64
     [533]    1  212  617  992  320  924  951  187  589  168  927  278  369  100
     [547]  309  882   55  350  868  651  909  524  704  475  907  354  958  314
     [561]  672  691  499  727  450  572   19   48  828   41  395  720  330  136
     [575]  807  370  729  269  872  871  517  558  112  826  910  443  460  326
     [589]  319  131  506   14  197  287  772  964   83  563   56  980  280   44
     [603]  906  525  966  449  278  192   29  829  319  403  556  992  206  729
     [617]  774  881  862  796  467  697  431  236   73  379   61  601  638    8
     [631]  689   35  210  134   97  162  315  159  625   32  290  970  189  863
     [645]  251   58  751  125  780    6  436  935   35   22  159  149  365  586
     [659]  254  593  311  167  898  591  163  204  761  577  962  883  288  776
     [673]  866  882  775  697  142  487  432  287   34  894  541  141  611  727
     [687]  806  992   30  426  692  383  285  562  707  349   82  703  265  723
     [701]   93  196  592  368  703   87  691  691  788  638  592  192  818  808
     [715]  943  865  571  175  155  600  887  938  451  209  647  287  797  814
     [729]  509  414  553   68  981  848  919  339  538  200  661  779  900   92
     [743]  445  507  429  994  459  387  648  437  513  758  478  994  775  608
     [757]  259  684  982  616  234  490  928  456  170  721   56  739  658  872
     [771]  723  774  896 1000  313  880  851  104  771  655  286  615  746  875
     [785]  818  564  439  543  286  840  635  987  386  507  204  366  286    2
     [799]  343  819  197  207  102  996  400  306  993  228  142   65  778  414
     [813]  153  991   66  131  200  351   30    8  457  208  498  276  998  821
     [827]  210  784   83  790  777  655  588  506  319  267  697  859  752  263
     [841]  906   55  152  836  627  502  492  666  477  650  120  163  487  321
     [855]  138  949  233   31  103  714  289  540  210  999  699  638  231  497
     [869]  789  269  263   28  887  462   72  513  631   81  661  695  628  632
     [883]  372  204  133  482  560  743  167  286  794  493  268  861  860  844
     [897]  607  155  820  459  555  964  792  139  496  793  563   73  507  200
     [911]  634  865   91  957  997    3  611  924   13  639  504  544  223  275
     [925]  281  451  298  972  409  761  971  991  416  687   60  127  669  358
     [939]  124  153  502  645  939  122  729   79  423  973  739  341  240  824
     [953]  865  609  514  675  305  249  545  758  832  609  180  678  136  744
     [967]  386  736  643  206  805  698  838  845  231  451   98  625  429   42
     [981]  882  739  855  115  103  276  112  918  309  669  599  288  936  436
     [995]  951  123  674  387  638  672
    
    $resamples[[2]]
       [1]  514    2  836   98  703  890  815  686  282  517  379  361  118  781
      [15]  102  708  106  228  730  892   26  690  555  698  474  731  824  717
      [29]  834  549  435   37  659  280   89  919  998  243  966  467  849  389
      [43]  704  783  207  725  452  700  604  851  157  553  176  844  552  642
      [57]  562  363  594  773  156  758  589  319  556  687  484  156  207  133
      [71]  617  448   93  405   48  956  629  922  288  280  770  735  312  224
      [85]  255  722  611  826   54  142  675  755  386  768  536  311  655  930
      [99]  563  532  126  310  894  459  161  221   81  332  589  836  870  290
     [113]  323  455  908  420  581   72  549  799  656   70  433  742  702  698
     [127]  908   71  857  379  308  222  444  537  403   67  696  887  677  544
     [141]  366  916  976  563  870  433  156  229  516  282   13  720   98   58
     [155]  509  270  710  874  934  397  719   94   52  928  426  406  381  708
     [169]  179  915  388  279  238  864  714  602  557  816  413  293  613  736
     [183]  500  297  324  735  344  326  820  340  509  383  547  778  428  590
     [197]  365  943   66  481  688  203  543  547  603  396  136  549  697  627
     [211]  663  941  659  512  520  360  525   32  949  935   92   20  242   48
     [225]   11  920  383  976  916  179  346  179  733  562  899  719    2  186
     [239]  712  140  131  932  663  179  670  247  144  570  904  347  799  815
     [253]  919  993  946  863  423  906  940  479  305   89  407  579  896  835
     [267]  605  583  797   45  625  272   89  328  633  942  388  656   52  448
     [281]  605  593  918  719  649  372  127  998   31  598  852  924  568  900
     [295]  666  882  589  959  779  468  834  552  719  600  993  927  917   11
     [309]  981  967  500  761  367  848  448  662  854  785  384  452  505  474
     [323]  486  251  434  613  842  382  896  232  907  615  651  354  267  392
     [337]  330  722  742  301  642   66  305  278  226  872  781   75  261  449
     [351]  814   95  505  162  341  751  204  167  928  221  578  347  540  448
     [365]  152  194  331  629  579   71  996  866   86  748  402  779  377  427
     [379]  748  260    3    7  700  609  656  362  921  258  744  522  856   24
     [393]  255  475  492  713  626    5  112  343  805  833  349  401  488  949
     [407]  262  165  138  407   36  533   94  789   70  652  590   77  553  629
     [421]  356  361  153  957  535  322  615   65  347  163  768  944  863  901
     [435]  904  154  857  748  150  151  857  287  685  889  908  292  658  857
     [449] 1000  449   10  915  211  552  645  155  536  108  701  873   95  250
     [463]  613  721  377  517  585  929  611  100  841  493  177  810  675  524
     [477]   43  379  663  633  785  698  830  549  311  464  329  245  589  260
     [491]  164  594  458  447  777   10   33  109  403  285  810  634  245  855
     [505]   89  655   37  764  843  437  991  190  330  720  547  647  983  719
     [519]  357  932  857  151  104  756  697  587  233  828  609  378   61  115
     [533]  984  384  180  829  874  539  495  809  367  808   96  421  594    7
     [547]  132  270  215  612  101  262  399  823  605  632  800  442  515  982
     [561]  543  787  271  100  878  713  737  717  824  728  812  789  135  417
     [575]  748  609  221  429  791  758  959  958  719  110   24  819  970  334
     [589]  303  604  895  323   39  914  508  596  894  840  983  566  694  633
     [603]  439  157  982  190  980   99  739  504   92  403    4  149  635  985
     [617]  875  610  354  744  902   49  192   94  770  102   42  190  758  497
     [631]  672  549   66  535  913  351  731  954  612  563  736  825  857  887
     [645]  731  496  274  782  272  778  660  377  175  761  915  444  198  824
     [659]  963   92  178  760  949  436  568  274  308  495  153  100  620  446
     [673]   26  902  875  658   10  746  268  248  680  184  977  409  152  453
     [687]   74  149  213  629  131  771  207  161  352   72  495    1  664  718
     [701]  397  784  368  249  476  877  898  221  212  710   71  106  502  772
     [715]   73  250  396  249  866  110  358  812  403  814  489  502  770   15
     [729]  931  736  264  509  924  485  281  342   61  361  715  290  176  287
     [743]  352  534  929  543  949  362  908  540  786  750  412  876  769  985
     [757]  799  329  200  694  654  344  867  946  970  854  997  161  906  287
     [771]  843  630  165  771  113  293  220  788  396   56  168   35  140  913
     [785]  993  998  149  913  183  744  195  466  937  160  158  245  974  251
     [799]  464  339  258  153   84  650  297  855  559  709  730  671  980  960
     [813]  597  424  342  266   18  352  944  132  474  174   29  310  384  186
     [827]  420  772  246  821  631  325  815  288  182  408  985  992  469  730
     [841]  697  466  397  296  318  684   82  831  151  435  580  601  974  575
     [855]  958  176  633  392  107  387  774  135  568  264  194  710  992  578
     [869]  655  535  368  568   71  363  372  483  230  227  269   32  529  795
     [883]  239  500  481  169  427  854  474  778   93   89  139  191  943  724
     [897]  901  972  928  594  784  835  919  965  578  199  914    2  653    1
     [911]  714  833  538  482  648  112  383  249   34  713  903   58  741  768
     [925]  662  822  520  837  650  865  230  154  724  608  858  961  399  671
     [939]  921  852  884  403  554  949  164  843  883  183  296  383  629  601
     [953]  373  295  962  976   11  614  533  221  992  109  468  674  634  851
     [967]  547  833  166  918  333  691  878  931  513  584  320  873   42  576
     [981]  628  798  267  916  121  609  805  879  991  605  496  253  955  606
     [995]  290  440  393  511  908  373
    
    $resamples[[3]]
       [1] 1000  204  162  529  743  140  125  573  366  553  754   50  874  982
      [15]   46  765   33  548  385  151  867   36   38  546  677  739  650  779
      [29]  428  848  733  811  897  759  174  674  953  340  263  723  775  659
      [43]  440  530  386  843  389  121  572  725  280  742  221  145  425  471
      [57]   25  370  106  211  700  377  947   58  791  767   31  711  343  261
      [71]   98  361  565  534  617  391  885  841  139  872  358   55  979  173
      [85]  606   52  811  884  895  928  804  901  493  721  495  291  761  881
      [99]  693  635  976  704  909  808  124  384  447  201  700  311   24  150
     [113]  405  352  342  300  694  760  236  516   24  239  830  839  981  217
     [127]  204  539  235  904  503  597  418  558  341  299  932  522  388  744
     [141]  553  555  441  495  747   47  948  750  667  161  309   34  157  410
     [155]  312  639  332  155  486  930  392  992  617  481  825  200  309  780
     [169]  600  874  733  343  864  281  538  551  807  721  880  534   65  867
     [183]  146  738  784  985  550  508  685   58  893  757  425  326  803  691
     [197]  636  924  197   15  253  914  924  393  254  787  301  323  346  295
     [211]  479  131  242  443  846  465   99   39   32  275  776  926  399  567
     [225]  428  746  141  422  114  999  334  906  702  159  904  908   14  692
     [239]  308  466  320  372  289  719  131  595  856  117  978  482  111  625
     [253]  930  877   90  946  578  686  262  809  122  525  454   66  963  674
     [267]  242  625  806  228  334  484  145  810  342  855  467  374  376  155
     [281]  550  185  562  482  663  777  673    2  307  721  280  566  879  822
     [295]  216  126  725  630  828  997  125  436  674  867  855   98  489  768
     [309]  395  431  237  186  588  138  801  809  980  794  552  666  328  263
     [323]  885   76  369  997  909   32  449  868  111  262  990  368  879  965
     [337]  242  629   31   30  227  462  376  114   82  632  884   43  276  103
     [351]  294  515  430   93  319  445  340  136   10  443  732  994  981  245
     [365]  673  813  936  812  563  272  486  722  766  148  796  817  203  125
     [379]  850  324  758  122  783  199  868  625  164  671  467  518  461  960
     [393]  737  921  402  635  664  810  115   96  300  624  523   98  370   43
     [407]  633  482  489  415  801   75  495  213  170  231  107  239  823  342
     [421]  914  228  562  538  437  603  844   74  201  976  174  973  565  210
     [435]  747  639  509  474  827  915  322  488  462  411  532    8  849  392
     [449]  653  419  200  332  507  569  908  768  322   95  325  407  908  533
     [463]  861   90  505  505  577  782  439  755  386  572   51  707  851  985
     [477]  116  589  533  583  679  282  923  579  766  298  739  249  916  117
     [491]  717    1  850  184  868  766  854  967  954  771  226  863   35  877
     [505]  756  318   81  211   28  949  712  888  969  303  349  234  117  915
     [519]  644  286  596  440  282  434  698  962  998  665  978  997  768  405
     [533]    8    2  873  178  739  841  992  890   12  408  824  801  685  837
     [547]  617  133  195  810  190  268  224  595  179  458  602   53  746  945
     [561]  189  664  862  163  810  433  380  463  733  299  238  265  201  105
     [575]   24   53  102  703  223  313  821  104  641  797  833  285  433  291
     [589]  657   91  989  584  343  778  150  958  917  445  996  318  249  298
     [603]   20  163  372  139  453  116  439  562  116  706  485   83  147  738
     [617]   99  696  412  262  534  460  421  190  686  198   11  908  505  686
     [631]   65  345  854  322  233  614   58   48  743  818  196  694  766  984
     [645]  897  313  371  390  903  635  823  392  199  809  283  891  116  713
     [659]  768  541  334  976  732  622  297   39   34  301  892  294  976  509
     [673]  420  951  411  931  900  867  950  552  172  158  211  502  426  101
     [687]  312  333  394  529  335  743  100  901  461  113  130  922  364  784
     [701]  823  743  864  563  688  206  710  930  634  382  943  347  432  989
     [715]  993  317  567  195   30  454  797  802  906  513  752  521  350  947
     [729]  640  169   75  229  137  853  482  383  117  243  571  520  157  128
     [743]  786  623  118  931  275   59  302   53  519  756  949   38   64  906
     [757]  360  449  155  589  339  850  336  168  224  960  941  312  118  350
     [771]  671  462  408  738  763  841  422  535  602  238  931  276  204  454
     [785]  972  551  942  292  866  837  785  631  257  454  571  290  744  460
     [799]  181  477  955  644  632  123  597  911  813  686  583  670  714  471
     [813]  807  236  640  654  327   91  696  167  285  419  178  425  691  520
     [827]  326  323  359  967  279  449   11  516  841  471  330  741  703  760
     [841]  287  686  577  661  250  206  156  541  986  832  894  662  626  398
     [855]  591   15  722  373  756  680  567  418  495  764  815  143  898  607
     [869]  710  739  171   57   11  403  610   57  605  380  294  833  319  396
     [883]  469  540  642  708  610  117  426  243  243  944  942  675   87  812
     [897]  538  162  721  880  557  985  290  490  715  958  684  611  169  866
     [911]  875  649   11  822  104  692  103  523    7  408  539  450  509  383
     [925]  728  229  796  766  282  187  690  999  914  971    3  326  682  748
     [939]  977  560  603  432  947  410   86  572   98  275  796   26  214  266
     [953]  643  469  238  280  670  220  594  622  871  869  995  135  261  763
     [967]  773  684  946  282  676  733  715   78   33  790  832  279  620  947
     [981]  306  754  748  360  932   71  148  131  568   16  772  240  175  768
     [995]  570  379  973  948  535   12
    
    $resamples[[4]]
       [1] 324 662 312 325 705 872 223 556  57   3 644 675  52 130  74 134 302 591
      [19] 123 375 771 718 786 974 248  75 617  95 812 203 658 490 995 673 776 320
      [37] 478  89 685 976 692 589 234 460 967 828 330 116 698 402 247 850 849 677
      [55] 125 316 431 428 648 229 597 861 743 466  54  80 182 165 541 741 552 651
      [73] 738 571 812  73 270 170  97 366 432 183 963 239   8  74 682  74  23 100
      [91] 705 608 602 964 449 366  56 583 226 204 346 463 764 515 930 998 172 782
     [109] 562 275 291 808 660 820 753 192 478 939 486 481 340 645 320 930 546 248
     [127] 287 612 233   7  16 284 599 289 840 197 988 166 395 535 465 631 491 738
     [145] 503  89 371  65 120 414 570 927 797 114 446 124 701 866 201  48 902 238
     [163] 470 211 286 764 763 652 751 994 574 320 650 759 918 150 613 414 463 307
     [181] 485 281 366 450 314 620 649 446 872 327 266 897 469 205 480 618 921  96
     [199] 123 964 684 304 930 909 275  88 894 326 716 453 554 782 859 725 289 858
     [217] 218 377 369 328 990 170 109 940 617 283 527 401 891 744 419 187  24   4
     [235] 900 656 245 672 663 699 696 454 924 350 384  74 408 615 379 587 340  18
     [253] 115  59 286 540 239 596 660 384 672 164 666 924 827 696 666 663   9 976
     [271] 147 882 423 966 564 915 481 981 236 140 629 219 609 176  31 138 603 877
     [289] 670  52 520  71 622 519 268 337 145  78 166 712 758 862 170 678 843 867
     [307] 334 340 979 774 832 768 429 506 917  29 283 886 762 140 747 887 726 301
     [325] 672 406 239 488 630 371 422  47 707 896 260 548 430  57 349 161 435 530
     [343] 529 368 876  35 181  43 168  71 215 531 944 178 598 905 157 522 942 469
     [361] 173 246 741 947  82 762 156 305 644 146 666 846  64 886 392 470 578 135
     [379] 454 499 396   9 297 824 143 393 540 720 412  17   2 795 273 450 825 372
     [397] 384 148 463 957 921 253 910 428 319 924 363 135 619 105 302 844 596 745
     [415] 187 851 799 821 545 142  49 469  39 193 460 644  37 293 879 295 911 981
     [433] 192 923 866 502 900 935 995 326 483 607 204  44  99 510 887 557 855 614
     [451] 674 642 828 535 161 211 177 253 802 206 254 427 583 857 711 371 457 276
     [469] 733 401 503 947 408 530  10  70 656 642 670 476  88 100 513 781 613 215
     [487] 161 215  41 497 795  75 954 615 192 214 526 209  94  64 877 678 264 682
     [505] 605 144 633 822  70 501  46  46 305 643 778 446 359 699 946 892 163 706
     [523] 875   1 171 204 479 249 159 713 107 822 221  43 245  77  87 382 573 527
     [541] 939 257 260 233 298 972 556 979  39  74 620 224  17 492 562 853   6  86
     [559] 708 738  34 703 517 654 854 351 579 161 487 498  29  35 678 987 611 755
     [577] 513 898 705 490 392  67 497 548 487 711 194 760  69 302 777 843 146 522
     [595]   1 249 224 175 904 880 732  42 815 390 506 529  55 754 100 280 290  84
     [613] 122 745 898 960 867 242 826 530 586 249 851 797 363 298 888 316 948 423
     [631] 338 989 958 303 538 799 564 283  70 829 434 904 264  54 959 404 544 136
     [649] 783  76 961 846 157 347 429  94 292 502 482 136 746  56 466 444 173 404
     [667]   7 998 605  11 813 989 364 748 742 949  68  29 894 800 738 392 365 122
     [685] 975 482 301 435 330 176 104 829 701 120 580 426 435 801 579 540 805 887
     [703] 555 502 788 628 506 666 854  30 756 222 712 718 515 798  87   2 151 916
     [721] 972 480 130 836 424 365 526 705 602 180 124  89 666 422 296 626 658 847
     [739] 148 929 504 827 768 214 932 336 667 598 602 931 182 191 989 367 240 970
     [757]  24 552 392 901 848 989 900  63 889 335 449 816 383 418 104 686 158 290
     [775] 298 712 602 514 406  33 456 442 421 751 226 315  40 490  24 359 163 608
     [793] 391  73 699 275 486 409 442 333 413 256 422 387 457  88 682 490 949 675
     [811] 728  72 342 969 707 353 915 396  13 184 844 850  23  57  94 128 741 331
     [829]  69 200 560 435 265 412 866 995 573 745 105 304 780 695 802 460 494 160
     [847] 404 227 783 253 100 215 529 716 367 686 883  75 382  95 602 955 624 816
     [865] 130 429 858 170 660 723 642 516 405 699 319 944 968 851 740 257 934 775
     [883] 972 229 326 630 891 352 269 715 145 336 873 789 873 249 469 649 799 348
     [901] 433 761 211 574  61 790 132 379 467 937 115 603 790 969 569 780 283 572
     [919] 849 448 946  50 989 545 740  60 526 203 885  36 622 225 377 598 332 813
     [937] 782 361 892 289 641 291 692 977 729 631 244 172 917 863 447 491 927 256
     [955] 427 540 857 391 855 309 597 810 936 870 287 599 836 552 744 445 851 155
     [973] 507 480 125 664 542 145 349 659 143 445 990 540 836 282 714 984 999 285
     [991] 570  47 697 337 675 135 214 265 817 220
    
    $resamples[[5]]
       [1] 123 227 774 792 765  10 323 397 967 486 559 948 101 204  70 995 129  96
      [19] 742 521 591 228 665 200 564 373  15  56 254 136 335 663  12 886 459 728
      [37] 818 276  87 745 845 501 924 585 831 254 267 523 349 499 273 171 765 745
      [55] 388 883  72 178 883 291 496 880 218 480 679 298 680 306 702 536  99 223
      [73] 542 568 997 560  11 937 826 648 214 363  39 404 768 308 195 371 562 404
      [91] 298 854 146 855 399 551 866 136 483 633 789 728  69  96 126 911 245 212
     [109] 753 632 761 919 265 619 190 923 644 654 629 434 332 283 855 184 756 826
     [127] 732 143 402 170 168 945 359 997 578 518 549 251 142 792 747 769 749 669
     [145] 763 578 687 209 829 743 175 922 327 994 485  49 308 900 261 171 235 988
     [163] 654 436 362 816  88 663 946 551 402 809 696 718 788 699 232 839 269 885
     [181] 769 407 871 173 770 544 616 826  60 497 775 406 146 282 475  65 688  73
     [199] 954 749 131 697 679 230 347 624 550 816 497  75 788 695 171 868 488 347
     [217] 643 951 736 422  40  22 928   7 343  65  40 110 427 293 205 435 202 919
     [235] 343  31 969 439 934 587 742 728 102 881 699 892 395 294 935 633 556 230
     [253] 956 834 339 838 906 821 935 275 835 788  44 813 241 736 165 621 602 824
     [271] 185 212 108 740 568 397 316 132 888 883 721 335 915 973 722 690 467 401
     [289] 953 694 193 237 682  15 960 271 395 957 281  49 355 783  56 589  75 974
     [307] 181 842 268 624 767 359 937 731 545 290 592 341  83 118 102 561 722 699
     [325]   2 246 379 774 288  41 154 144 354 975 778 191 956 368 436 393 853 275
     [343] 319 164  45 600 443  78 799  23 258 602 925 984 585 949 652 589 378  71
     [361] 518 591 810 566 897 165 255 907 988  94 950 741 464 729 469  86 458 635
     [379] 828 793 286 450 600 836 862 650 805  83 225 613 247  49 182 653 987 881
     [397]  53 900 983 953 340 414 552 341 157 417 232 152 633 170 935 603 194 366
     [415] 712 848  76 946 195 564 125 604 371  58 922  25 562 557 887 622 147 919
     [433] 433 295 761 576 126 518  25 532 998 909 922 143  17 869 910 701 946 133
     [451] 319 189 703 587 775 398 667 483 669 334 249 372 232 588 467 611 888 971
     [469] 125 264 801 394 490 537 153 518 582 378 882 546 508 361 947 396 954 937
     [487] 452 761 106 993 686 813 533 452 120  47 248 135 786 799  26 929 746 943
     [505] 513 648 198 183  84  66 234 567 859 163 158 911 688 515 389 374 846 218
     [523] 241 207 951 723 838 158  69 861 203 715  10 199 284 795 147 991 714 473
     [541] 455 146 817 374 668 385 291 893 142 747  51 397 442 727 618 336 439 318
     [559] 200 539 154 874 441 617   7 235  27 829 723 922  56  88 587 937  87 550
     [577] 990 359 884 843 645 146  81 279 871 670 626 390 850 922 171 581 512 767
     [595]  78 827 709 532 360 959 827 559 406 972   5 236 508 933 247 927 406 971
     [613] 326 679 196 234 325 876 237 724 477 378  29 504 646 990 716 528 139 412
     [631] 528 404 947 858 633 174 200 665 689 387 439 659 372  72 479 333 886 378
     [649] 485 506  66 131 928 170 409 366 649  58 818 313 200 652 144 651  68 943
     [667] 591 524 915 740 680 322 780 360 530 131 577 292 655 776 983 306 101 511
     [685] 578 983 229 743 396 682 365  38 465 843 482 689 706 237 930 683 855 740
     [703] 569 790 193  92   9 650 723 424 754 553 169 890 842 219 823 608  26 790
     [721]  95 829 299 490 373 765 400  93 191 884 905 643 750 750 244 638 922 524
     [739] 437 859 354 267 495  57 389 523 470 596 204 452 557 250 261 381  83 529
     [757] 853 240 452 260  80 726 138 913 552 991  75 529 823  33  82 116 674 252
     [775] 365 219 409 767 685 840 483 159 226 849 420 764 709 147 368 440 227 403
     [793] 806  96 847 661 557 292 961 495 785  75 615 742 604 121  90 137 360 979
     [811] 429 938 652 377  82 763   8 157 824 828 281 788 642 873 643 851 716 188
     [829] 974 959 510  26 204  51 604 846 175 354 249 322 878 795 154 949 636 454
     [847] 481 407   4 549 581 917 463 611 737 254 746 905 438 853 198 249 343 399
     [865] 512 473 580 996  93 302 784 917 527 255 689 950 595 846 417 651 447 705
     [883] 428 618  21 862 352 524 613 775 288 966  27 369 969   5 258  16 618 125
     [901]   7 921 682 775 893 464 646 819 447 605  78 131 643 986 521 769 238 415
     [919] 772 327 611 661  60 986 197 561 994 372 334 714 246 738  23 460 382 483
     [937] 425 274  21 599 506 459 777 328 322 261 110   7 670 752 716 304 439 415
     [955] 249 559 988 988  26 177 924 227 737 772 308 117 297 551 481  69 794 113
     [973] 154 771 573 557 338 816 189 916  75 436 417  21  34 261 912 381 419 523
     [991] 122  89 282 693 764 851 732  46 757 141
    
    $resamples[[6]]
       [1] 493 824 365 410 757 691 595 588 590 343 757 230  96 870 285 210 498 620
      [19] 612 612 159 933 107 743 842 229 653 541 632  55 153 405 111 846 186 526
      [37] 397 695 609  11 859  65 290  22 411 376 181 103  91 917 704 584 572 249
      [55] 827 694 938 549 600 574 301 905 102 401  96  31 735 863 514 387 532 914
      [73] 544 886 139 314  74 871   8 569 152 439  50  90  15  15 893  96 612  97
      [91] 936 567 563  64 907 674 109 609 459 633 477 497 157 689 188 388  28 390
     [109] 296 923 401  89  81 198 667 779 476 858 411  56  10 975 714 863 953 779
     [127]  48 192 891 794 638 654 199 766 700 298 891 183 783 159 918 786 469 959
     [145] 456 897 441 720 905 995 564 822 464  99 903 810 481 931 771  88 742 453
     [163] 833 556 194 912 231 935 595 864 250 897 282 865 873 723 891 422 180 391
     [181] 754 678 773  57 854 972   1 671  67 505 538 937 110 240 832 226  85 404
     [199] 268 834 452 750 763 945 348 307 484 469 564 216 557 691 269 103  46 435
     [217] 539 118 433 664 702 654  80 924 544 260 672 237  37 124  32 930 219 559
     [235] 666 731 670 751 670 625 929 962 596  32 634 734 369 585 473 761  40 146
     [253] 664 399 256 571  46 442 571 104 580 975 897 718 913 565 870 872 917 520
     [271] 263   9 547   1 967 979 965 690 130 513 625  90 468 607 800  97 367 847
     [289] 875 204 118 785 259 856 939 235 416 374 742 472 189 795 389 387 931 974
     [307] 845 343 734 435 402 799 508 806 712 900 505 575 776 325 705 816 919 857
     [325] 102 284 188 337 529 629 458 786 226 167 650 990 591  79 364 943 169  55
     [343] 232 157 842 145 362 858 649 276 203 673 707 282 242 530 667 182 392 802
     [361] 225 323 377 759 571 462 305 843 260 833 442 687 660 588 863 970 364 472
     [379] 571 787 624  22 389 459 558 874 107 560 370 305 524 606 426 622 427 373
     [397] 572   9 400 688 792 436 972 528 187  81 278  97 140 303 118 449 146 255
     [415]   2 921 228 604 864 888 100 145 410 278 536 942 943 693 755 657   1 320
     [433] 631 955 423 259 875 448 846 190 467 229 601   2 522  25 792 909 133 548
     [451] 972 827 813 479  80 838 277 225  38 588 266 411 744 469 469 855 419 524
     [469] 608 120  15 622 324 548 473 330 817 924 904 357 924 519 712 142 565 210
     [487] 688 392 918 867 313 556 455 836 469 754  85 668 267 736  42 895 834 435
     [505] 163 138 239 663 603 888 659 525 646 426 703 391 472 745 380 496 169 946
     [523] 629  60 988 249 308 501 758 835 714 399 960  19 559 204 894 251 691 596
     [541] 551 494 827 877 270 529 868 814 394 757 313 773 228 423 894 583 268 847
     [559] 166 318 548 356  89 501 723 319 697 703 955 794 925 851 290 904 254 521
     [577] 526 301  56 999 557 737   2 117 907 866 155 356  65 258 513 460 587 713
     [595] 223 234 360 453 782 420   7  16 417 327 946 469 113 517 679 440 746 433
     [613] 543 214 388 359  55 466 585 117 744 622 277 363 949 840 845 689  80 714
     [631] 789 139 712 764 704 598 302 610 740 120 803 164 781 866 154 549 357 221
     [649] 387 612 422 750 235 865 901 874 653 691 569 613 295 786 196 207 927 481
     [667] 511 850 485 218 165 535 922 900 603 674 417 340 422 386 749 322 853 252
     [685] 899 766 297 580 874 293 932 149 193  56 445  55 939 392 670 535 667 346
     [703] 791 291  57 194 921 894 453 453 411 478 287 387 960 816  57 595 218 778
     [721] 943 324 701 531 167  67  42 234 502 715 941 486 631  94 204 368 937 566
     [739] 466 264 298 742 252 265 881 820 397 402 638 115 394 229 236 278 135 160
     [757] 218 440 559 271 412 842 951 428 752  83 998 127 949 758 407 443 889 204
     [775] 875 632 365  55 997 768  19 330 371 809 945 506 491 878 396 246  93 242
     [793] 912 140 245 494 768 808  64 706 514 551 244 829 507 900 647 958 929 178
     [811] 776 257 111  27 467 471  82 183 749 246 111 542 261 808 273 905 983 278
     [829] 563 156 173 447 802 910 998 958 332 154 181 541  81 343 858 165 556 389
     [847] 992 849 920 702 286 434 725 793 131 795 913 347 533 759 302 521 783 715
     [865] 447 731 191  54 148 128 841 474 302 822 515 497 820 365 762 224 868  70
     [883] 231 901  12 995 441 545 537 778 190 457 254 285 191 957 406  10 371 773
     [901] 692 312 480 268 319 385 883 483 209 775 500 673 870  16 610 222 918 587
     [919] 486 811 593 362 150 212 466 740  23 295 561 128 835 136 869 163 631 105
     [937] 143 513 207 189 239 877 176 255 632 194 709 926 564 748 658  39 298 774
     [955] 259 706 350 830 481 887  49 480  32 764 476 400 743 364 707 498 970 939
     [973] 319 262 672 118 800 595 129 405 257 786 408 107 975 432 135 101 396 362
     [991] 584 787 559 780  13 923 421 529 955 689
    
    $resamples[[7]]
       [1] 787 515   5 498 397 450 233 471 437  78 463 894 781  43 907 630 807 426
      [19] 115 585 111  38 392 167 622 210  82 793 236 911 263 634 577 394 190 404
      [37] 355 234 531 519 404 656 826 937 701 830 663 934 408 429 916 586 691 924
      [55] 159 309 891 904 452 739 837 418 861 637 423 708 297 138 751 130 224 431
      [73] 406 685  48 984  50  98 876  63 487 486 467 550 752 462 730 668 841 143
      [91] 208 176 354 734 928 230 747 187 699 856 225 795 416  30 859 320 628 307
     [109] 410 586 382 815 858 619 727 331 246  26 835 668 880  25  27 639 806 499
     [127] 692 326 854 308 291 631 462 664 614 576 371 867 344 476 734 478 804 233
     [145] 372 879 656 872 394 362 945 233 519 313 596 343 520 157 784  21 352 267
     [163]  46 747 780 429 787  58 888 696 611 670 734  97 906 474 153 133 626 632
     [181] 833 119 119 280 471 769 125 429 355 371 268 922  62 600 245 225 493  93
     [199] 819 836 237 525 533 799   8 204 926 740  80  10 510 488 578 207 784 291
     [217] 745 782 764 104 335 835 375 549 387 988 982 553 489 764 422 599 254 683
     [235] 382 614 803  58 490 108 557 533 541 607 158 408 895 262 729 443 533 230
     [253] 506 709 544 777 915 787  17 951 973 271  40 377 985 181 386 127 116  80
     [271] 807 574 699 581 337 322 983 304 256 951 926 246 243 148 925  96 548 291
     [289] 261 226 799 808 951 673 812 880 346 171 615 193 798  16   6 396 461 832
     [307] 172 957 112 509 900 755 977 324 509  79 849 882 525 870 239 842 427 394
     [325] 138 695  72 309 527 621 354  53 340 832 685 367  27 979 721 783 812 534
     [343]  26 611 113 505 454 431 936 799 665 623 348 267 851 640 711 212 898 210
     [361] 127 941  73 415  20 381 683  32 573 775 155 439 916 431 294 369 772 870
     [379]  91 736 639 517 425 420  18 880 975  91 957  99 453 567 237 524 601 616
     [397] 114 832 121 981 125  98 226 314 272  43  18 629 882 642 993 825 920 671
     [415] 692 805 113 944 524 358 333 256 898 768 407 327 400 351 492 997 627 591
     [433] 239 112 319 941 565 752 850 784 889  29 975 409 503 607 668  14 115 593
     [451] 225  97 878  21 286 133 633 682 107 300 343 630 547 634 359 157 552 659
     [469] 318 690 620 498 343 872 714 272 812 385 292 127 253 276  98 830 564 133
     [487] 211 284  95   3 501 401 681 791 774 308 706 266 256 994 363 107 570 785
     [505] 381 639 262 517 813 796 966 188 859 578 546 987  32 464 919 987 731   4
     [523] 241 655 665 585 630 102 651 356  39 660  17 955 516 184  48 368 715  47
     [541]  74 206  85 445  37 375 135 346 363  12 907  93 785 315 290 760 541 854
     [559] 365 834 927 244 609  62 751 357 507 276 878 266 281 895 120 300 775 342
     [577]  73 808 241 350 407 381 746 100 796 638 837 667 155 484 961 128 966 650
     [595] 565 942 222 971 480 375 427 271 868 871 391 294 947 952 879 295 309 506
     [613] 521 277 605 443 722 449 872 448 662 977 461  29 721  86 971 225 317 642
     [631] 914 545 770 569 215 914 479  98 631 437 752 380 603 201 756 146 487 808
     [649]  43 620 772  21 975 417 721 594 622 337 937 545 182 961 794  96 985 157
     [667] 143 623 777  49 809 538 621 199 487 213 566 171 563 157 275 729 246 771
     [685] 520 151 564  96 291 893 770 241 743 492 544 430 948 187 969 885  41 278
     [703] 273 896 146 109 660 148 899 257 657 981 591 901 442 430  29 342 933 324
     [721]   6 642  22 189 725 129 661 702 646 827 247 753 444 492 499 554 570 783
     [739]  82 411 433 962 135 721 585 876 763 432 963 219 282 272 108 315 258  31
     [757] 202 944 570 752 216 798 552 518 659 485 142 536 567 930 821 508 881 356
     [775]  29 416 223 152 113 538 422 257 772 939 606 732 306 514 520 167 235 360
     [793]  56 525 193 420 674 446 662 442  75 434 669 571 735 857 544 345 449 172
     [811] 691 402 137 355 820 563 900 149 191 254 808 425 436 827 450 740 581 490
     [829]  48 536 442   7 758 943 831  42 371 517 905 679 823 813  42  39 122 280
     [847] 847 136 350 556 738   7 736 271  42 393 874 669 573 246  42 852 136 938
     [865] 965 694 733  62 229 273 375 232 254 138 128  96 201  39 306 790 404 626
     [883] 254 305 603 734 440 889 942 875 422 785  38 958 514 221 889 986 356 735
     [901] 487 477 487 496 422 373 221 444 553 984 246 245 312  11 343 300 778 873
     [919] 439 110 916 917 642 278 439 741  56 665 636  23 138 985  90 964  66 477
     [937] 856 398 788 254  32 224 520 858 492 204 875 483 807 597 539 651 218 736
     [955] 345 185 440 640 314 557 740  29 694 781 775 198 577 847 478 345 206 693
     [973] 791   3 192 136 454 487 113  34 945 633 344 863 146 495 460 545 737 310
     [991] 856 755  78 312 980 415 617 282 541 328
    
    $resamples[[8]]
       [1] 404 585 670 279 104 711 407 898  12 815 555 666 227  17 229 823 735  51
      [19] 103 753 758 405 205 918 136 106 320 566  98 137 758 555 820 654 680 467
      [37]  96 823 821 488 459 981 867 614 563 558 260 947 845   2 772 855  47 657
      [55] 401 589 954 971 525  50  10 196 243 565 582 698 321 825 457 759 238 316
      [73] 251  90 706 782 254 919 233 289 204 885 992  94 101 607 983 533 594 404
      [91] 133 302 556 164 812 307 821 238 629 913 524  47 790 641 630 812 160 983
     [109] 776  28 279 609 325 888 773 742 908 572 240 578 149 447 489 190 320 800
     [127] 844 319 286  80 120 627 379 483 383 455 753 354 396 785 542 608 161 288
     [145] 388 383 758 723 239 645 409 509 721  86 971 284 234 714 802 575 693  15
     [163] 215 732 364 336  86 889 254 293 890 676  21 967 129 952 458 524 752 107
     [181] 704 865  99 468 455 721 732 559 879 860 841 951 827 119  62 926  83 506
     [199] 584 118 431 165 891 294 452 989 456 327 621 744 988 813 502 339 736 704
     [217] 267 586 925 870 583  64 240 989 300 265 988 901 421 934  51 482 805 301
     [235] 371 972 922 457 859 495 687 110 438 791  67 747 623 894 343 959 134 770
     [253] 371 882 394 677  69 107   4 129 325  10 676 745 885 628  68 813 652 201
     [271] 701 935 219 371 147 285 463 200 152  82 381 118 826 559 411 291   3 199
     [289] 654  49  95 896 488 507 739 696 654 453 468  59 622 500 106  29 151 173
     [307] 979   9 991 774 675 620 947 916 604 306 948 470 955 178 897 779  77 955
     [325] 253 960 947 946 413 151 674 119 711 402 515 841 394 991 299 687 411 846
     [343]  13 790 825  16 950 805 236 503 766 129 604 249 325 643 162 277 325 643
     [361] 346 211 515 373 946 929 614 767 139 970 345 690 263 822 567 604   8 132
     [379] 937 222 372 859 734 252 723 238 952 306 894 479 235  24 826 536 533 622
     [397] 360 326 438 251  22 989 246 667  56 336 324 956 458 652  42 874 737 260
     [415] 929 850 578 416  54 334 615   3  45 901 947 375 628 211 432 687 263 905
     [433] 873  85 810 867 215 754 585 540  29 544 932 729 718 463  55 866 213  40
     [451]  79 851 765 247 790  73 538 111 534 299 664 267 730 319 802 905 202 217
     [469] 399 198 345 357 841 190 396 140 209 400 366 257 724 211 693 404  20  91
     [487] 895 306 946 461 935 436 173 935 166 625 830 439 916 792 742 899 702 840
     [505]  94 403 205 177 730 836 904 665 585 975  59  29 109 720 972 232  48  15
     [523] 380  53 318 642 137 950  98 962 946 535 958 960 267 911 499 920 775  40
     [541] 517  96 310 712 313 134 422 142 651 536 139 797 795 824 906 928 823 620
     [559] 308 532 123 225 386 145 554 335 957 320 622 492 168 641  44 863 771 261
     [577] 480 210 180 342 776 775 231 194 352 628 886 308 753 791 235 866 618 247
     [595] 176 227  90 465 661 459 137 592 717 138 800 746  38 172 349  11 836 391
     [613] 174 433 161 855  26 821 642 345 227 864 275 615 155 796 707 196  88 188
     [631] 763 821  55 567 428 539 286 645 334 124 164 817 740 415 921 863 460 510
     [649] 232 506 869 272 139 710 196 428 540 797 836 827 495 513 751 120 760 952
     [667] 677 226 940 479 847 446 261 383 511 548 106 589  64 452 493 952 468 175
     [685] 735  75 101 881 702 951 677   9 598 626 968 319 457  44 145 780  76 664
     [703] 505 336 883 700  69 628 435  68  39 139 543  59  20 117 358 807 579 259
     [721] 539 563 855 540 449 559  91 429 686 211 561 635 817 529 235 868  41 136
     [739] 297 586 931 777 417 928 292 925 349 986 316 466 907 909 220 513 493 441
     [757] 733 427  76 322 356 580 244 137 801 505  70 298 571 825 832 150 609 151
     [775] 170 153 369 346 443 172 844 488  19 978 424 689 608 759 722 332 844 344
     [793] 266  94 738 443 461 696 512 625 661  41 624 949 876 245 544 440 470 478
     [811] 328 252 293 625 489 916 211 723 745 570 567 380 502 476 378 939 169 107
     [829] 521 912 962 331 902 790 782 817 450 809 725 165 670 684   9 216 311 235
     [847] 419 428 133 843 772 421 357 837  23 572 223 318 312 758 789 516 395 429
     [865] 663 570 902  23 259 585 613 348 614 822 668 271 974 238 229 654 650 873
     [883] 645 929 739 999 892 530 701 411 447  97  69 614 756 913 518 701 948 805
     [901] 488 443 823 681 993 393 295 902 707 621 756 188 661 788 340 766 460 568
     [919] 555 480 554 752 699   9 586 436 323 871 845 167 710 972  92 326 281 156
     [937]  33 847 559 951 179  43 660 858 613 446 840  49 626 793 823 974 843 830
     [955] 793 940 593 354 968 177 696 409 429 689 680 715 491  58 430  22 581 738
     [973] 868  79 378 718 779 851 272 551 711 196 957 447 569 451 531 862 940 727
     [991] 757 207 329 251 715 376 352 149 213 327
    
    $resamples[[9]]
       [1]  980  185  863  251  912  255  305  837  124  680   83  637  238  888
      [15]  198  399  611  886  825  894  598   23  913  618  705  668  813  745
      [29]  486   75  180  319  582  697   95  942  931  587  995  736  865  868
      [43]  275  633  598  327  510   13  327  288  744  493  389  202  843  907
      [57]  378   33   72  692  294  559  424  942  338  237 1000  445  112  337
      [71]   73  702  980  380  942  897   75    4  941  113  680  424   98  116
      [85]  836  975  675  503  158  525  754   90  237  362  879   99  352   45
      [99]  706  216  551  436  582  736  964  509  806  900  633  926  432  431
     [113]  163  707  705  784  233  529  236   27  190  352  943  305   81  780
     [127]  710  813  749  668  163  669  191  772   69  557  557  428  784  220
     [141]  691  748  470  412  859  654  377  818  493  321  369  924  166  615
     [155]  400  736  201  790   56  368   83  787  715  341  224  284  870  282
     [169]  139  345  298   98  840  974  317  226   92  938  821   89  727   90
     [183]  310  904  189  239  985  568  555  570  326  325  643  864   16  684
     [197]  592  650  990  657  814  398  749  477  602   55  610  537  675  230
     [211]  377  716  921  529  594  613  828  223  887  119  776   53  651  554
     [225]   22  869  675  886  337  632  113  306  587  517   34  862  752  295
     [239]  627  108  281   77  902  394  521  832  397  145  448  921   11  649
     [253]  733  279  170  970  349  473  520   23  473  644  821   46  753  524
     [267]  605  530   94  730  399  917  739  720  698  662   20  492  983  993
     [281]  255  404  312  977  395  412  697  702  609  328   62  508  358  220
     [295]  171  539  985  860  606  224  439  408  627  248  569  113  958   45
     [309]  740  241  153  894  811  428  764  695  192  901  962  932  444  864
     [323]  208  967  576  883  612  859  257  644  473   55  986  492  995  218
     [337]  391  104  678    5  584  878  634  932  781  629  828  179  677  737
     [351]  835  883  388  927  900  981  753  650  533  330  132  340  189  867
     [365]  779   31  496  804  928  286  175  667  105  399  590  916  317  735
     [379]  671  603  287  383  227   67  705  746  666  353   24  958  113  991
     [393]  697  343  769  133  465  801  749   58  653  777  997  682  656  933
     [407]  248  373  424  927  400   40  276  369  101  358  146  861  287  738
     [421]  107  570   67  426   15  999  545  774  714   95  570  633  202  688
     [435]  793  461  381  779  150  728  849  109   64  970  284  712  323  329
     [449]  520  674  527  383    3  417  765  131   47  717  851  165  696  739
     [463]  541  930  199  760  927  558  352  833  348  701  351  829  478  106
     [477]  905  351  136    2  207  311   57  413  649  274  554   89  284  372
     [491]  853  392  317  634  993  205  518  793  715  101   66  203  711  284
     [505]  852  705  767    7  421  593  293  284  970  124  984  872  709  626
     [519]  616  479  907  672  710  982  683  985  302  485  402  528  179  506
     [533]  989  165  219  355  743  209  940   49  587  379  862  475  842  943
     [547]  380   15  206  840   49  286  133  817  683  425  226  100  841  824
     [561]  494  314  168    1  807  432  828  936  286   61  115  889  544  702
     [575]  210  474  902  197  561  322  749  924   27  533  688  281  456   72
     [589]  683  271  687  428  912  244  803  268  104    3  813  504  978  556
     [603]  297  523  810  993  809  536  169  426  253  369  681  754  982  436
     [617]  816  121  122  631  700  405  171  610  339  433  972   66  501   64
     [631]  963  360  490  408  540  588  897  330  673  113  431  247  784  939
     [645]  145  834  961  670  570  680  737  904  567  985  153  465  953  494
     [659]  450  314  550  125  232  820  362   71  567  966  558  575  496  612
     [673]  846  364  716   89  328  703  748  994  198  346  150  222  995  964
     [687]  238  170  760  773  661  375  493  928   16  323  159  778  612   80
     [701]   91  179  519  246  307  544  447   50  313  970  871  548   49 1000
     [715]  517  497  503  373  218  934  765  241  342  694  293  676  811  222
     [729]  386  424  266  449  936  394  196  193   31  752  852  896  932  765
     [743]  567  553   15  553  577  691  885  482  180  761  522  578  797  712
     [757]  512   90  491  784  311  693  581  335  835  818  154  231  628  592
     [771]  824  398  277  222  490  292  191  686  708  580  539   92  584  622
     [785]  590  603  562  448  120  289  863  190  796  820  640  797  815  935
     [799]  296  790  390  551  852   43  783  395  797  267  789  533  188  764
     [813]  991  908  246  462  720  676  393  821  584  831  370  186  588  999
     [827]  788  728  848  164  342  914  959  962  449  314  353  259  472  387
     [841]  891  521   48  902  623  965  867  207  701  940  894  388  508  614
     [855]  776  684  313  822  213  681   82  178  969  964  215  660  908  642
     [869]  354  381  474  839  919  321  197  418  877  977  558  498  794  120
     [883]  392  113  978  491  574  362  937   21  289  390  189  120   78  896
     [897]  236  414  280  892  460   53   39  670  155  922  607   13  349  949
     [911]  916   92  709  621  307  773   20  593  137  252   92  907  536   48
     [925]  483  593  118  658  152  342  368  327  224  620  837  628   44  818
     [939]  171  438  760  175  477  375  955  916  552  522  612  633  364  356
     [953]  829  553  871  958  841  808  972  934  199  544  447  811  397  412
     [967]  165   29  275  832   33  831  382  885  785  507  499  468  328   38
     [981]  966    7  891  182  378  552  506  912  283  650  307  585  563  890
     [995]  878  195  563  177  488  333
    
    $resamples[[10]]
       [1]  761  928  285  153  113  372  719  803  232  697  511   24  978  795
      [15]  340  860  313  504  621  371  107  273  297   80   68  859  182  486
      [29]  922  763    5  262   43  509  940  500   51  899  820  826  944  376
      [43]  826  652  493  767  772  764   16   16    8  212  347  692  362  575
      [57]  397  876  729  535  791  191  964  724  461  789  853  813  262  100
      [71]  681  173   46  736  948  951  765  444   15  477  100  354  310  233
      [85]  197  403  991  195  732  399  132  863  387  485   77  424  303  393
      [99]  545  562   22  759  171  258  605  578  465  984  317  712  621  957
     [113]  236  547  585  224  824  450  803  615  734  352  727  370  295  329
     [127]   35  262  290  785  568  895  745  869  128  582  828  757  163  609
     [141]  303  601  882  813  799  909  629  246  892  585  890  972  779  922
     [155]  463  505  356  206  521  616  553  619  176  236  672  847  723  750
     [169]  271  197  727  982  891  341  585  517  468  713  830  809  916  521
     [183]  228  507  562  492  850  720  308  858  591   63   52  249  405  826
     [197]  988  909  292   92  965  850  318  477  703  325   70  666  420  380
     [211]  486  151  604   47  374  715  665  615  698  762   80  385  488  163
     [225]  694  541  698  107  430  600   84  947  295  475  624   83  232  398
     [239]  894  579  402  470  320  934  692  772  522   92  472  571  979  575
     [253]  343  705  187  104  666  329  181   84  984  121  877  780  745  412
     [267]  463  521   87  801  350  710  807  310  686  979  656  925  406  877
     [281]  556  575  797  988  911  208  255  789   74  809  910  768  566  195
     [295]  924  797  136  873   80  540  409  858  161  296  323  103  240  911
     [309]  912   29  375  387  654  803  309  741  592   47  146  837   26  478
     [323]  564  966  485  394  128    9  314  957  231  373  199  213  407  853
     [337]  459  713  603  997  723  451  324  262  985  873  743  560  376  989
     [351]  860  227  828  373  811  943  319  568  937  468  288  305  100   62
     [365]  272  886  721  208  578  707  445  831  230  955  406  107  918  950
     [379]  578  664  638  630  468  755  522  849  548  353  672  586  739  108
     [393]  471  628    7  778  983   14  618   48  424  422  154  796  937  814
     [407]  996  325  538  446   91  356   17   77  627  777  396  922  167  913
     [421]  946  174   61  270  330  184  105  459   66  292  375  505  505  384
     [435]  806    7  403   35  728  835  222  219  456  883  112   67  550   10
     [449]  319  752  637  637  668  920   78  568  555   64  432  907  860   42
     [463]  740  924  982  252  493  306  676  501  807  610  207  898  362  863
     [477]  268  619  345  773  651  552  161  195   93  471  604  755  749  355
     [491]  398  237   47  271  979  991  714  321  446  541  328  284   12   80
     [505]  929   70  839   93  358  349  269   77  681  208  820  532  602  227
     [519]  120  365  479  702  772  296  182  295  590  213  528  160  880  721
     [533]  990   42  101  875  484  559  936  972  793  377  721  179  451   98
     [547]  457  603  162  393   44  582  736  599   38  343  791  194  181  685
     [561]  783  909  375  626  777  158  727  467  700  896  550  566  738  218
     [575]  551   57  379  561  414  879  719  792  660  622  822  562  436  453
     [589]  285  410  504  887  396   68  425  710  537  315  825  808  892  270
     [603]  425   80  293  317  702  941  696  116  705  259  678  809  714  891
     [617]  398  920  768  618  902  738  741   63  413  948  620   54  423   86
     [631]  465  596  802  144  701  660  150  877  897  871  439  881  354  829
     [645]  131  360  257  219  477  400  518  761  593  927   32  945  477  328
     [659]  601  689  173  368  809  493   27  832  933   82   11   35  263  993
     [673]  465  370  943  251  101  805  741  240  755  609  560  461    9  979
     [687]  923  967  342  703  249  656  223  311  842  979  559  994  433  414
     [701]  266  344  675  909  681  168  216   75  504  859  130   46  763  627
     [715]  341  655  233  133  282  605  812  601  685  506  323  886  532  260
     [729]  315  204  766  286  273  527  405  115  181   42  302  496  937  270
     [743]  975  973  353  806  575   50  349  347  924   73  665  727  177  553
     [757]   31  839  709  208  362  893   24   20  708  960  962  474  535  821
     [771]  107  969  953  292  502  435  495  893  539  957  837   70  396  501
     [785]  931  515  992  340  953  991  941  958  987   30  882  587  641  393
     [799]  572   70  298  502  402  446  434  628  199    3   96  902  891  577
     [813]  371  668  229  481  476  266  432  903  574  426  693  395  688  716
     [827]  161  373  725  711  973  590  245   50  176  484  859  995  373  687
     [841]  849  650  757  446  532  697  642  790  950  939  824  765  398  229
     [855]  862  723  746  114  139  244  813  300  855  603  681  550  798  545
     [869]  523  888  508  155  681   31  598  827  387  174  547  990  725  922
     [883]  349  440  185  954  702  806  508  184  650  592  529  285  586  476
     [897]  486  504  827  277  477  839   72  120   20  265  855  197  477  979
     [911]  699  700  264  792  805   62  490  300  852  841  818  884  862  353
     [925]  625  474  685  561  467  809  373  271    2  226  456  325  666  578
     [939]  986   70    2  301  976  672  332  832  423  183  735  265  266  178
     [953]  845  355  285  730  273 1000  328  268    3  941  934  358  317   61
     [967]  338  278  873   41  850  926  224   59  470  882  227  683  225  758
     [981]  344  923  587   44   22  298  100  955   98   89  630  750  901  857
     [995]  562   11  367  521  787  696
    
    
    $original
    Outlier-Robust 2SLS Model 
    Initial estimator:  robustified 
    Reference distribution:  normal 
    Two-stage Least-Squares Model: y ~ x1 + x2 + x3 + x4 + x5 | x1 + x2 + x3 + z4 + z5 + z6 
    Iterations:  3 
    Final selection:  Outliers found:  33     Outliers proportion:  0.033 
    
    attr(,"class")
    [1] "r2sls_boot"

---

    $boot
       X.Intercept. x1          x2         x3         x4        x5  m gauge  r
    1  -0.204681972 NA  0.03502074 0.66823217  0.9385139 0.4326476 m2 0.034  0
    2  -0.636506558 NA -0.57656157 0.02982617  2.1319602 0.2395394 m3 0.029  1
    3  -0.095681750 NA  0.24067648 0.85963714  0.5096375 0.4855097 m2 0.037  2
    4  -0.107743885 NA -0.08834303 0.47120246  1.1076975 0.3853691 m1 0.037  3
    5   0.197502322 NA  0.60852001 1.28133526 -0.1281401 0.4305294 m2 0.019  4
    6  -0.166551568 NA  0.44712120 1.04132538  0.2558132 0.4869656 m2 0.036  5
    7  -0.003687986 NA  0.35646868 1.12104142  0.2889508 0.4534283 m4 0.045  6
    8  -0.382315267 NA -0.08852382 0.51214983  1.3652876 0.3679794 m3 0.028  7
    9   0.100209716 NA  0.91537500 1.41331995 -0.3796446 0.6174150 m3 0.013  8
    10 -0.290801687 NA  0.22976280 0.72810698  0.7573736 0.4532208 m1 0.035  9
    11 -0.274915574 NA -0.54230900 0.12813735  1.8062160 0.3546880 m2 0.048 10
    
    $resamples
    $resamples[[1]]
       [1]  491  649  330  368  460  439  584  438  423  511  723  344  271  143
      [15]  938  455  330  930  536  525  351  392  622  775  998  231  667  342
      [29]  338  797  285  981  889  604   50  877  666  101  890   33  647  666
      [43]  946  670  324   93  114  600  307  694  955  754  288  267  335  417
      [57]  938  604  347   42  334   13  417  361  729  712  656  373   26  857
      [71]  209   48  663  527  958  878  536  482  317  132  739  270  929   35
      [85]  266   74  570  679  912  271  543  906  101  435  437  959  613  621
      [99]  943   39  947  630   89  530  899  982  554  394  254  192  955  761
     [113]  847  461  602  746  334  860  930  377  763  192    4   63  532  575
     [127]  861  867  855  224  753  176   94  660  182  825  227  508   27  905
     [141]   80  432  649  477  207  369  886  298  631  457   72  350  537  384
     [155]  612  931  571  302   51  371  460  790  602  865  895  909  774   40
     [169]  774  716  309  160  927  580  280  117  562  685  151  145  299  793
     [183]  129   68  478  349  654  636  472  109  102  757  788  935  990  834
     [197]  285  305  412  284  561  908  763  935  872  668  670  942  742  475
     [211]  117  963  283   60  718  940  426  990  731  330  576  699   72  454
     [225]  645  873  991  178  463  944  348  657  311  526   69   70  173   95
     [239]  149  470  195  412  430  339  972 1000  543    8  294  957  220  286
     [253]  930  213  285  233  109   22  158  509  479  872  900  671  209  429
     [267]  721  152  583   27  430  874  703  134  679    4  737  308  461  602
     [281]  181  488  565  302   96  853  987  962  618  614  735  215   32  230
     [295]  367  270  524  703  671   64  356  400  444  365  294  665  278  651
     [309]  547  703  379  605  668  610  577  328  663  880  743  577  510  385
     [323]  147  729  966  166  206   62  559   71  682  494  861   98  177   36
     [337]  726  627  679  811  796  119  185  866  564  536  798  687  245  575
     [351]  217  897  349  612  559  585  372  786  573  760  988  137  878  266
     [365]  783  572  333  389   90  636  349  152  188  752  901  490  793  743
     [379]  886  672  462  525  555  598  129   60  851  647  676  980  670  494
     [393]  706  176  847  894  304   55  756   46  756  660  976  107  164  891
     [407]  655  816  490  617   89  264  256  625  626  565  384  680  323  384
     [421]  192  838  391  697  710  684  556  817  274  223  543  801  762  766
     [435]  896  572  724  993  275  539  569  721  181  362  493  256  724   58
     [449]  613  569  126  998  996   25  582  457  721  234  471  390  414  532
     [463]  376  738  837  149  899  503  305  842  773  381  542  467  398  238
     [477]  577  933  853  572  470   90  900   22  370  396   56  181   12  972
     [491]  289  418    6  212  772  616  625  788  693  418  903   20  813   56
     [505]  653   89  228  530  777  483  979  273  194  805  768  940  650  651
     [519]  425  928  552  573  436   48  292  486  952  811  455  601  707  351
     [533]  199  105   43  178  143  656  533  530  914  711  148   71  507  890
     [547]  783  766  322   17  221  672  645  879  147  999  399  466   58  968
     [561]  202  515  889  693  514  637  750  726  731  739  921  683  291  583
     [575]   10  791  335  604  622  632  902   74  530  645  106  587   59  524
     [589]  858  764  885  249  952  926  580  307  700  198  527  103  591  797
     [603]  839  986  139  115  683  839  527  361  627  477  852  278  915  853
     [617]  497  545  266   73  622   19  321  756  813  646  655  696  286  186
     [631]  400   63  392  716  810  972  416  450   91  136  845  954  849  584
     [645]  657  139   67  837  901  205  159  465  704  690  663  690   35  391
     [659]  241  679  568  462  671  740  239  483  159   69  347  188  196  701
     [673]    9  968  909   11  182  644  996  204  291  596  652  919  664  736
     [687]   18    7  548  494   69  483  429  640  589   12  429  624  320  666
     [701]  351  337  229  592  911  600  413  249  380   39  803  176   19  339
     [715]  735  667  654  529   22  292  341  576    4  731  520  298  877  289
     [729]  979   31  889  593  380  159  191  286  158  459  916  179  341  775
     [743]  405  449  314   54  122   58  238  677  123  657  501  726  146  379
     [757]  469  851   56  284  857  127  319  308  630  739  953  810    5  598
     [771]  581  234  194  703  889  994  935  590  363  975  532  570   74  178
     [785]  582  997  615  417  632   81  507   95  669  747  628  831  653  362
     [799]   97  221  623  868   40  725  633  557  574  522  681  789  508  629
     [813]   40    4   89  842  456  624  909  819  353   95  973  875  701   73
     [827]   40  943  716  589  553  773  721  312  218  985  399  608  635  897
     [841]  317  292  849  871  893  808  701  510  455    7   32  353  818  499
     [855]   60  984   97  394  845   92  843  416    1  101  365  333  637  974
     [869]  712  937   12  973  482  737   81  660  110  738   99  909  520  284
     [883]  290  183  497   88  576  387  410  344   60  780  493  233  805  420
     [897]   75  175  242    5  789  935   60  457  352  826  269  416  523  205
     [911]  339  303  798  262  641  435  843  621  186  962  876  228  751   23
     [925]  991  431  986   57  786  930  227  111  126  192  434  718  570  707
     [939]  280  404  971  573   10  100   19  151  709  588  163  213  580  721
     [953]  415   88  313  402  966  782  658  592  757  713   34  680  302  473
     [967]  796  903  898  239  144   48  651  874   29  635  832  336  182  710
     [981]  463  910  642  411  226  970  800  329  228  117  670  124  903  770
     [995]  950  902  779  764  118  149
    
    $resamples[[2]]
       [1] 180 354 675 733 156 616 122 843 748 311 818 680 408 847 656 232 355 730
      [19] 896 166 880 871 835  67 300 518 752  40 103  16 915 538 691 683 746 677
      [37] 858 755  19 491 826 805 692  60 758 573 344 449 613 853 709 855 254 199
      [55] 313 900  66 602  90 248 863 994 384 633 328 726 457 815 298 443 454 450
      [73] 835 868 401 844 162 753 523 615 269 661 923  31 733 100 532 819 684 572
      [91] 472 279 758 914 760 604 368 395  58 655 733 340 487 759 668 584 394  82
     [109] 581  46 349 173 937 442 527 800 517 673 686 124 556 760 200 251 701 408
     [127] 439 760 277  64 683 497 894 413 373 533 589 671  68 745 360 955 526 888
     [145] 164 728 987 780 503 897 668  79 326 317 315 684 506 537 657 994  40 317
     [163] 763 241 313 881 848 307 641 752 406 544 981 693 765 549 618  74 610 420
     [181] 989 127 810 276 232 797 844 483 879 410 675 320 626 973 815 778 598 414
     [199] 215 951  13 520   3 379 685 764 558 411 282 969  17 493 221 385  15 790
     [217] 516 266 975  64 761 391 410 880 486 122 726 524 165 468 792 113 351 673
     [235] 228 574 182 390 101 843 274 711 638 236 954 404 533 693 770 977 398 841
     [253] 649 880 242 505 459 113 917  35 443 245 386 756 578 823 683 262 627 665
     [271] 510 648 235 993 380 273 931 808 570  26 479 290 797 263 568  51 305 520
     [289] 744 705 978 270 238 400 917 228 119 171 985  36 378 807 720 114 940 998
     [307] 379  12 804 360 921  26 454 612 536 370 719 307 335 139 707 142 329 801
     [325] 887 160 511 702 873 198 688 903 338 838 560 877 840 895 105 647 753  58
     [343] 209 840 385 451 146 429 686 521 905 230 865  28 900 252 437 889 411 547
     [361] 765 143 375   2 780 273 430 360 589 516 276 495 599  71 265  77 580 151
     [379] 413 998 812 299  59 493 588 325 426 797 889 120 773 432  89 614 520 998
     [397] 177 269 989 246 737 850 453 587 379 812 903 227 283 229 160 523 893  66
     [415] 277 302 691 269 589 387 220 857 464 544  34  50  48 930 488  90 173 361
     [433] 187  85 462 438 837 453  15 908  54  85 161  44 938 339 436 157 419 157
     [451] 228 674 863 840 945 781 747 358 990 712 723 174 448 978 956 585 335 767
     [469] 804 459 239 137 663 302 445 125 308 986 758 854 862 379 396 165  31 300
     [487] 323 775 933 330 503 255 115 136 490 884 262 555 115 479 895 855 831 185
     [505] 772 208 155 297 460  36 560 298 977 666   5 760 967 663 524 443 922  81
     [523]  42 634   2 918 238 747 301 152 749 538 822 166 532 549 614  41 475 846
     [541] 310 157 749 787 971  12 538 590 656  97 529 419 383 242 129 241 766 813
     [559] 601 946 819 675  80  18 631 352 236  80 798 785  77 672 746 142 835  46
     [577]  12 871  70 668 985  56 383 328  58 985 233 796 228 735 340 325 562 426
     [595] 305 141 185 451 421 197  83 636 923 903 813 848 175 998 613 563 540 458
     [613] 908 223 559 650 448 655 478 456 634 533 697 217 564 755 230  58 403 981
     [631] 592 452 172 900 642 426 212 392 920 818 974 403 766 287  25 846 142 476
     [649] 786  56 218   9 397   8 581 419 613 696 472 502 619 629 353   3 153 322
     [667] 392 259 960 392 509 626 202 633 325 704 166 607 302 524 783 732 233 239
     [685] 971 647 110 540 264 582 959 192 452 124 962 774 884 178 407 573 186 894
     [703] 876 480 380 450 230 760 276 960 563  76 309 775 503 471   9 842 117 211
     [721]  21  68 406 575 679 449 288 321 987 306 428 888 736 990 638 800 609 189
     [739] 589 661 232 834 605 447 362 874 578 705 969 594 650 988 337 268 687 151
     [757] 138 526 150 155 140 853 682 226  98 621 203 586 214 542 695 471 836 959
     [775] 777 657 965  77 950 252  95 860 194 214 397 475 404  89 726 709 115 181
     [793] 507   7 962 244 993 509  66 852 879 629 956 609 369 968 780 409 958 399
     [811] 395 575 254 633 808 177  94 889 351 257 742 649 700 365 375 128  33  66
     [829] 723 354 429 790 833 932 178 498 865 919  48 602 659  69  13 656 290 952
     [847] 676 443 501 386 424 944  74 862 677 858 200 188 342 636 568 726 558 259
     [865] 408 345 263 126 307 384 830  45 542 665 505 165  64 710 706 347   3 656
     [883] 696 383  10 307 319  69 290 654 863 504 146  78 321 229 638 773 832  28
     [901] 900 798 411 291 775 183  24 448 404 694 979 601 905 110  59 247 223 248
     [919] 611 343 597  97 186 945 982 542 686 856 966 937 276 660 936 351 338 462
     [937] 166 328 358 746 603 883 613 200 846 651 744 925 360 184 655 780 401 669
     [955] 907 472 151 638 707 274 134 787 616 466 212 116  86  41 998 363 638 268
     [973] 134 486 454 786  29 259 651 652 773 896 779 480 969 910  49 361 565 168
     [991] 782 748 542 675 219 556 831 760 794 227
    
    $resamples[[3]]
       [1]  694  707  134  766  839  891  866  881   99  536  685  230  578  991
      [15]  323  788  861  460  285  819  435  578  543  703  606  925  636  784
      [29]  339  731   36  401  270  704  545   36  344  139  888  979  283  359
      [43]  787  678  493  691  519  184  366    5  797  160  983  327   80  248
      [57]  289  882  493  290  662  205  982  329  330   80  202  163  565  716
      [71]  122  975    6    6  363  757  752  782  149  160  519  591   67   85
      [85]    8  407  292  338  173  501  924  997  554  712  317   23  963  111
      [99]  590  941  146  971  473  993  457  153  835  666  394  794  892  632
     [113]  694  615  905    3   41  922  124  513  573  916  365   71  915  106
     [127]  311   31  590  789  532  343  498  639   92  819  112  978   95    8
     [141]  475  414  864  254  540   25  828  267  566  181  855  271  965  768
     [155]   45  391  717   73  297  679  985  386  727  182  119   12  957  762
     [169]   57  331  281  232  788  613   98  555  131   24  117   58  641  714
     [183]  930  221  679  174  839  466  775  122  949  989  905  799  309  947
     [197]  671  942   40  303  770  163  883  918  944  991  338  581  459  799
     [211]   61  373  286  391  770  845  585  168  699   68  928  841  335  395
     [225]  541  657  475  692  576  158  456  758  181  697  991  378  650  576
     [239]  973  614    1  958  477  112  881  341  490  362  509  859  617  228
     [253]  179  316   56  131  327  967  431  687  962  387  156  909  197  822
     [267]  231  387  840  962  832  133    9  196  270  750  356  313  962  861
     [281]   30  699   29  123  219  286  679  690  712  735  162  766  470  189
     [295]  317  290  435  625  798  749  675  257  810   54  671  351  958  600
     [309]  993  712  194  750  856  631  231  283  822  322  631  886  642  878
     [323]  482  329  989  791   80  923  870  789  950  131  519  807  525  161
     [337]   18  739  111  493  145  191  117  680  495  391  809  580  541  430
     [351]  215  897  758  892  697  424  323  181  571  143  227  481  283  925
     [365]  837  969  718  682  975  636  226  758  310  122  577  887   25  561
     [379]  848  655  100  292  792  415  819  517  167  840  243  571  306  107
     [393]  766  997  946  532  675  556  996  779  608   30  511   72  455  605
     [407]  707  114  149  289  461  905  490  781   97  621  318  129  104   27
     [421]  275  997  290  579  671  887  185  686  407  741  486  560  143  101
     [435]  345  509  238  673  349  817  878  620  751    2  555  919  986  866
     [449]   35   57  240  469  808  747  679  893  861  590  850  905  181  250
     [463]  441  655  675  754  932  375  622  837  850  697  446  363  184  186
     [477]  419  874  148  779  386  790  989  899  599  795  464    5  267  588
     [491]  891  904  398  716  360  331  736  206   50  976  658  974  500  818
     [505]  115   99  200   92  119  921   89  113  666  185  734  952  901  854
     [519]  668  758  258  770  373  221  811  622  725   33  107   17  213  284
     [533]  518  451  678  757  581  997  553  701   22  878  421  885  927  806
     [547]  167   95  293  696  795  878  384  236   85  509  729  558  759  598
     [561]  261  360   89  583  839  418  669   52  303  562  286  207  315   39
     [575]  533    5  688  397  352  512  213  775  489   24  677  495  565  545
     [589]  411  655  954   98  101  436  617  204  127   50  357  223  832  175
     [603]  746  223  972  988  165  491  715  671  793  697  434  801  139  119
     [617]   89  883  889  936  813  678  927  837  271  161  988  390  792  977
     [631]  949  134  314  680  461  286  942  624  126  571  636  354  849  425
     [645]  239  859  262  753  359  127  987  194  494  268  445  908  565  951
     [659]  573   86  213  737   92  447  888  449  661  834  238  720  790  507
     [673]  730  443  829   37  977  270  338  214  149  298   59  121  708   68
     [687]  998  424  565   24  649  964  318  525  659  201  943  366  261  528
     [701]  581  966   16  171  222  578  316  501  995   11  374  993  804  161
     [715]  592  409  462  863  450  345  953  688  598  872  727  367  296   97
     [729]  390  344  969  963  812  314  877  424  228  720  672  446  317  109
     [743]  374  654  561   82  202  309   35  447   26  561  217  472  442  329
     [757]   93  471  531  159   32  436  587  806  664   73  591  525  931  849
     [771]  855  303  703  968  651   75  213  590 1000  516  323  246  404  468
     [785]  410  431  886  274   85   38  809  751   20  515  386  482  691  772
     [799]  508  331  275  158  885  731   73  192  582   54  248   78  677  180
     [813]  799  885  295  842  695  318  177  907  367  101  362  379   25  348
     [827]  267  438   72   17  318   61  443  814  285  719  477  385   31  612
     [841]  532  311  477  320  429  733   68  202  735  865  851  427  960  127
     [855]  164  491   51  446  283  734  732  800  965  139  747  166  519  659
     [869]  915  456   43  549  590  794   27  437  842  799   64  370  583  922
     [883]  385  640  116  251  542  535  407  413   20  392  200  962  456  511
     [897]  334  746  202  183  803  241  249  927  956  269   10  256  923  858
     [911]  969  511  151  133  959  763  258  556   59  277  473  400  336  443
     [925]  860  642  776   29  998  843  771  627   60  427  209  446  574  288
     [939]  893  196  398  337  304  794  288   41  103   18  196  311  616  219
     [953]  355  940  456  930  582  453  431  221  906  829  761  168  251  701
     [967]  133  696  181  448  468  889  685   84  944  290  791  517  647  576
     [981]  437   10  680  856  353  361  456  960  782  874  425  185  429  716
     [995]  748  190  661  350  497  595
    
    $resamples[[4]]
       [1]   12   97  794  743  193  642  964  390  220   36   24  689  178  344
      [15]  934  993  407  350  808  662  112  973  183  969  354   45  574  154
      [29]  713  251  115  957  897  263  416  227  662   20  501  733  360  731
      [43]  574  161  614  802  990  732  722  383   19  646  217  762  320  908
      [57]  569   99  552   47  300  629  212  786   26   98  952  697  177  987
      [71]  513  492  118  419  662  445   11  253  452  733  690  528  202  532
      [85]  273  102  859  224  234  283  558  118  565  429  659  451  543  739
      [99]   71  170  486  551  192  288   13  328  867  594  812  824  344  195
     [113]  344  543  498  993  227  583   59  944  752  479  151  627  257  343
     [127]  548  723  317  880  889  243   47  514  200  694   29  850  610  860
     [141]  866  430  254  648  320  107  883  935  384  777  597    8  218  569
     [155]   25  234  763  349  410  867  715  315  275  630  496  937  691  203
     [169]  487  773  154  794  199  229  218  433  854  572    7  776  529  321
     [183]  517  643  725  161  416  276  659  721  471  487  425  131  243   11
     [197]  795   90  207  225  442  708  643  708  492  827  633  329  805  806
     [211]  381  544  541  558  944  295  621  177   42  702  428  903 1000  995
     [225]  707  587   13  556  400  636  899  744  649  589  529  228  393  616
     [239]  356  293  739  795    3  465  885  605  197  894  152  785  498  271
     [253]  339  378  494  754  412  821  418  690  166  331  731  819   14  464
     [267]  520  438  900   36  305   47  857  955  206  346  372  599  763  494
     [281]  100  871  565  881  499   96  240  902  200  849  938  841  918  296
     [295]  887  460  886  388  371  782  806  601  242  457  735  806  656  364
     [309]  518  253  265  623  700  814  777  442  747  718  752   37  916  580
     [323]  537  250  463  467  714  116  127  396  110  867  107  666  642  205
     [337]  695   44  306  987  788  985  206  875  318  995  853  240  312    8
     [351]  418   18  108  214  700  317   38  958  156  602  603  622  996  992
     [365]  201  267  409  371   78  825   30  907  500  330  901  984  370  490
     [379]  852  821  748  971   81  337  301  707  795   57  992  768  301  945
     [393]    1  259  487  262  634  571  356   71  547  257  250  922  414   41
     [407]  896  811  991   89  410  372  154  872  792   37  893  456   81  974
     [421]  617  227  451  436  591   28  379  548  318  729  694  261  638  359
     [435]  620  894  955  728  683  914  547  345  744  319  770  510  486  440
     [449]  331  103  670  797  331  732  186  818  192  779  966  139  126  872
     [463]  814  452   15  830  916  122  820  781  715  606  105  961  527  716
     [477]  242  870  681  743  223   36   56  695  944  821  602  478  521  345
     [491]  938  159  167  718  632  690  886  472  990  551   60  485  970  987
     [505]  115  365  365  315  711  450  405    1  416  724  830  594  477  674
     [519]  235  702  552  246  164  751  236  144   95  259  512  794   54  965
     [533]  430  622  905  462  654  446  232  255  525  878  326   82  327  636
     [547]   66   78  409  938  178  550  603  977  141  514  634  785  471  369
     [561]  288  599  465  446  716  650  258  141  646   97  900  466  240  313
     [575]  799  156   56  276  663  808  369  439  111  886  472  981  563  163
     [589]  377  260  798  179  484  482  530  912  631  235  354  239  256  346
     [603]  115  834  811  256  672  766  919  121  767  477   93  208  586  653
     [617]  322  373  582  815  710   75 1000  339  618  173  340   83  597  104
     [631]  393  572  149  428  406  283  467  530  163  739  345  727  281  623
     [645]  968  329  820  747  860  813  868  595  208  241  180  287  332  130
     [659]   89  994  842  696  311  968  661  667  969  523  211  920  726  497
     [673]  454  587  696  858  371  730  688  607  510  510  268  340  455  522
     [687]  940  461  666  385  109  437  369  450  681  741  135  528  222  274
     [701]  954  304  630  361  194  467   67  899   77  245  417  991  240  142
     [715]  969  543  615  931  160   63  488  969  161  387  958  147  417  988
     [729]   16  269  752  393  319  127  838  258  517  993    3  794  919  746
     [743]  368  800  172  549  678  929  162  406  138  343  407  448  207  774
     [757]  394  185  231  734  617  556  741  787  223  846  520   73  613  455
     [771]  781  369  772  994  531  160  479  618   88   35  244  630  789  951
     [785]  564  902  184  639  401   48  830   61  661  335  947  988  213  574
     [799]  247  178  148  140  225  480  397  779  762  468  368  690  868  896
     [813]  350  855  629  388   48  413   42  500  269  288  587  999  450  777
     [827]  730  991  448  784  831  408  380  559   54  305  904   21  250  852
     [841]  465  667  441  323  236  729  238  555  135  851   64  518  773  316
     [855]  155  296  559  222  493  988  338  802  429  210  990  231  451   85
     [869]  932  359  650  338  589  117  779   70  940  669  900  845  411  838
     [883]  576  525  433  309  232  167  498  322  774  880  360  799  685  600
     [897]  271  563   90  484  380  507  659  536  218  508  256  445  937  925
     [911]  276  269  778  667  414  117   95  135  261  300  326  166  395  677
     [925]  403  947  221  759  529   70  624   43   23  721  126  146  136  158
     [939]  810  274  985   75  709  470  221  866  635  132  540  527  188  493
     [953]  775  727  647  284  629  353  400  730   53  100  814  237  448   27
     [967]  608   80  852   33  968  728  222  565  347  272  920  111  700  660
     [981]  111  192  562    6  294  324  734  354  495  537  364  733  889  375
     [995]  949  297  807  199   11  401
    
    $resamples[[5]]
       [1]  565  837  416  271  105  280  176  217   97  933  111  804  834  416
      [15]  196  623  598  919  862  739  933  405  179  509  723  667  104  523
      [29]  896  299  392  983  856  532   68  549  286  694  338   97  817  256
      [43]  750  146  211  108  669  385  981   23  852  665  919  877  248  509
      [57]  480   62   91  717  333  750  704  734  766  922  621  158  284  715
      [71]  563  771  407  738  177  886   75  456  946  570  646  996  788  355
      [85]  521  886  238  712  104  452  569  321  945  781  511  283  809  689
      [99]  805  600  362  540  438  481  710  182  923  443  493  605  584  766
     [113]  429  938  246  254  976   58  122  380   29  550  294  792  978  670
     [127]  422  859  741   48  290   60  189  395  350  639  351  664  958  675
     [141]  803  693  324  204  316  854  810  362  155  700  454  895  957  700
     [155]  346  770  744  295  466  871  590   58  172  401   25  525  410  737
     [169]  720  985  595  536  881  706  604  846  258  824  710  428  643  851
     [183]   69  579  111  562  837  216  437  572 1000  177   76  353  656  950
     [197]  539  472  274    9  854   41  424   17   14  147  580  955  684   21
     [211]  733  108  188  113  816  201  625  591  360  322   25  311  752  335
     [225]  921  817  848  933  201  511  242  148  516   60  328  991  855  614
     [239]  580  523  396  885  416  620  114  619  853  652  252  799  927  148
     [253]  354  666  544  455  604   28  470  669  711  138  623  945  362   56
     [267]  259  376   34  758  586  499  134  289  528  601  447  528  685  653
     [281]  573   63  306  293  178  740  380  400  818  576  945  214  784  370
     [295]  979  129  463  462  179  691  470  855  458  167  596  639  654   64
     [309]  233  127  910  209  721  610  753  335  231  792  154  427  391  583
     [323]  968  888  182  650  834  781    9  908  249   17  698  640  191  937
     [337]  625  767  411  962  601  147  163  136  352  657  866  829    5  161
     [351]  649  354  751  623  182  779   31  226  470  979  749   78  583   59
     [365]  973   27  330  510  916  715  973  743  839  491  386  450  812  141
     [379]   63  242  379  120  833  931  482  757  843  899  708  330  274  490
     [393]  459  939  667  533  976  819  911  248   20  265  210  359  941  976
     [407]  493  596  290  229  849  473  448  223  484  498  553  627  314  335
     [421]  158  215  986  433  169  509  483  329  983  225  243  415  565   41
     [435]  146  590  354   35  528   18  256  533  906  139  783  850  479  486
     [449]  469  296  266  684  202  608  386   90   32   15   47   94  543  303
     [463]  327  406   66  228  327  146  169  327  933  201   95  957  460  427
     [477]  522  526  934  300  680  577  525  964  664  934  256   75  746  982
     [491]  485  654  662  499  577  468  336  267   45  865  344  678  525  622
     [505]  221   63  581  884  407  618  425  653  174  224  912  411  798  488
     [519]  835  913  334  374  168   22  747  633  173  723  121  173  663  320
     [533]  541  336  834  510  913  166  701  994  347  521  388  461  625  702
     [547]   46  278  626  334   75  295  465  119  654  549  878  653  702  508
     [561]  855  934  262  670  255  808  171  470  446  624  982  419  738  924
     [575]  185  907  506  772  546  165   38   38  171   38  200  350  972  657
     [589]  239  638   65  570  666  868   77  424  496  645   16  387   27  947
     [603]  940  689   25  549   43  432  350  553  313  160  922  708  737  508
     [617]  834  894  303  748 1000  803  898  740  483  927   13  701  479  611
     [631]  864  121  347  251  915  552  537  996  342  255  336  808  625  619
     [645]  615  167   70  359  764  680  193  753  325  983  888  251  901  416
     [659]   50   44  464  181  470  859  183  487  708  791  734  273  680  301
     [673]  117  158  120  552  476  718  617  889  643   60  355  244  781  479
     [687]   45  169  599  459   60  732  525  491  977   77  173   16  487   33
     [701]  631  605   79  644  761  634  784  653  120   80  940  547  817  232
     [715]  647  686  495  139  376  635  713   68  884  155  463  290  769  814
     [729]  961  178  478  726  678  675  981  415  120  893  427  540  483  116
     [743]  534   36  479  516  304  991   92  472  820  468  918  226  325  197
     [757]  622  950  177  991  199  405  872  161  905  719  904  165   11  615
     [771]  418  555  600  635  304  589  272   65  596  708  369  302  365  440
     [785]  880  724  391  758  997  217  232   11  299  590  243  131  399  752
     [799]  981   50   77  596  373  803  226  399  195  438  444  725  255   45
     [813]  492  346  236  781  652  720  123  824  536  260  526   82  607  656
     [827]  268  602  478  526  592  330  941  232  794  335  851  418  446  745
     [841]  269  714  557  355  288  646  175  958  715  465  407  790  848  129
     [855]  468  300  286  208  254  236  372  332  769  615  912   78  473  969
     [869]  898  866  750  297  355  352  863  514   72  327  147   67  306  805
     [883]  820  483  508  606  413   20  415  638  929  625  107  151  307  856
     [897]  430  921  891   16   87  166  581  306   57  603  845   95  968  237
     [911]  363  622  470  367  465  378  601  312  560  111  252  615  357  164
     [925]  728  921  262  604  649  383  781  469  570  569  924  376  361  139
     [939]  703  928  958  260  516  395  333   59  160  494   89  596  719  539
     [953]  109  589  903  452   81  569   15  802  759  646  788  343  806  806
     [967]  391  364  167  133  771  786  469  877  624   30  475  559  908  209
     [981]  174  202  159  107  475   56  203   27  787  212  175  530  863  816
     [995]  895  630  720  940  817  798
    
    $resamples[[6]]
       [1]    6  687   69  743   73  130  106  691  284  255  738  350  259  173
      [15]  958  485  564  218  974  505  575  503  115  653  749  203  648  230
      [29]  854  246  588  455  919  203  541  393  134  502  272  936  947  667
      [43]  858    7  228  901  822  647  235  801  161  695  853  753  724  301
      [57]   98  738  720  647  968  966  712  434  455  283  736  608  903  329
      [71]  331  656   28  969  955  277  872  323  318  478  545   13  692  298
      [85]  734  309  565  638  461  358  897  381  995   49   20  229  116  773
      [99]  792  163  889  816  601  916  633  992  969  135  253   88  294  304
     [113]  926  658   96  681  577  764   80   86  865  749   90  288  343   76
     [127]  269  592  512  441  964  124  635  670  821  185  722  338  455   33
     [141]  224  806  257  286  496  192  947  187  152  125  174  801  242  570
     [155]   87  832  351  693  409  609  435  146  166  698  285  381  841  314
     [169]  938   61  981  804   39  255   78  789  488  796  983  440  655  295
     [183]  893  806  649  413  722  507  172  148  410  753  171  707  389  442
     [197]  570   14  325  361  810   95  130  117  221  976  906  268   44   10
     [211]  227  782  316  856  372  512  392  797  298  385  471  566   34  612
     [225]  751  374  283  583  811  987  682  558   18  418   99   76  373  111
     [239]  910  170  657  851  996  276  152  214  245  352  983   69  339  933
     [253]  187   54  871  763  966  138  677   41  349  265  275  121  967  180
     [267]  616  211  787  628  325  226  680  322  201  991   30  225  868  395
     [281]  984  889  537  824  211    1  148  646  571  137  269  233  773  277
     [295]  300  778  792  454  974  495  219   18  934  589  298  507  838  588
     [309]  947  949  764  320  826  589  229   98  918   74  355  193   55  952
     [323]   47  360  864   10   54  679  716  336  619  131  837  370   89  902
     [337]  207  499  446  763   84  871  927  117  897  482  307  575  269  843
     [351]  265    6  955  799  121   22  298  224  842  395   85   37  990  403
     [365]  501  194  355  246  521  730  959  634   93  411  914  328  106  739
     [379]  276  910  977  604  710  327  517  840  170  945  567  695  962  822
     [393]  468  147  541  589  325  869  947  171   44  740  411  796   51  275
     [407]  543  581  482   77  282  865  339  862  799  813  225  418  728  764
     [421]  235  764  957  917  769  567  576  725  783  638    8  490  430  525
     [435]  848  515  261  504   14   11  195  841  250  830  395   72  644  223
     [449]  944  605  386  170  265  771  386  598  538  925  452  251  551   25
     [463]  943  873  217  671  189  728  651   69  128  680   95  695  779  475
     [477]  336   84  985  165  495  624  101   16  327   38  475  532  280   41
     [491]  101  778  190  552  350   62  759  652  537  278  828  823  604   21
     [505]  742  174  328  378  919  272  449  967  762  745   29  393  866  513
     [519]  567  710  281  846  929  184  473  269  620  618  666  401  292  449
     [533]  500  756  690  232   90    4  900  133  587  993  617  476   57  109
     [547]  173  746  986   30    6  493  984  757  241  613  486  555  658   66
     [561]  300  860  930   97  883  962  969  693  551  883  969  516   40  282
     [575]  270  615  829   99  202  458  382  689  747  457   53  637  413   42
     [589]  980  211  340  645  369  615  702  166  349  146   45  967   57  606
     [603]  449 1000  379  543  631  473  197  374  978   58   91  173  326  978
     [617]  662   90  972  487  181  834  560  702  442  418  500  578  421  567
     [631]  783  947  317  214  862  423  391  627  802  746  319  303  927  482
     [645]  996  940  452  677  134   15  616  819  172  857  803  819  479  112
     [659]  695   79  187  864  714  459   22  958  575  183  454  400  488  368
     [673]  937  415   33  266  393  523  324   26   85  960  844  603  821  782
     [687]  157  741  915  443  344  150  231  954  958  116  195  619  921  248
     [701]  152  420   51  812  700  603  850  406  414  389  731   85  587  213
     [715]  903  467 1000  203  132  696  827  661  719  498  211  869  599  510
     [729]  295  511  287  766  517  805  206   13  604  429  544  733  722  259
     [743]  965  712  147  788  480  778  564  749  919  931  507  221  750  150
     [757]  256   94  873  328   89  116  260  298   72  981  417  835  506  372
     [771]  206  796  110  547  960  760  202  508  993  240   53  813  866  523
     [785]   91  840  420  276  657  736  560   62  298   84  687  772  255  320
     [799]   42  567  752  879  961  910  433  729  651  765  714  381  430   16
     [813]   89  946  885  608  728  664  887  806  270  698  846  508  405  827
     [827]  216  100  268  362  372  737  855  759  695  322  237  558  134  171
     [841]  628  574  563  918   17  282  972  289  324  475  163  224  629  615
     [855]  945  327  796  866  153  729  759  364  619  969  209  367  694  455
     [869]  577  680  684  894  168  368  254   45  198  473  295  544  117  941
     [883]  753  351  637  474   93  313   81  260  982  723  720  863  578  792
     [897]   34   55  495  225  215  247  203  333  631  656  678  112  889   25
     [911]  276  254  485  587  902   41  378  804  242  487  699   73  428  143
     [925]   11  801  572  751  529  148  148  216  653  572  736  396  537  877
     [939]    4  559  226  464  456  239  942  360  448  620   64  682  390  458
     [953]  432  494  531  907  216  258  427  192  431   82  629  403  547  200
     [967]  632  166  713  564    5  599  547  310  805  641  345  961  581  354
     [981]  227  603  286  396  947  181  921  753  429   31  604  978  862    3
     [995]  649  416  761  100  177  496
    
    $resamples[[7]]
       [1]  316  312  827  344  165  748  642   86  128  228  292  596  273  399
      [15]  899  363  940  770  857  251  332  227  722  665  429  388  545  378
      [29]  950  556  973  802  232  111  309  919  826  338  430  434  726  578
      [43]  192  983  845  254  851   80  362  865  618   58  617  310  438   61
      [57]  388  777  470  857  815  861  416  872  724  683  670  918  402  856
      [71]  504  768  658  559  918  812  641  310  455  194  821  442  297  305
      [85]  437   65  949  465  611  433  139  914  323   65  234  640  952  478
      [99]   83  376  312  863  757  317  608  552  542  290  925  928  242  187
     [113]  311  196  166  716  435  777  362  921  755  441  465  675  424  832
     [127]  362  948  390  332  772  398  624  198  877  374  810  560  128  705
     [141]  589  886  422  159  523  949  434  266  534  413  491  232   49  841
     [155]  248  779  816  136  616  435  888  284  153  275  985  698  428  847
     [169]   12  405  238  948  388   62  336  627  395  642  740  435   72  830
     [183]   56   42  830  578   76  713  101  196  856  730  851  759  718  474
     [197]  513  669   94  392  626  903  706  918  525  394  448  374  502  338
     [211]  587  562  286  505  957  274  561  137  802  924  774  924  757   35
     [225]  920  503  720  287  572  233  429  750  597  939  794  273  934  982
     [239]   97  169  446  342  823  803  429  423  222   15  230  515  351  359
     [253]  592  704  804  302  967  257  574  589   16  564   21  275  873  938
     [267]  748  302  944  983   53  729  326   32  994  573  739  856  578  189
     [281]   45  779  193  119  544  547  203  750  927  567  321   48  118  403
     [295]  314  167  635  325  682  164   91  240  323  880  127  131  156  367
     [309]  722  953  149  117  354  780  312  860  222  910  352   86   64  583
     [323]  551  329  353  422  598  759   64  796   99  491  973  952  854  762
     [337]  384  549  732  827  972  777  619   60  491  882   51  279  745  604
     [351]  303   88  780  253  203  537  192  771  651   54  367  192   10  566
     [365]  457  122  914  587  468  674  975  898  118  124  330  251  628  235
     [379]  596  505  653  983  578  620  338  927  975  569  737  270  239  174
     [393]   70  553  517  315  247  810  305  565  647  722  935  519  617  986
     [407]  453  315  971  651  861  393  638  781  699  743  959  316  445  344
     [421]  653  115  661  674  665  903  638  159  196  305  708  393  810  686
     [435]  795  933  489  136  891  204  224  862  207  584  373  692  102  439
     [449]  809  901  718  267  661  471  235  790  101  203  224   95  790  656
     [463]   96  662  699  905  813  204  811  468  181  430  437  742  379  342
     [477]  312  316  445  514  828  275  951  312  366  825  969  875  970  132
     [491]  200  620   46  637  666  148  125  628  382  452  271  651  869    5
     [505]  709  650  665  804  727   60  722  680  548  922  607  468  221  386
     [519]   79  647  106   12  384  456  242   81  561  610  401  314  229  975
     [533]  131  278  766  935  895  393  349  560  732  566  879  187  322  791
     [547]  300  601  171  947  224  421  421  898  334   97  239  641  113  604
     [561]  823  829  726  713  847  539  393    6  676  647  710   64  265  830
     [575]  156  631  484  236  729  520  853  197   15  652  972   79  776  371
     [589]  345  285  922  536  346   11  576  325  607  710  301   34  962  783
     [603]  587  379  887  909  756  385  899  284  661  772   35  470  513   69
     [617]  462  132  272  246    5   93   12  247  198  672  579  612  377  246
     [631]  677  991  508  504   19  121  151  430   16  689  191  933  649  310
     [645]  771  236  881  471  659  969  378  701  132   55  350  862  274  131
     [659]  673  398  996  393  691  481  472  655  527  560  879  440  800  560
     [673]  114  834  970  348  695  818  633  950  451  976  579  638  223  887
     [687]  638  701  601  461  780  195  477  662  289  940  338   63  600  446
     [701]  647  689  431  317  709  919    5  170  211  751  491  948  726  375
     [715]  712  164  754  635   67  620   60  214  879  311  696  570  532   95
     [729]  121  370  578  978  460  953  393  136  850   79   78   95  393  353
     [743]  490  180  972  852  746  958  575  776  557  353  394  881  861  428
     [757]   96  297  564  992  554  971  610  573  459  710  545  969  945  885
     [771]  677  510  990  835  972  392  842  650  436   52  890  841  230  227
     [785]  786  568  245  397  680  605  303  572  311  939  772  651  842  161
     [799]  693  710  973  325  251  962  294  191  382  993  748  191  869   41
     [813]  982  255  943  501  304  308  283  569  828  690  800  704  577  910
     [827]  816  108  813  176  335  207   52  114    8  616   92  129  444  637
     [841]   41  836  208  621  424  494  539  693  605  775  291  517  250   14
     [855]   22  185  303  708  486  944  752  684  776  268  822   23  624  796
     [869]  411  578   32  771  780  361  375  592  334  733  724  182  606  941
     [883]  879  281  672  773  562  421  400  298  195  793  194  893  229  136
     [897]  824  287  393  516  390  594  484  298  969  694  483  922    1  868
     [911]  950  345  353  776   35   39  519  834   32  163  839   55  336  946
     [925]  787  721  488  992  972  427  731  250  354  443    3   13  868  480
     [939]  731  501  803  748  262  772  507  851  527  791   85  838  979   54
     [953]  447  518  387  978  719  621  813  879  981  286  571  782  314  663
     [967]  200 1000  241  304   73  573  351  354  476  120  472  530  383  575
     [981]  918  177  779  230  605  389  645  242  573  515  237  252  599  123
     [995]  281  973  966  773  998  650
    
    $resamples[[8]]
       [1] 209 672 776 906 843 502 332 477 169 457 194 425 918 764 494 484 544 739
      [19]  38 970 863 320 429 298 697 285 233 748 467 527 792 836 833 329  18 453
      [37] 738 784 793 177 598 230 787 525 290  83 731 989 133 599 627 207 290 257
      [55] 870 534 900 185 240 116 809 736 684 392  27 247 337 421 921 946 973 353
      [73] 430 684 715 784 633 345 943 443 682   7 958 669 577 115 722 306 728 750
      [91] 839 756 349 924 827 404 191 935 641 858 741 455 547 163 718 813 269 111
     [109] 508 770 616 986 584 670 670   6  90 157 281   4  87 478 847 520 224 481
     [127] 525 891 315 555  11 797 683 536 359 597 156 550 986 215  18 918 692 520
     [145] 520 655 209 397 766 282 131 754 428 921 718 210 322 656 346 919 760 276
     [163] 595  43 115 922 476  53 266 325  37 623 639 537 233 932 682 140 715  93
     [181] 202 919 858 341 801 509 305 131 243 499 737 208 445 122 423 667 381 630
     [199] 875 219 169 954 340  68  17 330 384 236  76 451  88 422 250 964 190 625
     [217]  33 352 975 331 974 837 177 862 836 301 446 626  31 844  61 583 924   5
     [235] 570 998 986 475  15 212 358  51 934 754 952 728 793 564 367 224 490 384
     [253] 826 575 768 404 530 710 863 113 914 890 179 186 496 673 841 169 519 620
     [271]  43 318 771 198  52 268 501 492 841 286  98 165 483 698 725  76  76 201
     [289] 704 185 321 922 759 673 476 623 547 626 521 935 971 190 176 417 342  73
     [307] 982 968 856 624 286 465 921 662 917  59 308 697 479 768 205 148 107 853
     [325] 129 551 760 976 362 678 236   3 889 911 284   8 555  25 794 451 445 473
     [343] 194 586 387  49 168 928 103 553 493  49 890 355 144 996 186 351 426 572
     [361] 320 318 899 994 752 373 525 887 205 268 269 933 504 425 907 357  16 104
     [379]  64 250 658 677 977 164 404 218  16 596 795 195   2 574 369 264 286 670
     [397] 329 890 794 104 929 492 684 528 247 787 300 633 213 601 145 337 799 212
     [415] 927 950 877 281  52 619 582 504 502 395 783 688 541 231 198 247 894 764
     [433] 601 532 120 830 551 626 351 507 737 905 567 698 978 762 253 330 786 644
     [451] 724 942 469 989 757 586 975 991   1  58 650 443 669 869 889 616 671 764
     [469] 334 132 578 778 982  68 119 596 673 177 862 765 894 249 251  90 582 251
     [487]  32 739 950 603  87 626 910 214 523 298 292 952 137 878 233   2 733 654
     [505] 145 805 169 266 319 837 812 928 969 861  97 401 537 724 867 803 349 940
     [523]  12 373 569 148 371 354 452 879 720 952 474 413 388 954 636 421  68 571
     [541] 185  73 379 893 487 879 367 168 862 517 288 958 607 822  86 194 644 768
     [559] 336 549 271 334 815 202 385 866 184 209 382 874 183 549 711 181 530 577
     [577] 320 294 987 477  34 790 590 306 261 232  21 349 608  73 575 669 689 820
     [595] 261 622 233   5 995  28 436 371 442  56 302 886 743 380 592 988 821 350
     [613] 501 198 969 319 503 494 733 606 614 304 132   8 957 245 646 481 121 378
     [631] 249 955 741 131 185 228 950 472 694 854 806 690 812 619 138 877 150 482
     [649] 529  46 808 394 806  96 380 916 295 820 167 600 527  85 433 341 323 875
     [667] 765 991 991 770 225  76 567 571 115 883 975 449 428  57  23 857 409 712
     [685] 111  97 990  49 821 609 894 712 853 859 510 288 838 728 397 509 864 600
     [703] 703 564 954 708 900 571 342 130 464  33 545 138 444 604 679 925 689 627
     [721] 779 115 211 611 133 247 955 513 125 218 847  64 484 913 822 923 726 702
     [739] 902   4 683 983 878 460 120  12 716 432 128 684 903  24 423 768  32 261
     [757] 619 110 980 888 842 517 251 826 745 478 346 900 424   7 993 322 606 122
     [775] 147 616 933 133 858 682 366 951 438 749 445 982 995 652 593 333  39 816
     [793] 913 537 786 661 103 248  25 849  96 789 677 280 950 335 454 235 504 830
     [811]  83 168 211 708 763 695 795 764 939 232 515 560 888 840 200  30 800 727
     [829] 724 754 806 921 453 221 676 486 633 112 384 893 119 757 831 272 511 165
     [847] 919 603 612 925 493 673 984 940 530 519 795 360 860  28 508 329 167 127
     [865] 251 400 287 102 687 936 680 276  97 714 753  72 696 652 392 334 698 147
     [883] 783 821 936 879 892 164  58 657 823 808 978 530 329 544 306 258 136 719
     [901] 961 709 195 222 202 163 279 301 488 739 895 425 880 846 308 852 873 723
     [919] 639 921 439 321 531 157 947 546 333 394 660 625 220 376 901 791 978 800
     [937]  55 420 186 919 845 235 724 719 373 386 251 587  24 670 205  89 264 415
     [955] 240 164 652 181 996 805 169  29 225 759 734 545 682 385 862 273 199 420
     [973] 733  97 385 192 682  94 308 843 823 848 393 108 943 881 375  28 989  60
     [991] 217 941 668 952 297 970   2 146 571  58
    
    $resamples[[9]]
       [1] 118 108  72 667 359 137 900 240 508 751 731 152 266 603 537 550 174 373
      [19] 880 608 267 274 135 924   5 198 451 863 352 346 395 878 873 109 871  92
      [37] 851 205 300 411 145  73 960  89 436  77 118 931 707 132 892  45 948 276
      [55] 361 897 164 138 920 526 279 577 777 331 223 916 306 204 400 719  70 727
      [73] 729 416 520 701 165  21 846 415 625  87  60 227 788 204  45 376 705 685
      [91] 614 829 162 470 496 914 871 153 555 751 496 876 714 539 162 609  22 280
     [109] 456 688 431 874 958 473  60 391 808 750 639  17 909 325 380 584 556 707
     [127] 796 624 314 936 501 202 157 257 728 211 288 729 547 523  42 408 571  42
     [145] 242 895  21 264 625  61 720 432 300 430 505 886 791  95 610 227 835 988
     [163] 989 105 574 563 734 719  89 381 233 963 829 812 197 833 234 298 117 163
     [181] 469 168 670 932  17 723 601 708  51 341 806 356 187 486 351 652 485 858
     [199] 383 313 566 873 199 708 993 529 549 790 957 353 707 914 877 371 403 941
     [217] 303 603 397 447 329 393 764 704 373  28 255 521 181 145 209 900 635 232
     [235]  11 444 610  83  13 845 990 403 333   9 206 465 713 430 749 539 330 109
     [253] 355 247  64 228 833 434 372 113 704 543 338 981 353 402 605 567  41 898
     [271]   5  70 820 967 784 286 606 699 440 690 594 778 599 478  32 259 166 997
     [289] 428 118 466  71 700 660 725 972 134 415 473 273 714 409 192 910 581 612
     [307] 330 463 168 694 649 395 892 212 153 296 422 865 913 328  89 787  41 745
     [325] 946 260 352 668  90 992  25 976 809 893 617 533 257 999 700 781 620 205
     [343] 314 252 730 367  63  59 118 311 114 258 521 995 110 512 795 348 567 856
     [361] 564 332 247 256 704 788 655 896 304 518 721 891 572 794  18 574 705  41
     [379]  89  45 215 245 161 330 368 255 858 774 797 340 618 244  87 862  66 771
     [397]  84 821  30 942  58 568 256 725 965 732  64 158 666 323  45 609 158 419
     [415] 277 943 680 128 505 813 687 916 643 698 503   2 964  59  15 858 228 175
     [433] 195 657 335 636 446 585 487 565 622 595 787 631 872  82 911 581 462 655
     [451] 965 694 303 520 908 814  32 520 642  94 565 628 861 958 690 272 105 717
     [469] 121 436 262 677 124 102 705 547  60 328 732 594 679 277  22 394 160 943
     [487] 806 844 790 168 816 741 532 955 860 920 968 716 733  13 867 383  42 561
     [505] 374 694 871 688 598  63 244 758 458 614 190 318 261 823   3  81 295  25
     [523] 661 689 926 593 666 727 399 462 640 117 687 250 589 327 905  85 935 685
     [541] 585  47 649 853 664 155 120 365 168 474 231 159 210 267 261 686 973 443
     [559] 629 119 877 845 840  52 636 506 700 952 128 766 839 618 279 116 698 881
     [577] 566 247 108 570 849 172 845  40 311 297 125 899 660 489 272 738  66 117
     [595] 430 842 119 116 133 116 837 232 169 335 982 129 554 221 146 800 864 424
     [613] 341 209 943  16 853 815 199 177 201 640 528 808 245 710 139 156 326 397
     [631] 553 607 101 704  80 441 986  51 351 507  60  10 289 405 445  28 926 445
     [649] 585 178 469 118 356 932 507 463 879 956 179 152 358 843 140 352 198 424
     [667] 715 604 940 612  64 494 331 369 601 659 393   9 301 535 912 554 538 401
     [685] 215 845 327 691 247 354 211  13  23  88 797 791 300 560 367 565 813  78
     [703] 323 621 779 372 580 303  23 169 393 202 173 147  86 489 747 399 273  95
     [721] 826 259 623 488 244 528 925 581 534 235 683 658 683 779 879 717 612 458
     [739] 144 256  14 377 494 342 380 431 564 431 145 744 882 962 235 890 225 603
     [757] 318 957  67 740 353 248 688 453 502 493 457  45 332 288 416 132 397 838
     [775] 416  14  39 578 471 913 701 398  99 322 122  95  97 100  76 599 265 869
     [793] 276 301 397 676 984 492  94 157 689 462 501 916 252 163 487 701 534 979
     [811] 998 698 113  30 759 413 461  57 135 462 115 574 900 591  55 116 939 365
     [829] 672 317 931 499 371 896 428 936 673 145 915 485  11 944 165 247 116 778
     [847] 216 885 834 901 569 850 128 386 520 158 275 664 269 221 178  15 432 543
     [865] 612  87 981 381 537 509 606 905 824 716  92 338  93 670 894 868 296 722
     [883] 341 298 273 770 803 520 655 159 683 811 646 743 717 905 709 490 385 139
     [901] 161 398 348 465 424 946 931 943 974 837 639 107 455 565 131 545 381 311
     [919] 506 247 776 377 356 786 922 472 244 222 426 742 455 910 360 723  16 244
     [937]  28 770 733 266  93   1 772 276 488 340  84 673 345 437 710 790 493 427
     [955] 817 561 138 794 809  79 979  33 232 723 971  82 498 703 375 803 852 512
     [973] 799 337 434 548 448 426 157 554 931 174 222 359 734 318 690 372 567 254
     [991] 210 843 422  52 711 931   5 695 299 700
    
    $resamples[[10]]
       [1]  838  838  536  806  502  749  597  264   48  628  663  658  647  466
      [15]  412  231  752  119  564  398  380  435  832  470   41  342  120  527
      [29]  307  508  106  155   17  189  583  552  864  147  529   86  396  967
      [43]  976  368  934  209  933  277  856  297  705  257   71  973  772  279
      [57]  147  304  800  936  140  698  373  478  759  707  986  668  925  271
      [71]  488  977  692  544  554  309  670  448  223  176  129  795  426  494
      [85]  581  173  251  164  762  417  538  536   89  523  488  809  327  687
      [99]  277  305  627  222  701  123   52  499  288  426  348  808  463  312
     [113]  195  756  668  594  170  100   50  416  120  994  900  611  411  590
     [127]  609  981   11  905  118  135  904  165  296  413  662  537  114  392
     [141]  911  337  207  489  372  576  681  193  956  640  935  166  937  348
     [155]  498  240  577  299  891  960  994  742  158  697  542  957  656  118
     [169]  194  678  319  150  106  828  656  877  399  504  378  111  478   73
     [183]  248  147   33  590   20  303  246  949   39  396   14   69  345  152
     [197]  590  988  857  705  164  614  577  778  204  430  937  722  890  626
     [211]  937  700  842  634  511  323  675  311  824  968  418  753  929  581
     [225]  587  912  466  170  870  857  319  699 1000  685  325  751  137  769
     [239]  127  398  297   36  339  550  409  817  148  635  262  368  567  500
     [253]  713  308  521  423  766  129  737  682   14   15  217   23  446  756
     [267]   28  254  993  111  857  477  833  974  165   72  297  957  255  167
     [281]  180    7  483  237  861  962  489  125  951  561  561  676  131  172
     [295]  793  840  933  902  659  269  893  524  906  997  900  784   60  758
     [309]  613  615  868  907  811  406   38  668  474  614  316  572  536  405
     [323]  150  125  897  809  351  456  403  325  258    1  375    3   92  874
     [337]  838  384  510   19  368  687  803  284  834  589  701  851  697  135
     [351]  717  234  661  410  184   34  471  152   53  339  768  151  552  233
     [365]  990  266  935  330  836  479   46   46  127  573  885  114  317  822
     [379]  523  563  414  631  648  561  684  323  213  104  600  388  647    5
     [393]  966  798  778  700  156  241  493  279  614  234  852  588  645  262
     [407]  350  630  675  106  276  374   13  909  966  854  369  692  305  413
     [421]  673  208  121  875  346  580  999  687   88  947  386  112  612  656
     [435]  284  938  987  844  920  195  707  389  835  115  641  454  346  169
     [449]  892  265  838  112  272  826   42  947  384  169  167  622  636  717
     [463]  354  494  298   83   91  477  819   95  886  436  878  995  826  349
     [477]  160  879  134  564   64  719  443  696  931  889  563  523  805  681
     [491]   61  474  583  164  884  638  319  106  772  696  715  159  198  215
     [505]  130  660  865  305  997   21  138  509  475  989  791  691  694  318
     [519]  246  437  384  332  388  787  486   35  669  909  999  964  762  689
     [533]  888  562  791  948  350   63  569  716   87   33  288  637  148  466
     [547]   16  574   67  982   63  900  544  891  864  834  541  772  552  750
     [561]  438  493  660  877  604  788  291   80  331  573  166  549  711  513
     [575]  153  772  628  306  979  449  406  773  364  436  770   40  800  566
     [589]  751  720  466  593  345  228  135  508  838  530  787  907  485  136
     [603]   56  172  427  282  944   92  717  225  999  664  894  916  487  474
     [617]  555  887  937   42   98  241  454  333  919  428   75  583  961  443
     [631]   12  820  276  411  352  172  195  425  365  444  562  179  625  661
     [645]  174  793  673   81  338  322  637  444  859   37  585  504  536  139
     [659]  898  143  431  118  215  759   17  648  277  852  218  489  777  881
     [673]  276  861  766  585  403  396  853  281  607  879  888  218  883  398
     [687]  517  604  573  919  548  757   43  659  620  774  768  169  211  459
     [701]  192  674  525  721  858  750  171  177   40  398  476  291  512  893
     [715]   74  146  230  164  457  771  851  326  463  732  183  359   69  944
     [729]  818  822  880  733  218  883  711  514  867  465  945  934  659  894
     [743]   51  322  376  563  215   18  577    4  765  464  794  694  185  113
     [757]  378  849  105    3  653  875  662  516  505  840  732  881  749  374
     [771]  952  508  327  111  185  126  482  325  596  584   25  186   60  958
     [785]  472  695  427  676  717  535  163  100  567   62  269  402  164  187
     [799]  599  808  453  190  245  102  149  645  372  862  579  288   91  876
     [813]  336    6  527  466  708  277  995  967  749  749  694  623  713   69
     [827]  728  127  109  467  759  609  398  625  870  107  665  720  973  498
     [841]  318  215  795  831  362  538  815  131  635  406  419  592   27   69
     [855]  219  370  125  141  357  965  564  174  356  622  976  773  389  628
     [869]  197  295  480  498  501  640  323   83  240  262  795   21  467   20
     [883]  521  275   26  568  196  155  823  999  190  956  670  703  124  785
     [897]   77  844  716  583  300  240  893  734  277  832  272  106  644  145
     [911]  697  744  651  822  838  173  367  318  788  457  952  297  903  287
     [925]  217   18  417  237  768  107  512  353  961  305  691  500  994  355
     [939]  911  742  180  922  756  468  863   67  919   41  785  208  632  209
     [953]  957  615  929  464  862  892   68  962  421  531  136  360  707  815
     [967]  546  866  196  637  466  439  175  908  785  264  464  610  824  805
     [981]  547  901  565  518  388  571  461  874   95  674   80   91  389  823
     [995]   52   60   49  698  146  209
    
    
    $original
    Outlier-Robust 2SLS Model 
    Initial estimator:  saturated 
    Reference distribution:  normal 
    Two-stage Least-Squares Model: y ~ x1 + x2 + x3 + x4 + x5 | x1 + x2 + x3 + z4 + z5 + z6 
    Iterations:  2 
    Final selection:  Outliers found:  34     Outliers proportion:  0.034 
    
    attr(,"class")
    [1] "r2sls_boot"

---

    $boot
       X.Intercept. x1          x2         x3         x4        x5  m gauge  r
    1  -0.204681972 NA  0.03502074 0.66823217  0.9385139 0.4326476 m2 0.034  0
    2  -0.636506558 NA -0.57656157 0.02982617  2.1319602 0.2395394 m3 0.029  1
    3  -0.095681750 NA  0.24067648 0.85963714  0.5096375 0.4855097 m2 0.037  2
    4  -0.107743885 NA -0.08834303 0.47120246  1.1076975 0.3853691 m1 0.037  3
    5   0.197502322 NA  0.60852001 1.28133526 -0.1281401 0.4305294 m2 0.019  4
    6  -0.166551568 NA  0.44712120 1.04132538  0.2558132 0.4869656 m2 0.036  5
    7  -0.003687986 NA  0.35646868 1.12104142  0.2889508 0.4534283 m4 0.045  6
    8  -0.382315267 NA -0.08852382 0.51214983  1.3652876 0.3679794 m3 0.028  7
    9   0.100209716 NA  0.91537500 1.41331995 -0.3796446 0.6174150 m3 0.013  8
    10 -0.290801687 NA  0.22976280 0.72810698  0.7573736 0.4532208 m1 0.035  9
    11 -0.274915574 NA -0.54230900 0.12813735  1.8062160 0.3546880 m2 0.048 10
    
    $resamples
    $resamples[[1]]
       [1]  491  649  330  368  460  439  584  438  423  511  723  344  271  143
      [15]  938  455  330  930  536  525  351  392  622  775  998  231  667  342
      [29]  338  797  285  981  889  604   50  877  666  101  890   33  647  666
      [43]  946  670  324   93  114  600  307  694  955  754  288  267  335  417
      [57]  938  604  347   42  334   13  417  361  729  712  656  373   26  857
      [71]  209   48  663  527  958  878  536  482  317  132  739  270  929   35
      [85]  266   74  570  679  912  271  543  906  101  435  437  959  613  621
      [99]  943   39  947  630   89  530  899  982  554  394  254  192  955  761
     [113]  847  461  602  746  334  860  930  377  763  192    4   63  532  575
     [127]  861  867  855  224  753  176   94  660  182  825  227  508   27  905
     [141]   80  432  649  477  207  369  886  298  631  457   72  350  537  384
     [155]  612  931  571  302   51  371  460  790  602  865  895  909  774   40
     [169]  774  716  309  160  927  580  280  117  562  685  151  145  299  793
     [183]  129   68  478  349  654  636  472  109  102  757  788  935  990  834
     [197]  285  305  412  284  561  908  763  935  872  668  670  942  742  475
     [211]  117  963  283   60  718  940  426  990  731  330  576  699   72  454
     [225]  645  873  991  178  463  944  348  657  311  526   69   70  173   95
     [239]  149  470  195  412  430  339  972 1000  543    8  294  957  220  286
     [253]  930  213  285  233  109   22  158  509  479  872  900  671  209  429
     [267]  721  152  583   27  430  874  703  134  679    4  737  308  461  602
     [281]  181  488  565  302   96  853  987  962  618  614  735  215   32  230
     [295]  367  270  524  703  671   64  356  400  444  365  294  665  278  651
     [309]  547  703  379  605  668  610  577  328  663  880  743  577  510  385
     [323]  147  729  966  166  206   62  559   71  682  494  861   98  177   36
     [337]  726  627  679  811  796  119  185  866  564  536  798  687  245  575
     [351]  217  897  349  612  559  585  372  786  573  760  988  137  878  266
     [365]  783  572  333  389   90  636  349  152  188  752  901  490  793  743
     [379]  886  672  462  525  555  598  129   60  851  647  676  980  670  494
     [393]  706  176  847  894  304   55  756   46  756  660  976  107  164  891
     [407]  655  816  490  617   89  264  256  625  626  565  384  680  323  384
     [421]  192  838  391  697  710  684  556  817  274  223  543  801  762  766
     [435]  896  572  724  993  275  539  569  721  181  362  493  256  724   58
     [449]  613  569  126  998  996   25  582  457  721  234  471  390  414  532
     [463]  376  738  837  149  899  503  305  842  773  381  542  467  398  238
     [477]  577  933  853  572  470   90  900   22  370  396   56  181   12  972
     [491]  289  418    6  212  772  616  625  788  693  418  903   20  813   56
     [505]  653   89  228  530  777  483  979  273  194  805  768  940  650  651
     [519]  425  928  552  573  436   48  292  486  952  811  455  601  707  351
     [533]  199  105   43  178  143  656  533  530  914  711  148   71  507  890
     [547]  783  766  322   17  221  672  645  879  147  999  399  466   58  968
     [561]  202  515  889  693  514  637  750  726  731  739  921  683  291  583
     [575]   10  791  335  604  622  632  902   74  530  645  106  587   59  524
     [589]  858  764  885  249  952  926  580  307  700  198  527  103  591  797
     [603]  839  986  139  115  683  839  527  361  627  477  852  278  915  853
     [617]  497  545  266   73  622   19  321  756  813  646  655  696  286  186
     [631]  400   63  392  716  810  972  416  450   91  136  845  954  849  584
     [645]  657  139   67  837  901  205  159  465  704  690  663  690   35  391
     [659]  241  679  568  462  671  740  239  483  159   69  347  188  196  701
     [673]    9  968  909   11  182  644  996  204  291  596  652  919  664  736
     [687]   18    7  548  494   69  483  429  640  589   12  429  624  320  666
     [701]  351  337  229  592  911  600  413  249  380   39  803  176   19  339
     [715]  735  667  654  529   22  292  341  576    4  731  520  298  877  289
     [729]  979   31  889  593  380  159  191  286  158  459  916  179  341  775
     [743]  405  449  314   54  122   58  238  677  123  657  501  726  146  379
     [757]  469  851   56  284  857  127  319  308  630  739  953  810    5  598
     [771]  581  234  194  703  889  994  935  590  363  975  532  570   74  178
     [785]  582  997  615  417  632   81  507   95  669  747  628  831  653  362
     [799]   97  221  623  868   40  725  633  557  574  522  681  789  508  629
     [813]   40    4   89  842  456  624  909  819  353   95  973  875  701   73
     [827]   40  943  716  589  553  773  721  312  218  985  399  608  635  897
     [841]  317  292  849  871  893  808  701  510  455    7   32  353  818  499
     [855]   60  984   97  394  845   92  843  416    1  101  365  333  637  974
     [869]  712  937   12  973  482  737   81  660  110  738   99  909  520  284
     [883]  290  183  497   88  576  387  410  344   60  780  493  233  805  420
     [897]   75  175  242    5  789  935   60  457  352  826  269  416  523  205
     [911]  339  303  798  262  641  435  843  621  186  962  876  228  751   23
     [925]  991  431  986   57  786  930  227  111  126  192  434  718  570  707
     [939]  280  404  971  573   10  100   19  151  709  588  163  213  580  721
     [953]  415   88  313  402  966  782  658  592  757  713   34  680  302  473
     [967]  796  903  898  239  144   48  651  874   29  635  832  336  182  710
     [981]  463  910  642  411  226  970  800  329  228  117  670  124  903  770
     [995]  950  902  779  764  118  149
    
    $resamples[[2]]
       [1] 180 354 675 733 156 616 122 843 748 311 818 680 408 847 656 232 355 730
      [19] 896 166 880 871 835  67 300 518 752  40 103  16 915 538 691 683 746 677
      [37] 858 755  19 491 826 805 692  60 758 573 344 449 613 853 709 855 254 199
      [55] 313 900  66 602  90 248 863 994 384 633 328 726 457 815 298 443 454 450
      [73] 835 868 401 844 162 753 523 615 269 661 923  31 733 100 532 819 684 572
      [91] 472 279 758 914 760 604 368 395  58 655 733 340 487 759 668 584 394  82
     [109] 581  46 349 173 937 442 527 800 517 673 686 124 556 760 200 251 701 408
     [127] 439 760 277  64 683 497 894 413 373 533 589 671  68 745 360 955 526 888
     [145] 164 728 987 780 503 897 668  79 326 317 315 684 506 537 657 994  40 317
     [163] 763 241 313 881 848 307 641 752 406 544 981 693 765 549 618  74 610 420
     [181] 989 127 810 276 232 797 844 483 879 410 675 320 626 973 815 778 598 414
     [199] 215 951  13 520   3 379 685 764 558 411 282 969  17 493 221 385  15 790
     [217] 516 266 975  64 761 391 410 880 486 122 726 524 165 468 792 113 351 673
     [235] 228 574 182 390 101 843 274 711 638 236 954 404 533 693 770 977 398 841
     [253] 649 880 242 505 459 113 917  35 443 245 386 756 578 823 683 262 627 665
     [271] 510 648 235 993 380 273 931 808 570  26 479 290 797 263 568  51 305 520
     [289] 744 705 978 270 238 400 917 228 119 171 985  36 378 807 720 114 940 998
     [307] 379  12 804 360 921  26 454 612 536 370 719 307 335 139 707 142 329 801
     [325] 887 160 511 702 873 198 688 903 338 838 560 877 840 895 105 647 753  58
     [343] 209 840 385 451 146 429 686 521 905 230 865  28 900 252 437 889 411 547
     [361] 765 143 375   2 780 273 430 360 589 516 276 495 599  71 265  77 580 151
     [379] 413 998 812 299  59 493 588 325 426 797 889 120 773 432  89 614 520 998
     [397] 177 269 989 246 737 850 453 587 379 812 903 227 283 229 160 523 893  66
     [415] 277 302 691 269 589 387 220 857 464 544  34  50  48 930 488  90 173 361
     [433] 187  85 462 438 837 453  15 908  54  85 161  44 938 339 436 157 419 157
     [451] 228 674 863 840 945 781 747 358 990 712 723 174 448 978 956 585 335 767
     [469] 804 459 239 137 663 302 445 125 308 986 758 854 862 379 396 165  31 300
     [487] 323 775 933 330 503 255 115 136 490 884 262 555 115 479 895 855 831 185
     [505] 772 208 155 297 460  36 560 298 977 666   5 760 967 663 524 443 922  81
     [523]  42 634   2 918 238 747 301 152 749 538 822 166 532 549 614  41 475 846
     [541] 310 157 749 787 971  12 538 590 656  97 529 419 383 242 129 241 766 813
     [559] 601 946 819 675  80  18 631 352 236  80 798 785  77 672 746 142 835  46
     [577]  12 871  70 668 985  56 383 328  58 985 233 796 228 735 340 325 562 426
     [595] 305 141 185 451 421 197  83 636 923 903 813 848 175 998 613 563 540 458
     [613] 908 223 559 650 448 655 478 456 634 533 697 217 564 755 230  58 403 981
     [631] 592 452 172 900 642 426 212 392 920 818 974 403 766 287  25 846 142 476
     [649] 786  56 218   9 397   8 581 419 613 696 472 502 619 629 353   3 153 322
     [667] 392 259 960 392 509 626 202 633 325 704 166 607 302 524 783 732 233 239
     [685] 971 647 110 540 264 582 959 192 452 124 962 774 884 178 407 573 186 894
     [703] 876 480 380 450 230 760 276 960 563  76 309 775 503 471   9 842 117 211
     [721]  21  68 406 575 679 449 288 321 987 306 428 888 736 990 638 800 609 189
     [739] 589 661 232 834 605 447 362 874 578 705 969 594 650 988 337 268 687 151
     [757] 138 526 150 155 140 853 682 226  98 621 203 586 214 542 695 471 836 959
     [775] 777 657 965  77 950 252  95 860 194 214 397 475 404  89 726 709 115 181
     [793] 507   7 962 244 993 509  66 852 879 629 956 609 369 968 780 409 958 399
     [811] 395 575 254 633 808 177  94 889 351 257 742 649 700 365 375 128  33  66
     [829] 723 354 429 790 833 932 178 498 865 919  48 602 659  69  13 656 290 952
     [847] 676 443 501 386 424 944  74 862 677 858 200 188 342 636 568 726 558 259
     [865] 408 345 263 126 307 384 830  45 542 665 505 165  64 710 706 347   3 656
     [883] 696 383  10 307 319  69 290 654 863 504 146  78 321 229 638 773 832  28
     [901] 900 798 411 291 775 183  24 448 404 694 979 601 905 110  59 247 223 248
     [919] 611 343 597  97 186 945 982 542 686 856 966 937 276 660 936 351 338 462
     [937] 166 328 358 746 603 883 613 200 846 651 744 925 360 184 655 780 401 669
     [955] 907 472 151 638 707 274 134 787 616 466 212 116  86  41 998 363 638 268
     [973] 134 486 454 786  29 259 651 652 773 896 779 480 969 910  49 361 565 168
     [991] 782 748 542 675 219 556 831 760 794 227
    
    $resamples[[3]]
       [1]  694  707  134  766  839  891  866  881   99  536  685  230  578  991
      [15]  323  788  861  460  285  819  435  578  543  703  606  925  636  784
      [29]  339  731   36  401  270  704  545   36  344  139  888  979  283  359
      [43]  787  678  493  691  519  184  366    5  797  160  983  327   80  248
      [57]  289  882  493  290  662  205  982  329  330   80  202  163  565  716
      [71]  122  975    6    6  363  757  752  782  149  160  519  591   67   85
      [85]    8  407  292  338  173  501  924  997  554  712  317   23  963  111
      [99]  590  941  146  971  473  993  457  153  835  666  394  794  892  632
     [113]  694  615  905    3   41  922  124  513  573  916  365   71  915  106
     [127]  311   31  590  789  532  343  498  639   92  819  112  978   95    8
     [141]  475  414  864  254  540   25  828  267  566  181  855  271  965  768
     [155]   45  391  717   73  297  679  985  386  727  182  119   12  957  762
     [169]   57  331  281  232  788  613   98  555  131   24  117   58  641  714
     [183]  930  221  679  174  839  466  775  122  949  989  905  799  309  947
     [197]  671  942   40  303  770  163  883  918  944  991  338  581  459  799
     [211]   61  373  286  391  770  845  585  168  699   68  928  841  335  395
     [225]  541  657  475  692  576  158  456  758  181  697  991  378  650  576
     [239]  973  614    1  958  477  112  881  341  490  362  509  859  617  228
     [253]  179  316   56  131  327  967  431  687  962  387  156  909  197  822
     [267]  231  387  840  962  832  133    9  196  270  750  356  313  962  861
     [281]   30  699   29  123  219  286  679  690  712  735  162  766  470  189
     [295]  317  290  435  625  798  749  675  257  810   54  671  351  958  600
     [309]  993  712  194  750  856  631  231  283  822  322  631  886  642  878
     [323]  482  329  989  791   80  923  870  789  950  131  519  807  525  161
     [337]   18  739  111  493  145  191  117  680  495  391  809  580  541  430
     [351]  215  897  758  892  697  424  323  181  571  143  227  481  283  925
     [365]  837  969  718  682  975  636  226  758  310  122  577  887   25  561
     [379]  848  655  100  292  792  415  819  517  167  840  243  571  306  107
     [393]  766  997  946  532  675  556  996  779  608   30  511   72  455  605
     [407]  707  114  149  289  461  905  490  781   97  621  318  129  104   27
     [421]  275  997  290  579  671  887  185  686  407  741  486  560  143  101
     [435]  345  509  238  673  349  817  878  620  751    2  555  919  986  866
     [449]   35   57  240  469  808  747  679  893  861  590  850  905  181  250
     [463]  441  655  675  754  932  375  622  837  850  697  446  363  184  186
     [477]  419  874  148  779  386  790  989  899  599  795  464    5  267  588
     [491]  891  904  398  716  360  331  736  206   50  976  658  974  500  818
     [505]  115   99  200   92  119  921   89  113  666  185  734  952  901  854
     [519]  668  758  258  770  373  221  811  622  725   33  107   17  213  284
     [533]  518  451  678  757  581  997  553  701   22  878  421  885  927  806
     [547]  167   95  293  696  795  878  384  236   85  509  729  558  759  598
     [561]  261  360   89  583  839  418  669   52  303  562  286  207  315   39
     [575]  533    5  688  397  352  512  213  775  489   24  677  495  565  545
     [589]  411  655  954   98  101  436  617  204  127   50  357  223  832  175
     [603]  746  223  972  988  165  491  715  671  793  697  434  801  139  119
     [617]   89  883  889  936  813  678  927  837  271  161  988  390  792  977
     [631]  949  134  314  680  461  286  942  624  126  571  636  354  849  425
     [645]  239  859  262  753  359  127  987  194  494  268  445  908  565  951
     [659]  573   86  213  737   92  447  888  449  661  834  238  720  790  507
     [673]  730  443  829   37  977  270  338  214  149  298   59  121  708   68
     [687]  998  424  565   24  649  964  318  525  659  201  943  366  261  528
     [701]  581  966   16  171  222  578  316  501  995   11  374  993  804  161
     [715]  592  409  462  863  450  345  953  688  598  872  727  367  296   97
     [729]  390  344  969  963  812  314  877  424  228  720  672  446  317  109
     [743]  374  654  561   82  202  309   35  447   26  561  217  472  442  329
     [757]   93  471  531  159   32  436  587  806  664   73  591  525  931  849
     [771]  855  303  703  968  651   75  213  590 1000  516  323  246  404  468
     [785]  410  431  886  274   85   38  809  751   20  515  386  482  691  772
     [799]  508  331  275  158  885  731   73  192  582   54  248   78  677  180
     [813]  799  885  295  842  695  318  177  907  367  101  362  379   25  348
     [827]  267  438   72   17  318   61  443  814  285  719  477  385   31  612
     [841]  532  311  477  320  429  733   68  202  735  865  851  427  960  127
     [855]  164  491   51  446  283  734  732  800  965  139  747  166  519  659
     [869]  915  456   43  549  590  794   27  437  842  799   64  370  583  922
     [883]  385  640  116  251  542  535  407  413   20  392  200  962  456  511
     [897]  334  746  202  183  803  241  249  927  956  269   10  256  923  858
     [911]  969  511  151  133  959  763  258  556   59  277  473  400  336  443
     [925]  860  642  776   29  998  843  771  627   60  427  209  446  574  288
     [939]  893  196  398  337  304  794  288   41  103   18  196  311  616  219
     [953]  355  940  456  930  582  453  431  221  906  829  761  168  251  701
     [967]  133  696  181  448  468  889  685   84  944  290  791  517  647  576
     [981]  437   10  680  856  353  361  456  960  782  874  425  185  429  716
     [995]  748  190  661  350  497  595
    
    $resamples[[4]]
       [1]   12   97  794  743  193  642  964  390  220   36   24  689  178  344
      [15]  934  993  407  350  808  662  112  973  183  969  354   45  574  154
      [29]  713  251  115  957  897  263  416  227  662   20  501  733  360  731
      [43]  574  161  614  802  990  732  722  383   19  646  217  762  320  908
      [57]  569   99  552   47  300  629  212  786   26   98  952  697  177  987
      [71]  513  492  118  419  662  445   11  253  452  733  690  528  202  532
      [85]  273  102  859  224  234  283  558  118  565  429  659  451  543  739
      [99]   71  170  486  551  192  288   13  328  867  594  812  824  344  195
     [113]  344  543  498  993  227  583   59  944  752  479  151  627  257  343
     [127]  548  723  317  880  889  243   47  514  200  694   29  850  610  860
     [141]  866  430  254  648  320  107  883  935  384  777  597    8  218  569
     [155]   25  234  763  349  410  867  715  315  275  630  496  937  691  203
     [169]  487  773  154  794  199  229  218  433  854  572    7  776  529  321
     [183]  517  643  725  161  416  276  659  721  471  487  425  131  243   11
     [197]  795   90  207  225  442  708  643  708  492  827  633  329  805  806
     [211]  381  544  541  558  944  295  621  177   42  702  428  903 1000  995
     [225]  707  587   13  556  400  636  899  744  649  589  529  228  393  616
     [239]  356  293  739  795    3  465  885  605  197  894  152  785  498  271
     [253]  339  378  494  754  412  821  418  690  166  331  731  819   14  464
     [267]  520  438  900   36  305   47  857  955  206  346  372  599  763  494
     [281]  100  871  565  881  499   96  240  902  200  849  938  841  918  296
     [295]  887  460  886  388  371  782  806  601  242  457  735  806  656  364
     [309]  518  253  265  623  700  814  777  442  747  718  752   37  916  580
     [323]  537  250  463  467  714  116  127  396  110  867  107  666  642  205
     [337]  695   44  306  987  788  985  206  875  318  995  853  240  312    8
     [351]  418   18  108  214  700  317   38  958  156  602  603  622  996  992
     [365]  201  267  409  371   78  825   30  907  500  330  901  984  370  490
     [379]  852  821  748  971   81  337  301  707  795   57  992  768  301  945
     [393]    1  259  487  262  634  571  356   71  547  257  250  922  414   41
     [407]  896  811  991   89  410  372  154  872  792   37  893  456   81  974
     [421]  617  227  451  436  591   28  379  548  318  729  694  261  638  359
     [435]  620  894  955  728  683  914  547  345  744  319  770  510  486  440
     [449]  331  103  670  797  331  732  186  818  192  779  966  139  126  872
     [463]  814  452   15  830  916  122  820  781  715  606  105  961  527  716
     [477]  242  870  681  743  223   36   56  695  944  821  602  478  521  345
     [491]  938  159  167  718  632  690  886  472  990  551   60  485  970  987
     [505]  115  365  365  315  711  450  405    1  416  724  830  594  477  674
     [519]  235  702  552  246  164  751  236  144   95  259  512  794   54  965
     [533]  430  622  905  462  654  446  232  255  525  878  326   82  327  636
     [547]   66   78  409  938  178  550  603  977  141  514  634  785  471  369
     [561]  288  599  465  446  716  650  258  141  646   97  900  466  240  313
     [575]  799  156   56  276  663  808  369  439  111  886  472  981  563  163
     [589]  377  260  798  179  484  482  530  912  631  235  354  239  256  346
     [603]  115  834  811  256  672  766  919  121  767  477   93  208  586  653
     [617]  322  373  582  815  710   75 1000  339  618  173  340   83  597  104
     [631]  393  572  149  428  406  283  467  530  163  739  345  727  281  623
     [645]  968  329  820  747  860  813  868  595  208  241  180  287  332  130
     [659]   89  994  842  696  311  968  661  667  969  523  211  920  726  497
     [673]  454  587  696  858  371  730  688  607  510  510  268  340  455  522
     [687]  940  461  666  385  109  437  369  450  681  741  135  528  222  274
     [701]  954  304  630  361  194  467   67  899   77  245  417  991  240  142
     [715]  969  543  615  931  160   63  488  969  161  387  958  147  417  988
     [729]   16  269  752  393  319  127  838  258  517  993    3  794  919  746
     [743]  368  800  172  549  678  929  162  406  138  343  407  448  207  774
     [757]  394  185  231  734  617  556  741  787  223  846  520   73  613  455
     [771]  781  369  772  994  531  160  479  618   88   35  244  630  789  951
     [785]  564  902  184  639  401   48  830   61  661  335  947  988  213  574
     [799]  247  178  148  140  225  480  397  779  762  468  368  690  868  896
     [813]  350  855  629  388   48  413   42  500  269  288  587  999  450  777
     [827]  730  991  448  784  831  408  380  559   54  305  904   21  250  852
     [841]  465  667  441  323  236  729  238  555  135  851   64  518  773  316
     [855]  155  296  559  222  493  988  338  802  429  210  990  231  451   85
     [869]  932  359  650  338  589  117  779   70  940  669  900  845  411  838
     [883]  576  525  433  309  232  167  498  322  774  880  360  799  685  600
     [897]  271  563   90  484  380  507  659  536  218  508  256  445  937  925
     [911]  276  269  778  667  414  117   95  135  261  300  326  166  395  677
     [925]  403  947  221  759  529   70  624   43   23  721  126  146  136  158
     [939]  810  274  985   75  709  470  221  866  635  132  540  527  188  493
     [953]  775  727  647  284  629  353  400  730   53  100  814  237  448   27
     [967]  608   80  852   33  968  728  222  565  347  272  920  111  700  660
     [981]  111  192  562    6  294  324  734  354  495  537  364  733  889  375
     [995]  949  297  807  199   11  401
    
    $resamples[[5]]
       [1]  565  837  416  271  105  280  176  217   97  933  111  804  834  416
      [15]  196  623  598  919  862  739  933  405  179  509  723  667  104  523
      [29]  896  299  392  983  856  532   68  549  286  694  338   97  817  256
      [43]  750  146  211  108  669  385  981   23  852  665  919  877  248  509
      [57]  480   62   91  717  333  750  704  734  766  922  621  158  284  715
      [71]  563  771  407  738  177  886   75  456  946  570  646  996  788  355
      [85]  521  886  238  712  104  452  569  321  945  781  511  283  809  689
      [99]  805  600  362  540  438  481  710  182  923  443  493  605  584  766
     [113]  429  938  246  254  976   58  122  380   29  550  294  792  978  670
     [127]  422  859  741   48  290   60  189  395  350  639  351  664  958  675
     [141]  803  693  324  204  316  854  810  362  155  700  454  895  957  700
     [155]  346  770  744  295  466  871  590   58  172  401   25  525  410  737
     [169]  720  985  595  536  881  706  604  846  258  824  710  428  643  851
     [183]   69  579  111  562  837  216  437  572 1000  177   76  353  656  950
     [197]  539  472  274    9  854   41  424   17   14  147  580  955  684   21
     [211]  733  108  188  113  816  201  625  591  360  322   25  311  752  335
     [225]  921  817  848  933  201  511  242  148  516   60  328  991  855  614
     [239]  580  523  396  885  416  620  114  619  853  652  252  799  927  148
     [253]  354  666  544  455  604   28  470  669  711  138  623  945  362   56
     [267]  259  376   34  758  586  499  134  289  528  601  447  528  685  653
     [281]  573   63  306  293  178  740  380  400  818  576  945  214  784  370
     [295]  979  129  463  462  179  691  470  855  458  167  596  639  654   64
     [309]  233  127  910  209  721  610  753  335  231  792  154  427  391  583
     [323]  968  888  182  650  834  781    9  908  249   17  698  640  191  937
     [337]  625  767  411  962  601  147  163  136  352  657  866  829    5  161
     [351]  649  354  751  623  182  779   31  226  470  979  749   78  583   59
     [365]  973   27  330  510  916  715  973  743  839  491  386  450  812  141
     [379]   63  242  379  120  833  931  482  757  843  899  708  330  274  490
     [393]  459  939  667  533  976  819  911  248   20  265  210  359  941  976
     [407]  493  596  290  229  849  473  448  223  484  498  553  627  314  335
     [421]  158  215  986  433  169  509  483  329  983  225  243  415  565   41
     [435]  146  590  354   35  528   18  256  533  906  139  783  850  479  486
     [449]  469  296  266  684  202  608  386   90   32   15   47   94  543  303
     [463]  327  406   66  228  327  146  169  327  933  201   95  957  460  427
     [477]  522  526  934  300  680  577  525  964  664  934  256   75  746  982
     [491]  485  654  662  499  577  468  336  267   45  865  344  678  525  622
     [505]  221   63  581  884  407  618  425  653  174  224  912  411  798  488
     [519]  835  913  334  374  168   22  747  633  173  723  121  173  663  320
     [533]  541  336  834  510  913  166  701  994  347  521  388  461  625  702
     [547]   46  278  626  334   75  295  465  119  654  549  878  653  702  508
     [561]  855  934  262  670  255  808  171  470  446  624  982  419  738  924
     [575]  185  907  506  772  546  165   38   38  171   38  200  350  972  657
     [589]  239  638   65  570  666  868   77  424  496  645   16  387   27  947
     [603]  940  689   25  549   43  432  350  553  313  160  922  708  737  508
     [617]  834  894  303  748 1000  803  898  740  483  927   13  701  479  611
     [631]  864  121  347  251  915  552  537  996  342  255  336  808  625  619
     [645]  615  167   70  359  764  680  193  753  325  983  888  251  901  416
     [659]   50   44  464  181  470  859  183  487  708  791  734  273  680  301
     [673]  117  158  120  552  476  718  617  889  643   60  355  244  781  479
     [687]   45  169  599  459   60  732  525  491  977   77  173   16  487   33
     [701]  631  605   79  644  761  634  784  653  120   80  940  547  817  232
     [715]  647  686  495  139  376  635  713   68  884  155  463  290  769  814
     [729]  961  178  478  726  678  675  981  415  120  893  427  540  483  116
     [743]  534   36  479  516  304  991   92  472  820  468  918  226  325  197
     [757]  622  950  177  991  199  405  872  161  905  719  904  165   11  615
     [771]  418  555  600  635  304  589  272   65  596  708  369  302  365  440
     [785]  880  724  391  758  997  217  232   11  299  590  243  131  399  752
     [799]  981   50   77  596  373  803  226  399  195  438  444  725  255   45
     [813]  492  346  236  781  652  720  123  824  536  260  526   82  607  656
     [827]  268  602  478  526  592  330  941  232  794  335  851  418  446  745
     [841]  269  714  557  355  288  646  175  958  715  465  407  790  848  129
     [855]  468  300  286  208  254  236  372  332  769  615  912   78  473  969
     [869]  898  866  750  297  355  352  863  514   72  327  147   67  306  805
     [883]  820  483  508  606  413   20  415  638  929  625  107  151  307  856
     [897]  430  921  891   16   87  166  581  306   57  603  845   95  968  237
     [911]  363  622  470  367  465  378  601  312  560  111  252  615  357  164
     [925]  728  921  262  604  649  383  781  469  570  569  924  376  361  139
     [939]  703  928  958  260  516  395  333   59  160  494   89  596  719  539
     [953]  109  589  903  452   81  569   15  802  759  646  788  343  806  806
     [967]  391  364  167  133  771  786  469  877  624   30  475  559  908  209
     [981]  174  202  159  107  475   56  203   27  787  212  175  530  863  816
     [995]  895  630  720  940  817  798
    
    $resamples[[6]]
       [1]    6  687   69  743   73  130  106  691  284  255  738  350  259  173
      [15]  958  485  564  218  974  505  575  503  115  653  749  203  648  230
      [29]  854  246  588  455  919  203  541  393  134  502  272  936  947  667
      [43]  858    7  228  901  822  647  235  801  161  695  853  753  724  301
      [57]   98  738  720  647  968  966  712  434  455  283  736  608  903  329
      [71]  331  656   28  969  955  277  872  323  318  478  545   13  692  298
      [85]  734  309  565  638  461  358  897  381  995   49   20  229  116  773
      [99]  792  163  889  816  601  916  633  992  969  135  253   88  294  304
     [113]  926  658   96  681  577  764   80   86  865  749   90  288  343   76
     [127]  269  592  512  441  964  124  635  670  821  185  722  338  455   33
     [141]  224  806  257  286  496  192  947  187  152  125  174  801  242  570
     [155]   87  832  351  693  409  609  435  146  166  698  285  381  841  314
     [169]  938   61  981  804   39  255   78  789  488  796  983  440  655  295
     [183]  893  806  649  413  722  507  172  148  410  753  171  707  389  442
     [197]  570   14  325  361  810   95  130  117  221  976  906  268   44   10
     [211]  227  782  316  856  372  512  392  797  298  385  471  566   34  612
     [225]  751  374  283  583  811  987  682  558   18  418   99   76  373  111
     [239]  910  170  657  851  996  276  152  214  245  352  983   69  339  933
     [253]  187   54  871  763  966  138  677   41  349  265  275  121  967  180
     [267]  616  211  787  628  325  226  680  322  201  991   30  225  868  395
     [281]  984  889  537  824  211    1  148  646  571  137  269  233  773  277
     [295]  300  778  792  454  974  495  219   18  934  589  298  507  838  588
     [309]  947  949  764  320  826  589  229   98  918   74  355  193   55  952
     [323]   47  360  864   10   54  679  716  336  619  131  837  370   89  902
     [337]  207  499  446  763   84  871  927  117  897  482  307  575  269  843
     [351]  265    6  955  799  121   22  298  224  842  395   85   37  990  403
     [365]  501  194  355  246  521  730  959  634   93  411  914  328  106  739
     [379]  276  910  977  604  710  327  517  840  170  945  567  695  962  822
     [393]  468  147  541  589  325  869  947  171   44  740  411  796   51  275
     [407]  543  581  482   77  282  865  339  862  799  813  225  418  728  764
     [421]  235  764  957  917  769  567  576  725  783  638    8  490  430  525
     [435]  848  515  261  504   14   11  195  841  250  830  395   72  644  223
     [449]  944  605  386  170  265  771  386  598  538  925  452  251  551   25
     [463]  943  873  217  671  189  728  651   69  128  680   95  695  779  475
     [477]  336   84  985  165  495  624  101   16  327   38  475  532  280   41
     [491]  101  778  190  552  350   62  759  652  537  278  828  823  604   21
     [505]  742  174  328  378  919  272  449  967  762  745   29  393  866  513
     [519]  567  710  281  846  929  184  473  269  620  618  666  401  292  449
     [533]  500  756  690  232   90    4  900  133  587  993  617  476   57  109
     [547]  173  746  986   30    6  493  984  757  241  613  486  555  658   66
     [561]  300  860  930   97  883  962  969  693  551  883  969  516   40  282
     [575]  270  615  829   99  202  458  382  689  747  457   53  637  413   42
     [589]  980  211  340  645  369  615  702  166  349  146   45  967   57  606
     [603]  449 1000  379  543  631  473  197  374  978   58   91  173  326  978
     [617]  662   90  972  487  181  834  560  702  442  418  500  578  421  567
     [631]  783  947  317  214  862  423  391  627  802  746  319  303  927  482
     [645]  996  940  452  677  134   15  616  819  172  857  803  819  479  112
     [659]  695   79  187  864  714  459   22  958  575  183  454  400  488  368
     [673]  937  415   33  266  393  523  324   26   85  960  844  603  821  782
     [687]  157  741  915  443  344  150  231  954  958  116  195  619  921  248
     [701]  152  420   51  812  700  603  850  406  414  389  731   85  587  213
     [715]  903  467 1000  203  132  696  827  661  719  498  211  869  599  510
     [729]  295  511  287  766  517  805  206   13  604  429  544  733  722  259
     [743]  965  712  147  788  480  778  564  749  919  931  507  221  750  150
     [757]  256   94  873  328   89  116  260  298   72  981  417  835  506  372
     [771]  206  796  110  547  960  760  202  508  993  240   53  813  866  523
     [785]   91  840  420  276  657  736  560   62  298   84  687  772  255  320
     [799]   42  567  752  879  961  910  433  729  651  765  714  381  430   16
     [813]   89  946  885  608  728  664  887  806  270  698  846  508  405  827
     [827]  216  100  268  362  372  737  855  759  695  322  237  558  134  171
     [841]  628  574  563  918   17  282  972  289  324  475  163  224  629  615
     [855]  945  327  796  866  153  729  759  364  619  969  209  367  694  455
     [869]  577  680  684  894  168  368  254   45  198  473  295  544  117  941
     [883]  753  351  637  474   93  313   81  260  982  723  720  863  578  792
     [897]   34   55  495  225  215  247  203  333  631  656  678  112  889   25
     [911]  276  254  485  587  902   41  378  804  242  487  699   73  428  143
     [925]   11  801  572  751  529  148  148  216  653  572  736  396  537  877
     [939]    4  559  226  464  456  239  942  360  448  620   64  682  390  458
     [953]  432  494  531  907  216  258  427  192  431   82  629  403  547  200
     [967]  632  166  713  564    5  599  547  310  805  641  345  961  581  354
     [981]  227  603  286  396  947  181  921  753  429   31  604  978  862    3
     [995]  649  416  761  100  177  496
    
    $resamples[[7]]
       [1]  316  312  827  344  165  748  642   86  128  228  292  596  273  399
      [15]  899  363  940  770  857  251  332  227  722  665  429  388  545  378
      [29]  950  556  973  802  232  111  309  919  826  338  430  434  726  578
      [43]  192  983  845  254  851   80  362  865  618   58  617  310  438   61
      [57]  388  777  470  857  815  861  416  872  724  683  670  918  402  856
      [71]  504  768  658  559  918  812  641  310  455  194  821  442  297  305
      [85]  437   65  949  465  611  433  139  914  323   65  234  640  952  478
      [99]   83  376  312  863  757  317  608  552  542  290  925  928  242  187
     [113]  311  196  166  716  435  777  362  921  755  441  465  675  424  832
     [127]  362  948  390  332  772  398  624  198  877  374  810  560  128  705
     [141]  589  886  422  159  523  949  434  266  534  413  491  232   49  841
     [155]  248  779  816  136  616  435  888  284  153  275  985  698  428  847
     [169]   12  405  238  948  388   62  336  627  395  642  740  435   72  830
     [183]   56   42  830  578   76  713  101  196  856  730  851  759  718  474
     [197]  513  669   94  392  626  903  706  918  525  394  448  374  502  338
     [211]  587  562  286  505  957  274  561  137  802  924  774  924  757   35
     [225]  920  503  720  287  572  233  429  750  597  939  794  273  934  982
     [239]   97  169  446  342  823  803  429  423  222   15  230  515  351  359
     [253]  592  704  804  302  967  257  574  589   16  564   21  275  873  938
     [267]  748  302  944  983   53  729  326   32  994  573  739  856  578  189
     [281]   45  779  193  119  544  547  203  750  927  567  321   48  118  403
     [295]  314  167  635  325  682  164   91  240  323  880  127  131  156  367
     [309]  722  953  149  117  354  780  312  860  222  910  352   86   64  583
     [323]  551  329  353  422  598  759   64  796   99  491  973  952  854  762
     [337]  384  549  732  827  972  777  619   60  491  882   51  279  745  604
     [351]  303   88  780  253  203  537  192  771  651   54  367  192   10  566
     [365]  457  122  914  587  468  674  975  898  118  124  330  251  628  235
     [379]  596  505  653  983  578  620  338  927  975  569  737  270  239  174
     [393]   70  553  517  315  247  810  305  565  647  722  935  519  617  986
     [407]  453  315  971  651  861  393  638  781  699  743  959  316  445  344
     [421]  653  115  661  674  665  903  638  159  196  305  708  393  810  686
     [435]  795  933  489  136  891  204  224  862  207  584  373  692  102  439
     [449]  809  901  718  267  661  471  235  790  101  203  224   95  790  656
     [463]   96  662  699  905  813  204  811  468  181  430  437  742  379  342
     [477]  312  316  445  514  828  275  951  312  366  825  969  875  970  132
     [491]  200  620   46  637  666  148  125  628  382  452  271  651  869    5
     [505]  709  650  665  804  727   60  722  680  548  922  607  468  221  386
     [519]   79  647  106   12  384  456  242   81  561  610  401  314  229  975
     [533]  131  278  766  935  895  393  349  560  732  566  879  187  322  791
     [547]  300  601  171  947  224  421  421  898  334   97  239  641  113  604
     [561]  823  829  726  713  847  539  393    6  676  647  710   64  265  830
     [575]  156  631  484  236  729  520  853  197   15  652  972   79  776  371
     [589]  345  285  922  536  346   11  576  325  607  710  301   34  962  783
     [603]  587  379  887  909  756  385  899  284  661  772   35  470  513   69
     [617]  462  132  272  246    5   93   12  247  198  672  579  612  377  246
     [631]  677  991  508  504   19  121  151  430   16  689  191  933  649  310
     [645]  771  236  881  471  659  969  378  701  132   55  350  862  274  131
     [659]  673  398  996  393  691  481  472  655  527  560  879  440  800  560
     [673]  114  834  970  348  695  818  633  950  451  976  579  638  223  887
     [687]  638  701  601  461  780  195  477  662  289  940  338   63  600  446
     [701]  647  689  431  317  709  919    5  170  211  751  491  948  726  375
     [715]  712  164  754  635   67  620   60  214  879  311  696  570  532   95
     [729]  121  370  578  978  460  953  393  136  850   79   78   95  393  353
     [743]  490  180  972  852  746  958  575  776  557  353  394  881  861  428
     [757]   96  297  564  992  554  971  610  573  459  710  545  969  945  885
     [771]  677  510  990  835  972  392  842  650  436   52  890  841  230  227
     [785]  786  568  245  397  680  605  303  572  311  939  772  651  842  161
     [799]  693  710  973  325  251  962  294  191  382  993  748  191  869   41
     [813]  982  255  943  501  304  308  283  569  828  690  800  704  577  910
     [827]  816  108  813  176  335  207   52  114    8  616   92  129  444  637
     [841]   41  836  208  621  424  494  539  693  605  775  291  517  250   14
     [855]   22  185  303  708  486  944  752  684  776  268  822   23  624  796
     [869]  411  578   32  771  780  361  375  592  334  733  724  182  606  941
     [883]  879  281  672  773  562  421  400  298  195  793  194  893  229  136
     [897]  824  287  393  516  390  594  484  298  969  694  483  922    1  868
     [911]  950  345  353  776   35   39  519  834   32  163  839   55  336  946
     [925]  787  721  488  992  972  427  731  250  354  443    3   13  868  480
     [939]  731  501  803  748  262  772  507  851  527  791   85  838  979   54
     [953]  447  518  387  978  719  621  813  879  981  286  571  782  314  663
     [967]  200 1000  241  304   73  573  351  354  476  120  472  530  383  575
     [981]  918  177  779  230  605  389  645  242  573  515  237  252  599  123
     [995]  281  973  966  773  998  650
    
    $resamples[[8]]
       [1] 209 672 776 906 843 502 332 477 169 457 194 425 918 764 494 484 544 739
      [19]  38 970 863 320 429 298 697 285 233 748 467 527 792 836 833 329  18 453
      [37] 738 784 793 177 598 230 787 525 290  83 731 989 133 599 627 207 290 257
      [55] 870 534 900 185 240 116 809 736 684 392  27 247 337 421 921 946 973 353
      [73] 430 684 715 784 633 345 943 443 682   7 958 669 577 115 722 306 728 750
      [91] 839 756 349 924 827 404 191 935 641 858 741 455 547 163 718 813 269 111
     [109] 508 770 616 986 584 670 670   6  90 157 281   4  87 478 847 520 224 481
     [127] 525 891 315 555  11 797 683 536 359 597 156 550 986 215  18 918 692 520
     [145] 520 655 209 397 766 282 131 754 428 921 718 210 322 656 346 919 760 276
     [163] 595  43 115 922 476  53 266 325  37 623 639 537 233 932 682 140 715  93
     [181] 202 919 858 341 801 509 305 131 243 499 737 208 445 122 423 667 381 630
     [199] 875 219 169 954 340  68  17 330 384 236  76 451  88 422 250 964 190 625
     [217]  33 352 975 331 974 837 177 862 836 301 446 626  31 844  61 583 924   5
     [235] 570 998 986 475  15 212 358  51 934 754 952 728 793 564 367 224 490 384
     [253] 826 575 768 404 530 710 863 113 914 890 179 186 496 673 841 169 519 620
     [271]  43 318 771 198  52 268 501 492 841 286  98 165 483 698 725  76  76 201
     [289] 704 185 321 922 759 673 476 623 547 626 521 935 971 190 176 417 342  73
     [307] 982 968 856 624 286 465 921 662 917  59 308 697 479 768 205 148 107 853
     [325] 129 551 760 976 362 678 236   3 889 911 284   8 555  25 794 451 445 473
     [343] 194 586 387  49 168 928 103 553 493  49 890 355 144 996 186 351 426 572
     [361] 320 318 899 994 752 373 525 887 205 268 269 933 504 425 907 357  16 104
     [379]  64 250 658 677 977 164 404 218  16 596 795 195   2 574 369 264 286 670
     [397] 329 890 794 104 929 492 684 528 247 787 300 633 213 601 145 337 799 212
     [415] 927 950 877 281  52 619 582 504 502 395 783 688 541 231 198 247 894 764
     [433] 601 532 120 830 551 626 351 507 737 905 567 698 978 762 253 330 786 644
     [451] 724 942 469 989 757 586 975 991   1  58 650 443 669 869 889 616 671 764
     [469] 334 132 578 778 982  68 119 596 673 177 862 765 894 249 251  90 582 251
     [487]  32 739 950 603  87 626 910 214 523 298 292 952 137 878 233   2 733 654
     [505] 145 805 169 266 319 837 812 928 969 861  97 401 537 724 867 803 349 940
     [523]  12 373 569 148 371 354 452 879 720 952 474 413 388 954 636 421  68 571
     [541] 185  73 379 893 487 879 367 168 862 517 288 958 607 822  86 194 644 768
     [559] 336 549 271 334 815 202 385 866 184 209 382 874 183 549 711 181 530 577
     [577] 320 294 987 477  34 790 590 306 261 232  21 349 608  73 575 669 689 820
     [595] 261 622 233   5 995  28 436 371 442  56 302 886 743 380 592 988 821 350
     [613] 501 198 969 319 503 494 733 606 614 304 132   8 957 245 646 481 121 378
     [631] 249 955 741 131 185 228 950 472 694 854 806 690 812 619 138 877 150 482
     [649] 529  46 808 394 806  96 380 916 295 820 167 600 527  85 433 341 323 875
     [667] 765 991 991 770 225  76 567 571 115 883 975 449 428  57  23 857 409 712
     [685] 111  97 990  49 821 609 894 712 853 859 510 288 838 728 397 509 864 600
     [703] 703 564 954 708 900 571 342 130 464  33 545 138 444 604 679 925 689 627
     [721] 779 115 211 611 133 247 955 513 125 218 847  64 484 913 822 923 726 702
     [739] 902   4 683 983 878 460 120  12 716 432 128 684 903  24 423 768  32 261
     [757] 619 110 980 888 842 517 251 826 745 478 346 900 424   7 993 322 606 122
     [775] 147 616 933 133 858 682 366 951 438 749 445 982 995 652 593 333  39 816
     [793] 913 537 786 661 103 248  25 849  96 789 677 280 950 335 454 235 504 830
     [811]  83 168 211 708 763 695 795 764 939 232 515 560 888 840 200  30 800 727
     [829] 724 754 806 921 453 221 676 486 633 112 384 893 119 757 831 272 511 165
     [847] 919 603 612 925 493 673 984 940 530 519 795 360 860  28 508 329 167 127
     [865] 251 400 287 102 687 936 680 276  97 714 753  72 696 652 392 334 698 147
     [883] 783 821 936 879 892 164  58 657 823 808 978 530 329 544 306 258 136 719
     [901] 961 709 195 222 202 163 279 301 488 739 895 425 880 846 308 852 873 723
     [919] 639 921 439 321 531 157 947 546 333 394 660 625 220 376 901 791 978 800
     [937]  55 420 186 919 845 235 724 719 373 386 251 587  24 670 205  89 264 415
     [955] 240 164 652 181 996 805 169  29 225 759 734 545 682 385 862 273 199 420
     [973] 733  97 385 192 682  94 308 843 823 848 393 108 943 881 375  28 989  60
     [991] 217 941 668 952 297 970   2 146 571  58
    
    $resamples[[9]]
       [1] 118 108  72 667 359 137 900 240 508 751 731 152 266 603 537 550 174 373
      [19] 880 608 267 274 135 924   5 198 451 863 352 346 395 878 873 109 871  92
      [37] 851 205 300 411 145  73 960  89 436  77 118 931 707 132 892  45 948 276
      [55] 361 897 164 138 920 526 279 577 777 331 223 916 306 204 400 719  70 727
      [73] 729 416 520 701 165  21 846 415 625  87  60 227 788 204  45 376 705 685
      [91] 614 829 162 470 496 914 871 153 555 751 496 876 714 539 162 609  22 280
     [109] 456 688 431 874 958 473  60 391 808 750 639  17 909 325 380 584 556 707
     [127] 796 624 314 936 501 202 157 257 728 211 288 729 547 523  42 408 571  42
     [145] 242 895  21 264 625  61 720 432 300 430 505 886 791  95 610 227 835 988
     [163] 989 105 574 563 734 719  89 381 233 963 829 812 197 833 234 298 117 163
     [181] 469 168 670 932  17 723 601 708  51 341 806 356 187 486 351 652 485 858
     [199] 383 313 566 873 199 708 993 529 549 790 957 353 707 914 877 371 403 941
     [217] 303 603 397 447 329 393 764 704 373  28 255 521 181 145 209 900 635 232
     [235]  11 444 610  83  13 845 990 403 333   9 206 465 713 430 749 539 330 109
     [253] 355 247  64 228 833 434 372 113 704 543 338 981 353 402 605 567  41 898
     [271]   5  70 820 967 784 286 606 699 440 690 594 778 599 478  32 259 166 997
     [289] 428 118 466  71 700 660 725 972 134 415 473 273 714 409 192 910 581 612
     [307] 330 463 168 694 649 395 892 212 153 296 422 865 913 328  89 787  41 745
     [325] 946 260 352 668  90 992  25 976 809 893 617 533 257 999 700 781 620 205
     [343] 314 252 730 367  63  59 118 311 114 258 521 995 110 512 795 348 567 856
     [361] 564 332 247 256 704 788 655 896 304 518 721 891 572 794  18 574 705  41
     [379]  89  45 215 245 161 330 368 255 858 774 797 340 618 244  87 862  66 771
     [397]  84 821  30 942  58 568 256 725 965 732  64 158 666 323  45 609 158 419
     [415] 277 943 680 128 505 813 687 916 643 698 503   2 964  59  15 858 228 175
     [433] 195 657 335 636 446 585 487 565 622 595 787 631 872  82 911 581 462 655
     [451] 965 694 303 520 908 814  32 520 642  94 565 628 861 958 690 272 105 717
     [469] 121 436 262 677 124 102 705 547  60 328 732 594 679 277  22 394 160 943
     [487] 806 844 790 168 816 741 532 955 860 920 968 716 733  13 867 383  42 561
     [505] 374 694 871 688 598  63 244 758 458 614 190 318 261 823   3  81 295  25
     [523] 661 689 926 593 666 727 399 462 640 117 687 250 589 327 905  85 935 685
     [541] 585  47 649 853 664 155 120 365 168 474 231 159 210 267 261 686 973 443
     [559] 629 119 877 845 840  52 636 506 700 952 128 766 839 618 279 116 698 881
     [577] 566 247 108 570 849 172 845  40 311 297 125 899 660 489 272 738  66 117
     [595] 430 842 119 116 133 116 837 232 169 335 982 129 554 221 146 800 864 424
     [613] 341 209 943  16 853 815 199 177 201 640 528 808 245 710 139 156 326 397
     [631] 553 607 101 704  80 441 986  51 351 507  60  10 289 405 445  28 926 445
     [649] 585 178 469 118 356 932 507 463 879 956 179 152 358 843 140 352 198 424
     [667] 715 604 940 612  64 494 331 369 601 659 393   9 301 535 912 554 538 401
     [685] 215 845 327 691 247 354 211  13  23  88 797 791 300 560 367 565 813  78
     [703] 323 621 779 372 580 303  23 169 393 202 173 147  86 489 747 399 273  95
     [721] 826 259 623 488 244 528 925 581 534 235 683 658 683 779 879 717 612 458
     [739] 144 256  14 377 494 342 380 431 564 431 145 744 882 962 235 890 225 603
     [757] 318 957  67 740 353 248 688 453 502 493 457  45 332 288 416 132 397 838
     [775] 416  14  39 578 471 913 701 398  99 322 122  95  97 100  76 599 265 869
     [793] 276 301 397 676 984 492  94 157 689 462 501 916 252 163 487 701 534 979
     [811] 998 698 113  30 759 413 461  57 135 462 115 574 900 591  55 116 939 365
     [829] 672 317 931 499 371 896 428 936 673 145 915 485  11 944 165 247 116 778
     [847] 216 885 834 901 569 850 128 386 520 158 275 664 269 221 178  15 432 543
     [865] 612  87 981 381 537 509 606 905 824 716  92 338  93 670 894 868 296 722
     [883] 341 298 273 770 803 520 655 159 683 811 646 743 717 905 709 490 385 139
     [901] 161 398 348 465 424 946 931 943 974 837 639 107 455 565 131 545 381 311
     [919] 506 247 776 377 356 786 922 472 244 222 426 742 455 910 360 723  16 244
     [937]  28 770 733 266  93   1 772 276 488 340  84 673 345 437 710 790 493 427
     [955] 817 561 138 794 809  79 979  33 232 723 971  82 498 703 375 803 852 512
     [973] 799 337 434 548 448 426 157 554 931 174 222 359 734 318 690 372 567 254
     [991] 210 843 422  52 711 931   5 695 299 700
    
    $resamples[[10]]
       [1]  838  838  536  806  502  749  597  264   48  628  663  658  647  466
      [15]  412  231  752  119  564  398  380  435  832  470   41  342  120  527
      [29]  307  508  106  155   17  189  583  552  864  147  529   86  396  967
      [43]  976  368  934  209  933  277  856  297  705  257   71  973  772  279
      [57]  147  304  800  936  140  698  373  478  759  707  986  668  925  271
      [71]  488  977  692  544  554  309  670  448  223  176  129  795  426  494
      [85]  581  173  251  164  762  417  538  536   89  523  488  809  327  687
      [99]  277  305  627  222  701  123   52  499  288  426  348  808  463  312
     [113]  195  756  668  594  170  100   50  416  120  994  900  611  411  590
     [127]  609  981   11  905  118  135  904  165  296  413  662  537  114  392
     [141]  911  337  207  489  372  576  681  193  956  640  935  166  937  348
     [155]  498  240  577  299  891  960  994  742  158  697  542  957  656  118
     [169]  194  678  319  150  106  828  656  877  399  504  378  111  478   73
     [183]  248  147   33  590   20  303  246  949   39  396   14   69  345  152
     [197]  590  988  857  705  164  614  577  778  204  430  937  722  890  626
     [211]  937  700  842  634  511  323  675  311  824  968  418  753  929  581
     [225]  587  912  466  170  870  857  319  699 1000  685  325  751  137  769
     [239]  127  398  297   36  339  550  409  817  148  635  262  368  567  500
     [253]  713  308  521  423  766  129  737  682   14   15  217   23  446  756
     [267]   28  254  993  111  857  477  833  974  165   72  297  957  255  167
     [281]  180    7  483  237  861  962  489  125  951  561  561  676  131  172
     [295]  793  840  933  902  659  269  893  524  906  997  900  784   60  758
     [309]  613  615  868  907  811  406   38  668  474  614  316  572  536  405
     [323]  150  125  897  809  351  456  403  325  258    1  375    3   92  874
     [337]  838  384  510   19  368  687  803  284  834  589  701  851  697  135
     [351]  717  234  661  410  184   34  471  152   53  339  768  151  552  233
     [365]  990  266  935  330  836  479   46   46  127  573  885  114  317  822
     [379]  523  563  414  631  648  561  684  323  213  104  600  388  647    5
     [393]  966  798  778  700  156  241  493  279  614  234  852  588  645  262
     [407]  350  630  675  106  276  374   13  909  966  854  369  692  305  413
     [421]  673  208  121  875  346  580  999  687   88  947  386  112  612  656
     [435]  284  938  987  844  920  195  707  389  835  115  641  454  346  169
     [449]  892  265  838  112  272  826   42  947  384  169  167  622  636  717
     [463]  354  494  298   83   91  477  819   95  886  436  878  995  826  349
     [477]  160  879  134  564   64  719  443  696  931  889  563  523  805  681
     [491]   61  474  583  164  884  638  319  106  772  696  715  159  198  215
     [505]  130  660  865  305  997   21  138  509  475  989  791  691  694  318
     [519]  246  437  384  332  388  787  486   35  669  909  999  964  762  689
     [533]  888  562  791  948  350   63  569  716   87   33  288  637  148  466
     [547]   16  574   67  982   63  900  544  891  864  834  541  772  552  750
     [561]  438  493  660  877  604  788  291   80  331  573  166  549  711  513
     [575]  153  772  628  306  979  449  406  773  364  436  770   40  800  566
     [589]  751  720  466  593  345  228  135  508  838  530  787  907  485  136
     [603]   56  172  427  282  944   92  717  225  999  664  894  916  487  474
     [617]  555  887  937   42   98  241  454  333  919  428   75  583  961  443
     [631]   12  820  276  411  352  172  195  425  365  444  562  179  625  661
     [645]  174  793  673   81  338  322  637  444  859   37  585  504  536  139
     [659]  898  143  431  118  215  759   17  648  277  852  218  489  777  881
     [673]  276  861  766  585  403  396  853  281  607  879  888  218  883  398
     [687]  517  604  573  919  548  757   43  659  620  774  768  169  211  459
     [701]  192  674  525  721  858  750  171  177   40  398  476  291  512  893
     [715]   74  146  230  164  457  771  851  326  463  732  183  359   69  944
     [729]  818  822  880  733  218  883  711  514  867  465  945  934  659  894
     [743]   51  322  376  563  215   18  577    4  765  464  794  694  185  113
     [757]  378  849  105    3  653  875  662  516  505  840  732  881  749  374
     [771]  952  508  327  111  185  126  482  325  596  584   25  186   60  958
     [785]  472  695  427  676  717  535  163  100  567   62  269  402  164  187
     [799]  599  808  453  190  245  102  149  645  372  862  579  288   91  876
     [813]  336    6  527  466  708  277  995  967  749  749  694  623  713   69
     [827]  728  127  109  467  759  609  398  625  870  107  665  720  973  498
     [841]  318  215  795  831  362  538  815  131  635  406  419  592   27   69
     [855]  219  370  125  141  357  965  564  174  356  622  976  773  389  628
     [869]  197  295  480  498  501  640  323   83  240  262  795   21  467   20
     [883]  521  275   26  568  196  155  823  999  190  956  670  703  124  785
     [897]   77  844  716  583  300  240  893  734  277  832  272  106  644  145
     [911]  697  744  651  822  838  173  367  318  788  457  952  297  903  287
     [925]  217   18  417  237  768  107  512  353  961  305  691  500  994  355
     [939]  911  742  180  922  756  468  863   67  919   41  785  208  632  209
     [953]  957  615  929  464  862  892   68  962  421  531  136  360  707  815
     [967]  546  866  196  637  466  439  175  908  785  264  464  610  824  805
     [981]  547  901  565  518  388  571  461  874   95  674   80   91  389  823
     [995]   52   60   49  698  146  209
    
    
    $original
    Outlier-Robust 2SLS Model 
    Initial estimator:  saturated 
    Reference distribution:  normal 
    Two-stage Least-Squares Model: y ~ x1 + x2 + x3 + x4 + x5 | x1 + x2 + x3 + z4 + z5 + z6 
    Iterations:  2 
    Final selection:  Outliers found:  34     Outliers proportion:  0.034 
    
    attr(,"class")
    [1] "r2sls_boot"

# extract_boot() works correctly

       X.Intercept. x1          x2        x3          x4        x5  m gauge  r
    1   -0.16423128 NA  0.09838952 0.7554412  0.81082980 0.4197672 m0 0.043  0
    5   -0.42449811 NA -0.28891413 0.2958235  1.60544532 0.3284866 m0 0.041  1
    9   -0.19486576 NA  0.11501128 0.6975547  0.81243705 0.4497745 m0 0.042  2
    13  -0.04339017 NA  0.10604116 0.7006944  0.76295660 0.4351493 m0 0.037  3
    17   0.83553644 NA  2.08791390 2.6497849 -2.52009639 0.7965948 m0 0.046  4
    21  -0.19320960 NA  0.25262404 0.9027499  0.61218833 0.4134014 m0 0.048  5
    25   0.09273114 NA  0.48696841 1.2466315  0.07171286 0.4669341 m0 0.051  6
    29  -0.28949315 NA  0.04767542 0.6378383  1.10392763 0.3763080 m0 0.035  7
    33   0.10618913 NA  0.94625628 1.4767236 -0.42240291 0.6128926 m0 0.039  8
    37  -0.23013345 NA  0.29573052 0.8023522  0.66011659 0.4757657 m0 0.040  9
    41  -0.16948269 NA -0.40367453 0.2052077  1.61141101 0.3931555 m0 0.051 10

---

       X.Intercept. x1           x2         x3        x4        x5  m gauge  r
    2   -0.17641899 NA  0.071183572 0.71576933 0.8607925 0.4302637 m1 0.039  0
    6   -0.66766994 NA -0.582144442 0.02607292 2.1744650 0.2294951 m1 0.031  1
    10  -0.06698538 NA  0.266355756 0.88557640 0.4561790 0.4923297 m1 0.035  2
    14  -0.11353069 NA -0.085681191 0.46397661 1.1088961 0.3882579 m1 0.036  3
    18  -0.09545578 NA -0.003440662 0.66417445 0.9223154 0.3189445 m1 0.021  4
    22  -0.21998948 NA  0.316498804 0.94400651 0.4926799 0.4425193 m1 0.037  5
    26  -0.13916971 NA  0.027456398 0.80218240 0.8455441 0.3447881 m1 0.048  6
    30  -0.43187099 NA -0.158525453 0.44955118 1.4662059 0.3417812 m1 0.026  7
    34  -0.08949921 NA  0.555232279 1.07396465 0.2329891 0.5448959 m1 0.014  8
    38  -0.27836399 NA  0.277611125 0.77103108 0.6770450 0.4613643 m1 0.031  9
    42  -0.29170790 NA -0.600097755 0.06787593 1.9026544 0.3432818 m1 0.046 10

---

       X.Intercept. x1          x2         x3         x4        x5  m gauge  r
    1   -0.17641899 NA  0.07118357 0.71576933  0.8607925 0.4302637 m1 0.039  0
    2   -0.66766994 NA -0.58214444 0.02607292  2.1744650 0.2294951 m1 0.031  1
    3   -0.06698538 NA  0.26635576 0.88557640  0.4561790 0.4923297 m1 0.035  2
    4   -0.11353069 NA -0.08568119 0.46397661  1.1088961 0.3882579 m1 0.036  3
    5    0.16338911 NA  0.62591855 1.28756639 -0.1498303 0.4425880 m6 0.018  4
    6   -0.21998948 NA  0.31649880 0.94400651  0.4926799 0.4425193 m1 0.037  5
    7   -0.09115500 NA  0.15209986 0.92988396  0.5999764 0.4204470 m4 0.047  6
    8   -0.43187099 NA -0.15852545 0.44955118  1.4662059 0.3417812 m1 0.026  7
    9   -0.08949921 NA  0.55523228 1.07396465  0.2329891 0.5448959 m1 0.014  8
    10  -0.27836399 NA  0.27761113 0.77103108  0.6770450 0.4613643 m1 0.031  9
    11  -0.29170790 NA -0.60009776 0.06787593  1.9026544 0.3432818 m1 0.046 10

# evaluate_boot() works correctly

      X.Intercept. x1        x2        x3       x4       x5       gauge
    1    0.3356252 NA 0.6820347 0.6724583 1.151733 0.130071 0.005403702
      theory_gauge m
    1  0.004610476 0

---

      X.Intercept. x1        x2        x3        x4         x5    gauge
    1    0.1809713 NA 0.3596016 0.3405184 0.6096371 0.09005173 0.010104
      theory_gauge m
    1  0.007731479 1

---

      X.Intercept. x1        x2        x3      x4        x5       gauge
    1    0.3697423 NA 0.7430389 0.7247708 1.26345 0.1422645 0.008225238
      theory_gauge m
    1  0.009338738 2

---

      X.Intercept. x1        x2        x3        x4        x5       gauge
    1    0.2059683 NA 0.4709452 0.4329343 0.7750922 0.1173063 0.008646597
      theory_gauge m
    1   0.01013444 3

---

      X.Intercept. x1        x2        x3        x4         x5       gauge
    1    0.3356252 NA 0.6820347 0.6724583 1.1517327 0.13007096 0.005403702
    2    0.1809713 NA 0.3596016 0.3405184 0.6096371 0.09005173 0.010104005
    3    0.3697423 NA 0.7430389 0.7247708 1.2634502 0.14226447 0.008225238
    4    0.2059683 NA 0.4709452 0.4329343 0.7750922 0.11730633 0.008646597
      theory_gauge m
    1  0.004610476 0
    2  0.007731479 1
    3  0.009338738 2
    4  0.010134437 3

---

      X.Intercept. x1        x2        x3        x4         x5      gauge
    1    0.1702842 NA 0.3755665 0.3560021 0.6257264 0.08280282 0.00908145
      theory_gauge m
    1  0.007731479 1

