% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_estimators.R
\name{iis_init}
\alias{iis_init}
\title{Impulse Indicator Saturation (IIS initial estimator)}
\usage{
iis_init(
  data,
  formula,
  gamma,
  t.pval = gamma,
  do.pet = FALSE,
  normality.JarqueB = NULL,
  turbo = FALSE,
  overid = NULL,
  weak = NULL
)
}
\arguments{
\item{data}{A dataframe.}

\item{formula}{A formula in the format \code{y ~ x1 + x2 | x1 + z2} where
\code{y} is the dependent variable, \code{x1} are the exogenous regressors,
\code{x2} the endogenous regressors, and \code{z2} the outside instruments.}

\item{gamma}{A numeric value between 0 and 1 representing the significance
level used for two-sided significance t-test on the impulse indicators.
Corresponds to the probability of falsely classifying an observation as an
outlier.}

\item{t.pval}{A numeric value between 0 and 1 representing the significance
level for the Parsimonious Encompassing Test (PET).}

\item{do.pet}{logical. If \code{TRUE}, then a Parsimonious Encompassing Test (PET) against the GUM is undertaken at each regressor removal for the joint significance of all the deleted regressors along the current path. If FALSE (default), then a PET is not undertaken at each regressor removal. By default, the numeric value is the same as that of \code{t.pval}}

\item{normality.JarqueB}{\code{NULL} (the default) or a value between 0 and 1. In the latter case, a test for non-normality is conducted using a significance level equal to \code{normality.JarqueB}. If \code{NULL}, then no test for non-normality is conducted}

\item{turbo}{logical. If \code{TRUE}, then (parts of) paths are not searched twice (or more) unnecessarily, thus yielding a significant potential for speed-gain. However, the checking of whether the search has arrived at a point it has already been comes with a slight computational overhead. Accordingly, if \code{turbo=TRUE}, then the total search time might in fact be higher than if \code{turbo=FALSE}. This happens if estimation is very fast, say, less than quarter of a second. Hence the default is \code{FALSE}}

\item{overid}{\code{NULL} if no Sargan test of overidentifying restrictions
should be used as a diagnostic check for model selection or a numeric value
between 0 and 1. In the latter case, the test is conducted using this value
as the significance level.}

\item{weak}{\code{NULL} if no weak instrument F-test on the first stage
should be used as a diagnostic check for model selection or a numeric value
between 0 and 1. In the latter case, the test is conducted using this value
as the significance level.}
}
\value{
\code{iis_init} returns a list with five elements. The first
four are vectors whose length equals the number of observations in the data
set. Unlike the residuals stored in a model object (usually accessible via
\code{model$residuals}), it does not ignore observations where any of y, x
or z are missing. It instead sets their values to \code{NA}.

The first element is a double vector containing the residuals for each
observation based on the model estimates. The second element contains the
standardised residuals, the third one a logical vector with \code{TRUE} if
the observation is judged as not outlying, \code{FALSE} if it is an outlier,
and \code{NA} if any of y, x, or z are missing. The fourth element of the
list is an integer vector with three values: 0 if the observations is judged
to be an outlier, 1 if not, and -1 if missing. The fifth and last element
stores the \code{\link[ivreg]{ivreg}} model object based on which the four
vectors were calculated.
}
\description{
Impulse Indicator Saturation (IIS initial estimator)
}
\section{Note}{

IIS runs multiple models, similar to \code{\link{saturated_init}} but with
multiple block search. These intermediate models are not recorded. For
simplicity, the element \code{$model} of the returned list stores the full
sample model result, identical to \code{\link{robustified_init}}.
}

