% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{weighted_median_line}
\alias{weighted_median_line}
\title{Robust simple linear regression based on medians}
\usage{
weighted_median_line(x, y = NULL, w, type = "slopes", na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector (explanatory variable)}

\item{y}{a numeric vector (response variable)}

\item{w}{a numeric vector of weights}

\item{type}{either "slopes" (default) or "products"}

\item{na.rm}{a logical value indicating whether rows with \code{NA}
values should be stripped before the computation proceeds}
}
\value{
a vector with two components: intercept and slope
}
\description{
For type medslopes the median individual ratios response/explanatory
is used as estimator of the slope. For version ratiomeds the ratio of
the median crossproduct to the median of squares of the explanatory
variable is used as the estimator of the slope. Survey weights may be used.
Missing values are neglected.
}
\details{
Uses \code{weighted_median()}. The median of slopes (type="slopes")
uses \eqn{b1=M((y-M(y,w))/(x-M(x,w)), w)}. The median of crossproducts
by median of squares (type="products") uses
\eqn{b1=M((y-M(y,w))(x-M(x,w)), w )/ M((x-M(x,w )^2), w )}, where
\eqn{M(x, w)} is shorthand for the function \code{weighted_median(x, w)}.
The function allows weights and missing values.
}
\examples{
x <- c(1, 2, 4, 5)
y <- c(3, 2, 7, 4)
weighted_line(y~x, w=rep(1, length(x)))
weighted_median_line(y~x, w=rep(1, length(x)))
weighted_median_line(y~x, w=rep(1, length(x)), type="prod")

data(cars)
with(cars, weighted_median_line(dist ~ speed, w=rep(1, length(dist))))
with(cars, weighted_median_line(dist ~ speed, w=rep(1, length(dist)), type="prod"))

# weighted
w <- c(rep(1,20), rep(2,20), rep(5, 10))
with(cars, weighted_median_line(dist ~ speed, w=w))
with(cars, weighted_median_line(dist ~ speed, w=w, type="prod"))

# outlier in y
cars$dist[49] <- 360
with(cars, weighted_median_line(dist ~ speed, w=w))
with(cars, weighted_median_line(dist ~ speed, w=w, type="prod"))

# outlier in x
data(cars)
cars$speed[49] <- 72
with(cars, weighted_median_line(dist ~ speed, w=w))
with(cars, weighted_median_line(dist ~ speed, w=w, type="prod"))
}
\seealso{
\code{\link[stats]{line}}, \code{\link{weighted_line}},
\code{\link{weighted_median_ratio}}
}
