% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occurrence.R
\name{occurrence}
\alias{occurrence}
\title{Find occurrences.}
\usage{
occurrence(scientificname = NULL, taxonid = NULL, datasetid = NULL,
  nodeid = NULL, areaid = NULL, startdate = NULL, enddate = NULL,
  startdepth = NULL, enddepth = NULL, geometry = NULL,
  measurementtype = NULL, measurementtypeid = NULL, measurementvalue = NULL,
  measurementvalueid = NULL, measurementunit = NULL, measurementunitid = NULL,
  redlist = NULL, hab = NULL, mof = NULL, absence = NULL, event = NULL,
  dropped = NULL, flags = NULL, exclude = NULL, fields = NULL,
  verbose = FALSE)
}
\arguments{
\item{scientificname}{the scientific name.}

\item{taxonid}{the taxon identifier (WoRMS AphiaID).}

\item{datasetid}{the dataset identifier.}

\item{nodeid}{the OBIS node identifier.}

\item{areaid}{the OBIS area identifier.}

\item{startdate}{the earliest date on which occurrence took place.}

\item{enddate}{the latest date on which the occurrence took place.}

\item{startdepth}{the minimum depth below the sea surface.}

\item{enddepth}{the maximum depth below the sea surface.}

\item{geometry}{a WKT geometry string.}

\item{measurementtype}{the measurement type to be included in the measurements data.}

\item{measurementtypeid}{the measurement type ID to be included in the measurements data.}

\item{measurementvalue}{the measurement value to be included in the measurements data.}

\item{measurementvalueid}{the measurement value ID to be included in the measurements data.}

\item{measurementunit}{the measurement unit to be included in the measurements data.}

\item{measurementunitid}{the measurement unit ID to be included in the measurements data.}

\item{redlist}{include only IUCN Red List species.}

\item{hab}{include only IOC-UNESCO HAB species.}

\item{mof}{include measurements data (default = \code{NULL}).}

\item{absence}{only include absence records (\code{TRUE}), exclude absence records (\code{NULL}) or include absence records (\code{include}).}

\item{event}{only include pure event records (\code{TRUE}), exclude pure event records (\code{NULL}) or include event records (\code{include}).}

\item{dropped}{only include dropped records (\code{TRUE}), exclude dropped records (\code{NULL}) or include dropped records (\code{include}).}

\item{flags}{quality flags which need to be set.}

\item{exclude}{quality flags to be excluded from the results.}

\item{fields}{fields to be included in the results.}

\item{verbose}{logical. Optional parameter to enable verbose logging (default = \code{FALSE}).}
}
\value{
The occurrence records.
}
\description{
Find occurrences.
}
\examples{
records <- occurrence(scientificname = "Abra sibogai")
records <- occurrence(taxonid = 141438, startdate = as.Date("2007-10-10"))
records <- occurrence(taxon = 141438, geometry = "POLYGON ((0 0, 0 45, 45 45, 45 0, 0 0))")
}
