% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bm_parameters.R
\name{get_lbm_param}
\alias{get_lbm_param}
\title{Estimate the parameters of a LBM}
\usage{
get_lbm_param(A, model_size = NULL, ...)
}
\arguments{
\item{A}{A matrix, the incident matrix of the network}

\item{model_size}{A vector of size 2, the size of the model parameters.
If \code{NULL}, the default, model will be chosen as the one with the
highest ICL criterion among all fitted models during the inference.}

\item{...}{Additional arguments pass to the inference function of
package \code{GREMLIN} if there are missing value and \code{blockmodels} if
none.}
}
\value{
A list of the LBM parameters. The list is set
}
\description{
Estimate the parameters of a LBM
}
\examples{
# When the size of the model is unknown:
data("seeddispersal")
param <- get_lbm_param(seeddispersal, ncores = 1L)
do.call(auc_robustness_lbm, param)

# For a fixed number of blocks (useful for comparison)
param <- get_lbm_param(seeddispersal, model_size = c(1, 3), ncores = 1L)
do.call(auc_robustness_lbm, param)

# For data with missing observations
\donttest{
A <- seeddispersal
A[sample(seq_len(nrow(A)), 5),
  sample(seq_len(ncol(A)), 10)] <- NA
param <- get_lbm_param(A, nbCores = 1L)
do.call(auc_robustness_lbm, param)}
}
