% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{phd}
\alias{phd}
\title{PhD Students in the EU}
\format{A data set on 32 compositions and 11 variables.}
\source{
\url{http://epp.eurostat.ec.europa.eu/cache/ITY_PUBLIC/1-18092009-AP/DE/1-18092009-AP-DE.PDF}
}
\description{
PhD students in Europe based on the standard klassification system splitted
by different kind of studies (given as percentages).
}
\details{
Due to unknown reasons the rowSums of the percentages is not always 100.

\itemize{
\item{\code{country }}{country of origin (German)}  
\item{\code{countryEN }}{country of origin (English)}    
\item{\code{country2 }}{country of origin, 2-digits}   
\item{\code{total }}{total phd students (in 1.000)}              
\item{\code{male }}{male phd students (in 1.000)}                   
\item{\code{female }}{total phd students (in 1.000)}               
\item{\code{technical }}{phd students in natural and technical sciences}
\item{\code{socio-economic-low }}{phd students in social sciences, economic sciences and law sciences}                    
\item{\code{human }}{phd students in human sciences including teaching}
\item{\code{health }}{phd students in health and life sciences}               
\item{\code{agriculture }}{phd students in agriculture} 
}
}
\examples{

data(phd)
phdImputed <- impCoda(phd[, 7:ncol(phd)])$xOrig

}
\references{
Hron, K. and Templ, M. and Filzmoser, P. (2010) Imputation of missing values for compositional data using classical and robust methods. \emph{Computational Statistics and Data Analysis}, vol 54 (12), pages 3095-3107.
}
\keyword{datasets}

