% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_spearman_inference.R
\name{BCIntervalSpearmanMultivariate}
\alias{BCIntervalSpearmanMultivariate}
\title{Bootstrap Confidence Interval on Spearman's Correlation Coefficient of a Multivariate Functional Dataset}
\usage{
BCIntervalSpearmanMultivariate(mfD, ordering = "MEI",
  bootstrap_iterations = 1000, alpha = 0.05, verbose = FALSE)
}
\arguments{
\item{mfD}{is the multivariate functional sample in form of \code{mfData} object.}

\item{ordering}{is either \code{MEI} (default) or \code{MHI}, and indicates the ordering relation
to be used during in the Spearman's coefficient computation.}

\item{bootstrap_iterations}{is the number of bootstrap iterations to use in order to estimate the
confidence intervals (default is 1000).}

\item{alpha}{controls the coverage probability (1-\code{alpha}).}

\item{verbose}{whether to log information on the progression of bootstrap iterations.}
}
\value{
The function returns a list of two elements, \code{lower} and \code{upper}, representing
the matrices of lower and upper ends of the bootstrap confidence intervals for each pair of
components. The elements on the main diagonal are set to 1.
}
\description{
This function computes the bootstrap confidence intervals of coverage probability
\eqn{1 - \alpha} for the Spearman correlation coefficients within a multivariate functional dataset.
}
\details{
The function takes a multivariate functional dataset and computes a matrix of bootstrap confidence
intervals for its Spearman correlation coefficients.
}
\examples{

set.seed(1)

N = 2e2
P = 1e2
grid = seq( 0, 1, length.out = P )

# Creating an exponential covariance function to simulate guassian data
Cov = exp_cov_function( grid, alpha = 0.3, beta = 0.4 )

# Simulating (independent) gaussian functional data with given center and
# covariance function
Data_1 = generate_gauss_fdata( N, centerline = sin( 2 * pi * grid ), Cov = Cov )
Data_2 = generate_gauss_fdata( N, centerline = sin( 4 * pi * grid ), Cov = Cov )
Data_3 = generate_gauss_fdata( N, centerline = sin( 6 * pi * grid ), Cov = Cov )

# Using the simulated data as (independent) components of a multivariate functional
# dataset
mfD = mfData( grid, list( Data_1, Data_2, Data_3 ) )

\dontrun{
BCIntervalSpearmanMultivariate(mfD, ordering = 'MEI')
}
# BC intervals contain zero since the functional samples are uncorrelated.

}
\seealso{
\code{\link{cor_spearman}}, \code{\link{cor_spearman_accuracy}}, \code{\link{fData}},
\code{\link{mfData}}, \code{\link{BCIntervalSpearman}}
}
