% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{minima}
\alias{minima}
\title{Minima of a univariate functional dataset}
\usage{
minima(fData, ..., which = FALSE)
}
\arguments{
\item{fData}{the functional dataset containing elements whose minima have to
be computed, in form of \code{fData} object.}

\item{...}{additional parameters.}

\item{which}{logical flag specifying whether the grid values where minima are
fulfilled have to be returned too.}
}
\value{
If \code{which = FALSE}, the function returns a vector containing the
minima for each element of the functional dataset; if \code{which = TRUE},
the function returns a \code{data.frame} whose field \code{value} contains
the values of minima, and \code{grid} contains the grid points where minima
are reached.
}
\description{
This function computes computes the minimum value of each element of a
univariate functional dataset, optionally returing also the value of the
grid where they are fulfilled.
}
\examples{

P = 1e3

grid = seq( 0, 1, length.out = P )

Data = matrix( c( 1 * grid,
                  2 *  grid,
                  3 * ( 0.5 - abs( grid - 0.5 ) ) ),
               nrow = 3, ncol = P, byrow = TRUE )

fD = fData( grid, Data )

minima( fD, which = TRUE )

}
\seealso{
\code{\link{maxima}}
}
