% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLandingsFromTarget.R
\name{getLandingsFromTarget}
\alias{getLandingsFromTarget}
\title{Get landing points inside harvest blocks}
\usage{
getLandingsFromTarget(harvest, landingDens = NULL, sampleType = "centroid")
}
\arguments{
\item{harvest}{sf, SpatialPolygons or RasterLayer object with harvested
areas. If it is a RasterLayer with more than one unique value other than 0
each value will be run separately which will produce different results from
a 0/1 raster but will be much slower.}

\item{landingDens}{number of landings per unit area. This should be in the
same units as the CRS of the harvest. Note that 0.001 points per m2 is > 1000
points per km2 so this number is usually very small for projected CRS.}

\item{sampleType}{character. "centroid" (default), "regular" or "random".
Centroid returns one landing per harvest block, which is guaranteed to be
in the harvest block for sf objects but not for rasters. Regular returns
points from a grid with density \code{landingDens} that overlap the
harvested areas. Random returns a random set of points from each polygon
where the number is determined by the area of the polygons and
\code{landingDens}. If \code{harvest} is a raster the centroid is always
returned as one of the landings to ensure all harvest areas get at least
one landing.}
}
\value{
an sf simple feature collection with an ID column and POINT geometry
}
\description{
Generate landing points inside polygons representing harvested area. There
are three different sampling types available: "centroid" is the default and
will return the centroid or a point that is inside the polygon if the
centroid is not (see \code{\link[sf:geos_unary]{st_point_on_surface}}); "random" takes a
random sample based on the given \code{landingDens} see
(\code{\link[sf]{st_sample}}); "regular" intersects the polygons with a
regular grid with cell size \code{sqrt(1/landingDens)}, if a polygon does not
intersect with the grid its centroid is used.
}
\details{
Note that the \code{landingDens} is in points per unit area where the unit of
area is determined by the CRS. For projected CRS this should likely be a very
small number i.e. < 0.001.
}
\examples{
doPlots <- interactive()

polys <- demoScen[[1]]$landings.poly[1:2,]
# Get centroid
outCent <- getLandingsFromTarget(polys)

if(doPlots){
  raster::plot(polys)
  plot(outCent, col = "red", add = TRUE)
}

# Get random sample with density 0.1 points per unit area
outRand <- getLandingsFromTarget(polys, 0.1, sampleType = "random")

if(doPlots){
  raster::plot(polys)
  plot(outRand, col = "red", add = TRUE)
}

# Get regular sample with density 0.1 points per unit area
outReg <- getLandingsFromTarget(polys, 0.1, sampleType = "regular")

if(doPlots){
  raster::plot(polys)
  plot(outReg, col = "red", add = TRUE)
}

}
