% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTS.R
\name{getTS}
\alias{getTS}
\title{This function retrieves time series data.}
\usage{
getTS(id, type, metadata = FALSE, parallel = FALSE)
}
\arguments{
\item{id}{station identification number(s), each number should be in the range [3002,236051].}

\item{type}{This is character string that can have one of the two following values: "cmr" (to obtain catchment mean rainfall) or "gdf" (to obtain gauged daily flow).}

\item{metadata}{Logical, FALSE by default. If metadata = TRUE means that the result for a single station is a list with two elements: data (the time series) and meta (metadata).}

\item{parallel}{Logical, FALSE by default. If parallel = TRUE means that the function can be used in parallel computations.}
}
\value{
list composed of as many objects as in the list of station identification numbers. Each object can be accessed using their names or index (e.g. x[[1]], x[[2]], and so forth). Each object contains a zoo time series.
}
\description{
Given the station identification number(s), this function retrieves data (time series in zoo format with accompanying metadata) from the WaterML2 service on the NRFA database. The time series can be of two types: \code{cmr} (catchment mean rainfall, monthly) or \code{gdf} (gauged daily flows, daily).
}
\examples{
# getTS(18019, type = "cmr")
# getTS(c(54022,54090,54091), type = "cmr")
# getTS(18019, type = "gdf")
# getTS(c(54022,54090,54091), type = "gdf")

}
\author{
Claudia Vitolo
}

