% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_data_download.R
\name{npn_get_data}
\alias{npn_get_data}
\title{Download NPN Data}
\usage{
npn_get_data(
  endpoint,
  query,
  download_path = NULL,
  always_append = FALSE,
  six_leaf_raster = NULL,
  six_bloom_raster = NULL,
  agdd_layer = NULL,
  additional_layers = NULL
)
}
\arguments{
\item{endpoint}{The endpoint to request data from starting at
'https://services.usanpn.org/npn_portal/'. E.g.
\code{"observations/getObservations.ndjson"}}

\item{download_path}{String, optional file path to the file for which to
output the results.}

\item{always_append}{Boolean flag. When set to \code{TRUE}, then we always append
data to the download path. This is used in the case of
\code{\link[=npn_get_data_by_year]{npn_get_data_by_year()}} where we're making multiple requests to the same
service and aggregating all data results in a single file. Without this
flag, otherwise, each call to the service would truncate the output file.}
}
\value{
A tibble of the requested data. If a \code{download_path} was specified,
the file path is returned.
}
\description{
Generic utility function for querying data from the NPN data services.
}
\examples{
\dontrun{
npn_get_data(
  endpoint = "observations/getObservations.ndjson",
  query = list(
    request_src = "Unit Test",
    climate_data = "0",
    `species_id[1]` = "6",
    start_date = "2010-01-01",
    end_date = "2010-12-31"
  )
)
}
}
\keyword{internal}
