% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonStatsAndPlots.R
\docType{methods}
\name{plotMatrices}
\alias{plotMatrices}
\alias{plotMatrices,rnaCrosslinkDataSet-method}
\title{Plots a number of contact maps to file of each sample for a stage in the analysis}
\usage{
plotMatrices(
  cds,
  type = "original",
  directory = 0,
  a = 1,
  b = 50,
  c = 1,
  d = 50,
  h = 3
)
}
\arguments{
\item{cds}{A rnaCrosslinkDataSet object}

\item{type}{The analysis stage to plot}

\item{directory}{An output directory for the heatmap (use 0 for no output)}

\item{a}{To make a subsetted plot (left value on x)}

\item{b}{To make a subsetted plot (right value on x)}

\item{c}{To make a subsetted plot (left value on y)}

\item{d}{To make a subsetted plot (right value on y)}

\item{h}{Height of image (inches) ( only useful if plotting)}
}
\value{
A heatmap of the reads in the analysis stage chosen
}
\description{
Plots a number of contact maps to file of each sample for a stage in the analysis
}
\examples{
cds = makeExamplernaCrosslinkDataSet()

plotMatrices(cds,
            b = rnaSize(cds),
            d = rnaSize(cds))
}
