% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{check_type}
\alias{check_type}
\title{Checks the value's class type, which should match at least of the types given in
any_expected_class_types.}
\usage{
check_type(value, any_expected_class_types, expected_length = 0)
}
\arguments{
\item{value}{A certain value (e.g. a single value, data.frame etc)}

\item{any_expected_class_types}{A vector of valid class types, any of which the @p value should have}

\item{expected_length}{The expected length of value (usually to check if its a single value); 0 (default) indicates that length can be ignored}
}
\description{
Checks the value's class type, which should match at least of the types given in
any_expected_class_types.
}
\examples{
  check_type(1, "numeric", 1)   # TRUE
  check_type("1", "numeric", 1) # FALSE
  check_type(1, "numeric", 2)   # FALSE
  check_type("ABC", "character", 1)             # TRUE
  check_type("ABC", "character")                # TRUE
  check_type("ABC", "character", 2)             # FALSE
  check_type(c("ABC", "DEF"), "character", 2)   # TRUE
  check_type(1.1, c("numeric", "double"))    # TRUE
  check_type(1.1, c("numeric", "double"), 1) # TRUE
  check_type(matrix(1:9, nrow=3), "matrix")   # TRUE
  check_type(data.frame(a=1:3, b=4:6), c("something", "data.frame"))   # TRUE

}
