% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_train_model.R
\name{rmw_train_model}
\alias{rmw_train_model}
\title{Function to train a random forest model to predict (usually) pollutant
concentrations using meteorological and time variables.}
\usage{
rmw_train_model(
  df,
  variables,
  n_trees = 300,
  mtry = NULL,
  min_node_size = 5,
  keep_inbag = TRUE,
  n_cores = NA,
  verbose = FALSE
)
}
\arguments{
\item{df}{Input tibble after preparation with \code{\link{rmw_prepare_data}}.
\code{df} has a number of constraints which will be checked for before
modelling.}

\item{variables}{Independent/explanatory variables used to predict 
\code{"value"}.}

\item{n_trees}{Number of trees to grow to make up the forest.}

\item{mtry}{Number of variables to possibly split at in each node. Default is 
the (rounded down) square root of the number variables.}

\item{min_node_size}{Minimal node size.}

\item{keep_inbag}{Should in-bag data be kept in the \strong{ranger} model 
object? This needs to be \code{TRUE} if standard errors are to be calculated
when predicting with the model.}

\item{n_cores}{Number of CPU cores to use for the model calculation. Default
is system's total minus one.}

\item{verbose}{Should the function give messages?}
}
\value{
A \strong{ranger} model object, a named list.
}
\description{
Function to train a random forest model to predict (usually) pollutant
concentrations using meteorological and time variables.
}
\examples{

\donttest{

# Load package
library(dplyr)

# Keep things reproducible
set.seed(123)

# Prepare example data
data_london_prepared <- data_london \%>\% 
  filter(variable == "no2") \%>\% 
  rmw_prepare_data()

# Calculate a model using common meteorological and time variables
model <- rmw_train_model(
  data_london_prepared,
  variables = c(
    "ws", "wd", "air_temp", "rh", "date_unix", "day_julian", "weekday", "hour"
  ),
  n_trees = 300
)

}

}
\seealso{
\code{\link{rmw_prepare_data}}, \code{\link{rmw_normalise}}
}
\author{
Stuart K. Grange
}
