% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blrm.r
\name{print.blrm}
\alias{print.blrm}
\title{print.blrm}
\usage{
\method{print}{blrm}(
  x,
  dec = 4,
  coefs = TRUE,
  intercepts = x$non.slopes < 10,
  prob = 0.95,
  ns = 400,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{object created by \code{\link[=blrm]{blrm()}}}

\item{dec}{number of digits to print to the right of the decimal}

\item{coefs}{specify \code{FALSE} to suppress printing parameter estimates, and in integer k to print only the first k}

\item{intercepts}{set to \code{FALSE} to suppress printing intercepts.   Default is to print them unless there are more than 9.}

\item{prob}{HPD interval probability for summary indexes}

\item{ns}{number of random samples of the posterior draws for use in computing HPD intervals for accuracy indexes}

\item{title}{title of output, constructed by default}

\item{...}{passed to \code{prModFit}}
}
\description{
Print \code{\link[=blrm]{blrm()}} Results
}
\details{
Prints main results from \code{\link[=blrm]{blrm()}} along with indexes and predictive accuracy and their highest posterior density intervals computed from \code{blrmStats}.
}
\examples{
\dontrun{
  f <- blrm(...)
  options(lang='html')   # default is lang='plain'; also can be latex
  f               # print using defaults
  print(f, posterior.summary='median')   # instead of post. means
}
}
\author{
Frank Harrell
}
