% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmcorr.R
\name{rmcorr}
\alias{rmcorr}
\title{Calculate the repeated measures correlation coefficient.}
\usage{
rmcorr(participant, measure1, measure2, dataset, CIs = c("analytic",
  "bootstrap"), nreps = 100, bstrap.out = F)
}
\arguments{
\item{participant}{A variable giving the subject name/id for each observation.}

\item{measure1}{A numeric variable giving the observations for one measure.}

\item{measure2}{A numeric variable giving the observations for the second measure.}

\item{dataset}{The data frame containing the variables.}

\item{CIs}{The method of calculating confidence intervals.}

\item{nreps}{The number of resamples to take if bootstrapping.}

\item{bstrap.out}{Determines if the output include the bootstrap resamples.}
}
\value{
A list with class "rmc" containing the following components.
\item{r}{the value of the repeated measures correlation coefficient.}
\item{df}{the degrees of freedom}
\item{p}{the p-value for the repeated measures correlation coefficient.}
\item{CI}{the 95\% confidence interval for the repeated measures correlation coefficient.}
\item{model}{the multiple regression model used to calculate the correlation coefficient.}
\item{resamples}{the bootstrap resampled correlation values.}
}
\description{
Calculate the repeated measures correlation coefficient.
}
\examples{
## Bland Altman 1995 data
rmcorr(Subject, PacO2, pH, bland1995)
}
\seealso{
\code{\link{plot.rmc}}
}
