/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.text.DecimalFormat;
import java.util.Random;
import weka.classifiers.functions.pace.ChisqMixture;
import weka.classifiers.functions.pace.NormalMixture;
import weka.core.RevisionUtils;
import weka.core.matrix.DoubleVector;
import weka.core.matrix.FlexibleDecimalFormat;
import weka.core.matrix.IntVector;
import weka.core.matrix.Maths;
import weka.core.matrix.Matrix;

public class PaceMatrix
extends Matrix {
    static final long serialVersionUID = 2699925616857843973L;

    public PaceMatrix(int m, int n) {
        super(m, n);
    }

    public PaceMatrix(int m, int n, double s) {
        super(m, n, s);
    }

    public PaceMatrix(double[][] A) {
        super(A);
    }

    public PaceMatrix(double[][] A, int m, int n) {
        super(A, m, n);
    }

    public PaceMatrix(double[] vals, int m) {
        super(vals, m);
    }

    public PaceMatrix(DoubleVector v) {
        this(v.size(), 1);
        this.setMatrix(0, v.size() - 1, 0, v);
    }

    public PaceMatrix(Matrix X) {
        super(X.getRowDimension(), X.getColumnDimension());
        this.A = X.getArray();
    }

    public void setRowDimension(int rowDimension) {
        this.m = rowDimension;
    }

    public void setColumnDimension(int columnDimension) {
        this.n = columnDimension;
    }

    @Override
    public Object clone() {
        PaceMatrix X = new PaceMatrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public void setPlus(int i, int j, double s) {
        double[] dArray = this.A[i];
        int n = j;
        dArray[n] = dArray[n] + s;
    }

    public void setTimes(int i, int j, double s) {
        double[] dArray = this.A[i];
        int n = j;
        dArray[n] = dArray[n] * s;
    }

    public void setMatrix(int i0, int i1, int j0, int j1, double s) {
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    this.A[i][j] = s;
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
    }

    public void setMatrix(int i0, int i1, int j, DoubleVector v) {
        int i = i0;
        while (i <= i1) {
            this.A[i][j] = v.get(i - i0);
            ++i;
        }
    }

    public void setMatrix(double[] v, boolean columnFirst) {
        try {
            if (v.length != this.m * this.n) {
                throw new IllegalArgumentException("sizes not match.");
            }
            int count = 0;
            if (columnFirst) {
                int i = 0;
                while (i < this.m) {
                    int j = 0;
                    while (j < this.n) {
                        this.A[i][j] = v[count];
                        ++count;
                        ++j;
                    }
                    ++i;
                }
            } else {
                int j = 0;
                while (j < this.n) {
                    int i = 0;
                    while (i < this.m) {
                        this.A[i][j] = v[count];
                        ++count;
                        ++i;
                    }
                    ++j;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public double maxAbs() {
        double ma = Math.abs(this.A[0][0]);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                ma = Math.max(ma, Math.abs(this.A[i][j]));
                ++i;
            }
            ++j;
        }
        return ma;
    }

    public double maxAbs(int i0, int i1, int j) {
        double m = Math.abs(this.A[i0][j]);
        int i = i0 + 1;
        while (i <= i1) {
            m = Math.max(m, Math.abs(this.A[i][j]));
            ++i;
        }
        return m;
    }

    public double minAbs(int i0, int i1, int column) {
        double m = Math.abs(this.A[i0][column]);
        int i = i0 + 1;
        while (i <= i1) {
            m = Math.min(m, Math.abs(this.A[i][column]));
            ++i;
        }
        return m;
    }

    public boolean isEmpty() {
        if (this.m == 0 || this.n == 0) {
            return true;
        }
        return this.A == null;
    }

    public DoubleVector getColumn(int j) {
        DoubleVector v = new DoubleVector(this.m);
        double[] a = v.getArray();
        int i = 0;
        while (i < this.m) {
            a[i] = this.A[i][j];
            ++i;
        }
        return v;
    }

    public DoubleVector getColumn(int i0, int i1, int j) {
        DoubleVector v = new DoubleVector(i1 - i0 + 1);
        double[] a = v.getArray();
        int count = 0;
        int i = i0;
        while (i <= i1) {
            a[count] = this.A[i][j];
            ++count;
            ++i;
        }
        return v;
    }

    public double times(int i, int j0, int j1, PaceMatrix B, int l) {
        double s = 0.0;
        int j = j0;
        while (j <= j1) {
            s += this.A[i][j] * B.A[j][l];
            ++j;
        }
        return s;
    }

    protected DecimalFormat[] format() {
        return this.format(0, this.m - 1, 0, this.n - 1, 7, false);
    }

    protected DecimalFormat[] format(int digits) {
        return this.format(0, this.m - 1, 0, this.n - 1, digits, false);
    }

    protected DecimalFormat[] format(int digits, boolean trailing) {
        return this.format(0, this.m - 1, 0, this.n - 1, digits, trailing);
    }

    protected DecimalFormat format(int i0, int i1, int j, int digits, boolean trailing) {
        FlexibleDecimalFormat df = new FlexibleDecimalFormat(digits, trailing);
        df.grouping(true);
        int i = i0;
        while (i <= i1) {
            df.update(this.A[i][j]);
            ++i;
        }
        return df;
    }

    protected DecimalFormat[] format(int i0, int i1, int j0, int j1, int digits, boolean trailing) {
        DecimalFormat[] f = new DecimalFormat[j1 - j0 + 1];
        int j = j0;
        while (j <= j1) {
            f[j] = this.format(i0, i1, j, digits, trailing);
            ++j;
        }
        return f;
    }

    @Override
    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int digits, boolean trailing) {
        if (this.isEmpty()) {
            return "null matrix";
        }
        StringBuffer text = new StringBuffer();
        DecimalFormat[] nf = this.format(digits, trailing);
        int numCols = 0;
        int count = 0;
        int width = 80;
        int[] nCols = new int[this.n];
        int nk = 0;
        int j = 0;
        while (j < this.n) {
            int lenNumber = nf[j].format(this.A[0][j]).length();
            if (count + 1 + lenNumber > width - 1) {
                nCols[nk++] = numCols;
                count = 0;
                numCols = 0;
            }
            count += 1 + lenNumber;
            ++numCols;
            ++j;
        }
        nCols[nk] = numCols;
        nk = 0;
        int k = 0;
        while (k < this.n) {
            int i = 0;
            while (i < this.m) {
                int j2 = k;
                while (j2 < k + nCols[nk]) {
                    text.append(" " + nf[j2].format(this.A[i][j2]));
                    ++j2;
                }
                text.append("\n");
                ++i;
            }
            k += nCols[nk];
            ++nk;
            text.append("\n");
        }
        return text.toString();
    }

    public double sum2(int j, int i0, int i1, boolean col) {
        double s2 = 0.0;
        if (col) {
            int i = i0;
            while (i <= i1) {
                s2 += this.A[i][j] * this.A[i][j];
                ++i;
            }
        } else {
            int i = i0;
            while (i <= i1) {
                s2 += this.A[j][i] * this.A[j][i];
                ++i;
            }
        }
        return s2;
    }

    public double[] sum2(boolean col) {
        int l = col ? this.n : this.m;
        int p = col ? this.m : this.n;
        double[] s2 = new double[l];
        int i = 0;
        while (i < l) {
            s2[i] = this.sum2(i, 0, p - 1, col);
            ++i;
        }
        return s2;
    }

    public double[] h1(int j, int k) {
        double[] dq = new double[2];
        double s2 = this.sum2(j, k, this.m - 1, true);
        dq[0] = this.A[k][j] >= 0.0 ? -Math.sqrt(s2) : Math.sqrt(s2);
        double[] dArray = this.A[k];
        int n = j;
        dArray[n] = dArray[n] - dq[0];
        dq[1] = this.A[k][j] * dq[0];
        return dq;
    }

    public void h2(int j, int k, double q, PaceMatrix b, int l) {
        double s = 0.0;
        int i = k;
        while (i < this.m) {
            s += this.A[i][j] * b.A[i][l];
            ++i;
        }
        double alpha = s / q;
        i = k;
        while (i < this.m) {
            double[] dArray = b.A[i];
            int n = l;
            dArray[n] = dArray[n] + alpha * this.A[i][j];
            ++i;
        }
    }

    public double[] g1(double a, double b) {
        double[] cs = new double[2];
        double r = Maths.hypot(a, b);
        if (r == 0.0) {
            cs[0] = 1.0;
            cs[1] = 0.0;
        } else {
            cs[0] = a / r;
            cs[1] = b / r;
        }
        return cs;
    }

    public void g2(double[] cs, int i0, int i1, int j) {
        double w = cs[0] * this.A[i0][j] + cs[1] * this.A[i1][j];
        this.A[i1][j] = -cs[1] * this.A[i0][j] + cs[0] * this.A[i1][j];
        this.A[i0][j] = w;
    }

    public void forward(PaceMatrix b, IntVector pvt, int k0) {
        int j = k0;
        while (j < Math.min(pvt.size(), this.m)) {
            this.steplsqr(b, pvt, j, this.mostExplainingColumn(b, pvt, j), true);
            ++j;
        }
    }

    public int mostExplainingColumn(PaceMatrix b, IntVector pvt, int ks) {
        int[] p = pvt.getArray();
        double ma = this.columnResponseExplanation(b, pvt, ks, ks);
        int jma = ks;
        int i = ks + 1;
        while (i < pvt.size()) {
            double val = this.columnResponseExplanation(b, pvt, i, ks);
            if (val > ma) {
                ma = val;
                jma = i;
            }
            ++i;
        }
        return jma;
    }

    public void backward(PaceMatrix b, IntVector pvt, int ks, int k0) {
        int j = ks;
        while (j > k0) {
            this.steplsqr(b, pvt, j, this.leastExplainingColumn(b, pvt, j, k0), false);
            --j;
        }
    }

    public int leastExplainingColumn(PaceMatrix b, IntVector pvt, int ks, int k0) {
        int[] p = pvt.getArray();
        double mi = this.columnResponseExplanation(b, pvt, ks - 1, ks);
        int jmi = ks - 1;
        int i = k0;
        while (i < ks - 1) {
            double val = this.columnResponseExplanation(b, pvt, i, ks);
            if (val <= mi) {
                mi = val;
                jmi = i;
            }
            ++i;
        }
        return jmi;
    }

    public double columnResponseExplanation(PaceMatrix b, IntVector pvt, int j, int ks) {
        double val;
        double[] xxx = new double[this.n];
        int[] p = pvt.getArray();
        if (j == ks - 1) {
            val = b.A[j][0];
        } else if (j > ks - 1) {
            int jm = Math.min(this.n - 1, j);
            DoubleVector u = this.getColumn(ks, jm, p[j]);
            DoubleVector v = b.getColumn(ks, jm, 0);
            val = v.innerProduct(u) / u.norm2();
        } else {
            int k = j + 1;
            while (k < ks) {
                xxx[k] = this.A[j][p[k]];
                ++k;
            }
            val = b.A[j][0];
            k = j + 1;
            while (k < ks) {
                double[] cs = this.g1(xxx[k], this.A[k][p[k]]);
                int l = k + 1;
                while (l < ks) {
                    xxx[l] = -cs[1] * xxx[l] + cs[0] * this.A[k][p[l]];
                    ++l;
                }
                val = -cs[1] * val + cs[0] * b.A[k][0];
                ++k;
            }
        }
        return val * val;
    }

    public void lsqr(PaceMatrix b, IntVector pvt, int k0) {
        double TINY = 1.0E-15;
        int[] p = pvt.getArray();
        int ks = 0;
        int j = 0;
        while (j < k0) {
            if (this.sum2(p[j], ks, this.m - 1, true) > 1.0E-15) {
                this.steplsqr(b, pvt, ks, j, true);
                ++ks;
            } else {
                pvt.shiftToEnd(j);
                pvt.setSize(pvt.size() - 1);
                --k0;
                --j;
            }
            ++j;
        }
        j = k0;
        while (j < Math.min(pvt.size(), this.m)) {
            if (this.sum2(p[j], ks, this.m - 1, true) > 1.0E-15) {
                this.steplsqr(b, pvt, ks, j, true);
                ++ks;
            } else {
                pvt.shiftToEnd(j);
                pvt.setSize(pvt.size() - 1);
                --j;
            }
            ++j;
        }
        b.m = this.m = ks;
        pvt.setSize(ks);
    }

    public void lsqrSelection(PaceMatrix b, IntVector pvt, int k0) {
        int numObs = this.m;
        int numXs = pvt.size();
        this.lsqr(b, pvt, k0);
        if (numXs > 200 || numXs > numObs) {
            this.forward(b, pvt, k0);
        }
        this.backward(b, pvt, pvt.size(), k0);
    }

    public void positiveDiagonal(PaceMatrix Y, IntVector pvt) {
        int[] p = pvt.getArray();
        int i = 0;
        while (i < pvt.size()) {
            if (this.A[i][p[i]] < 0.0) {
                int j = i;
                while (j < pvt.size()) {
                    this.A[i][p[j]] = -this.A[i][p[j]];
                    ++j;
                }
                Y.A[i][0] = -Y.A[i][0];
            }
            ++i;
        }
    }

    public void steplsqr(PaceMatrix b, IntVector pvt, int ks, int j, boolean adjoin) {
        int kp = pvt.size();
        int[] p = pvt.getArray();
        if (adjoin) {
            int pj = p[j];
            pvt.swap(ks, j);
            double[] dq = this.h1(pj, ks);
            int k = ks + 1;
            while (k < kp) {
                int pk = p[k];
                this.h2(pj, ks, dq[1], this, pk);
                ++k;
            }
            this.h2(pj, ks, dq[1], b, 0);
            this.A[ks][pj] = dq[0];
            k = ks + 1;
            while (k < this.m) {
                this.A[k][pj] = 0.0;
                ++k;
            }
        } else {
            int pj = p[j];
            int i = j;
            while (i < ks - 1) {
                p[i] = p[i + 1];
                ++i;
            }
            p[ks - 1] = pj;
            int i2 = j;
            while (i2 < ks - 1) {
                double[] cs = this.g1(this.A[i2][p[i2]], this.A[i2 + 1][p[i2]]);
                int l = i2;
                while (l < kp) {
                    this.g2(cs, i2, i2 + 1, p[l]);
                    ++l;
                }
                l = 0;
                while (l < b.n) {
                    b.g2(cs, i2, i2 + 1, l);
                    ++l;
                }
                ++i2;
            }
        }
    }

    public void rsolve(PaceMatrix b, IntVector pvt, int kp) {
        if (kp == 0) {
            b.m = 0;
        }
        int[] p = pvt.getArray();
        double[][] ba = b.getArray();
        int k = 0;
        while (k < b.n) {
            double[] dArray = ba[kp - 1];
            int n = k;
            dArray[n] = dArray[n] / this.A[kp - 1][p[kp - 1]];
            int i = kp - 2;
            while (i >= 0) {
                double s = 0.0;
                int j = i + 1;
                while (j < kp) {
                    s += this.A[i][p[j]] * ba[j][k];
                    ++j;
                }
                double[] dArray2 = ba[i];
                int n2 = k;
                dArray2[n2] = dArray2[n2] - s;
                double[] dArray3 = ba[i];
                int n3 = k;
                dArray3[n3] = dArray3[n3] / this.A[i][p[i]];
                --i;
            }
            ++k;
        }
        b.m = kp;
    }

    public PaceMatrix rbind(PaceMatrix b) {
        if (this.n != b.n) {
            throw new IllegalArgumentException("unequal numbers of rows.");
        }
        PaceMatrix c = new PaceMatrix(this.m + b.m, this.n);
        c.setMatrix(0, this.m - 1, 0, this.n - 1, this);
        c.setMatrix(this.m, this.m + b.m - 1, 0, this.n - 1, b);
        return c;
    }

    public PaceMatrix cbind(PaceMatrix b) {
        if (this.m != b.m) {
            throw new IllegalArgumentException("unequal numbers of rows: " + this.m + " and " + b.m);
        }
        PaceMatrix c = new PaceMatrix(this.m, this.n + b.n);
        c.setMatrix(0, this.m - 1, 0, this.n - 1, this);
        c.setMatrix(0, this.m - 1, this.n, this.n + b.n - 1, b);
        return c;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public DoubleVector nnls(PaceMatrix b, IntVector pvt) {
        counter = 0;
        jm = -1;
        n = pvt.size();
        p = pvt.getArray();
        x = new DoubleVector(n);
        xA = x.getArray();
        z = new PaceMatrix(n, 1);
        kp = 0;
        block0: while (true) {
            if (++counter > 3 * n) {
                throw new RuntimeException("Does not converge");
            }
            t = -1;
            max = 0.0;
            bt = new PaceMatrix(b.transpose());
            j = kp;
            while (j <= n - 1) {
                wj = bt.times(0, kp, this.m - 1, this, p[j]);
                if (wj > max) {
                    max = wj;
                    t = j;
                }
                ++j;
            }
            if (t == -1) {
                x.setSize(kp);
                pvt.setSize(kp);
                return x;
            }
            pvt.swap(kp, t);
            xA[++kp - 1] = 0.0;
            this.steplsqr(b, pvt, kp - 1, kp - 1, true);
            ma = 0.0;
            while (true) {
                block13: {
                    if (!(ma < 1.5)) continue block0;
                    j = 0;
                    while (j <= kp - 1) {
                        z.A[j][0] = b.A[j][0];
                        ++j;
                    }
                    this.rsolve(z, pvt, kp);
                    ma = 2.0;
                    jm = -1;
                    j = 0;
                    while (j <= kp - 1) {
                        if (z.A[j][0] <= 0.0 && (alpha = xA[j] / (xA[j] - z.A[j][0])) < ma) {
                            ma = alpha;
                            jm = j;
                        }
                        ++j;
                    }
                    if (!(ma > 1.5)) break block13;
                    j = 0;
                    if (true) ** GOTO lbl57
                }
                j = kp - 1;
                if (true) ** GOTO lbl68
                do {
                    xA[j] = z.A[j][0];
                    ++j;
lbl57:
                    // 2 sources

                } while (j <= kp - 1);
                continue;
                do {
                    if (j == jm) {
                        xA[j] = 0.0;
                        this.steplsqr(b, pvt, kp, j, false);
                        --kp;
                    } else {
                        v0 = j;
                        xA[v0] = xA[v0] + ma * (z.A[j][0] - xA[j]);
                    }
                    --j;
lbl68:
                    // 2 sources

                } while (j >= 0);
            }
            break;
        }
    }

    public DoubleVector nnlse(PaceMatrix b, PaceMatrix c, PaceMatrix d, IntVector pvt) {
        double eps = 1.0E-10 * Math.max(c.maxAbs(), d.maxAbs()) / Math.max(this.maxAbs(), b.maxAbs());
        PaceMatrix e = c.rbind(new PaceMatrix(this.times(eps)));
        PaceMatrix f = d.rbind(new PaceMatrix(b.times(eps)));
        return e.nnls(f, pvt);
    }

    public DoubleVector nnlse1(PaceMatrix b, IntVector pvt) {
        PaceMatrix c = new PaceMatrix(1, this.n, 1.0);
        PaceMatrix d = new PaceMatrix(1, b.n, 1.0);
        return this.nnlse(b, c, d, pvt);
    }

    public static Matrix randomNormal(int m, int n) {
        Random random = new Random();
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = random.nextGaussian();
                ++j;
            }
            ++i;
        }
        return A;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public static void main(String[] args) {
        System.out.println("===========================================================");
        System.out.println("To test the pace estimators of linear model\ncoefficients.\n");
        double sd = 2.0;
        int n = 200;
        double beta0 = 100.0;
        int k1 = 20;
        double beta1 = 0.0;
        int k2 = 20;
        double beta2 = 5.0;
        int k = 1 + k1 + k2;
        DoubleVector beta = new DoubleVector(1 + k1 + k2);
        beta.set(0, beta0);
        beta.set(1, k1, beta1);
        beta.set(k1 + 1, k1 + k2, beta2);
        System.out.println("The data set contains " + n + " observations plus " + (k1 + k2) + " variables.\n\nThe coefficients of the true model" + " are:\n\n" + beta);
        System.out.println("\nThe standard deviation of the error term is " + sd);
        System.out.println("===========================================================");
        PaceMatrix X = new PaceMatrix(n, k1 + k2 + 1);
        X.setMatrix(0, n - 1, 0, 0, 1.0);
        X.setMatrix(0, n - 1, 1, k1 + k2, PaceMatrix.random(n, k1 + k2));
        PaceMatrix Y = new PaceMatrix(X.times(new PaceMatrix(beta)).plusEquals(PaceMatrix.randomNormal(n, 1).times(sd)));
        IntVector pvt = IntVector.seq(0, k1 + k2);
        X.lsqrSelection(Y, pvt, 1);
        X.positiveDiagonal(Y, pvt);
        PaceMatrix sol = (PaceMatrix)Y.clone();
        X.rsolve(sol, pvt, pvt.size());
        DoubleVector betaHat = sol.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe OLS estimate (through lsqr()) is: \n\n" + betaHat);
        System.out.println("\nQuadratic loss of the OLS estimate (||X b - X bHat||^2) = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaHat)))).getColumn(0).sum2());
        System.out.println("===========================================================");
        System.out.println("             *** Pace estimation *** \n");
        DoubleVector r = Y.getColumn(pvt.size(), n - 1, 0);
        double sde = Math.sqrt(r.sum2() / (double)r.size());
        System.out.println("Estimated standard deviation = " + sde);
        DoubleVector aHat = Y.getColumn(0, pvt.size() - 1, 0).times(1.0 / sde);
        System.out.println("\naHat = \n" + aHat);
        System.out.println("\n========= Based on chi-square mixture ============");
        ChisqMixture d2 = new ChisqMixture();
        int method = 1;
        DoubleVector AHat = aHat.square();
        d2.fit(AHat, method);
        System.out.println("\nEstimated mixing distribution is:\n" + d2);
        DoubleVector ATilde = d2.pace2(AHat);
        DoubleVector aTilde = ATilde.sqrt().times(aHat.sign());
        PaceMatrix YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        DoubleVector betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe pace2 estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        ATilde = d2.pace4(AHat);
        aTilde = ATilde.sqrt().times(aHat.sign());
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe pace4 estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        ATilde = d2.pace6(AHat);
        aTilde = ATilde.sqrt().times(aHat.sign());
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe pace6 estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        System.out.println("\n========= Based on normal mixture ============");
        NormalMixture d = new NormalMixture();
        d.fit(aHat, method);
        System.out.println("\nEstimated mixing distribution is:\n" + d);
        aTilde = d.nestedEstimate(aHat);
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("The nested estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        aTilde = d.subsetEstimate(aHat);
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe subset estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        aTilde = d.empiricalBayesEstimate(aHat);
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe empirical Bayes estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
    }
}

