/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.framework;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.File2Array;
import dmLab.classifier.Params;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.cutoffMethods.Cutoff;
import dmLab.mcfs.mcfsEngine.MCFSAutoParams;
import dmLab.mcfs.mcfsEngine.arrays.MCFSArrays;
import dmLab.mcfs.mcfsEngine.framework.GlobalStats;
import dmLab.mcfs.mcfsEngine.framework.MCFSJob;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.dataframe.DataFrame;
import java.io.File;
import java.util.Date;
import java.util.Random;

public abstract class MCFSFramework
implements Runnable {
    protected MCFSParams mcfsParams;
    public MCFSArrays mcfsArrays;
    public GlobalStats globalStats;
    public String chartTitle;
    public String experimentName;
    protected Random random;

    /*
     * WARNING - void declaration
     */
    public MCFSFramework(Random random) {
        void var1_1;
        this.random = var1_1;
        this.experimentName = "";
        this.chartTitle = "MCFS-ID Progress";
    }

    /*
     * WARNING - void declaration
     */
    private void cleanTmpWekaFiles() {
        int i = 0;
        while (i < this.mcfsParams.threadsNumber) {
            void var3_3;
            void var2_2;
            String trainFilePath = String.valueOf(this.mcfsParams.resFilesPATH) + "C" + i + "_tmp_train.arff";
            String testFilePath = String.valueOf(this.mcfsParams.resFilesPATH) + "C" + i + "_tmp_test.arff";
            File trainFile = new File(trainFilePath);
            File testFile = new File(testFilePath);
            var2_2.delete();
            var3_3.delete();
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean run(MCFSParams mcfsParams) {
        Object object;
        this.mcfsParams = ((MCFSParams)object).clone();
        object = this;
        if (((MCFSFramework)object).mcfsArrays == null) {
            ((MCFSFramework)object).mcfsArrays = new MCFSArrays();
            MCFSParams mCFSParams = ((MCFSFramework)object).mcfsParams;
            object = ((MCFSFramework)object).mcfsArrays;
            ((MCFSFramework)object).mcfsArrays.sourceArray = new FArray();
            File2Array file2Array = new File2Array();
            if (!file2Array.load(((MCFSArrays)object).sourceArray, String.valueOf(mCFSParams.inputFilesPATH) + mCFSParams.inputFileName)) {
                return false;
            }
            if (!((MCFSArrays)object).sourceArray.checkDecisionValues()) {
                return false;
            }
            ((MCFSArrays)object).sourceArray.findDomains();
            boolean bl = true;
            if (!bl) {
                return false;
            }
        }
        boolean bl = true;
        if (!bl) {
            return false;
        }
        this.run();
        return true;
    }

    @Override
    public abstract void run();

    /*
     * WARNING - void declaration
     */
    protected final ConfusionMatrix runExperiment(FArray inputArray) {
        void var1_1;
        void var3_8;
        if (this.mcfsParams.verbose) {
            System.out.println(this.mcfsParams.toString());
        }
        if (!this.mcfsParams.check(inputArray)) {
            return null;
        }
        if (!inputArray.isTargetNominal()) {
            this.mcfsParams.balance = 0.0f;
            this.mcfsParams.finalRuleset = false;
        }
        if (this.mcfsParams.buildID) {
            System.out.println("MCFS-ID param: " + Params.intParamToString(this.mcfsParams.buildID ? 1 : 0, "ID-Graph"));
        }
        if (this.mcfsParams.finalCV) {
            System.out.println("MCFS-ID param: " + Params.intParamToString(this.mcfsParams.finalCV ? 1 : 0, "finalCV"));
        }
        if (this.mcfsParams.finalRuleset) {
            System.out.println("MCFS-ID param: " + Params.intParamToString(this.mcfsParams.finalRuleset ? 1 : 0, "finalRuleset"));
        }
        if (this.mcfsParams.balance != 0.0f) {
            System.out.println("MCFS-ID param: " + Params.intParamToString((int)this.mcfsParams.balance, " balance classes"));
        }
        this.mcfsParams.tmpBalancedClassSizes = MCFSAutoParams.getBalancedClassSizes(this.mcfsParams.balance, this.mcfsArrays.sourceArray);
        if (this.mcfsParams.cutoffMethod.equalsIgnoreCase("contrast")) {
            System.out.println("Adding Contrast Attributes...");
            FArray fArray = inputArray;
            int contrastColumns22 = Math.max(Math.round(((float)fArray.attributes.length - 1.0f) * this.mcfsParams.contrastSize), MCFSParams.CONTRAST_ATTR_MIN);
            DiscFunctions.addColumnsUniform(inputArray, MCFSParams.CONTRAST_ATTR_NAME, contrastColumns22);
            FArray contrastColumns22 = inputArray;
            System.out.println("Data size: attributes: " + contrastColumns22.attributes.length + " events: " + inputArray.rowsNumber());
        }
        this.globalStats = new GlobalStats();
        this.globalStats.init(inputArray, this.mcfsParams, this.experimentName, this.chartTitle);
        Cutoff cutoff = new Cutoff(this.mcfsParams);
        this.globalStats.setCutoff(cutoff);
        int threadsNumber = this.mcfsParams.threadsNumber;
        System.out.println("Starting MCFS-ID Procedure: projectionSize(m) = " + this.mcfsParams.projectionSizeValue + ", projections(s) = " + this.mcfsParams.projectionsValue + ", splits(t) = " + this.mcfsParams.splits);
        long start = System.currentTimeMillis();
        System.out.println("Start time: " + new Date(start).toString());
        MCFSJob[] mcfsJob = new MCFSJob[threadsNumber];
        Thread[] jobs = new Thread[threadsNumber];
        int i = 0;
        while (i < threadsNumber) {
            mcfsJob[i] = new MCFSJob(i, this.mcfsParams, inputArray, this.globalStats);
            mcfsJob[i].init(new Random(this.random.nextLong()));
            jobs[i] = new Thread(mcfsJob[i]);
            jobs[i].setPriority(8);
            ++i;
        }
        System.out.println("Running: " + threadsNumber + " threads.");
        i = 0;
        while (i < jobs.length) {
            jobs[i].start();
            if (this.mcfsParams.verbose) {
                System.out.println("Thread " + i + " Started...");
            }
            ++i;
        }
        try {
            i = 0;
            while (i < jobs.length) {
                jobs[i].join();
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            InterruptedException i2 = interruptedException;
            interruptedException.printStackTrace();
        }
        System.out.println("All " + threadsNumber + " threads are finished.");
        int i3 = 0;
        while (i3 < threadsNumber) {
            mcfsJob[i3].finish();
            ++i3;
        }
        long stop = System.currentTimeMillis();
        ConfusionMatrix confusionMatrix = this.globalStats.getConfusionMatrix();
        float experimentTime = (float)(stop - start) / 1000.0f;
        System.out.println(String.valueOf(this.mcfsParams.projectionsValue * this.mcfsParams.splits) + " trees built in " + DiscFunctions.timeIntervalFormat((float)var3_8));
        if (confusionMatrix != null) {
            System.out.println(confusionMatrix.toString());
            System.out.println(confusionMatrix.statsToString(4));
        } else {
            System.out.println("*** Prediction Summary on Random Subsample (st) ***");
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("pearson"));
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("MAE"));
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("RMSE"));
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("SMAPE"));
            System.out.println();
        }
        if (this.globalStats.getAttrConnections() != null) {
            this.globalStats.getAttrConnections().findMinMaxID();
            if (this.mcfsParams.saveResutFiles) {
                this.globalStats.getAttrConnections().save(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_ID);
            }
        }
        if (this.mcfsParams.saveResutFiles) {
            DataFrame distances = this.globalStats.getDistances();
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_DISTANCE, distances.toString());
            if (confusionMatrix != null) {
                String matrix = confusionMatrix.toString(false, true, false, ",");
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_MATRIX, matrix);
            } else {
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_PREDICTION_STATS, this.globalStats.getSplitsStats().toString());
            }
        }
        double minRI = cutoff.calcCutoff(this.globalStats.getAttrImportances()[0]);
        System.out.println("Minimal important (mean based on cutoff methods) RI = " + DiscFunctions.formatFloat(minRI, 7));
        if (this.mcfsParams.saveResutFiles) {
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_CUTOFF, cutoff.toString());
        }
        int mainMeasureIndex = this.globalStats.getAttrImportances()[0].mainMeasureIdx;
        Ranking topRanking = this.globalStats.getAttrImportances()[0].getTopRanking(mainMeasureIndex, (float)minRI);
        if (topRanking != null) {
            System.out.println("Size of important (mean based on cutoff methods) attributes set = " + topRanking.size());
            if (this.mcfsParams.saveResutFiles) {
                void var2_6;
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_TOPRANKING, var2_6.toString());
            }
        }
        this.cleanTmpWekaFiles();
        this.globalStats.closeChartFrame();
        if (this.mcfsParams.saveResutFiles) {
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + ".run", this.mcfsParams.toString());
        }
        System.out.println("");
        return var1_1;
    }
}

