/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.Utils;

public abstract class MultipleClassifiersCombiner
extends Classifier {
    private static final long serialVersionUID = 2776436621129422119L;
    protected Classifier[] m_Classifiers = new Classifier[]{new ZeroR()};

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tFull class name of classifier to include, followed\n\tby scheme options. May be specified multiple times.\n\t(default: \"weka.classifiers.rules.ZeroR\")", "B", 1, "-B <classifier specification>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String classifierString;
        Vector<Classifier> classifiers = new Vector<Classifier>();
        while ((classifierString = Utils.getOption('B', options)).length() != 0) {
            String[] classifierSpec = Utils.splitOptions(classifierString);
            if (classifierSpec.length == 0) {
                throw new IllegalArgumentException("Invalid classifier specification string");
            }
            String classifierName = classifierSpec[0];
            classifierSpec[0] = "";
            classifiers.addElement(Classifier.forName(classifierName, classifierSpec));
        }
        if (classifiers.size() == 0) {
            classifiers.addElement(new ZeroR());
        }
        Classifier[] classifiersArray = new Classifier[classifiers.size()];
        int i = 0;
        while (i < classifiersArray.length) {
            classifiersArray[i] = (Classifier)classifiers.elementAt(i);
            ++i;
        }
        this.setClassifiers(classifiersArray);
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        int current = 0;
        String[] options = new String[superOptions.length + this.m_Classifiers.length * 2];
        int i = 0;
        while (i < this.m_Classifiers.length) {
            options[current++] = "-B";
            options[current++] = this.getClassifierSpec(i);
            ++i;
        }
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public String classifiersTipText() {
        return "The base classifiers to be used.";
    }

    public void setClassifiers(Classifier[] classifiers) {
        this.m_Classifiers = classifiers;
    }

    public Classifier[] getClassifiers() {
        return this.m_Classifiers;
    }

    public Classifier getClassifier(int index) {
        return this.m_Classifiers[index];
    }

    protected String getClassifierSpec(int index) {
        if (this.m_Classifiers.length < index) {
            return "";
        }
        Classifier c = this.getClassifier(index);
        return String.valueOf(c.getClass().getName()) + " " + Utils.joinOptions(c.getOptions());
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getClassifiers().length == 0) {
            result = new Capabilities(this);
            result.disableAll();
        } else {
            result = (Capabilities)this.getClassifier(0).getCapabilities().clone();
            int i = 1;
            while (i < this.getClassifiers().length) {
                result.and(this.getClassifier(i).getCapabilities());
                ++i;
            }
        }
        Capabilities.Capability[] capabilityArray = Capabilities.Capability.values();
        int n = capabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Capabilities.Capability cap = capabilityArray[n2];
            result.enableDependency(cap);
            ++n2;
        }
        result.setOwner(this);
        return result;
    }
}

