/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Random;
import weka.classifiers.bayes.NaiveBayesUpdateable;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.NBTreeNoSplit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class NBTreeSplit
extends ClassifierSplitModel {
    private static final long serialVersionUID = 8922627123884975070L;
    private int m_complexityIndex;
    private int m_attIndex;
    private int m_minNoObj;
    private double m_splitPoint;
    private double m_sumOfWeights;
    private double m_errors;
    private C45Split m_c45S;
    NBTreeNoSplit m_globalNB;

    public NBTreeSplit(int attIndex, int minNoObj, double sumOfWeights) {
        this.m_attIndex = attIndex;
        this.m_minNoObj = minNoObj;
        this.m_sumOfWeights = sumOfWeights;
    }

    @Override
    public void buildClassifier(Instances trainInstances) throws Exception {
        this.m_numSubsets = 0;
        this.m_splitPoint = Double.MAX_VALUE;
        this.m_errors = 0.0;
        if (this.m_globalNB != null) {
            this.m_errors = this.m_globalNB.getErrors();
        }
        if (trainInstances.attribute(this.m_attIndex).isNominal()) {
            this.m_complexityIndex = trainInstances.attribute(this.m_attIndex).numValues();
            this.handleEnumeratedAttribute(trainInstances);
        } else {
            this.m_complexityIndex = 2;
            trainInstances.sort(trainInstances.attribute(this.m_attIndex));
            this.handleNumericAttribute(trainInstances);
        }
    }

    public final int attIndex() {
        return this.m_attIndex;
    }

    private void handleEnumeratedAttribute(Instances trainInstances) throws Exception {
        this.m_c45S = new C45Split(this.m_attIndex, 2, this.m_sumOfWeights);
        this.m_c45S.buildClassifier(trainInstances);
        if (this.m_c45S.numSubsets() == 0) {
            return;
        }
        this.m_errors = 0.0;
        Instances[] trainingSets = new Instances[this.m_complexityIndex];
        int i = 0;
        while (i < this.m_complexityIndex) {
            trainingSets[i] = new Instances(trainInstances, 0);
            ++i;
        }
        int i2 = 0;
        while (i2 < trainInstances.numInstances()) {
            Instance instance = trainInstances.instance(i2);
            int subset = this.m_c45S.whichSubset(instance);
            if (subset > -1) {
                trainingSets[subset].add((Instance)instance.copy());
            } else {
                double[] weights = this.m_c45S.weights(instance);
                int j = 0;
                while (j < this.m_complexityIndex) {
                    try {
                        Instance temp = (Instance)instance.copy();
                        if (weights.length == this.m_complexityIndex) {
                            temp.setWeight(temp.weight() * weights[j]);
                        } else {
                            temp.setWeight(temp.weight() / (double)this.m_complexityIndex);
                        }
                        trainingSets[j].add(temp);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.err.println("*** " + this.m_complexityIndex);
                        System.err.println(weights.length);
                        System.exit(1);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        Random r = new Random(1L);
        int minNumCount = 0;
        int i3 = 0;
        while (i3 < this.m_complexityIndex) {
            if (trainingSets[i3].numInstances() >= 5) {
                ++minNumCount;
                Discretize disc = new Discretize();
                disc.setInputFormat(trainingSets[i3]);
                trainingSets[i3] = Filter.useFilter(trainingSets[i3], disc);
                trainingSets[i3].randomize(r);
                trainingSets[i3].stratify(5);
                NaiveBayesUpdateable fullModel = new NaiveBayesUpdateable();
                fullModel.buildClassifier(trainingSets[i3]);
                this.m_errors += NBTreeNoSplit.crossValidate(fullModel, trainingSets[i3], r);
            } else {
                int j = 0;
                while (j < trainingSets[i3].numInstances()) {
                    this.m_errors += trainingSets[i3].instance(j).weight();
                    ++j;
                }
            }
            ++i3;
        }
        if (minNumCount > 1) {
            this.m_numSubsets = this.m_complexityIndex;
        }
    }

    private void handleNumericAttribute(Instances trainInstances) throws Exception {
        this.m_c45S = new C45Split(this.m_attIndex, 2, this.m_sumOfWeights);
        this.m_c45S.buildClassifier(trainInstances);
        if (this.m_c45S.numSubsets() == 0) {
            return;
        }
        this.m_errors = 0.0;
        Instances[] trainingSets = new Instances[this.m_complexityIndex];
        trainingSets[0] = new Instances(trainInstances, 0);
        trainingSets[1] = new Instances(trainInstances, 0);
        int subset = -1;
        int i = 0;
        while (i < trainInstances.numInstances()) {
            Instance instance = trainInstances.instance(i);
            subset = this.m_c45S.whichSubset(instance);
            if (subset != -1) {
                trainingSets[subset].add((Instance)instance.copy());
            } else {
                double[] weights = this.m_c45S.weights(instance);
                int j = 0;
                while (j < this.m_complexityIndex) {
                    Instance temp = (Instance)instance.copy();
                    if (weights.length == this.m_complexityIndex) {
                        temp.setWeight(temp.weight() * weights[j]);
                    } else {
                        temp.setWeight(temp.weight() / (double)this.m_complexityIndex);
                    }
                    trainingSets[j].add(temp);
                    ++j;
                }
            }
            ++i;
        }
        Random r = new Random(1L);
        int minNumCount = 0;
        int i2 = 0;
        while (i2 < this.m_complexityIndex) {
            if (trainingSets[i2].numInstances() > 5) {
                ++minNumCount;
                Discretize disc = new Discretize();
                disc.setInputFormat(trainingSets[i2]);
                trainingSets[i2] = Filter.useFilter(trainingSets[i2], disc);
                trainingSets[i2].randomize(r);
                trainingSets[i2].stratify(5);
                NaiveBayesUpdateable fullModel = new NaiveBayesUpdateable();
                fullModel.buildClassifier(trainingSets[i2]);
                this.m_errors += NBTreeNoSplit.crossValidate(fullModel, trainingSets[i2], r);
            } else {
                int j = 0;
                while (j < trainingSets[i2].numInstances()) {
                    this.m_errors += trainingSets[i2].instance(j).weight();
                    ++j;
                }
            }
            ++i2;
        }
        if (minNumCount > 1) {
            this.m_numSubsets = this.m_complexityIndex;
        }
    }

    @Override
    public final int whichSubset(Instance instance) throws Exception {
        return this.m_c45S.whichSubset(instance);
    }

    @Override
    public final double[] weights(Instance instance) {
        return this.m_c45S.weights(instance);
    }

    @Override
    public final String sourceExpression(int index, Instances data) {
        return this.m_c45S.sourceExpression(index, data);
    }

    @Override
    public final String rightSide(int index, Instances data) {
        return this.m_c45S.rightSide(index, data);
    }

    @Override
    public final String leftSide(Instances data) {
        return this.m_c45S.leftSide(data);
    }

    @Override
    public double classProb(int classIndex, Instance instance, int theSubset) throws Exception {
        if (theSubset > -1) {
            return this.m_globalNB.classProb(classIndex, instance, theSubset);
        }
        throw new Exception("This shouldn't happen!!!");
    }

    public NBTreeNoSplit getGlobalModel() {
        return this.m_globalNB;
    }

    public void setGlobalModel(NBTreeNoSplit global) {
        this.m_globalNB = global;
    }

    public double getErrors() {
        return this.m_errors;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

