% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rlowdb}
\alias{rlowdb}
\title{rlowdb: A Simple JSON-Based Database in R}
\description{
The `rlowdb` class provides a lightweight, JSON-based database solution
for storing and managing structured data in R.
It supports CRUD operations (Create, Read, Update, Delete)
and enables querying with custom functions.
}
\examples{

## ------------------------------------------------
## Method `rlowdb$get_data`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$get_data()
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$insert`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
unlink("database.json")


## ------------------------------------------------
## Method `rlowdb$find`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$find("users", "id", 1)
unlink("database.json")


## ------------------------------------------------
## Method `rlowdb$update`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$update("users", "id", 1, list(name = "Alice Updated"))
unlink("database.json")


## ------------------------------------------------
## Method `rlowdb$upsert`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(id = 100, name = "Coconut"))
db$upsert("users", "id", 1, list(name = "Alice Updated"))
unlink("database.json")


## ------------------------------------------------
## Method `rlowdb$delete`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$delete("users", "id", 1)
db$get_data()
unlink("database.json")


## ------------------------------------------------
## Method `rlowdb$query`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("posts", list(id = 1, title = "LowDB in R", views = 100))
db$insert("posts", list(id = 2, title = "Data Management", views = 250))
db$insert("posts", list(id = 3, title = "Advanced R", views = 300))

# Query posts with views > 200 AND id > 2
db$query("posts", "views > 200 & id > 2")

# Query posts with views > 100 OR id == 1
db$query("posts", "views > 100 | id == 1")

# Query all posts (no condition)
db$query("posts", "")

unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$filter`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("users", list(name = "Gamma", age = 36))
# Find users older than 30
db$filter("users", function(record) record$age > 30)
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$drop`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$drop("users")
db$get_data()
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$drop_all`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$drop_all()
db$get_data()
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$clear`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$clear("users")
db$get_data()
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$count`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("users", list(name = "Gamma", age = 36))
db$count("users")
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$list_collections`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$list_collections()
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$exists_collection`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$exists_collection("users")
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$exists_key`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$exists_key("users", "name")
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$exists_value`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$exists_value("users", "name", "Delta")
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$transaction`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$count("users")
db$transaction(function() {
  db$insert("users", list(name = "Zlatan", age = 40))
  db$insert("users", list(name = "Neymar", age = 28))
  # if an error is raised, a rollback will happen and
  # the records won't be inserted
})
db$count("users")
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$search`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$insert("users", list(id = 2, name = "Bob"))
db$insert("users", list(id = 3, name = "alice"))

# Case-sensitive search
db$search("users", "name", "Alice", ignore.case = FALSE)

# Case-insensitive search
db$search("users", "name", "alice", ignore.case = TRUE)
unlink("database.json")

## ------------------------------------------------
## Method `rlowdb$bulk_insert`
## ------------------------------------------------

db <- rlowdb$new("database.json")
db$bulk_insert("users", list(
  list(id = 1, name = "Alice", age = 25),
  list(id = 2, name = "Bob", age = 32),
  list(id = 3, name = "Charlie", age = 40)
))
db$count("users")
unlink("database.json")
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rlowdb-new}{\code{rlowdb$new()}}
\item \href{#method-rlowdb-get_data}{\code{rlowdb$get_data()}}
\item \href{#method-rlowdb-insert}{\code{rlowdb$insert()}}
\item \href{#method-rlowdb-find}{\code{rlowdb$find()}}
\item \href{#method-rlowdb-update}{\code{rlowdb$update()}}
\item \href{#method-rlowdb-upsert}{\code{rlowdb$upsert()}}
\item \href{#method-rlowdb-delete}{\code{rlowdb$delete()}}
\item \href{#method-rlowdb-query}{\code{rlowdb$query()}}
\item \href{#method-rlowdb-filter}{\code{rlowdb$filter()}}
\item \href{#method-rlowdb-drop}{\code{rlowdb$drop()}}
\item \href{#method-rlowdb-drop_all}{\code{rlowdb$drop_all()}}
\item \href{#method-rlowdb-clear}{\code{rlowdb$clear()}}
\item \href{#method-rlowdb-count}{\code{rlowdb$count()}}
\item \href{#method-rlowdb-list_collections}{\code{rlowdb$list_collections()}}
\item \href{#method-rlowdb-exists_collection}{\code{rlowdb$exists_collection()}}
\item \href{#method-rlowdb-exists_key}{\code{rlowdb$exists_key()}}
\item \href{#method-rlowdb-exists_value}{\code{rlowdb$exists_value()}}
\item \href{#method-rlowdb-transaction}{\code{rlowdb$transaction()}}
\item \href{#method-rlowdb-restore}{\code{rlowdb$restore()}}
\item \href{#method-rlowdb-backup}{\code{rlowdb$backup()}}
\item \href{#method-rlowdb-search}{\code{rlowdb$search()}}
\item \href{#method-rlowdb-bulk_insert}{\code{rlowdb$bulk_insert()}}
\item \href{#method-rlowdb-clone}{\code{rlowdb$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-new"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-new}{}}}
\subsection{Method \code{new()}}{
Initialize the database, loading data from a JSON file.
If the file does not exist, an empty database is created.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$new(file_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_path}}{The path to the JSON file that stores the database.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-get_data}{}}}
\subsection{Method \code{get_data()}}{
Retrieve all stored data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$get_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing all database records.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$get_data()
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-insert"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-insert}{}}}
\subsection{Method \code{insert()}}{
Insert a new record into a specified collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$insert(collection, record)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name (a string).}

\item{\code{record}}{A named list representing the record to insert.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
unlink("database.json")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-find"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-find}{}}}
\subsection{Method \code{find()}}{
Find records in a collection that match a given key-value pair.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$find(collection, key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name (a string).}

\item{\code{key}}{The field name to search for.}

\item{\code{value}}{The value to match.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of matching records. Returns an empty list if no match is found.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$find("users", "id", 1)
unlink("database.json")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-update"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-update}{}}}
\subsection{Method \code{update()}}{
Update existing records in a collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$update(collection, key, value, new_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name.}

\item{\code{key}}{The field name to search for.}

\item{\code{value}}{The value to match.}

\item{\code{new_data}}{A named list containing the updated data.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$update("users", "id", 1, list(name = "Alice Updated"))
unlink("database.json")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-upsert"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-upsert}{}}}
\subsection{Method \code{upsert()}}{
If a record exists, update it; otherwise, insert a new record.
Note that in order to use the method, the 'collection' has to
exist
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$upsert(collection, key, value, new_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name.}

\item{\code{key}}{The field name to search for.}

\item{\code{value}}{The value to match.}

\item{\code{new_data}}{A named list containing the updated data.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(id = 100, name = "Coconut"))
db$upsert("users", "id", 1, list(name = "Alice Updated"))
unlink("database.json")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-delete"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-delete}{}}}
\subsection{Method \code{delete()}}{
Delete records from a collection that match a given key-value pair.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$delete(collection, key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name.}

\item{\code{key}}{The field name to search for.}

\item{\code{value}}{The value to match.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$delete("users", "id", 1)
db$get_data()
unlink("database.json")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-query"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-query}{}}}
\subsection{Method \code{query()}}{
Query a collection using a condition string.
This function allows filtering records from a collection using a condition
string that is evaluated dynamically. The condition supports multiple logical
expressions using standard R operators (e.g., `>`, `<`, `==`, `&`, `|`).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$query(collection, condition = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name (a string).}

\item{\code{condition}}{A string representing a logical condition for filtering records.
- Supports comparisons (`>`, `<`, `>=`, `<=`, `==`, `!=`).
- Allows logical operators (`&` for AND, `|` for OR).
- Example: `"views > 200 & id > 2"`.
- If `NULL` or an empty string (`""`), returns all records.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of records that satisfy the condition. If no records match, returns an empty list.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("posts", list(id = 1, title = "LowDB in R", views = 100))
db$insert("posts", list(id = 2, title = "Data Management", views = 250))
db$insert("posts", list(id = 3, title = "Advanced R", views = 300))

# Query posts with views > 200 AND id > 2
db$query("posts", "views > 200 & id > 2")

# Query posts with views > 100 OR id == 1
db$query("posts", "views > 100 | id == 1")

# Query all posts (no condition)
db$query("posts", "")

unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-filter"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-filter}{}}}
\subsection{Method \code{filter()}}{
Filter Records Using a Custom Function
This method applies a user-defined function to filter records in a specified collection.
The function should take a record as input and return `TRUE` for records that should be included
in the result and `FALSE` for records that should be excluded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$filter(collection, filter_fn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{A character string specifying the name of the collection.}

\item{\code{filter_fn}}{A function that takes a record (a list) as input and returns `TRUE` or `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of records that satisfy the filtering condition.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("users", list(name = "Gamma", age = 36))
# Find users older than 30
db$filter("users", function(record) record$age > 30)
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-drop"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-drop}{}}}
\subsection{Method \code{drop()}}{
Just like DROP TABLE in SQL, drops a complete collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$drop(collection)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$drop("users")
db$get_data()
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-drop_all"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-drop_all}{}}}
\subsection{Method \code{drop_all()}}{
Drop all the collections available in your JSON file DB
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$drop_all()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$drop_all()
db$get_data()
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-clear"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-clear}{}}}
\subsection{Method \code{clear()}}{
Removes all records from a collection without deleting the collection itself
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$clear(collection)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{the collection name}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$clear("users")
db$get_data()
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-count"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-count}{}}}
\subsection{Method \code{count()}}{
Count the number of records in a collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$count(collection)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{the collection name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
numeric
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("users", list(name = "Gamma", age = 36))
db$count("users")
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-list_collections"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-list_collections}{}}}
\subsection{Method \code{list_collections()}}{
List the available collections
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$list_collections()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$list_collections()
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-exists_collection"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-exists_collection}{}}}
\subsection{Method \code{exists_collection()}}{
Check if a collection exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$exists_collection(collection)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the collection exists, FALSE otherwise
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$exists_collection("users")
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-exists_key"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-exists_key}{}}}
\subsection{Method \code{exists_key()}}{
Check if a key exists within a specific collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$exists_key(collection, key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name}

\item{\code{key}}{The key name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the key exists, FALSE otherwise
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$exists_key("users", "name")
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-exists_value"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-exists_value}{}}}
\subsection{Method \code{exists_value()}}{
Check if a value exists within a specific collection/key combination.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$exists_value(collection, key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{The collection name}

\item{\code{key}}{The key name}

\item{\code{value}}{The value to look for}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the value exists, FALSE otherwise
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$insert("consumers", list(name = "Teta", age = 22))
db$exists_value("users", "name", "Delta")
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-transaction"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-transaction}{}}}
\subsection{Method \code{transaction()}}{
Perform a Transaction with Rollback on Failure

This method executes a sequence of operations as a transaction.
If any operation fails, it rolls back all changes to maintain data integrity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$transaction(transaction_fn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transaction_fn}}{A function that performs operations on `self`. It should not return a value.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(name = "Delta", age = 25))
db$count("users")
db$transaction(function() {
  db$insert("users", list(name = "Zlatan", age = 40))
  db$insert("users", list(name = "Neymar", age = 28))
  # if an error is raised, a rollback will happen and
  # the records won't be inserted
})
db$count("users")
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-restore"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-restore}{}}}
\subsection{Method \code{restore()}}{
Load a JSON backup and replace the current database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$restore(backup_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backup_path}}{The path of the backup JSON file.
Allow users to quickly backup their database.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-backup"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-backup}{}}}
\subsection{Method \code{backup()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$backup(backup_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backup_path}}{The path of the backup JSON file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-search"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-search}{}}}
\subsection{Method \code{search()}}{
Search Records in a Collection

This method searches for records in a collection where a specified key's value
contains a given search term.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$search(collection, key, term, ignore.case = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{A character string specifying the name of the collection.}

\item{\code{key}}{A character string specifying the field to search within.}

\item{\code{term}}{A character string specifying the term to search for.}

\item{\code{ignore.case}}{A logical value indicating whether the search should be case-insensitive (default: `FALSE`).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of matching records. Returns an empty list if no matches are found.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$insert("users", list(id = 1, name = "Alice"))
db$insert("users", list(id = 2, name = "Bob"))
db$insert("users", list(id = 3, name = "alice"))

# Case-sensitive search
db$search("users", "name", "Alice", ignore.case = FALSE)

# Case-insensitive search
db$search("users", "name", "alice", ignore.case = TRUE)
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-bulk_insert"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-bulk_insert}{}}}
\subsection{Method \code{bulk_insert()}}{
Insert Multiple Records into a Collection

This method inserts multiple records into a specified collection at once.
Each record should be a named list representing an entry in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$bulk_insert(collection, records)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{A character string specifying the name of the collection.}

\item{\code{records}}{A list of named lists, where each named list represents a record to insert.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rlowdb$new("database.json")
db$bulk_insert("users", list(
  list(id = 1, name = "Alice", age = 25),
  list(id = 2, name = "Bob", age = 32),
  list(id = 3, name = "Charlie", age = 40)
))
db$count("users")
unlink("database.json")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rlowdb-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rlowdb-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rlowdb$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
