% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{deg.marker}
\alias{deg.marker}
\title{Data frame for example marker DEG test result}
\format{
data.frame object of 1992 rows with columns:
\itemize{
\item feature: gene names, 249 unique genes repeated 8 times for the tests
done for 8 clusters.
\item group: cluster names, 8 unique cluster names, dividing the tests.
\item logFC: log fold change of the gene expression between the cluster of
interest against all other clusters.
\item pval: p-value of the DEG test.
\item padj: adjusted p-value of the DEG test.
\item pct_in: percentage of cells in the cluster of interest expressing the
gene.
\item pct_out: percentage of cells in all other clusters expressing the gene.
}
}
\usage{
deg.marker
}
\description{
The data frame is the direct output of marker detection DEG test applied on
example dataset which can be loaded with \code{data("pbmc")}. The DEG test
was done with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{defaultCluster(pbmc) <- pbmcPlot$leiden_cluster
deg.marker <- runMarkerDEG(
    pbmc,
    minCellPerRep = 5
)
}\if{html}{\out{</div>}}

The result is for the marker detection test for 8 clusters in the dataset by
comparing each cluster against all other clusters.
}
\seealso{
\code{\link[=runMarkerDEG]{runMarkerDEG()}}
}
\keyword{datasets}
