% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{selectGenesVST}
\alias{selectGenesVST}
\title{Select variable genes from one dataset with Seurat VST method}
\usage{
selectGenesVST(
  object,
  useDataset,
  n = 2000,
  loessSpan = 0.3,
  clipMax = "auto",
  useShared = TRUE,
  verbose = getOption("ligerVerbose", TRUE)
)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{useDataset}{The names, a numeric or logical index of the dataset to
be considered for selection.}

\item{n}{Number of variable features needed. Default \code{2000}.}

\item{loessSpan}{Loess span parameter used when fitting the variance-mean
relationship. Default \code{0.3}.}

\item{clipMax}{After standardization values larger than \code{clipMax} will
be set to \code{clipMax}. Default \code{"auto"} sets this value to the square
root of the number of cells.}

\item{useShared}{Logical. Whether to only select from genes shared by all
dataset. Default \code{TRUE}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}
}
\description{
Seurat FindVariableFeatures VST method. This allows the selection of a fixed
number of variable features, but only applies to one dataset. No
normalization is needed in advance.
}
\examples{
pbmc <- selectGenesVST(pbmc, "ctrl", n = 50)
}
\references{
Seurat::FindVariableFeatures.default(selection.method = "vst")
}
