% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{suggestLambda}
\alias{suggestLambda}
\title{Visually suggest appropriate lambda value}
\usage{
suggestLambda(
  object,
  k,
  lambda.test = NULL,
  rand.seed = 1,
  num.cores = 1,
  thresh = 1e-04,
  max.iters = 100,
  knn_k = 20,
  k2 = 500,
  ref_dataset = NULL,
  resolution = 1,
  gen.new = FALSE,
  nrep = 1,
  return.data = FALSE,
  return.raw = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should normalize, select genes, and scale before calling.}

\item{k}{Number of factors to use in test factorizations. See optimizeALS documentation.}

\item{lambda.test}{Vector of lambda values to test. If not given, use default set spanning
0.25 to 60}

\item{rand.seed}{Random seed for reproducibility (default 1).}

\item{num.cores}{Number of cores to use for optimizing factorizations in parallel (default 1).}

\item{thresh}{Convergence threshold. Convergence occurs when |obj0-obj|/(mean(obj0,obj)) < thresh}

\item{max.iters}{Maximum number of block coordinate descent iterations to perform}

\item{knn_k}{Number of nearest neighbors for within-dataset knn in quantileAlignSNF (default 20).}

\item{k2}{Horizon parameter for quantileAlignSNF (default 500).}

\item{ref_dataset}{Reference dataset for quantileAlignSNF (defaults to larger dataset).}

\item{resolution}{Resolution for quantileAlignSNF (default 1).}

\item{gen.new}{Do not use optimizeNewLambda in factorizations. Recommended to set TRUE
when looking at only a small range of lambdas (ie. 1:7) (default FALSE)}

\item{nrep}{Number restarts to perform at each lambda value tested (increase to produce
smoother curve if results unclear) (default 1).}

\item{return.data}{Whether to return list of data matrices (raw) or dataframe (processed)
instead of ggplot object (default FALSE).}

\item{return.raw}{If return.results TRUE, whether to return raw data (in format described below),
or dataframe used to produce ggplot object. Raw data is matrix of alignment values for each
lambda value tested (each column represents a different rep for nrep).(default FALSE)}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
Matrix of results if indicated or ggplot object. Plots alignment vs. lambda to console.
}
\description{
Can be used to select appropriate value of lambda for factorization of particular dataset. Plot
alignment and agreement for various test values of lambda. Most appropriate lambda
is likely around the "elbow" of the alignment plot (when alignment stops increasing). This will
likely also correspond to slower decrease in agreement. Depending on number of cores used,
this process can take 10-20 minutes.
}
\examples{
\donttest{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
suggestLambda(ligerex, k = 20, lambda.test = c(5, 10), max.iters = 1)
}
}
