% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{normalize}
\alias{normalize}
\title{Normalize raw datasets to column sums}
\usage{
normalize(
  object,
  chunk = 1000,
  format.type = "10X",
  remove.missing = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{chunk}{size of chunks in hdf5 file. (default 1000)}

\item{format.type}{string of HDF5 format (10X CellRanger by default).}

\item{remove.missing}{Whether to remove cells not expressing any measured genes, and genes not
expressed in any cells (if take.gene.union = TRUE, removes only genes not expressed in any
dataset) (default TRUE).}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
\code{liger} object with norm.data slot set.
}
\description{
This function normalizes data to account for total gene expression across a cell.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
}
