% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{print.NoiseKriging}
\alias{print.NoiseKriging}
\title{Print the content of a \code{NoiseKriging} object.}
\usage{
\method{print}{NoiseKriging}(x, ...)
}
\arguments{
\item{x}{A (S3) \code{NoiseKriging} Object.}

\item{...}{Ignored.}
}
\value{
String of printed object.
}
\description{
Print the content of a \code{NoiseKriging} object.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X)) # add noise dep. on X

k <- NoiseKriging(y, noise=(X/10)^2, X, kernel = "matern3_2")

print(k)
## same thing
k
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
